class tnmUWindowConsoleClientWindow extends UWindowConsoleClientWindow;

function Notify(UWindowDialogControl C, byte E)
{
	local string s;
	Super(UWindowDialogClientWindow).Notify(C, E);

	switch(E)
	{
	case DE_EnterPressed:
		switch(C)
		{
		case EditControl:
			if(EditControl.GetValue() != "")
			{
				s = EditControl.GetValue();
				Root.Console.Message( None, "> "$s, 'Console' );
				EditControl.Clear();

				//specifies that the user wants the console closed after this command is executed
				//for "legend" and such that render beneath the console -nick
				if(left(s,1)=="!")
				{
					s=right(s,len(s)-1);
					Root.Console.HideConsole();
				}

				if( !Root.Console.ConsoleCommand( s ) )
					Root.Console.Message( None, Localize("Errors","Exec","Core"), 'Console' );
			}
			break;
		}
		break;
	case DE_WheelUpPressed:
		switch(C)
		{
		case EditControl:
			TextArea.VertSB.Scroll(-1);
			break;
		}
		break;
	case DE_WheelDownPressed:
		switch(C)
		{
		case EditControl:
			TextArea.VertSB.Scroll(1);
			break;
		}
		break;
	}
}

defaultproperties
{
}