//allows various manipulations of calls to UGalaxyAudioSubsystem::PlaySoundW
//used by all uscript sound related functions
class tnmSoundModifier extends tnmNativeHookObject
	native abstract;

var private bool bEnabled;

native static final function ConfigureSound(optional bool bEnabled, optional float volumeMult, optional float radiusMult, optional float pitchMult);

static final function bool IsEnabled()
{
	return Default.bEnabled;
}

static final function On()
{
	AssertHook();
	Default.bEnabled=true;
	ConfigureSound(true);
}

static final function Off()
{
	AssertHook();
	Default.bEnabled=false;
	ConfigureSound(false);
}

static final function Toggle()
{
	AssertHook();
	Default.bEnabled=!Default.bEnabled;
	ConfigureSound(Default.bEnabled);
}

static final function SetVolumeMultiplier(float volume)
{
	AssertHook();
	ConfigureSound(,volume);
}

static final function ResetVolumeMultiplier()
{
	AssertHook();
	ConfigureSound(,1.0);
}

static final function SetRadiusMultiplier(float radius)
{
	AssertHook();
	ConfigureSound(,,radius);
}

static final function ResetRadiusMultiplier()
{
	AssertHook();
	ConfigureSound(,,1.0);
}

static final function SetPitchMultiplier(float pitch)
{
	AssertHook();
	ConfigureSound(,,,pitch);
}

static final function ResetPitchMultiplier()
{
	AssertHook();
	ConfigureSound(,,,1.0);
}

static final function ResetMultipliers()
{
	AssertHook();
	ConfigureSound(,1.0,1.0,1.0);
}

defaultproperties
{
}
