/*
//separated into DECLARE_HOOK and DECLARE_HOOK_FULL for readability purposes
#define DECLARE_HOOK(cls,method,ret,...) \
class cls##method##Hook; \
typedef ret(cls##method##Hook::* ##method##Function)(__VA_ARGS__); \
class cls##method##Hook : public cls \
{ \
public: \
	static method##Function old_##method; \
	ret method(__VA_ARGS__); \
}; \
method##Function cls##method##Hook::old_##method = \
(method##Function)&cls::method; \
ret cls##method##Hook::method(__VA_ARGS__)
*/

//for internal use
//still pretty hard to read
#define DECLARE_HOOK_FULL(cls,method,ret,args,hcls,hmethod,omethod) \
class hcls; \
typedef ret(hcls::* hmethod)(args); \
class hcls : public cls \
{ \
public: \
	static hmethod omethod; \
	ret method(args); \
}; \
hmethod hcls::omethod = \
(hmethod)&cls::method; \
ret hcls::method(args)

//declare a function hook for ret cls::method(...)
#define DECLARE_HOOK(cls,method,ret,...) \
DECLARE_HOOK_FULL(cls,method,ret,__VA_ARGS__,cls##method##Hook,method##Function,old_##method)

//call detourattach on the previously declared hook
#define IMPLEMENT_HOOK(cls,method) \
DetourAttach(&(PVOID&)cls##method##Hook::old_##method, \
	(PVOID)(&(PVOID&)cls##method##Hook::method))

//modified iterator macro
#undef POST_ITERATOR
#define POST_ITERATOR \
		while( (B=*Stack.Code)!=EX_IteratorPop && B!=EX_IteratorNext ) \
			Stack.Step( Stack.Object, Buffer ); \
		if( *Stack.Code++==EX_IteratorNext ) \
			Stack.Code = StartCode; \
	} while( B != EX_IteratorPop ); \
	Stack.Code = &((BYTE*)Stack.Node->Script.GetData())[wEndOffset + 1];

//virtual function lookup code
//modified from code by Roman 'Switch`' Dzieciol
inline void VTableLookup(PBYTE base, int offset, PBYTE *func)
{
	int problem=0;
	PBYTE code=*(PBYTE*)(*(PBYTE*)(base) + offset);

	while(code[0]==0xE9) //jump to actual function address
	{
		code+=5+*(LONG*)&code[1];
		if(problem++==20)
		{
			GLog->Logf(TEXT("TNMNative >> Error looking up member function in vtable. Report this as a bug."));
			_asm int 3; //breakpoint
			func=NULL;
			return;
		}
	}

	*func=code;
}
 