/* 27sep07abu
 * (c) Software Lab. Alexander Burger
 */

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <ctype.h>
#include <string.h>
#include <errno.h>
#include <setjmp.h>

#ifdef __cplusplus
     #define cpp_symbol "C"
#else
     #define cpp_symbol
#endif

#ifdef BUILD_DLL
     // the dll exports
     #define EXPORT __declspec(dllexport)
#else
     // the exe imports
     #define EXPORT extern cpp_symbol  __declspec(dllimport)
#endif

#define WORD ((int)sizeof(long))
#define BITS (8*WORD)
#define CELLS (1024*1024/sizeof(cell))

typedef unsigned long long int u_int64_t;
typedef signed long int int32_t;
typedef unsigned long word;
typedef unsigned char byte;
typedef unsigned char *ptr;

//typedef enum {NO,YES} bool;

typedef struct cell {            // Pico primary data type
   struct cell *car;
   struct cell *cdr;
} cell, *any;

typedef any (*fun)(any);

typedef struct heap {
   cell cells[CELLS];
   struct heap *next;
} heap;

typedef struct bindFrame {
   struct bindFrame *link;
   int i, cnt;
   struct {any sym; any val;} bnd[1];
} bindFrame;

typedef struct methFrame {
   struct methFrame *link;
   any key, cls;
} methFrame;

typedef struct inFrame {
   struct inFrame *link;
   void (*get)(void);
   FILE *fp;
   int next;
} inFrame;

typedef struct outFrame {
   struct outFrame *link;
   void (*put)(int);
   FILE *fp;
} outFrame;

typedef struct parseFrame {
   int i;
   word w;
   any sym, nm;
} parseFrame;

typedef struct stkEnv {
   cell *stack, *arg;
   bindFrame *bind;
   methFrame *meth;
   int next;
   any make;
   inFrame *inFiles;
   outFrame *outFiles;
   parseFrame *parser;
   void (*get)(void);
   void (*put)(int);
   bool brk;
} stkEnv;

typedef struct catchFrame {
   struct catchFrame *link;
   any tag;
   stkEnv env;
   jmp_buf rst;
} catchFrame;

/*** Macros ***/
#define Free(p)         ((p)->cdr=Avail, Avail=(p))

/* Number access */
#define num(x)          ((long)(x))
#define txt(n)          ((any)(num(n)<<1|1))
#define box(n)          ((any)(num(n)<<2|2))
#define unBox(n)        (num(n)>>2)
#define Zero            ((any)2)
#define One             ((any)6)

/* Symbol access */
#define symPtr(x)       ((any)&(x)->cdr)
#define val(x)          ((x)->car)
#define tail(x)         (((x)-1)->cdr)

/* Cell access */
#define car(x)          ((x)->car)
#define cdr(x)          ((x)->cdr)
#define caar(x)         (car(car(x)))
#define cadr(x)         (car(cdr(x)))
#define cdar(x)         (cdr(car(x)))
#define cddr(x)         (cdr(cdr(x)))
#define caaar(x)        (car(car(car(x))))
#define caadr(x)        (car(car(cdr(x))))
#define cadar(x)        (car(cdr(car(x))))
#define caddr(x)        (car(cdr(cdr(x))))
#define cdaar(x)        (cdr(car(car(x))))
#define cdadr(x)        (cdr(car(cdr(x))))
#define cddar(x)        (cdr(cdr(car(x))))
#define cdddr(x)        (cdr(cdr(cdr(x))))
#define cadddr(x)       (car(cdr(cdr(cdr(x)))))
#define cddddr(x)       (cdr(cdr(cdr(cdr(x)))))

#define data(c)         ((c).car)
#define Save(c)         ((c).cdr=Env.stack, Env.stack=&(c))
#define drop(c)         (Env.stack=(c).cdr)
#define Push(c,x)       (data(c)=(x), Save(c))
#define Pop(c)          (drop(c), data(c))

#define Bind(s,f)       ((f).i=0, (f).cnt=1, (f).bnd[0].sym=(s), (f).bnd[0].val=val(s), (f).link=Env.bind, Env.bind=&(f))
#define Unbind(f)       (val((f).bnd[0].sym)=(f).bnd[0].val, Env.bind=(f).link)

/* Predicates */
#define isNil(x)        ((x)==Nil)
#define isTxt(x)        (num(x)&1)
#define isNum(x)        (num(x)&2)
#define isSym(x)        (num(x)&WORD)
#define isSymb(x)       ((num(x)&(WORD+2))==WORD)
#define isCell(x)       (!(num(x)&(2*WORD-1)))

/* Evaluation */
#define EVAL(x)         (isNum(x)? x : isSym(x)? val(x) : evList(x))
#define evSubr(f,x)     (*(fun)(num(f) & ~2))(x)

/* Error checking */
#define NeedNum(ex,x)   if (!isNum(x)) numError(ex,x)
#define NeedSym(ex,x)   if (!isSym(x)) symError(ex,x)
#define NeedSymb(ex,x)  if (!isSymb(x)) symError(ex,x)
#define NeedCell(ex,x)  if (!isCell(x)) cellError(ex,x)
#define NeedAtom(ex,x)  if (isCell(x)) atomError(ex,x)
#define NeedLst(ex,x)   if (!isCell(x) && !isNil(x)) lstError(ex,x)
#define NeedVar(ex,x)   if (isNum(x)) varError(ex,x)
#define CheckVar(ex,x)  if ((x)>=Nil && (x)<=T) protError(ex,x)

/* Globals */

EXPORT int Chr, Trace;
EXPORT char **AV, *Home;
EXPORT heap *Heaps;
EXPORT cell *Avail;
EXPORT stkEnv Env;
EXPORT catchFrame *CatchPtr;
EXPORT FILE *InFile, *OutFile;
EXPORT any TheKey, TheCls;
EXPORT any Intern[2], Transient[2], Reloc;
EXPORT any ApplyArgs, ApplyBody;
EXPORT any Nil, Meth, Quote, T, At, At2, At3, This;
EXPORT any Dbg, Scl, Class, Up, Err, Rst, Msg, Bye;

EXPORT bool Jam;
EXPORT jmp_buf ErrRst;

EXPORT fun doCustom1f;
EXPORT fun doCustom2f;
EXPORT fun doCustom3f;
EXPORT fun doCustom4f;
EXPORT fun doCustom5f;
EXPORT fun doCustom6f;
EXPORT fun doCustom7f;
EXPORT fun doCustom8f;
EXPORT fun doCustom9f;
EXPORT fun doCustom10f;
EXPORT fun doCustom11f;
EXPORT fun doCustom12f;
EXPORT fun doCustom13f;
EXPORT fun doCustom14f;
EXPORT fun doCustom15f;
EXPORT fun doCustom16f;

EXPORT any doCustom1(any ex);
EXPORT any doCustom2(any ex);
EXPORT any doCustom3(any ex);
EXPORT any doCustom4(any ex);
EXPORT any doCustom5(any ex);
EXPORT any doCustom6(any ex);
EXPORT any doCustom7(any ex);
EXPORT any doCustom8(any ex);
EXPORT any doCustom9(any ex);
EXPORT any doCustom10(any ex);
EXPORT any doCustom11(any ex);
EXPORT any doCustom12(any ex);
EXPORT any doCustom13(any ex);
EXPORT any doCustom14(any ex);
EXPORT any doCustom15(any ex);
EXPORT any doCustom16(any ex);

/*extern int Chr, Trace;
extern char **AV, *Home;
extern heap *Heaps;
extern cell *Avail;
extern stkEnv Env;
extern catchFrame *CatchPtr;
extern FILE *InFile, *OutFile;
extern any TheKey, TheCls;
extern any Intern[2], Transient[2], Reloc;
extern any ApplyArgs, ApplyBody;
extern any Nil, Meth, Quote, T, At, At2, At3, This;
extern any Dbg, Scl, Class, Up, Err, Rst, Msg, Bye;

extern bool Jam;
extern jmp_buf ErrRst;*/

/* Prototypes */

EXPORT void *alloc(void*,size_t);
EXPORT any apply(any,any,bool,int,cell*);
EXPORT void argError(any,any);
EXPORT void atomError(any,any) ;
EXPORT void begString(void);
EXPORT any boxSubr(fun);
EXPORT void brkLoad(any);
EXPORT int bufNum(char[20],long);
EXPORT int bufSize(any);
EXPORT void bufString(any,char*);
EXPORT void bye(int) ;
EXPORT void cellError(any,any) ;
EXPORT int compare(any,any);
EXPORT any cons(any,any);
EXPORT any consName(word,any);
EXPORT any consSym(any,word);
EXPORT void crlf(void);
EXPORT any endString(void);
EXPORT bool equal(any,any);
EXPORT void err(any,any,char*,...) ;
EXPORT any evExpr(any,any);
EXPORT any evList(any);
EXPORT long evNum(any,any);
EXPORT any evSym(any);
EXPORT void execError(char*) ;
EXPORT int firstByte(any);
EXPORT any get(any,any);
EXPORT int getByte(int*,word*,any*);
EXPORT int getByte1(int*,word*,any*);
EXPORT void getStdin(void);
EXPORT void giveup(char*) ;
EXPORT void heapAlloc(void);
EXPORT void initSymbols(void);
EXPORT any intern(any,any[2]);
EXPORT bool isBlank(any);
EXPORT any isIntern(any,any[2]);
EXPORT void lstError(any,any) ;
EXPORT any load(any,int,any);
EXPORT any method(any);
EXPORT any mkChar(int);
EXPORT any mkChar2(int,int);
EXPORT any mkSym(byte*);
EXPORT any mkStr(char*);
EXPORT any mkTxt(int);
EXPORT any name(any);
EXPORT int numBytes(any);
EXPORT void numError(any,any) ;
EXPORT any numToSym(any,int,int,int);
EXPORT void outName(any);
EXPORT void outNum(long);
EXPORT void outString(char*);
EXPORT void pack(any,int*,word*,any*,cell*);
EXPORT int pathSize(any);
EXPORT void pathString(any,char*);
EXPORT void popInFiles(void);
EXPORT void popOutFiles(void);
EXPORT any popSym(int,word,any,cell*);
EXPORT void prin(any);
EXPORT void print(any);
EXPORT void protError(any,any) ;
EXPORT void pushInFiles(inFrame*);
EXPORT void pushOutFiles(outFrame*);
EXPORT any put(any,any,any);
EXPORT void putByte(int,int*,word*,any*,cell*);
EXPORT void putByte0(int*,word*,any*);
EXPORT void putByte1(int,int*,word*,any*);
EXPORT void putStdout(int);
EXPORT void rdOpen(any,any,inFrame*);
EXPORT any read1(int);
EXPORT int secondByte(any);
EXPORT void space(void);
EXPORT int symBytes(any);
EXPORT void symError(any,any) ;
EXPORT any symToNum(any,int,int,int);
EXPORT void undefined(any,any);
EXPORT void unintern(any,any[2]);
EXPORT void unwind (catchFrame*);
EXPORT void varError(any,any) ;
EXPORT void wrOpen(any,any,outFrame*);
EXPORT long xNum(any,any);
EXPORT any xSym(any);

EXPORT any doAbs(any);
EXPORT any doAdd(any);
EXPORT any doAll(any);
EXPORT any doAnd(any);
EXPORT any doAny(any);
EXPORT any doAppend(any);
EXPORT any doApply(any);
EXPORT any doArg(any);
EXPORT any doArgs(any);
EXPORT any doArgv(any);
EXPORT any doAsoq(any);
EXPORT any doAs(any);
EXPORT any doAssoc(any);
EXPORT any doAt(any);
EXPORT any doAtom(any);
EXPORT any doBind(any);
EXPORT any doBitAnd(any);
EXPORT any doBitOr(any);
EXPORT any doBitQ(any);
EXPORT any doBitXor(any);
EXPORT any doBool(any);
EXPORT any doBox(any);
EXPORT any doBoxQ(any);
EXPORT any doBreak(any);
EXPORT any doBy(any);
EXPORT any doBye(any) ;
EXPORT any doCaaar(any);
EXPORT any doCaadr(any);
EXPORT any doCaar(any);
EXPORT any doCadar(any);
EXPORT any doCadddr(any);
EXPORT any doCaddr(any);
EXPORT any doCadr(any);
EXPORT any doCar(any);
EXPORT any doCase(any);
EXPORT any doCatch(any);
EXPORT any doCdaar(any);
EXPORT any doCdadr(any);
EXPORT any doCdar(any);
EXPORT any doCddar(any);
EXPORT any doCddddr(any);
EXPORT any doCdddr(any);
EXPORT any doCddr(any);
EXPORT any doCdr(any);
EXPORT any doChain(any);
EXPORT any doChar(any);
EXPORT any doChop(any);
EXPORT any doCirc(any);
EXPORT any doClip(any);
EXPORT any doCnt(any);
EXPORT any doCol(any);
EXPORT any doCon(any);
EXPORT any doConc(any);
EXPORT any doCond(any);
EXPORT any doCons(any);
EXPORT any doCopy(any);
EXPORT any doCut(any);
EXPORT any doDate(any);
EXPORT any doDe(any);
EXPORT any doDec(any);
EXPORT any doDef(any);
EXPORT any doDefault(any);
EXPORT any doDel(any);
EXPORT any doDelete(any);
EXPORT any doDelq(any);
EXPORT any doDiff(any);
EXPORT any doDiv(any);
EXPORT any doDm(any);
EXPORT any doDo(any);
EXPORT any doE(any);
EXPORT any doEnv(any);
EXPORT any doEof(any);
EXPORT any doEq(any);
EXPORT any doEqual(any);
EXPORT any doEqual0(any);
EXPORT any doEqualT(any);
EXPORT any doEval(any);
EXPORT any doExtra(any);
EXPORT any doFifo(any);
EXPORT any doFill(any);
EXPORT any doFilter(any);
EXPORT any doFin(any);
EXPORT any doFinally(any);
EXPORT any doFind(any);
EXPORT any doFish(any);
EXPORT any doFlgQ(any);
EXPORT any doFlip(any);
EXPORT any doFlush(any);
EXPORT any doFold(any);
EXPORT any doFor(any);
EXPORT any doFormat(any);
EXPORT any doFrom(any);
EXPORT any doFull(any);
EXPORT any doFunQ(any);
EXPORT any doGc(any);
EXPORT any doGe(any);
EXPORT any doGe0(any);
EXPORT any doGet(any);
EXPORT any doGetl(any);
EXPORT any doGlue(any);
EXPORT any doGt(any);
EXPORT any doGt0(any);
EXPORT any doHead(any);
EXPORT any doHeap(any);
EXPORT any doHide(any);
EXPORT any doIdx(any);
EXPORT any doIf(any);
EXPORT any doIf2(any);
EXPORT any doIfn(any);
EXPORT any doIn(any);
EXPORT any doInc(any);
EXPORT any doIndex(any);
EXPORT any doIntern(any);
EXPORT any doIsa(any);
EXPORT any doJob(any);
EXPORT any doLast(any);
EXPORT any doLe(any);
EXPORT any doLength(any);
EXPORT any doLet(any);
EXPORT any doLetQ(any);
EXPORT any doLine(any);
EXPORT any doLink(any);
EXPORT any doList(any);
EXPORT any doLit(any);
EXPORT any doLstQ(any);
EXPORT any doLoad(any);
EXPORT any doLookup(any);
EXPORT any doLoop(any);
EXPORT any doLowQ(any);
EXPORT any doLowc(any);
EXPORT any doLt(any);
EXPORT any doLt0(any);
EXPORT any doLup(any);
EXPORT any doMade(any);
EXPORT any doMake(any);
EXPORT any doMap(any);
EXPORT any doMapc(any);
EXPORT any doMapcan(any);
EXPORT any doMapcar(any);
EXPORT any doMapcon(any);
EXPORT any doMaplist(any);
EXPORT any doMaps(any);
EXPORT any doMatch(any);
EXPORT any doMax(any);
EXPORT any doMaxi(any);
EXPORT any doMember(any);
EXPORT any doMemq(any);
EXPORT any doMeta(any);
EXPORT any doMeth(any);
EXPORT any doMethod(any);
EXPORT any doMin(any);
EXPORT any doMini(any);
EXPORT any doMix(any);
EXPORT any doMmeq(any);
EXPORT any doMul(any);
EXPORT any doMulDiv(any);
EXPORT any doName(any);
EXPORT any doNand(any);
EXPORT any doNEq(any);
EXPORT any doNEq0(any);
EXPORT any doNEqT(any);
EXPORT any doNEqual(any);
EXPORT any doNeed(any);
EXPORT any doNew(any);
EXPORT any doNext(any);
EXPORT any doNil(any);
EXPORT any doNond(any);
EXPORT any doNor(any);
EXPORT any doNot(any);
EXPORT any doNth(any);
EXPORT any doNumQ(any);
EXPORT any doOff(any);
EXPORT any doOffset(any);
EXPORT any doOn(any);
EXPORT any doOne(any);
EXPORT any doOnOff(any);
EXPORT any doOpt(any);
EXPORT any doOr(any);
EXPORT any doOut(any);
EXPORT any doPack(any);
EXPORT any doPair(any);
EXPORT any doPass(any);
EXPORT any doPath(any);
EXPORT any doPatQ(any);
EXPORT any doPeek(any);
EXPORT any doPick(any);
EXPORT any doPop(any);
EXPORT any doPreQ(any);
EXPORT any doPrin(any);
EXPORT any doPrinl(any);
EXPORT any doPrint(any);
EXPORT any doPrintln(any);
EXPORT any doPrintsp(any);
EXPORT any doProg(any);
EXPORT any doProg1(any);
EXPORT any doProg2(any);
EXPORT any doProp(any);
EXPORT any doPropCol(any);
EXPORT any doProve(any);
EXPORT any doPush(any);
EXPORT any doPush1(any);
EXPORT any doPut(any);
EXPORT any doPutl(any);
EXPORT any doQueue(any);
EXPORT any doQuit(any);
EXPORT any doQuote(any);
EXPORT any doRand(any);
EXPORT any doRank(any);
EXPORT any doRead(any);
EXPORT any doRem(any);
EXPORT any doReplace(any);
EXPORT any doRest(any);
EXPORT any doReverse(any);
EXPORT any doRot(any);
EXPORT any doRun(any);
EXPORT any doSave(any);
EXPORT any doSect(any);
EXPORT any doSeed(any);
EXPORT any doSeek(any);
EXPORT any doSend(any);
EXPORT any doSet(any);
EXPORT any doSetCol(any);
EXPORT any doSetq(any);
EXPORT any doShift(any);
EXPORT any doSize(any);
EXPORT any doSkip(any);
EXPORT any doSort(any);
EXPORT any doSpace(any);
EXPORT any doSplit(any);
EXPORT any doSpQ(any);
EXPORT any doSqrt(any);
EXPORT any doState(any);
EXPORT any doStem(any);
EXPORT any doStk(any);
EXPORT any doStr(any);
EXPORT any doStrip(any);
EXPORT any doStrQ(any);
EXPORT any doSub(any);
EXPORT any doSum(any);
EXPORT any doSuper(any);
EXPORT any doSym(any);
EXPORT any doSymQ(any);
EXPORT any doT(any);
EXPORT any doTail(any);
EXPORT any doText(any);
EXPORT any doThrow(any);
EXPORT any doTill(any);
EXPORT any doTrace(any);
EXPORT any doTrim(any);
EXPORT any doTry(any);
EXPORT any doType(any);
EXPORT any doUnify(any);
EXPORT any doUnless(any);
EXPORT any doUntil(any);
EXPORT any doUp(any);
EXPORT any doUppQ(any);
EXPORT any doUppc(any);
EXPORT any doUse(any);
EXPORT any doVal(any);
EXPORT any doWhen(any);
EXPORT any doWhile(any);
EXPORT any doWith(any);
EXPORT any doXchg(any);
EXPORT any doXor(any);
EXPORT any doYoke(any);
EXPORT any doZap(any);
EXPORT any doZero(any);

/* List element access */
static inline any nCdr(int n, any x) {
   while (--n >= 0)
      x = cdr(x);
   return x;
}

static inline any nth(int n, any x) {
   if (--n < 0)
      return Nil;
   return nCdr(n,x);
}

static inline any getn(any x, any y) {
   if (isNum(x)) {
      long n = unBox(x);

      if (n < 0) {
         while (++n)
            y = cdr(y);
         return cdr(y);
      }
      if (n == 0)
         return Nil;
      while (--n)
         y = cdr(y);
      return car(y);
   }
   do
      if (isCell(car(y)) && x == caar(y))
         return cdar(y);
   while (isCell(y = cdr(y)));
   return Nil;
}

/* List length calculation */
static inline int length(any x) {
   int n;

   for (n = 0; isCell(x); x = cdr(x))
      ++n;
   return n;
}

/* Membership */
static inline any member(any x, any y) {
   any z = y;

   while (isCell(y)) {
      if (equal(x, car(y)))
         return y;
      if (z == (y = cdr(y)))
         return NULL;
   }
   return isNil(y) || !equal(x,y)? NULL : y;
}

static inline any memq(any x, any y) {
   any z = y;

   while (isCell(y)) {
      if (x == car(y))
         return y;
      if (z == (y = cdr(y)))
         return NULL;
   }
   return isNil(y) || x != y? NULL : y;
}

static inline int indx(any x, any y) {
   int n = 1;
   any z = y;

   while (isCell(y)) {
      if (equal(x, car(y)))
         return n;
      ++n;
      if (z == (y = cdr(y)))
         return 0;
   }
   return 0;
}

/* List interpreter */
static inline any prog(any x) {
   any y;

   do
      y = EVAL(car(x));
   while (isCell(x = cdr(x)));
   return y;
}

static inline any run(any x) {
   any y;
   cell at;

   Push(at,val(At));
   do
      y = EVAL(car(x));
   while (isCell(x = cdr(x)));
   val(At) = Pop(at);
   return y;
}
