#define DB GLog->Logf(L"%i",++dbvar)
static int dbvar=0;

static char* Ascii (const TCHAR *input)
{
	int size;
	for(size=0;input[size]!='\0';size++);

	char *ret = new char[size];

	for(int i=0;i<size;i++)
		ret[i]=(char)input[i];
	ret[i]='\0';

	return ret;
}

static TCHAR* Unicode (const char *input)
{
	int size;
	for(size=0;input[size]!='\0';size++);

	TCHAR *ret = new TCHAR[size];

	for(int i=0;i<size;i++)
		ret[i]=(TCHAR)input[i];
	ret[i]='\0';

	return ret;
}

static char longbuf[4096];
static int lpos;

static void putStr(char c)
{
	longbuf[lpos++]=c;
	longbuf[lpos]='\0';
}

static void outStr(char *s)
{
   while (*s)
      putStr(*s++);
}

//static void _crlf(void)		{putStr('\n');}
static void _space(void)		{putStr(' ');}

static int bufNumStr(char buf[20], long n)
{
   return sprintf(buf, "%ld", n);
}

static void outNumStr(long n)
{
   char buf[20];

   bufNumStr(buf, n);
   outStr(buf);
}

static void strIntern(any nm)
{
   int i, c;
   word w;

   putStr(getByte1(&i, &w, &nm));
   while (c = getByte(&i, &w, &nm))
      putStr(c);
}

static void strTransient(any nm)
{
   int i, c;
   word w;

   //putStr('"');
   c = getByte1(&i, &w, &nm);
   do {
      //if (c == '"'  ||  c == '\\')
         //putStr('\\');
      putStr(c);
   } while (c = getByte(&i, &w, &nm));
   //putStr('"');
}

/* Print one expression */
static void str(any x)
{
   if (isNum(x))
      outNumStr(unBox(x));
   else if (isSym(x))
   {
      any nm = name(x);

      if (nm == txt(0))
         putStr('$'),  outNumStr((word)x/sizeof(cell));
      else if (x == isIntern(nm, Intern))
         strIntern(nm);
      else
         strTransient(nm);
   }
   else if (car(x) == Quote  &&  x != cdr(x))
      putStr('\''),  print(cdr(x));
   else 
   {
      any y = x;
      putStr('(');
      while (str(car(x)), !isNil(x = cdr(x))) 
	  {
         if (x == y)
		 {
            outStr(" .");
            break;
         }
         if (!isCell(x))
		 {
            outStr(" . ");
            str(x);
            break;
         }
         _space();
      }
      putStr(')');
   }
}

static TCHAR* toString(any x)
{
	lpos=0;
	for(int i=0;i<sizeof(longbuf);i++)
		longbuf[i]='\0';

	str(x);

	char *buffer = new char[sizeof(longbuf)];
	for(int i=0;i<sizeof(longbuf);i++)
	{
		buffer[i]=longbuf[i];
		if(buffer[i]=='\0')
			break;
	}

	return Unicode(buffer);
}

any doFindFirst(any ex)
{
	any x, y;
	TCHAR *class_name;
	char *result=NULL;

	x = cdr(ex);
	if (isNil(y = EVAL(car(x))))
		return Nil;
	class_name = toString(y);

	UClass *CLASS=NULL;
	TObjectIterator<UClass> it;
	while(it.operator UBOOL())
	{
		if(FName(it->GetName())==FName(class_name))
		{
			CLASS=*it;
			break;
		}
		++it;
	}

	TObjectIterator<AActor> it2;
	while(it2.operator UBOOL())
	{
		if(it2->IsA(CLASS))
		{
			result=Ascii(it2->GetName());
			break;
		}
		++it2;
	}

	if(result)
		return mkSym((byte*)result);
	return Nil;
}

/*void deleteParam(PVOID ptr, FString &type)
{
	if (type==L"BYTE")
	{
		BYTE *dat=(BYTE*)ptr;
		delete dat;
	}
	else if (type==L"INT")
	{
		INT *dat=(INT*)ptr;
		delete dat;
	}
	else if (type==L"BOOL")
	{
		BITFIELD *dat=(BITFIELD*)ptr;
		delete dat;
	}
	else if (type==L"FLOAT")
	{
		FLOAT *dat=(FLOAT*)ptr;
		delete dat;
	}
	else if (type==L"OBJECT")
	{
		UObject **dat=(UObject**)ptr;
		delete dat;
	}
	else if (type==L"CLASS")
	{
		UClass **dat=(UClass**)ptr;
		delete dat;
	}
	else if (type==L"NAME")
	{
		FName *dat=(FName*)ptr;
		delete dat;
	}
	else if (type==L"STR")
	{
		FString *dat=(FString*)ptr;
		delete dat;
	}
	else if (type==L"STRUCT")
	{
		UStruct **dat=(UStruct**)ptr;
		delete dat;
	}
}*/

PVOID createParam(LBufferWriter &out, FString &type, FString &valstr)
{
	char *txt = Ascii(*valstr);

	if (type==L"BYTE")
	{
		unsigned short int tmp;
		if(sscanf(txt,"%hu",&tmp)==EOF)
			return NULL;
		BYTE *dat=new BYTE;
		*dat=(BYTE)tmp;
		out.Serialize(dat,sizeof(BYTE));
		return dat;
	}
	else if (type==L"INT")
	{
		INT *dat=new INT;
		if(sscanf(txt,"%i",dat)==EOF)
			return NULL;
		out.Serialize(dat,sizeof(INT));
		return dat;
	}
	else if (type==L"BOOL")
	{
		BITFIELD *dat=new BITFIELD;
		FString check=valstr.Caps();		
		*dat=(check==L"TRUE"||check==L"1")?1:0;
		out.Serialize(dat,sizeof(BITFIELD));
		return dat;
	}
	else if (type==L"FLOAT")
	{
		FLOAT *dat=new FLOAT;
		if(sscanf(txt,"%f",&dat)==EOF)
			return NULL;
		out.Serialize(dat,sizeof(FLOAT));
		return dat;
	}
	else if (type==L"OBJECT")
	{
		UObject **dat=new UObject*;
		*dat=NULL;
		if(valstr.Caps()==L"NONE")
			return dat;
		TObjectIterator<UObject> it;
		while(it.operator UBOOL())
		{
			if(it->GetFlags() & RF_ScriptMask && FName(it->GetName())==FName(*valstr))
			{
				*dat=*it;
				break;
			}
			++it;
		}
		if(!*dat)
			return NULL;
		out.Serialize(dat,sizeof(UObject*));
		return dat;
	}
	else if (type==L"CLASS")
	{
		UClass **dat=new UClass*;
		TObjectIterator<UClass> it;
		while(it.operator UBOOL())
		{
			if(FName(it->GetName())==FName(*valstr))
			{
				*dat=*it;
				break;
			}
			++it;
		}
		if(!*dat)
			return NULL;
		out.Serialize(dat,sizeof(UClass*));
		return dat;
	}
	else if (type==L"NAME")
	{
		FName *dat=new FName(*valstr);
		out.Serialize(dat,sizeof(FName));
		return dat;
	}
	else if (type==L"STR")
	{
		FString *dat = new FString(*valstr);
		out.Serialize(dat,sizeof(FString));
		return dat;
	}
	else if (type==L"STRUCT")
	{
		UStruct **dat=new UStruct*;
		*dat=NULL;
		TObjectIterator<UStruct> it;
		while(it.operator UBOOL())
		{
			if(it->GetFlags() & RF_ScriptMask && FName(it->GetName())==FName(*valstr))
			{
				*dat=*it;
				break;
			}
			++it;
		}
		if(!*dat)
			return NULL;
		out.Serialize(dat,sizeof(UStruct*));
		return dat;
	}
	return NULL; //unhandled type
}

PVOID createReturn(LBufferWriter &out, FString &type)
{
	if (type==L"BYTE")
	{
		BYTE *dat = new BYTE;
		out.Serialize(dat,sizeof(BYTE));
		return (PVOID*)&dat;
	}
	else if (type==L"INT")
	{
		INT *dat = new INT;
		out.Serialize(dat,sizeof(INT));
		return dat;
	}
	else if (type==L"BOOL")
	{
		BITFIELD *dat = new BITFIELD;
		out.Serialize(&*dat,sizeof(BITFIELD));
		return (PVOID*)&dat;
	}
	else if (type==L"FLOAT")
	{
		FLOAT *dat = new FLOAT;
		out.Serialize(&*dat,sizeof(FLOAT));
		return (PVOID*)&dat;
	}
	else if (type==L"OBJECT")
	{
		UObject **dat = new UObject*;
		out.Serialize(&*dat,sizeof(UObject*));
		return (PVOID*)&dat;
	}
	else if (type==L"CLASS")
	{
		UClass **dat = new UClass*;
		out.Serialize(&*dat,sizeof(UClass*));
		return (PVOID*)&dat;
	}
	else if (type==L"NAME")
	{
		FName *dat = new FName();
		out.Serialize(&*dat,sizeof(FName));
		return (PVOID*)&dat;
	}
	else if (type==L"STR")
	{
		FString *dat = new FString();
		out.Serialize(&*dat,sizeof(FString));
		return (PVOID*)&dat;
	}
	else if (type==L"STRUCT")
	{
		UStruct **dat = new UStruct*;
		out.Serialize(&*dat,sizeof(UStruct*));
		return (PVOID*)&dat;
	}
	return NULL; //unhandled type
}

any evalReturn(PVOID ptr, FString &type)
{
	char output[256];

	if (type==L"BYTE")
	{
		BYTE *dat=(BYTE*)ptr;
		sprintf(output,"%hu",(unsigned short)*dat);
		delete dat;
	}
	else if (type==L"INT")
	{
		INT *dat=*((INT**)ptr);		
		sprintf(output,"%i",*dat);
		GLog->Logf(L"INT: %i",*dat);
		//delete dat;
	}
	else if (type==L"BOOL")
	{
		BITFIELD *dat=(BITFIELD*)ptr;
		if(!*dat)
			sprintf(output,"true");
		else
			sprintf(output,"false");
		delete dat;
	}
	else if (type==L"FLOAT")
	{
		FLOAT *dat=(FLOAT*)ptr;
		sprintf(output,"%f",*dat);
		delete dat;
	}
	else if (type==L"OBJECT")
	{
		UObject **dat=(UObject**)ptr;
		if(!*dat)
			return mkStr("none");
		sprintf(output,"%s",Ascii((*dat)->GetName()));
		delete dat;
	}
	else if (type==L"CLASS")
	{
		UClass **dat=(UClass**)ptr;
		if(!*dat)
			return Nil;
		sprintf(output,"%s",Ascii((*dat)->GetName()));
		delete dat;
	}
	else if (type==L"NAME")
	{
		FName *dat=(FName*)ptr;
		sprintf(output,"%s",Ascii(**dat));
		delete dat;
	}
	else if (type==L"STR")
	{
		FString *dat=(FString*)ptr;
		sprintf(output,"%s",Ascii(**dat));
		delete dat;
	}
	else if (type==L"STRUCT")
	{
		UStruct **dat=(UStruct**)ptr;
		if(!*dat)
			return Nil;
		sprintf(output,"%s",Ascii((*dat)->GetName()));
		delete dat;
	}
	else
		return Nil;

	return mkStr(output);
}

any doInvoke(any ex)
{
	any x, y;
	TCHAR *name;
	TCHAR *method;

	x = cdr(ex);
	if (isNil(y = EVAL(car(x))))
		return Nil;
	name = toString(y);
	if (isNil(x = cdr(x)) || isNil(y = EVAL(car(x))))
		return Nil;
	method = toString(y);

	TArray<FString> plst;
	while(!isNil(x = cdr(x)) && !isNil(y = EVAL(car(x))))
	{
		plst.AddItem(FString(toString(y)));
		GLog->Logf(L"PARAMETER: %s",toString(y));
	}

	AActor *obj=NULL;
	TObjectIterator<AActor> it;
	while(it.operator UBOOL())
	{
		if(FName(it->GetName())==FName(name))
		{
			obj=*it;
			break;
		}
		++it;
	}

	if(!obj)
	{
		GLog->Logf(L"OBJ NOT FOUND");
		plst.Empty();
		return Nil;
	}

	UFunction *func = obj->FindFunction(FName(method));
	if(!func)
	{
		GLog->Logf(L"FUNC NOT FOUND");
		plst.Empty();
		return Nil;
	}

	LArray<BYTE> pdata;
	LBufferWriter stream(pdata);
	LArray<PVOID> pptrs;
	PVOID ret_val=NULL;
	FString ret_type;

	int i=0;
	TFieldIterator<UProperty> params(func);
	while(params.operator UBOOL())
	{
		if(params->PropertyFlags & CPF_ParmFlags)
		{
			FString type = FString::Printf(TEXT("%s"),params->GetClass()->GetName());
			type = type.Left(type.InStr(TEXT("Property"))).Caps();

			if(params->PropertyFlags & CPF_ReturnParm)
			{
				GLog->Logf(TEXT("returns: %s"),type);
				ret_type=type;
				ret_val=createReturn(stream,type);
			}
			else
			{
				GLog->Logf(TEXT("argument: %s"),(type+TEXT(" "))+params->GetName());
				PVOID tmp = createParam(stream,type,plst(i));
				if(!tmp)
				{
					GLog->Logf(L"ARG NOT PARSED");
					plst.Empty();
					stream.Close();
					pdata.Empty();
					pptrs.Empty();
					return Nil;
				}
				pptrs.AddItem(tmp);
			}
		}
		++params;
		++i;
	}

	//int *temp=new int;
	//*temp=5;
	obj->ProcessEvent(func,pdata.GetData(),NULL);
	//GLog->Logf(L"RESULT: %i",*temp);

//	UProperty *ret_prop=func->GetReturnProperty();
	

	any ret = T;
	if(ret_val)
		ret = evalReturn(ret_val, ret_type);

	plst.Empty();
	stream.Close();
	pdata.Empty();
	pptrs.Empty();

	return ret;
}

static any initSym(any v, char *s)
{
   any x;

   val(x = intern(mkSym((byte*)s), Intern)) = v;
   return x;
}

static bool lisp_init = false;
static void initLISP()
{
	heapAlloc();
	initSymbols();

	Reloc = Nil;
	ApplyArgs = cons(cons(consSym(Nil,0), Nil), Nil);
	ApplyBody = cons(Nil,Nil);

	//I do it like this because picolisp depends on function alignment
	//which gcc handles but vc++ doesn't
	//in retrospect a better lisp library might have gone a long way
	doCustom1f=doFindFirst;
	doCustom2f=doInvoke;

	initSym(boxSubr(doCustom1),"findfirst");
	initSym(boxSubr(doCustom2),"invoke");

	lisp_init=true;
}

//usage example:
//	sLISP(L"(+ 1 2 3)");
TCHAR* sLISP(TCHAR *str)
{
	if(!lisp_init)
		initLISP();

	FILE *input = fopen("input.l","w");
	fprintf(input,"%s",Ascii(str));
	fclose(input);

	return toString(load(NULL, 0, mkStr("input.l")));
}

any dLISP(TCHAR *str)
{
	if(!lisp_init)
		initLISP();

	FILE *input = fopen("input.l","w");
	fprintf(input,"%s",Ascii(str));
	fclose(input);

	return load(NULL, 0, mkStr("input.l"));
}