//created by Nicholas 'NVShacker' Van Sickle
#include "TNMNative.h"

//unreal function generation macros and name registration
#define NAMES_ONLY
#define AUTOGENERATE_NAME(name) TNMNATIVE_API FName TNMNATIVE_##name;
#define AUTOGENERATE_FUNCTION(cls,idx,name) IMPLEMENT_FUNCTION(cls,idx,name)
#include "TNMNativeClasses.h"
#include "TNMNativeClasses2.h"
#undef AUTOGENERATE_FUNCTION
#undef AUTOGENERATE_NAME
#undef NAMES_ONLY
void RegisterNames()
{
	static INT Registered=0;
	if(!Registered++)
	{
		#define NAMES_ONLY
		#define AUTOGENERATE_NAME(name) extern TNMNATIVE_API FName TNMNATIVE_##name; TNMNATIVE_##name=FName(TEXT(#name),FNAME_Intrinsic);
		#define AUTOGENERATE_FUNCTION(cls,idx,name)
		#include "TNMNativeClasses.h"
		#include "TNMNativeClasses2.h"
		#undef DECLARE_NAME
		#undef NAMES_ONLY
	}
}

/*#undef IMPLEMENT_PACKAGE_PLATFORM(pkgname)
#define IMPLEMENT_PACKAGE_PLATFORM(pkgname) \
	extern "C" {HINSTANCE hInstance;} \
	INT DLL_EXPORT STDCALL DllMain( HINSTANCE hInInstance, DWORD Reason, void* Reserved ) \
	{ hInstance = hInInstance;  return 1; }*/

//unreal package implementation.
IMPLEMENT_PACKAGE(TNMNative);

//audio hook runtime vars
static float	SoundVolumeMultiplier=1.f;
static float	SoundRadiusMultiplier=1.f;
static float	SoundPitchMultiplier=1.f;
static bool		SoundHookEnabled=false;

static bool		FunctionsHooked=false;

//hook data
class UAudioSubsystemHook;
typedef UBOOL(UAudioSubsystemHook::* PlaySoundFunction)( AActor* Actor, INT Id, USound* Sound, FVector Location, FLOAT Volume, FLOAT Radius, FLOAT Pitch );

class UAudioSubsystemHook : public UAudioSubsystem
{
public:
	static PlaySoundFunction old_PlaySound;
	UBOOL PlaySound( AActor* Actor, INT Id, USound* Sound, FVector Location, FLOAT Volume, FLOAT Radius, FLOAT Pitch )
	{
#ifdef SOUND_DEBUG
		if(Sound)
			GLog->Logf(TEXT("hooked! %s"),Sound->GetName());
#endif
		if(SoundHookEnabled)
			return (this->*old_PlaySound)(Actor,Id,Sound,Location,Volume*SoundVolumeMultiplier,Radius*SoundRadiusMultiplier,Pitch*SoundPitchMultiplier);
		else
			return (this->*old_PlaySound)(Actor,Id,Sound,Location,Volume,Radius,Pitch);
	}
};

PlaySoundFunction UAudioSubsystemHook::old_PlaySound=NULL;

//ensures all function hooks are in place
void UtnmNativeHookObject::execAssertHook( FFrame& Stack, RESULT_DECL )
{
	RegisterNames();

	P_FINISH;

	if(FunctionsHooked)
		return;
	FunctionsHooked=true;

	guard(Utnmnative::execAssertHook);

	//hook UGalaxyAudioSubsystem::PlaySoundW
	DetourTransactionBegin();
	DetourUpdateThread(GetCurrentThread());
	//VTableLookup((PBYTE)USound::Audio,0x74,(PBYTE*)&UAudioSubsystemHook::old_PlaySound);
	HMODULE hGalaxy = GetModuleHandle(TEXT("Galaxy")); //jim is officially my hero!
	FARPROC *address=(FARPROC*)&UAudioSubsystemHook::old_PlaySound;
	*address=GetProcAddress(hGalaxy,"?PlaySoundW@UGalaxyAudioSubsystem@@UAEHPAVAActor@@HPAVUSound@@VFVector@@MMM@Z");
	DetourAttach(&(PVOID&)UAudioSubsystemHook::old_PlaySound,
			(PVOID)(&(PVOID&)UAudioSubsystemHook::PlaySound));

	LONG l = DetourTransactionCommit();
	GLog->Logf(TEXT("TNMNative >> Function hooking complete, DetourTransactionCommit returned code %ld"),l);

	unguard;
}

IMPLEMENT_CLASS(UtnmNativeHookObject);

//update hook info
void UtnmSoundModifier::execConfigureSound(FFrame &Stack, void *const Result)
{
	RegisterNames();

	P_GET_UBOOL_OPTX(n_SoundHookEnabled,SoundHookEnabled);
	P_GET_FLOAT_OPTX(n_SoundVolumeMultiplier,SoundVolumeMultiplier);
	P_GET_FLOAT_OPTX(n_SoundRadiusMultiplier,SoundRadiusMultiplier);
	P_GET_FLOAT_OPTX(n_SoundPitchMultiplier,SoundPitchMultiplier);
	P_FINISH;

	SoundHookEnabled=n_SoundHookEnabled;
	SoundVolumeMultiplier=n_SoundVolumeMultiplier;
	SoundRadiusMultiplier=n_SoundRadiusMultiplier;
	SoundPitchMultiplier=n_SoundPitchMultiplier;
}

IMPLEMENT_CLASS(UtnmSoundModifier);

//various time retrieval functions for convenience (used with the irc client)
void UtnmTime::execGetYear(FFrame &Stack, void *const Result)
{
	P_FINISH;

    SYSTEMTIME st;  
    GetLocalTime(&st);

	int *time=(int*)Result;
	*time=st.wYear;
}

void UtnmTime::execGetMonth(FFrame &Stack, void *const Result)
{
	P_FINISH;

    SYSTEMTIME st;  
    GetLocalTime(&st);

	int *time=(int*)Result;
	*time=st.wMonth;
}

void UtnmTime::execGetDate(FFrame &Stack, void *const Result)
{
	P_FINISH;

    SYSTEMTIME st;  
    GetLocalTime(&st);

	int *time=(int*)Result;
	*time=st.wDay;
}

void UtnmTime::execGetDayOfWeek(FFrame &Stack, void *const Result)
{
	P_FINISH;

    SYSTEMTIME st;  
    GetLocalTime(&st);

	int *time=(int*)Result;
	*time=st.wDayOfWeek;
}

void UtnmTime::execGetHour(FFrame &Stack, void *const Result)
{
	P_FINISH;

    SYSTEMTIME st;  
    GetLocalTime(&st);

	int *time=(int*)Result;
	*time=st.wHour;
}

void UtnmTime::execGetMinute(FFrame &Stack, void *const Result)
{
	P_FINISH;

    SYSTEMTIME st;  
    GetLocalTime(&st);

	int *time=(int*)Result;
	*time=st.wMinute;
}

void UtnmTime::execGetSecond(FFrame &Stack, void *const Result)
{
	P_FINISH;

    SYSTEMTIME st;  
    GetLocalTime(&st);

	int *time=(int*)Result;
	*time=st.wSecond;
}

IMPLEMENT_CLASS(UtnmTime);

void ATestReflection::execTestReflection1(FFrame &Stack, void *const Result)
{
	RegisterNames();

	P_GET_OBJECT(UClass,lookup);
	P_FINISH;

	TFieldIterator<UFunction> functions(lookup);
	while(functions.operator UBOOL())
	{
		GLog->Logf(TEXT("function: %s"),functions->GetName());
		TFieldIterator<UProperty> params(*functions);
		while(params.operator UBOOL())
		{
			if(params->PropertyFlags & CPF_ParmFlags)
			{
				FString type = FString::Printf(TEXT("%s"),params->GetClass()->GetName());
				type = type.Left(type.InStr(TEXT("Property")));

				if(params->PropertyFlags & CPF_ReturnParm)
					GLog->Logf(TEXT("returns: %s"),type);
				else
					GLog->Logf(TEXT("argument: %s"),(type+TEXT(" "))+params->GetName());
			/*}
			else if(params->GetName())
			{*/
				//GLog->Logf(L"field: %s",params->GetName());
				params->ExportCppItem(*GLog);
			}
			++params;
		}
		++functions;
	}
}

void ATestReflection::execTestReflection2(FFrame &Stack, void *const Result)
{
	RegisterNames();

	P_GET_OBJECT(UObject,obj);
	P_GET_NAME(fn);
	P_GET_OBJECT(UObject,src);
	P_GET_NAME(params);
	P_FINISH;

	ScriptConsoleExec(TEXT("testexec1"),*GLog,this);
	UFunction *test=FindFunction(FName(TEXT("TestExec2")));
	test->FunctionFlags = test->FunctionFlags | 0x00000200;
	ScriptConsoleExec(TEXT("testexec2"),*GLog,this);
	test->FunctionFlags = test->FunctionFlags ^ 0x00000200;

	TFieldIterator<UStructProperty> structs(src->GetClass());
	while(structs.operator UBOOL())
	{
		if(appStricmp(structs->GetName(),*params)==0)
		{
			/*UStruct *str = (UStruct*)(src->FindObjectField(structs->GetName()));

			size_t size=0;
			TFieldIterator<UProperty> properties(str);
			while(properties.operator UBOOL())
			{
				properties->GetOuterUField()
				size+=properties->GetSize();
				++properties;
			}

			void *data=malloc(size);
			void *data2=data;
			properties=*new TFieldIterator<UProperty>(str);
			while(properties.operator UBOOL())
			{
				properties->CopyCompleteValue(data2,(void*)properties->Offset);
				//memcpy(data2,*properties,sizeof(*properties));
				data2=(void*)(size_t(data2)+properties->GetSize());
				++properties;
			}
			
			obj->ProcessEvent(obj->FindFunction(fn),data);*/

			struct
			{
				INT damage;
				class APawn* instigatedBy;
				FVector hitlocation;
				FVector momentum;
				FName damageType;
			} _params;

			TObjectIterator<APlayerPawn> fp;

			_params.damage=10;
			_params.instigatedBy=*fp;
			_params.hitlocation=fp->Location;
			_params.momentum=FVector(0,0,0);
			_params.damageType=FName(TEXT("Shot"));

			obj->ProcessEvent(obj->FindFunction(fn),&_params);
			break;
		}
		++structs;
	}
}

void ATestReflection::execTestLisp(FFrame &Stack, void *const Result)
{
	RegisterNames();
	P_FINISH;
}

IMPLEMENT_CLASS(ATestReflection);

void UtnmLisp::execExecute(FFrame &Stack, void *const Result)
{
	RegisterNames();
}

IMPLEMENT_CLASS(UtnmLisp);

void UtnmLog::execfOpen(FFrame &Stack, void *const Result)
{
	RegisterNames();

	P_GET_STR(file_name_str);
	P_FINISH;

	//GLog->Logf(L"Opening file: %s",file_name_str);
	const char *file_name_a=appToAnsi((TCHAR*)file_name_str.GetCharArray().GetData());
	file = new ofstream(file_name_a);
	free((void*)file_name_a);
	//GLog->Logf(L"File opened...");
}

void UtnmLog::execfClose(FFrame &Stack, void *const Result)
{
	RegisterNames();

	P_FINISH;

	if(file)
	{
		file->close();
		delete file;
		file=NULL;
	}

	/*GLog->Logf(L"Closing file...");
	file->close();
	delete file;
	file=NULL;
	GLog->Logf(L"File closed...");*/
}

void UtnmLog::execfLog(FFrame &Stack, void *const Result)
{
	RegisterNames();

	P_GET_STR(line);
	P_FINISH;

	//GLog->Logf(L"Writing line: %s",line);
	const char *line_a=appToAnsi((TCHAR*)line.GetCharArray().GetData());
	(*file) << line_a << endl;
	free((void*)line_a);
	//GLog->Logf(L"Line written...");
}

UtnmLog::~UtnmLog()
{
	ConditionalDestroy();
}

IMPLEMENT_CLASS(UtnmLog);

void UTestGC::execLogInfo(FFrame &Stack, void *const Result)
{
	RegisterNames();

	P_GET_OBJECT(XGC, _gc);
	P_FINISH;

	XClipRect rect = _gc->GetClipRect();
	GLog->Logf(L"originX: %f originY: %f clipX: %f clipY: %f, clipWidth: %f clipHeight: %f",
		rect.originX, rect.originY, rect.clipX, rect.clipY, rect.clipWidth, rect.clipHeight);
}

IMPLEMENT_CLASS(UTestGC);

static bool uihooked;
#define SCALE 1.25f

void ClipRectSize(XGC *gc)
{
	XClipRect rect = gc->GetClipRect();

	rect.clipX*=SCALE;
	rect.clipY*=SCALE;
	rect.clipWidth*=SCALE;
	rect.clipHeight*=SCALE;
	rect.originX*=SCALE;
	rect.originY*=SCALE;

	gc->SetClipRect(rect);
}

void ClipRectDownSize(XGC *gc)
{
	XClipRect rect = gc->GetClipRect();

	rect.clipX/=SCALE;
	rect.clipY/=SCALE;
	rect.clipWidth/=SCALE;
	rect.clipHeight/=SCALE;
	rect.originX/=SCALE;
	rect.originY/=SCALE;

	gc->SetClipRect(rect);
}

DECLARE_HOOK(XGC, DrawIconPattern, void, 
	FLOAT destX, FLOAT destY, FLOAT destWidth, FLOAT destHeight,
	FLOAT srcX, FLOAT srcY, FLOAT srcWidth, FLOAT srcHeight,
	UTexture *texture)
{
	ClipRectSize(this);
	/*destX*=SCALE;
	destY*=SCALE;
	destWidth*=SCALE;
	destHeight*=SCALE;*/
	(this->*old_DrawIconPattern)(destX,destY,destWidth,destHeight,srcX,srcY,
									srcWidth,srcHeight,texture);
	ClipRectDownSize(this);
}

DECLARE_HOOK(XGC, DrawStretchedIcon, void,
	FLOAT destX, FLOAT destY,
	FLOAT destWidth, FLOAT destHeight, UTexture *texture)
{
	ClipRectSize(this);
	/*destX*=SCALE;
	destY*=SCALE;
	destWidth*=SCALE;
	destHeight*=SCALE;*/
	(this->*old_DrawStretchedIcon)(destX,destY,destWidth,destHeight,texture);
	ClipRectDownSize(this);
}

DECLARE_HOOK(XGC, DrawScaledIcon, void,
	FLOAT destX, FLOAT destY,
	FLOAT scaleX, FLOAT scaleY, UTexture *texture)
{
/*	ClipRectSize(this);
	destX*=SCALE;
	destY*=SCALE;*/
	scaleX*=SCALE;
	scaleY*=SCALE;
	(this->*old_DrawScaledIcon)(destX,destY,scaleX,scaleY,texture);
//	ClipRectDownSize(this);
}

DECLARE_HOOK(XGC, DrawIcon, void,
	FLOAT destX, FLOAT destY, UTexture *texture)
{
//	ClipRectSize(this);
	DrawScaledIcon(destX,destY,1.f,1.f,texture);
//	ClipRectDownSize(this);
}

DECLARE_HOOK(XGC, DrawPattern, void,
	FLOAT destX, FLOAT destY,
	FLOAT destWidth, FLOAT destHeight, FLOAT orgX, FLOAT orgY,
	UTexture *texture)
{
	ClipRectSize(this);
	/*destX*=SCALE;
	destY*=SCALE;
	destWidth*=SCALE;
	destHeight*=SCALE;*/
	(this->*old_DrawPattern)(destX,destY,destWidth,destHeight,orgX,orgY,texture);
	ClipRectDownSize(this);
}

DECLARE_HOOK(XGC, DrawTexture, void,
	FLOAT destX, FLOAT destY, FLOAT destWidth, FLOAT destHeight,
	FLOAT srcX, FLOAT srcY, UTexture *texture)
{
	ClipRectSize(this);
	/*destX*=SCALE;
	destY*=SCALE;
	destWidth*=SCALE;
	destHeight*=SCALE;*/
	(this->*old_DrawTexture)(destX,destY,destWidth,destHeight,srcX,srcY,texture);
	ClipRectDownSize(this);
}

DECLARE_HOOK(XGC, DrawStretchedTexture, void,
	FLOAT destX, FLOAT destY, FLOAT destWidth, FLOAT destHeight,
	FLOAT srcX, FLOAT srcY, FLOAT srcWidth, FLOAT srcHeight, UTexture *texture)
{
	ClipRectSize(this);
	destX*=SCALE;
	destY*=SCALE;
	destWidth*=SCALE;
	destHeight*=SCALE;
	(this->*old_DrawStretchedTexture)(destX,destY,destWidth,destHeight,
		srcX,srcY,srcWidth,srcHeight,texture);
	ClipRectDownSize(this);
}
/*
		void DrawStretchedTexture(FLOAT destX, FLOAT destY, FLOAT destWidth, FLOAT destHeight,
		                 FLOAT srcX, FLOAT srcY, FLOAT srcWidth, FLOAT srcHeight, UTexture *texture);

		void DrawBox(FLOAT destX, FLOAT destY, FLOAT destWidth, FLOAT destHeight,
		             FLOAT srcX, FLOAT srcY, FLOAT thickness, UTexture *texture);

		void DrawBorders(FLOAT destX, FLOAT destY, FLOAT destWidth, FLOAT destHeight,
		                 FLOAT leftMargin, FLOAT rightMargin, FLOAT topMargin, FLOAT bottomMargin,
		                 UTexture *bordTL, UTexture *bordTR, UTexture *bordBL, UTexture *bordBR,
		                 UTexture *bordL, UTexture *bordR, UTexture *bordT, UTexture *bordB,
		                 UTexture *center=NULL,
		                 UBOOL bStretchHorizontally=FALSE, UBOOL bStretchVertically=FALSE);

		void DrawActor(class AActor *actor, UBOOL bClearZ=FALSE, UBOOL bConstrain=FALSE,
		               UBOOL bUnlit=FALSE, FLOAT drawScale=1.0, FLOAT scaleGlow=1.0,
		               UTexture *newSkin=NULL);

		void DrawChar(UFont *font, TCHAR ch, FPlane &plane, BYTE &bUnderline,
		              FLOAT destX, FLOAT destY, FLOAT *pXOffset=NULL, FLOAT *pHeight=NULL);
			  */
DECLARE_HOOK(XGC, DrawChar, void,
	UFont *font, TCHAR ch, FPlane &plane, BYTE &bUnderline,
	FLOAT destX, FLOAT destY, FLOAT *pXOffset, FLOAT *pHeight)
{
	ClipRectSize(this);
	destX*=SCALE;
	destY*=SCALE;
	(this->*old_DrawChar)(font,ch,plane,bUnderline,destX,destY,pXOffset,pHeight);
	ClipRectDownSize(this);
}

DECLARE_HOOK(XGC, DrawTile, void, 
	UTexture *texture,
	FLOAT destX, FLOAT destY, FLOAT destWidth, FLOAT destHeight,
	FLOAT srcX, FLOAT srcY, FLOAT srcWidth, FLOAT srcHeight,
	UBOOL bWrapHorizontal, UBOOL bWrapVertical)
{
	ClipRectSize(this);
	destX*=SCALE;
	destY*=SCALE;
	destWidth*=SCALE;
	destHeight*=SCALE;
	
	(this->*old_DrawTile)(texture,destX,destY,destWidth,destHeight,srcX,srcY,
							srcWidth,srcHeight,bWrapHorizontal,bWrapVertical);
	ClipRectDownSize(this);
}

//hook data
class XRootWindowHook;
typedef void(XRootWindowHook::* DrawFunction)(UCanvas *canvas);
class XRootWindowHook : public XRootWindow
{
public:
	static DrawFunction old_ResizeRoot;
	void ResizeRoot(UCanvas *canvas)
	{static bool onlyonce=true;		
		if(hMultiplier!=1 || vMultiplier!=1/* || onlyonce*/)
		{//onlyonce=false;
			(this->*old_ResizeRoot)(canvas);
			//update window size
//			width*=hMultiplier/SCALE;
//			height*=vMultiplier/SCALE;
			width*=hMultiplier;
			height*=vMultiplier;
			//disable multipliers that cause the scaling
			hMultiplier=1;
			vMultiplier=1;
			//update default window size
			//(might not be necessary)
			hardcodedWidth=width;
			hardcodedHeight=height;
			//update clipping rectangle for cursor
//			clipRect.clipWidth=width*SCALE;
//			clipRect.clipHeight=height*SCALE;
			clipRect.clipWidth=width;
			clipRect.clipHeight=height;
			winGC->SetClipRect(clipRect);
			//refresh subwindows
			for(XWindow *win=GetBottomChild();win!=NULL;win=win->GetHigherSibling())
			{
				win->Hide();
				win->Show();
			}
		}
	}
};
DrawFunction XRootWindowHook::old_ResizeRoot = (DrawFunction)&XRootWindow::ResizeRoot;

void UtnmUIfix::execUpdateUIRes(FFrame &Stack, void *const Result)
{
	RegisterNames();
	P_FINISH;

	if(!uihooked)
	{
		uihooked=true;

		DetourTransactionBegin();
		DetourUpdateThread(GetCurrentThread());

		DetourAttach(&(PVOID&)XRootWindowHook::old_ResizeRoot,
					 (PVOID)(&(PVOID&)XRootWindowHook::ResizeRoot));

		//IMPLEMENT_HOOK(XGC,DrawIconPattern);
		//IMPLEMENT_HOOK(XGC,DrawStretchedIcon);
		//IMPLEMENT_HOOK(XGC,DrawScaledIcon);
		//IMPLEMENT_HOOK(XGC,DrawIcon);
		//IMPLEMENT_HOOK(XGC,DrawPattern);
		//IMPLEMENT_HOOK(XGC,DrawTexture);
		//IMPLEMENT_HOOK(XGC,DrawStretchedTexture);
		//IMPLEMENT_HOOK(XGC,DrawChar);
		//IMPLEMENT_HOOK(XGC,DrawTile);		
		LONG l = DetourTransactionCommit();
		GLog->Logf(TEXT("UIfix >> Function hooking complete, DetourTransactionCommit returned code %ld"),l);
	}
}

IMPLEMENT_CLASS(UtnmUIfix);

void UtnmCanvas::DrawTile( UTexture* Texture, FLOAT X, FLOAT Y, FLOAT XL, FLOAT YL, FLOAT U, FLOAT V, FLOAT UL, FLOAT VL, class FSpanBuffer* SpanBuffer, FLOAT Z, FPlane Color, FPlane Fog, DWORD PolyFlags )
{
	/*FLOAT	scale=1.25f;
	X*=scale;
	Y*=scale;
	XL*=scale;
	YL*=scale;*/
	UCanvas::DrawTile(Texture,X,Y,XL,YL,U,V,UL,VL,SpanBuffer,Z,Color,Fog,PolyFlags);
}

void UtnmCanvas::DrawIcon( UTexture* Texture, FLOAT ScreenX, FLOAT ScreenY, FLOAT XSize, FLOAT YSize, class FSpanBuffer* SpanBuffer, FLOAT Z, FPlane Color, FPlane Fog, DWORD PolyFlags )
{
	/*FLOAT	scale=1.25f;
	ScreenX*=scale;
	ScreenY*=scale;
	XSize*=scale;
	YSize*=scale;*/
	UCanvas::DrawIcon(Texture,ScreenX,ScreenY,XSize,YSize,SpanBuffer,Z,Color,Fog,PolyFlags);
}

void UtnmCanvas::DrawPattern( UTexture* Texture, FLOAT X, FLOAT Y, FLOAT XL, FLOAT YL, FLOAT Scale, FLOAT OrgX, FLOAT OrgY, class FSpanBuffer* SpanBuffer, FLOAT Z, FPlane Color, FPlane Fog, DWORD PolyFlags )
{
	/*FLOAT	scale=1.25f;
	X*=scale;
	Y*=scale;
	XL*=scale;
	YL*=scale;
	Scale*=scale;*/
	UCanvas::DrawPattern(Texture,X,Y,XL,YL,Scale,OrgX,OrgY,SpanBuffer,Z,Color,Fog,PolyFlags);
}

IMPLEMENT_CLASS(UtnmCanvas);
/*
boost::regex expression(
   "^(template[[:space:]]*<[^;:{]+>[[:space:]]*)?"
   "(class|struct)[[:space:]]*"
   "(\\<\\w+\\>([[:blank:]]*\\([^)]*\\))?"
   "[[:space:]]*)*(\\<\\w*\\>)[[:space:]]*"
   "(<[^;:{]+>[[:space:]]*)?(\\{|:[^;\\{()]*\\{)"); 

void IndexClasses(map_type& m, const std::string& file) 
{ 
   std::string::const_iterator start, end; 
   start = file.begin(); 
   end = file.end(); 
      boost::match_results<std::string::const_iterator> what; 
   boost::match_flag_type flags = boost::match_default; 
   while(regex_search(start, end, what, expression, flags)) 
   { 
      // what[0] contains the whole string 
      // what[5] contains the class name. 
      // what[6] contains the template specialisation if any. 
      // add class name and position to map: 
      m[std::string(what[5].first, what[5].second) 
            + std::string(what[6].first, what[6].second)] 
         = what[5].first - file.begin(); 
      // update search position: 
      start = what[0].second; 
      // update flags: 
      flags |= boost::match_prev_avail; 
      flags |= boost::match_not_bob; 
   } 
}*/

void UtnmRegEx::execregex_search(FFrame &Stack,void *const Result)
{
	RegisterNames();

	P_GET_STR(query_str);
	P_GET_STR(regex_str);
	P_GET_STR_REF(match_str);
	P_FINISH;

	const char *query_a=appToAnsi((TCHAR*)query_str.GetCharArray().GetData());
	const char *regex_a=appToAnsi((TCHAR*)regex_str.GetCharArray().GetData());
	string query=string(query_a);
	regex expression=regex(regex_a);
//	free((void*)query_a);
//	free((void*)regex_a);

	string::const_iterator start=query.begin(), end=query.end(); 
	if(results==NULL)
		results=new match_results<string::const_iterator>(); 
	match_flag_type flags = boost::match_default; 
	//match_str=NULL;

	in_iterator=true;

	PRE_ITERATOR
		//if(match_str)
			//delete match_str;
		if(regex_search(start,end,*results,expression,flags))
		{
			string r=string((*results)[0].first,(*results)[0].second);
			*match_str=FString(appFromAnsi(r.c_str()));
			start=(*results)[0].second;
			flags |= boost::match_prev_avail; 
		}
		else
			break;
	POST_ITERATOR
	in_iterator=false;

	/*skip++;
	while(*skip++!=EX_IteratorNext)GLog->Logf(L"0x%02X",*skip);
	int z=10;
	while(z-->0)GLog->Logf(L"0x%02X",*skip++);*/
}

void UtnmRegEx::execregex_replace(FFrame &Stack,void *const Result)
{
	RegisterNames();

	P_GET_STR(orig_str);
	P_GET_STR(regex_str);
	P_GET_STR(replacement_str);
	P_FINISH;

	FString *ret=(FString*)Result;

	const char *orig_a=appToAnsi((TCHAR*)orig_str.GetCharArray().GetData());
	const char *regex_a=appToAnsi((TCHAR*)regex_str.GetCharArray().GetData());
	const char *replacement_a=appToAnsi((TCHAR*)replacement_str.GetCharArray().GetData());
	string orig=string(orig_a);
	regex expression=regex(regex_a);
	string replacement=string(replacement_a);

	ostringstream t(ios::out);
	ostream_iterator<char, char> oi(t);
	regex_replace(oi, orig.begin(), orig.end(),
		expression, replacement, match_default | format_all);
	*ret=FString(appFromAnsi(t.str().c_str()));
}

void UtnmRegEx::execregex_match(FFrame &Stack,void *const Result)
{
	RegisterNames();

	P_GET_STR(query_str);
	P_GET_STR(regex_str);
	P_FINISH;
	bool *ret=(bool*)Result;

	const char *query_a=appToAnsi((TCHAR*)query_str.GetCharArray().GetData());
	const char *regex_a=appToAnsi((TCHAR*)regex_str.GetCharArray().GetData());
	string query=string(query_a);
	regex expression=regex(regex_a);	

	if(results2==NULL)
		results2=new cmatch(); 

	*ret=regex_match(query_a,*results2,expression);
}

void UtnmRegEx::execsubgroup_search(FFrame &Stack,void *const Result)
{
	RegisterNames();

	P_GET_INT(i);
	P_FINISH;

	FString *ret=(FString*)Result;

	if(!in_iterator)
	{
		*ret=FString(L"");
		return;
	}

	string r=string((*results)[i].first,(*results)[i].second);
	*ret=FString(appFromAnsi(r.c_str()));
}

void UtnmRegEx::execsubgroup_match(FFrame &Stack,void *const Result)
{
	RegisterNames();

	P_GET_INT(i);
	P_FINISH;

	FString *ret=(FString*)Result;

	if(results2==NULL)
	{
		*ret=FString(L"");
		return;
	}

	string r=string((*results2)[i].first,(*results2)[i].second);
	*ret=FString(appFromAnsi(r.c_str()));
}

IMPLEMENT_CLASS(UtnmRegEx);

void ATestIterator::execIteratorTest(FFrame &Stack,void *const Result)
{
	RegisterNames();

	P_GET_INT(count);
	P_GET_INT_REF(cur);
	P_FINISH;

	*cur=0;
	PRE_ITERATOR
		(*cur)++;
		if(*cur>count)
			break;
	POST_ITERATOR
	//GLog->Logf(L"%p %X %p",StartCode,wEndOffset,Stack.Code);
}

IMPLEMENT_CLASS(ATestIterator);

void UtnmRendererChanger::execChangeRenderer(FFrame &Stack, void  *const Result)
{
	RegisterNames();

	P_FINISH;

	//system("TNM.exe INI=\"..\\TNM\\System\\TNM.ini\" USERINI=\"..\\TNM\\System\\TNMUser.ini\" log=TNM.log");
	ShellExecuteA(NULL, "open", "TNM.exe", 
		"-changevideo INI=\"..\\TNM\\System\\TNM.ini\" USERINI=\"..\\TNM\\System\\TNMUser.ini\" log=TNM.log",
		NULL, SW_SHOWNORMAL);
}

IMPLEMENT_CLASS(UtnmRendererChanger);