//=============================================================================
// AmmoDoubleGuns.
//=============================================================================
class Ammo45 extends TNMAmmo;

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	// If this is a netgame, then override defaults
	if ( Level.NetMode != NM_StandAlone )
      AmmoAmount = 20;
}

function bool UseAmmo(int AmountNeeded)
{
	local vector offset, tempvec, X, Y, Z;
	local ShellCasing shell;
	local DeusExWeapon W;
	local int modifier;

	if (Super.UseAmmo(AmountNeeded))
	{
		GetAxes(Pawn(Owner).ViewRotation, X, Y, Z);
		offset = Owner.CollisionRadius * X + 0.3 * Owner.CollisionRadius * Y;
		tempvec = 0.8 * Owner.CollisionHeight * Z;
		offset.Z += tempvec.Z;

		// use silent shells if the weapon has been silenced
		W = DeusExWeapon(Pawn(Owner).Weapon);
		if ((DeusExMPGame(Level.Game) != None) && (!DeusExMPGame(Level.Game).bSpawnEffects))
		{
			shell = None;
		}
		else
		{
			if (W != None)
			{
				if(W.isA('WeaponDoubleGuns') && !WeaponDoubleGuns(W).bFired1)
					modifier = -1;
				else 
					modifier = 1;
	
				if(modifier == -1) //we need to do silly stuff because vectors are shits
				{
					offset = Owner.CollisionRadius * X - 0.3 * Owner.CollisionRadius * Y;
					offset.Z += tempvec.Z;
				}

				if((W.NoiseLevel < 0.1) || W.bHasSilencer)
					shell = spawn(class'ShellCasingSilent',,, Owner.Location + offset);
				else
					shell = spawn(class'ShellCasing',,, Owner.Location + offset);
			}
		}

		if (shell != None)
		{			
			shell.Velocity = (FRand()*20+90) * Y * modifier + (10-FRand()*20) * X;
			shell.Velocity.Z = 0;
		}
		return True;
	}
	return False;

}

//
// Belt and Inventory Icons
//
#exec texture IMPORT NAME=LargeIconAmmoDGuns FILE=Textures\LargeIconAmmoDguns.pcx GROUP=Skins MIPS=off
#exec texture IMPORT NAME=BeltIconAmmoDGuns FILE=Textures\BeltIconAmmoDguns.pcx GROUP=Skins MIPS=off

#exec mesh IMPORT MESH=AmmoDoubleGuns ANIVFILE=MODELS\AmmoDoubleGuns_a.3d DATAFILE=MODELS\AmmoDoubleGuns_d.3d X=0 Y=0 Z=0 UNMIRROR=1
#exec MESH ORIGIN MESH=AmmoDoubleGuns X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=AmmoDoubleGuns SEQ=All       STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=AmmoDoubleGuns SEQ=DgunsAmmo STARTFRAME=0 NUMFRAMES=1

#exec TEXTURE IMPORT NAME=JAmmoDoubleGuns1 FILE=Textures\45AmmoTex1.PCX GROUP=Skins // 01 - default

#exec MESHMAP NEW   MESHMAP=AmmoDoubleGuns MESH=AmmoDoubleGuns
#exec MESHMAP SCALE MESHMAP=AmmoDoubleGuns X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=AmmoDoubleGuns NUM=1 TEXTURE=JAmmoDoubleGuns1

defaultproperties
{
     bShowInfo=True
     AmmoAmount=20
     MaxAmmo=200
     ItemName=".45 Ammo"
     ItemArticle="some"
     PickupViewMesh=LodMesh'TNMItems.AmmoDoubleGuns'
     PickupViewScale=0.300000
     Icon=Texture'TNMItems.Skins.BeltIconAmmoDGuns'
     largeIcon=Texture'TNMItems.Skins.LargeIconAmmoDGuns'
     largeIconWidth=44
     largeIconHeight=28
     Description="Caliber 45 ball rounds are a type of ammunition commonly used in powerful semi-automatic sidearms. 13mm in diameter, they have greater stopping power than 10mm bullets, but they also create a greater recoil than less powerful ammo. Additionally they are... quite messy."
     beltDescription=".45 AMMO"
     Mesh=LodMesh'TNMItems.AmmoDoubleGuns'
     DrawScale=0.300000
     CollisionRadius=8.500000
     CollisionHeight=2.300000
     bCollideActors=True
}
