//=============================================================================
// AmmoBlowDart.
//=============================================================================
class AmmoBlowDart extends TNMAmmo;

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	// If this is a netgame, then override defaults
	if ( Level.NetMode != NM_StandAlone )
      AmmoAmount = 8;
}

// Belt and Inventory Icons
#exec TEXTURE IMPORT NAME=BeltIconAmmoDart FILE=Textures\BeltIconAmmoDart.pcx GROUP=Icons MIPS=off // Belt Icon
#exec texture IMPORT NAME=LargeIconAmmoDart FILE=Textures\LargeIconAmmoDart.pcx GROUP=Icons MIPS=off // Iventory Icon

#exec MESH IMPORT MESH=AmmoBlowDart ANIVFILE=MODELS\AmmoBlowDart_a.3d DATAFILE=MODELS\AmmoBlowDart_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=AmmoBlowDart X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=AmmoBlowDart SEQ=All      STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=AmmoBlowDart SEQ=DartAmmo STARTFRAME=0 NUMFRAMES=1

#exec TEXTURE IMPORT NAME=JAmmoBlowDart1 FILE=Textures\AmmoBlowDart.pcx GROUP=Skins // 1 - Default

#exec MESHMAP NEW   MESHMAP=AmmoBlowDart MESH=AmmoBlowDart
#exec MESHMAP SCALE MESHMAP=AmmoBlowDart X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=AmmoBlowDart NUM=1 TEXTURE=JAmmoBlowDart1

defaultproperties
{
     bShowInfo=True
     AmmoAmount=6
     MaxAmmo=60
     ItemName="Blow Darts"
     ItemArticle="some"
     PickupViewMesh=LodMesh'tnmitems.AmmoBlowDart'
     PickupViewScale=0.100000
     LandSound=Sound'DeusExSounds.Generic.PaperHit2'
     Icon=Texture'tnmitems.Icons.BeltIconAmmoDart'
     largeIcon=Texture'tnmitems.Icons.LargeIconAmmoDart'
     largeIconWidth=20
     largeIconHeight=47
     Description="The blow dart was a weapon favored by the TutiFruti Tribe for guerilla jungle combat (until they found out about silencers); however, silent kills require a high degree of skill."
     beltDescription="BLOWDART"
     Mesh=LodMesh'tnmitems.AmmoBlowDart'
     DrawScale=0.100000
     CollisionRadius=8.500000
     CollisionHeight=2.000000
     bCollideActors=True
}
