//=============================================================================
// AmmoQdRocket.
//=============================================================================
class AmmoQdRocket extends TNMAmmo;

#exec texture IMPORT NAME=BeltIconAmmoQdRockets FILE="Textures\BeltIconAmmoQdRockets.pcx" MIPS=off
#exec texture IMPORT NAME=LargeIconAmmoQdRockets FILE="Textures\LargeIconAmmoQdRockets.pcx" MIPS=off

#exec mesh IMPORT MESH=DblRocketAmmo ANIVFILE=MODELS\DblRocketAmmo_a.3d DATAFILE=MODELS\DblRocketAmmo_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=DblRocketAmmo X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=DblRocketAmmo SEQ=All    STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=DblRocketAmmo SEQ=QdAmmo STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW   MESHMAP=DblRocketAmmo MESH=DblRocketAmmo
#exec MESHMAP SCALE MESHMAP=DblRocketAmmo X=0.00390625 Y=0.00390625 Z=0.00390625


#exec MESHMAP SETTEXTURE MESHMAP=DblRocketAmmo NUM=2 TEXTURE=DblRClip

defaultproperties
{
     bShowInfo=True
     AmmoAmount=4
     MaxAmmo=40
     ItemName="Rockets"
     ItemArticle="some"
     PickupViewMesh=LodMesh'tnmitems.DblRocketAmmo'
     LandSound=Sound'DeusExSounds.Generic.WoodHit2'
     Icon=Texture'tnmitems.BeltIconAmmoQdRockets'
     largeIcon=Texture'tnmitems.LargeIconAmmoQdRockets'
     largeIconWidth=46
     largeIconHeight=36
     Description="A clip of gyroscopically stabilized anti-personnel rockets with limited onboard guidance systems for in-flight course corrections. Engineered for use with the Quad Rocket Launcher."
     beltDescription="ROCKET"
     Mesh=LodMesh'tnmitems.DblRocketAmmo'
     DrawScale=0.800000
     CollisionRadius=8.000000
     CollisionHeight=2.000000
     bCollideActors=True
}
