//=============================================================================
// BigNapalmExplosion
//=============================================================================
class BigNapalmExplosion extends NapalmExplosion;


function tick(float deltatime)
{
    local int i, j;
	local NapalmBlob blob;

	time += deltaTime;
	totalTime += deltaTime;

	DrawScale = 0.5 + (3.0 * totalTime / duration);
	ScaleGlow = (duration - totalTime) / duration;

	if (time >= animSpeed)
	{
		Texture = frames[nextFrame++];
		if (nextFrame >= numFrames)  //hack here
		{
		if(!bUnderWater)
        {
        	for (i=0; i<NumBlobs; i++)
        		{
        		j = (Frand()+2);
        		blob = Spawn(class'NapalmBlob', none,, Location);
                if(blob != none)
        			{
        			blob.drawscale=blob.default.DrawScale*j;
                    }
        		}
    	}
    	else  //no fire underwater
    	{
        }
			Destroy();
		}

		time -= animSpeed;
	}


}

defaultproperties
{
     numBlobs=15
     numFrames=6
     frames(0)=Texture'DeusExItems.Skins.FlatFXTex14'
     frames(1)=Texture'DeusExItems.Skins.FlatFXTex15'
     frames(2)=Texture'DeusExItems.Skins.FlatFXTex16'
     frames(3)=Texture'DeusExItems.Skins.FlatFXTex17'
     frames(4)=Texture'DeusExItems.Skins.FlatFXTex18'
     frames(5)=Texture'DeusExItems.Skins.FlatFXTex19'
     Texture=Texture'DeusExItems.Skins.FlatFXTex14'
}
