//=============================================================================
// ChemicalBottle.
//=============================================================================
class ChemicalBottle extends tnmitems;

enum ESkinColor
{
	Ethanol,
	Acetone,
	Turpentine,
	Methanol,
	Toluene,
	Isopropanol,
	Chloroform,
	PicricAcid
};

#exec TEXTURE IMPORT NAME=JChemBottleTex0 FILE=Textures\ChemBottleTex0.pcx GROUP=Skins // 2 - Default
#exec TEXTURE IMPORT NAME=JChemBottleTex1 FILE=Textures\ChemBottleTex1.pcx GROUP=Skins
#exec TEXTURE IMPORT NAME=JChemBottleTex2 FILE=Textures\ChemBottleTex2.pcx GROUP=Skins
#exec TEXTURE IMPORT NAME=JChemBottleTex3 FILE=Textures\ChemBottleTex3.pcx GROUP=Skins
#exec TEXTURE IMPORT NAME=JChemBottleTex4 FILE=Textures\ChemBottleTex4.pcx GROUP=Skins
#exec TEXTURE IMPORT NAME=JChemBottleTex5 FILE=Textures\ChemBottleTex5.pcx GROUP=Skins
#exec TEXTURE IMPORT NAME=JChemBottleTex6 FILE=Textures\ChemBottleTex6.pcx GROUP=Skins
#exec TEXTURE IMPORT NAME=JChemBottleTex7 FILE=Textures\ChemBottleTex7.pcx GROUP=Skins

var() ESkinColor SkinColor;

var localized string name1;
var localized string name2;
var localized string name3;
var localized string name4;
var localized string name5;
var localized string name6;
var localized string name7;
var localized string name8;

state Activated
{
	function Activate()
	{
		// can't turn it off
	}

	function BeginState()
	{
		local trestkon player;
		local int i;
		
		Super.BeginState();

		player = trestkon(Owner);
		if (player != None)
		{
			for ( i = player.MakeMolotov(self); i > 0; i--)
				UseOnce();
		}
		GotoState('DeActivated');
	}
Begin:
}

function BeginPlay()
{
	Super.BeginPlay();

	switch (SkinColor)
	{
		case Ethanol:		MultiSkins[1]=Texture'JChemBottleTex0'; ItemName = name1; break;
		case Acetone:		MultiSkins[1]=Texture'JChemBottleTex1'; ItemName = name2; break;
		case Turpentine:	MultiSkins[1]=Texture'JChemBottleTex2'; ItemName = name3; break;
		case Methanol:		MultiSkins[1]=Texture'JChemBottleTex3'; ItemName = name4; break;
		case Toluene:		MultiSkins[1]=Texture'JChemBottleTex4'; ItemName = name5; break;
		case Isopropanol:	MultiSkins[1]=Texture'JChemBottleTex5'; ItemName = name6; break;
		case Chloroform:	MultiSkins[1]=Texture'JChemBottleTex6'; ItemName = name7; break;
		case PicricAcid:	MultiSkins[1]=Texture'JChemBottleTex7'; ItemName = name8; break;
	}
}

#exec MESH IMPORT MESH=ChemicalBottle ANIVFILE=MODELS\ChemicalBottle_a.3d DATAFILE=MODELS\ChemicalBottle_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=ChemicalBottle X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=ChemicalBottle SEQ=All            STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=ChemicalBottle SEQ=chemicalbottle STARTFRAME=0 NUMFRAMES=1

#exec TEXTURE IMPORT NAME=BeltIconChemBottle FILE=Textures\BeltIconChemBottle.pcx GROUP=Skins MIPS=off
#exec TEXTURE IMPORT NAME=LargeIconChemBottle FILE=Textures\LargeIconChemBottle.pcx GROUP=Skins MIPS=off

#exec MESHMAP NEW   MESHMAP=ChemicalBottle MESH=ChemicalBottle
#exec MESHMAP SCALE MESHMAP=ChemicalBottle X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=ChemicalBottle NUM=1 TEXTURE=JChemBottleTex0

defaultproperties
{
     name1="Ethanol"
     name2="Acetone"
     name3="Turpentine"
     name4="Methanol"
     name5="Toluene"
     name6="Isopropanol"
     name7="Chloroform"
     name8="Picric Acid"
     FragType=Class'DeusEx.PlasticFragment'
     maxCopies=20
     bCanHaveMultipleCopies=True
     bActivatable=True
     ItemName="Chemicals"
     ItemArticle="a container of"
     PlayerViewOffset=(X=30.000000,Z=-12.000000)
     PlayerViewMesh=LodMesh'ChemicalBottle'
     PickupViewMesh=LodMesh'ChemicalBottle'
     PickupViewScale=0.070000
     PlayerViewScale=0.070000
     ThirdPersonMesh=LodMesh'ChemicalBottle'
     ThirdPersonScale=0.070000
     Icon=Texture'tnmitems.Skins.BeltIconChemBottle'
     largeIcon=Texture'tnmitems.Skins.LargeIconChemBottle'
     largeIconWidth=36
     largeIconHeight=48
     Description="A bottle containing a household chemical suitable for putting in a bottle and setting on fire."
     beltDescription="CHEMICAL"
     Mesh=LodMesh'ChemicalBottle'
     DrawScale=0.070000
     CollisionRadius=6.000000
     CollisionHeight=8.800000
     Mass=10.000000
     Buoyancy=8.000000
}
