//=============================================================================
// DartProj.
//=============================================================================
class DartProj extends tnmProjectile;

var float mpDamage;

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	if ( Level.NetMode != NM_Standalone )
		Damage = mpDamage;
}

#exec MESH IMPORT MESH=DartProj ANIVFILE=MODELS\DartProj_a.3d DATAFILE=MODELS\DartProj_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=DartProj X=0 Y=0 Z=10000 PITCH=64

#exec MESH SEQUENCE MESH=DartProj SEQ=All      STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=DartProj SEQ=DartProj STARTFRAME=0 NUMFRAMES=1

#exec TEXTURE IMPORT NAME=JDartProj1 FILE=Textures\BlowDartProj.pcx GROUP=Skins // 1 - Default

#exec MESHMAP NEW   MESHMAP=DartProj MESH=DartProj
#exec MESHMAP SCALE MESHMAP=DartProj X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=DartProj NUM=1 TEXTURE=JDartProj1

defaultproperties
{
     mpDamage=20.000000
     bBlood=True
     bStickToWall=True
     DamageType=Poison
     spawnAmmoClass=Class'tnmitems.AmmoBlowDart'
     bIgnoresNanoDefense=True
     ItemName="Blow Dart"
     ItemArticle="a"
     speed=2000.000000
     MaxSpeed=3000.000000
     Damage=8.000000
     MomentumTransfer=1000
     Mesh=LodMesh'tnmitems.DartProj'
     DrawScale=0.100000
     CollisionRadius=3.000000
     CollisionHeight=0.500000
}
