//=============================================================================
// EMPRocket.
//=============================================================================
class EMPRocket extends tnmRocket;

var float	mpBlastRadius;
var float	mpProxRadius;
var float	mpEMPDamage;

simulated function DrawExplosionEffects(vector HitLocation, vector HitNormal)
{
	local ExplosionLight light;
	local int i;
	local Rotator rot;
	local SphereEffect sphere;
    local ExplosionSmall expeffect;

	// draw a pretty explosion
	light = Spawn(class'ExplosionLight',,, HitLocation);
	// draw a cool light sphere
	sphere = Spawn(class'SphereEffect',,, HitLocation);
}

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	if ( Level.NetMode != NM_Standalone )
	{
		blastRadius=mpBlastRadius;
		//proxRadius=mpProxRadius;
		Damage=mpEMPDamage;
		bIgnoresNanoDefense=True;
	}
}

simulated function Timer()
{
   if (Level.NetMode != NM_Standalone)
   {
      Explode(Location, vect(0,0,1));
   }
}

#exec TEXTURE IMPORT NAME=EMPRocketTex1 FILE=Textures\EMPRocketTex1.pcx GROUP="Skins" MIPS=off

defaultproperties
{
     mpBlastRadius=192.000000
     mpProxRadius=128.000000
     mpEMPDamage=200.000000
     bBlood=False
     bDebris=False
     DamageType=EMP
     ItemName="Electromagnetic Pulse (EMP) Rocket"
     ImpactSound=Sound'DeusExSounds.Weapons.EMPGrenadeExplode'
     MultiSkins(0)=Texture'tnmitems.Skins.EMPRocketTex1'
}
