//=============================================================================
// LollerSkates.
//=============================================================================
class LollerSkates extends ChargedPickup;


#exec texture IMPORT NAME=BeltIconLollerSkates FILE=Textures\LollerSkatesBeltIcon.pcx GROUP=Skins MIPS=off // LollerSkatesBeltIcon
#exec texture IMPORT NAME=LargeIconLollerSkates FILE=Textures\LollerSkatesLargeIcon.pcx GROUP=Skins MIPS=off // LollerSkatesLargeIcon
#exec texture IMPORT NAME=ChargeIconLollerSkates FILE=Textures\LollerSkatesChargeIcon.pcx GROUP=Skins MIPS=off // LollerSkatesChargeIcon

#exec mesh IMPORT MESH=LollerSkates ANIVFILE=MODELS\LollerSkates_a.3d DATAFILE=MODELS\LollerSkates_d.3d X=0 Y=0 Z=0
#exec mesh ORIGIN MESH=LollerSkates X=0 Y=0 Z=0 YAW=-64

#exec mesh SEQUENCE MESH=LollerSkates SEQ=All          STARTFRAME=0 NUMFRAMES=1
#exec mesh SEQUENCE MESH=LollerSkates SEQ=Still        STARTFRAME=0 NUMFRAMES=1

#exec texture IMPORT NAME=JLollerSkates1 FILE=Textures\LollerSkatesTex1.pcx GROUP=Skins

#exec MESHMAP NEW   MESHMAP=LollerSkates MESH=LollerSkates
#exec MESHMAP SCALE MESHMAP=LollerSkates X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=LollerSkates NUM=1 TEXTURE=JLollerSkates1

//PlayerView
#exec mesh IMPORT MESH=LollerSkatesPickup ANIVFILE=MODELS\LollerSkatesPickup_a.3d DATAFILE=MODELS\LollerSkatesPickup_d.3d X=0 Y=0 Z=0
#exec mesh ORIGIN MESH=LollerSkatesPickup X=0 Y=0 Z=0

#exec mesh SEQUENCE MESH=LollerSkatesPickup SEQ=All                STARTFRAME=0 NUMFRAMES=1
#exec mesh SEQUENCE MESH=LollerSkatesPickup SEQ=Still              STARTFRAME=0 NUMFRAMES=1


#exec MESHMAP new   MESHMAP=LollerSkatesPickup MESH=LollerSkatesPickup
#exec MESHMAP scale MESHMAP=LollerSkatesPickup X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=LollerSkatesPickup NUM=1 TEXTURE=JLollerSkates1

function ChargedPickupBegin(DeusExPlayer Player)
{
	super.ChargedPickupBegin(Player);
	trestkon(player).StartSkates();
}

function ChargedPickupEnd(DeusExPlayer Player)
{
	super.ChargedPickupEnd(player);
	trestkon(player).StopSkates();
}

defaultproperties
{
     skillNeeded=Class'DeusEx.SkillEnviro'
     LoopSound=Sound'DeusExSounds.Pickup.SuitLoop'
     ChargedIcon=Texture'tnmitems.Skins.ChargeIconLollerSkates'
     ExpireMessage="You have used up all the rocket fuel... well done on not getting yourself killed!"
     ItemName="Lollerskates"
     ItemArticle="some"
     PlayerViewOffset=(X=30.000000,Z=-12.000000)
     PlayerViewMesh=LodMesh'tnmitems.LollerSkates'
     PlayerViewScale=0.500000
     PickupViewMesh=LodMesh'tnmitems.LollerSkatesPickup'
     PickupViewScale=0.500000
     ThirdPersonMesh=LodMesh'tnmitems.LollerSkates'
     ThirdPersonScale=0.500000
     Charge=1000
     LandSound=Sound'DeusExSounds.Generic.MetalHit2'
     Icon=Texture'tnmitems.Skins.BeltIconLollerSkates'
     largeIcon=Texture'tnmitems.Skins.LargeIconLollerSkates'
     largeIconWidth=34
     largeIconHeight=49
     Description="At some point, somebody must've thought rollerskates could be massively improved if one were to mount a rocket engine on them. Unfortunately, he must've had a friend capable of bringing his psychotic idea to fruition, because here they are: The lollerskates, product of a sick mind.|n|nTurn them on, and they will propel you forwards at a velocity never meant for a human to endure. And the best part? There is no 'off' button. These babies don't stop running until they're out of gas. Good luck."
     beltDescription="SKATES"
     Mesh=LodMesh'tnmitems.LollerSkatesPickup'
     DrawScale=0.500000
     CollisionRadius=11.500000
     CollisionHeight=12.000000
     Mass=40.000000
     Buoyancy=30.000000
}
