//=============================================================================
// MineProj.
//=============================================================================
class MineProj extends TNMThrownProjectile;

var float	mpBlastRadius;
var float	mpProxRadius;
var float	mpLAMDamage;
var float	mpFuselength;


var() float fanRate, spinRate, minPitch;
var bool bSpent;
var bool bActivated;
var TNMLaserEmitter emmiters[7];
var float hurttime;
var float damageAmount;

function DestroyMine()
{
	local int i;
	for (i=0;i<7;i++)
		emmiters[i].destroy();
	bSpent = true;
	bActivated = false;
}


simulated function TakeDamage(int Damage, Pawn instigatedBy, Vector HitLocation, Vector Momentum, name damageType)
{
	local ParticleGenerator gen;

	if ((DamageType == 'TearGas') || (DamageType == 'PoisonGas') || (DamageType == 'Radiation'))
		return;

	if (DamageType == 'NanoVirus')
		return;

	if ( Role == ROLE_Authority )
	{
		// EMP damage disables explosives
		if (DamageType == 'EMP')
		{
			if (!bDisabled)
			{
				PlaySound(sound'EMPZap', SLOT_None,,, 1280);
				bDisabled = True;
				gen = Spawn(class'ParticleGenerator', Self,, Location, rot(16384,0,0));
				if (gen != None)
				{
					gen.checkTime = 0.25;
					gen.LifeSpan = 2;
					gen.particleDrawScale = 0.3;
					gen.bRandomEject = True;
					gen.ejectSpeed = 10.0;
					gen.bGravity = False;
					gen.bParticlesUnlit = True;
					gen.frequency = 0.5;
					gen.riseRate = 10.0;
					gen.spawnSound = Sound'Spark2';
					gen.particleTexture = Texture'Effects.Smoke.SmokePuff1';
					gen.SetBase(Self);
				}
			}
			return;
		}
		bDamaged = True;
	}
	DestroyMine();
}

function Frob(Actor Frobber, Inventory frobWith)
{
	// if the player frobs it and it's disabled, the player can grab it
	if (bDisabled)
		Super.Frob(Frobber, frobWith);
	else if (bProximityTriggered && bArmed && (skillTime >= 0) && !bSpent && !bActivated)
	{
		// if the player frobs it and has the demolition skill, disarm the explosive
		PlaySound(sound'Beep4',SLOT_None,,, 1280, 0.5);
		bDisabled = True;
	}
}

auto simulated state Flying
{
	simulated function Explode(vector HitLocation, vector HitNormal)
	{
	local int i;
	local rotator rotoff, rotin;
	
	if (!bactivated && !bSpent)
	{
		rotoff.yaw = 65536 / 7; rotoff.pitch =0;  rotoff.roll = 0;
		rotin.yaw = 0; rotin.pitch = 16384; rotin.yaw = 0;

		for (i=0;i<7;i++)
		{
		     emmiters[i] = Spawn(class'tnmLaserEmitter', Self,,location + vect(0,0,2.1) + vector(rotoff * i)*2,rotin - i * rotoff);
		     if (emmiters[i] != None)
		     {
			emmiters[i].SetGoldBeam();
			emmiters[i].TurnOn();
			emmiters[i].setbase(self);
		     }
		}
		ResetSkinStyle();
		bActivated = true;
	}
	}
}

simulated function Tick(float deltaTime)
{
	local float blinkRate;
	local int i;
	local rotator rot;

	if ( !bSpent && !bActivated )
		Super.Tick(deltaTime);
	else
		Super(deusexprojectile).Tick(deltatime);

	if (bActivated)
	{
		for (i=0;i<7;i++)
		{
			if (emmiters[i] != none)
			{
				rot.yaw = emmiters[i].rotation.yaw; rot.roll = emmiters[i].rotation.roll;
				rot.pitch = emmiters[i].rotation.pitch - deltatime * fanRate;
				emmiters[i].setRotation(rot);
				rot = rotation;
				rot.yaw += deltatime * spinRate;
				self.setrotation(rot);
				if (emmiters[i].HitActor != None)
				{
					hurtTime -= deltaTime;
					while (hurtTime <= 0)
					{
						hurtTime += 0.25;
			emmiters[i].HitActor.TakeDamage(damageAmount, None, Location, vect(0,0,0), 'Flamed');
					}
				}
				if (emmiters[i].rotation.pitch <= minPitch)
					DestroyMine();
			}
		}		
	}

	if (bDisabled||bSpent||bActivated)
	{
		Style=STY_Normal;
		ScaleGlow=2.0;
		return;
	}

	// flash faster as the time expires
	if (fuseLength - time<= 0.75)
		blinkRate = 0.1;
	else if (fuseLength - time <= fuseLength * 0.5)
		blinkRate = 0.3;
	else
		blinkRate = 0.5;

   if ((Level.NetMode == NM_Standalone) || (Role < ROLE_Authority) || (Level.NetMode == NM_ListenServer))
   {
      if ((time > fuselength)&&!bActivated)
      {
	SetSkinStyle(STY_Translucent, Texture'WhiteStatic', 0.05);
      }
      else
        SetSkinStyle(STY_Translucent, Texture'WhiteStatic', 1.0-time/fuselength+0.05);
      /*else if (((fuseLength - time) % blinkRate > blinkRate * 0.5) && !bActivated && !bSpent)
         Style=STY_Translucent;
      else
         Style=STY_Normal;*/
   }
}

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	if ( Level.NetMode != NM_Standalone )
	{
		blastRadius=mpBlastRadius;
		proxRadius=mpProxRadius;
		Damage=mpLAMDamage;
		fuseLength=mpFuselength;
		bIgnoresNanoDefense=True;
	}
}

/*
 * ripped from scripted pawn
 */
function ResetSkinStyle()
{
	ScaleGlow = Default.ScaleGlow;
	Style     = Default.Style;
}

function Texture GetStyleTexture(ERenderStyle newStyle, texture oldTex, optional texture newTex)
{
	local texture defaultTex;

	if      (newStyle == STY_Translucent)
		defaultTex = Texture'BlackMaskTex';
	else if (newStyle == STY_Modulated)
		defaultTex = Texture'GrayMaskTex';
	else if (newStyle == STY_Masked)
		defaultTex = Texture'PinkMaskTex';
	else
		defaultTex = Texture'BlackMaskTex';

	if (oldTex == None)
		return defaultTex;
	else if (oldTex == Texture'BlackMaskTex')
		return Texture'BlackMaskTex';  // hack
	else if (oldTex == Texture'GrayMaskTex')
		return defaultTex;
	else if (oldTex == Texture'PinkMaskTex')
		return defaultTex;
	else if (newTex != None)
		return newTex;
	else
		return oldTex;

}

function SetSkinStyle(ERenderStyle newStyle, optional texture newTex, optional float newScaleGlow)
{
	local int i;

	if (newScaleGlow == 0)
		newScaleGlow = ScaleGlow;
	ScaleGlow = newScaleGlow;
	Style     = newStyle;
}

#exec mesh IMPORT MESH=MinePlaced ANIVFILE=MODELS\MinePickup_a.3d DATAFILE=MODELS\MinePickup_d.3d X=0 Y=0 Z=0
#exec mesh ORIGIN MESH=MinePlaced X=0 Y=0 Z=1000 Pitch=-64

#exec MESH SEQUENCE MESH=MinePlaced SEQ=All      STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=MinePlaced SEQ=MineDrop STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP new   MESHMAP=MinePlaced MESH=MinePlaced
#exec MESHMAP SCALE MESHMAP=MinePlaced X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=MinePlaced NUM=1 TEXTURE=JMine1

defaultproperties
{
     mpBlastRadius=512.000000
     mpProxRadius=128.000000
     mpLAMDamage=500.000000
     mpFuselength=1.500000
     fanRate=2000.000000
     spinRate=10000.000000
     minPitch=2052.000000
     DamageAmount=50.000000
     bHeatSource=True
     fuseLength=3.000000
     bProximityTriggered=True
     proxRadius=128.000000
     blastRadius=384.000000
     spawnWeaponClass=Class'tnmitems.WeaponMine'
     ItemName="Step Mine"
     speed=1000.000000
     MaxSpeed=1000.000000
     Damage=500.000000
     MomentumTransfer=50000
     ImpactSound=Sound'DeusExSounds.Weapons.LAMExplode'
     ExplosionDecal=Class'DeusEx.ScorchMark'
     LifeSpan=0.000000
     Mesh=LodMesh'tnmitems.MinePlaced'
     DrawScale=0.400000
     CollisionRadius=4.000000
     Mass=5.000000
     Buoyancy=2.000000
     bVisionImportant=True
}
