//=============================================================================
// NapalmGlop
//=============================================================================
class NapalmGlop extends tnmProjectile;



var vector SurfaceNormal;
var sound impactsound, miscsound, cracklesound;
var bool bOnGround; //don't know if we need this anymore...
var bool bCheckedSurface;
var bool bSpewing;
var bool bIgnited;
var bool bBlinking;
var bool bUnderwater;
var bool bExploded;
var bool bOnThing;
var int numBlobs;
var float fuselength;
var int fuseseconds;
var float wallTime;
var float BaseOffset;
var mesh randmesh[3];
var Particlegenerator fusegen, firegen;


#exec OBJ LOAD FILE=Effects


function PreBeginPlay()
{
    mesh=randmesh[rand(2)];
    super(DeusExProjectile).PreBeginPlay();
}

function PostBeginPlay()
{
	LightType=LT_None;
	Style=Sty_Translucent;
	WatchYourDrawScale();
	Damage *= NumBlobs;
	time= 0.00;
	fuseSeconds=FuseLength;
	Super(DeusExProjectile).PostbeginPlay();

}

function timer()
{
local pawn p;

p = pawn(owner);
if (p != none)
{
if((bOnThing) && (Pawn(base) != none) && (Frand() > 0.33)) //hurt our attachee once in a while
             {
             Pawn(base).TakeDamage(1,p,location,location,'burned');
             }
}
super(DeusExProjectile).Timer();
}
simulated function Tick(float deltaTime)
{
  local float blinkRate;



time += deltatime;

	Super(DeusExProjectile).Tick(deltaTime);



        fuseSeconds=fuseLength;
        fuseLength=fuseLength - deltaTime;
        if ((fuseLength <= 0.0) && !bExploded)
		{
        self.Explode(Location, vector(rotation));
        bExploded=true;
        }


	// do stuff as the time expires
	if ((fuseLength - time <=  0.1) && !bIgnited)
		{
         	self.LightType=LT_Steady;
         	self.bUnlit=true;
         	blinkrate = 0.1;
         	if(fuseGen != none)
         	           {
        	            fusegen.particleDrawScale = 0.2;
        	            fusegen.checkTime = 0.05;
        	            fusegen.ejectSpeed = 50.0;
        	            fusegen.bAmbientSound = true;
        	            fuseGen.AmbientSound = cracklesound;

        	            }
           firegen = spawn(Class'ParticleGenerator',Self,,Location + SurfaceNormal*1.5);
           if(firegen != none)
                      {
                      fireGen.RemoteRole = ROLE_None;
            		  fireGen.particleTexture = Texture'Effects.Fire.Fireball1';
            		  fireGen.particleDrawScale = 0.1;
            		  fireGen.checkTime = 0.01;
            		  fireGen.riseRate = 0.0;
            		  fireGen.ejectSpeed = 1.0;
            		  fireGen.particleLifeSpan = 0.1;
            		  fireGen.bRandomEject = True;
            		  fireGen.SetBase(Self);
            		  }
           bIgnited=true;
           bBlinking=true;
         	//self.Multiskins[0]=Texture'Effects.Fire.OnFire_J';



  	    }
	else if
    ((fuseLength - time <= default.fuseLength * 0.75) && !bSpewing)
	{
             self.LightType=LT_Flicker;
             SpawnNapalmEffects();

	}

	else
	    {
		LightType=LT_None;
		Style=Sty_Translucent;
		}

        if ((Level.NetMode == NM_Standalone) || (Role < ROLE_Authority) || (Level.NetMode == NM_ListenServer))
   {
      if(bBlinking)
      {
      if (Abs((fuseLength - time)) % blinkRate > blinkRate * 0.5)
         ScaleGlow = 1.00;
      else
         ScaleGlow = 3.00;
      }
   }

}

function WatchYourDrawScale()
{
Drawscale=(numBlobs+3)*0.1;
}


function SpawnNapalmEffects()
{
if(bUnderwater) //don't smoke underwater
return;


     fuseGen = Spawn(class'ParticleGenerator', Self,,Location + SurfaceNormal*2);
     if (fuseGen != None)
    	{

    		fuseGen.particleTexture = Texture'Effects.Smoke.SmokePuff1';
    		fuseGen.particleDrawScale = 0.1;
    		fuseGen.checkTime = 0.1;
    		fuseGen.riseRate = 20.0;
    		fuseGen.ejectSpeed = 20.0;
    		fuseGen.particleLifeSpan = 2.0;
    		fuseGen.bRandomEject = True;
    		fuseGen.SetBase(Self);
    		fuseGen.RemoteRole = ROLE_None;
    		bSpewing=true;
    	}
}

function ExtinguishSmoke()
{
if(fuseGen != none)
           fuseGen.DelayedDestroy();
if(fireGen != none)
           firegen.DelayedDestroy();

}

simulated function Destroyed()
{
	if (fuseGen != None)
		fuseGen.DelayedDestroy();
	if(fireGen != none)
           firegen.DelayedDestroy();

	Super(DeusExProjectile).Destroyed();
}
function drawexplosioneffects(vector HitLocation, vector HitNormal)
{
         local ShockRing ring;
         local SphereEffect sphere;
	     local ExplosionLight light;
         local NapalmExplosion expeffect;
         local int i;



	PlaySound (MiscSound,,3.0*DrawScale);
// draw a pretty explosion
	light = Spawn(class'ExplosionLight',,, HitLocation);
   if (light != None)
      light.RemoteRole = ROLE_None;

		if(Numblobs > 7)
			{
			expeffect = Spawn(class'BigNapalmExplosion',,, HitLocation);
			light.size = 4;
			}
		else
			{
			expeffect = Spawn(class'NapalmExplosion',,, HitLocation);
			light.size = 2;
            		}



   if ((expeffect != None) && !bUnderwater)
      {
      expeffect.RemoteRole = ROLE_None;
      expeffect.numBlobs = numBlobs;
      }
	else if((expeffect != None) && bUnderwater)
         {
         expeffect.RemoteRole = ROLE_None;
         expeffect.bUnderwater = true;
         expeffect.numBlobs = numBlobs;
         }

	// draw a pretty shock ring
   // For nano defense we are doing something else.
	//no we're not. How the fuck do you nanodefense napalm blobs, huh?
   //if ((!bAggressiveExploded) || (Level.NetMode == NM_Standalone))
   //{
      ring = Spawn(class'ShockRing',,, HitLocation, rot(16384,0,0));
      if (ring != None)
      {
         ring.RemoteRole = ROLE_None;
	if(!bUnderwater)
         ring.size = blastRadius / 32.0;
	else
	 ring.size = blastRadius / 96.0; //muted underwater explosion
      }
      ring = Spawn(class'ShockRing',,, HitLocation, rot(0,0,0));
      if (ring != None)
      {
         ring.RemoteRole = ROLE_None;
         if(!bUnderwater)
         ring.size = blastRadius / 32.0;
	else
	 ring.size = blastRadius / 96.0;
      }
      ring = Spawn(class'ShockRing',,, HitLocation, rot(0,16384,0));
      if (ring != None)
      {
         ring.RemoteRole = ROLE_None;
         if(!bUnderwater)
         ring.size = blastRadius / 32.0;
	else
	 ring.size = blastRadius / 96.0;
      }
   //}

}

state OnSurface
{
	function ProcessTouch (Actor Other, vector HitLocation)
	{
		fuselength=fuselength*0.25; //if you brush up against it, better start running...
	}

	simulated function CheckSurface()
	{

	}
}

singular function TakeDamage( int NDamage, Pawn instigatedBy, Vector hitlocation, vector momentum, name damageType )
{
   local int ouch, i, j;
   local NapalmBleb Bleb;

   ouch = NDamage*0.2;

   if(ouch <= 1.00)
           Ouch = 1.00;

	if ( (damageType == 'Flamed') || (damageType == 'Burned'))
	{
	Explode(HitLocation, vector(rotation));
	}
	else if((damageType == 'Shot') || (damageType == 'Sabot') || (damageType == 'Exploded'))
	{
	numBlobs -= Ouch;
	Damage*=NumBlobs; //reduce damage as it gets smaller
	for(i=0; i<Ouch; i++)
	         {
	         j = (Frand()+2)*0.5;
	         bleb = Spawn(Class'NapalmBleb',none,,location);
	         if(bleb != none)
	                 bleb.Drawscale = bleb.default.drawscale*j;
             WatchYourDrawScale();
	         }
    }
    if(NumBlobs <= 1)
    {
    NumBlobs=1;
    Explode(HitLocation, vector(rotation));
    }
}


simulated function SetWall(vector HitNormal, Actor Wall)
{
	local vector TraceNorm, TraceLoc, Extent;
	local actor HitActor;
	local rotator RandRot;

	SurfaceNormal = HitNormal;
	RandRot = rotator(HitNormal);
	RandRot.Roll = Frand()*65536;
    RandRot.Yaw = Frand()*65536;
    RandRot.Pitch = Frand()*65536;
	SetRotation(RandRot);
	if ( Mover(Wall) != None )
		SetBase(Wall);
}

simulated function Explode(vector HitLocation, vector HitNormal)
	{
         if(base != none)
                 SpawnEffects(HitLocation, HitNormal, Base);
         else
                 SpawnEffects(HitLocation, HitNormal, None);

         DrawExplosionEffects(HitLocation, HitNormal);




		PlayImpactSound();

			AISendEvent('LoudNoise', EAITYPE_Audio, 2.0, blastRadius*16);

		GotoState('Exploding');
	}
//
// Exploding state
//
state Exploding
{
	ignores ProcessTouch, HitWall, Explode;

   function DamageRing()
   {
		local Pawn apawn;
		local float damageRadius;
		local Vector dist;

		if ( Level.NetMode != NM_Standalone )
		{
			damageRadius = (blastRadius / gradualHurtSteps) * gradualHurtCounter;

			for ( apawn = Level.PawnList; apawn != None; apawn = apawn.nextPawn )
			{
				if ( apawn.IsA('DeusExPlayer') )
				{
					dist = apawn.Location - Location;
					if ( VSize(dist) < damageRadius )
					{
						if ( gradualHurtCounter <= 2 )
						{
							if ( apawn.FastTrace( apawn.Location, Location ))
								DeusExPlayer(apawn).myProjKiller = Self;
						}
						else
							DeusExPlayer(apawn).myProjKiller = Self;
					}
				}
			}
		}
      //DEUS_EX AMSD Ignore Line of Sight on the lowest radius check, only in multiplayer
		HurtRadius
		(
			(2 * Damage) / gradualHurtSteps,
			(blastRadius / gradualHurtSteps) * gradualHurtCounter,
			damageType,
			MomentumTransfer / gradualHurtSteps,
			Location,
         ((gradualHurtCounter <= 2) && (Level.NetMode != NM_Standalone))
		);
   }

	function Timer()
	{
		gradualHurtCounter++;
      DamageRing();
		if (gradualHurtCounter >= gradualHurtSteps)
			Destroy();
	}

Begin:
	// stagger the HurtRadius outward using Timer()
	// do five separate blast rings increasing in size
	gradualHurtCounter = 1;
	gradualHurtSteps = 5;
	Velocity = vect(0,0,0);
	bHidden = True;
	LightType = LT_None;
	SetCollision(False, False, False);
   DamageRing();
	SetTimer(0.25/float(gradualHurtSteps), True);
}

auto state Flying
{

	simulated function Explode(vector HitLocation, vector HitNormal)
	{

         SpawnEffects(HitLocation, HitNormal, None);
         DrawExplosionEffects(HitLocation, HitNormal);




		PlayImpactSound();

			AISendEvent('LoudNoise', EAITYPE_Audio, 2.0, blastRadius*16);

		GotoState('Exploding');
	}




	function ProcessTouch (Actor Other, vector HitLocation)
	{
	    local pawn p;
	    local vector loc, newloc;
	    local rotator RandRot;

		if ((Other != instigator) && (DeusExProjectile(Other) == None) && (Other 
!= Owner))
			{
			SetPhysics(PHYS_None);
			if((pawn(other) != none) && !Other.IsA('Robot'))
			                {
			                p = pawn(other);
			                loc = p.location;
			                newloc = location-((location - loc)*0.33); //move us in a bit closer to people we hit (damned cylindrical collision)
			                self.setlocation(newloc);
	                        RandRot = rotator(HitLocation);
                            RandRot.Roll = Frand()*65536;
                            RandRot.Yaw = Frand()*65536;
                            RandRot.Pitch = Frand()*65536;
	                        SetRotation(RandRot);
	                        SetTimer(0.5,false);
			                }
			else if((Other.IsA('Robot')) || (Other.IsA('Vehicles'))) //because vehicles (especially that fucking helicopter) have particularly unrealistic collision properties,
  		                                                                 //and including bots adds a touch of consistency. Christ...
					{
					ExtinguishSmoke();
					Explode(HitLocation, vector(rotation));
					}
		    MakeNoise(0.3);
		    bOnGround = True;
		    PlaySound(ImpactSound);
		    SetBase(Other);
		    bOnThing = true;
		    Other.TakeDamage(1, instigator, Location, MomentumTransfer * 
Normal(Velocity)*0.1, 'KnockedOut'); //concussion effect: the AI needs to know SOMETHING is up when it gets hit by big ol' globs of napalm..
		    GoToState('OnSurface');
		    }
	}

	simulated function HitWall( vector HitNormal, actor Wall )
	{
		SetPhysics(PHYS_None);
		MakeNoise(0.3);
		bOnGround = True;
		PlaySound(ImpactSound);
		SetWall(HitNormal, Wall);
		GoToState('OnSurface');
	}


	simulated function ZoneChange( Zoneinfo NewZone )
	{
		local waterring w;

		if (!NewZone.bWaterZone) Return;

		if (!bOnGround)
		{
			w = Spawn(class'WaterRing',,,,rot(16384,0,0));
			w.DrawScale = 0.1;
		}
		if(fuseGen != none)
		           {
                  ExtinguishSmoke();
                   }
		bOnGround = True;
		Velocity=0.1*Velocity;
		bUnderwater = True;
	}


	function BeginState()
	{
		if ( Role == ROLE_Authority )
		{
			Velocity = Vector(Rotation) * Speed;
			Velocity.z += 120;
			if( Region.zone.bWaterZone )
				Velocity=Velocity*0.7;
		}
		if ( Level.NetMode != NM_DedicatedServer )
			RandSpin(100000);
		bOnGround=False;
	}
}

defaultproperties
{
     ImpactSound=Sound'DeusExSounds.Player.BodyHit'
     MiscSound=Sound'DeusExSounds.Weapons.GasGrenadeExplode'
     numBlobs=7
     fuseLength=4.000000
     randmesh(0)=LodMesh'DeusExItems.FleshFragment1'
     randmesh(1)=LodMesh'DeusExItems.FleshFragment2'
     randmesh(2)=LodMesh'DeusExItems.FleshFragment3'
     bExplodes=True
     blastRadius=64.000000
     DamageType=Flamed
     speed=800.000000
     MaxSpeed=1500.000000
     Damage=3.000000
     MomentumTransfer=20000
     LifeSpan=12.000000
     Skin=Texture'TNM_Core_Tex.Effects.LiquidHotMagma'
     Mesh=LodMesh'DeusExItems.FleshFragment1'
     CollisionRadius=2.000000
     CollisionHeight=2.000000
     bProjTarget=True
     LightType=LT_Steady
     LightEffect=LE_FireWaver
     LightBrightness=70
     LightHue=32
     LightSaturation=100
     LightRadius=3
     bBounce=True
     Buoyancy=170.000000
}
