//=============================================================================
// NapalmLProjectile.
//=============================================================================
class NapalmLProjectile extends Rocket;

var float mpExplodeDamage;

#exec OBJ LOAD FILE=Effects

simulated function DrawExplosionEffects(vector HitLocation, vector HitNormal)
{
	local ExplosionLight light;
	local ParticleGenerator gen;
   local ExplosionSmall expeffect;

	// draw a pretty explosion
	light = Spawn(class'ExplosionLight',,, HitLocation);
	if (light != None)
   {
      light.RemoteRole = ROLE_None;
	  light.size = 64;
   }

   expeffect = Spawn(class'ExplosionSmall',,, HitLocation);
   if (expeffect != None)
      expeffect.RemoteRole = ROLE_None;

	// create a particle generator shooting out white-hot fireballs
	gen = Spawn(class'ParticleGenerator',,, HitLocation, Rotator(HitNormal));
	if (gen != None)
	{
      gen.RemoteRole = ROLE_None;
		gen.particleDrawScale = 1.0;
		gen.checkTime = 0.05;
		gen.frequency = 1.0;
		gen.ejectSpeed = 200.0;
		gen.bGravity = True;
		gen.bRandomEject = True;
		gen.particleTexture = Texture'Effects.Fire.FireballWhite';
		gen.LifeSpan = 2.0;
	}
}

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	if ( ( Level.NetMode != NM_Standalone ) && (Class == Class'RocketWP') )
	{
      speed = 2000.0000;
      SetTimer(5,false);
      Damage = mpExplodeDamage;
		blastRadius = mpBlastRadius;
		SoundRadius=76;
	}
}

#exec MESH IMPORT MESH=NapalmLProjectile ANIVFILE=MODELS\NapalmLProjectile_a.3d DATAFILE=MODELS\NapalmLProjectile_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=NapalmLProjectile X=0 Y=0 Z=0

#exec mesh SEQUENCE MESH=NapalmLProjectile SEQ=All     STARTFRAME=0  NUMFRAMES=1
#exec mesh SEQUENCE MESH=NapalmLProjectile SEQ=Flying  STARTFRAME=0  NUMFRAMES=10   RATE=12
#exec mesh SEQUENCE MESH=NapalmLProjectile SEQ=Landing STARTFRAME=10 NUMFRAMES=11   RATE=16

#exec TEXTURE IMPORT NAME=JNapalmLProjectile1 FILE=Textures\Napalmproj.pcx GROUP=Skins // UNLIT

#exec MESHMAP NEW   MESHMAP=NapalmLProjectile MESH=NapalmLProjectile
#exec MESHMAP SCALE MESHMAP=NapalmLProjectile X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=NapalmLProjectile NUM=1 TEXTURE=JNapalmLProjectile1

defaultproperties
{
     mpExplodeDamage=75.000000
     mpBlastRadius=468.000000
     bBlood=False
     bDebris=False
     blastRadius=212.000000
     DamageType=Flamed
     ItemName="Napalm Rocket"
     ImpactSound=Sound'tnmitems.Weapons.NapalmExplode'
     Mesh=LodMesh'tnmitems.NapalmLProjectile'
     DrawScale=0.600000
     AmbientSound=Sound'DeusExSounds.Weapons.WPApproach'
}
