//=============================================================================
// PlasmaProj.
//=============================================================================
class PlasmaProj extends TNMThrownProjectile;

#exec mesh IMPORT MESH=plasmanadeProj ANIVFILE=MODELS\plasmanadepickup_a.3d DATAFILE=MODELS\plasmanadepickup_d.3d X=0 Y=0 Z=0
#exec mesh ORIGIN MESH=plasmanadeProj X=0 Y=0 Z=0

#exec mesh SEQUENCE MESH=plasmanadeProj SEQ=All          STARTFRAME=0 NUMFRAMES=1
#exec mesh SEQUENCE MESH=plasmanadeProj SEQ=plasmanadeProj STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP new   MESHMAP=plasmanadeProj MESH=plasmanadeProj
#exec MESHMAP scale MESHMAP=plasmanadeProj X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=plasmanadeProj NUM=1 TEXTURE=JPlasmanade1
#exec MESHMAP SETTEXTURE MESHMAP=plasmanadeProj NUM=2 TEXTURE=BlackMaskTex
#exec MESHMAP SETTEXTURE MESHMAP=plasmanadeProj NUM=3 TEXTURE=JPlasmanade3

simulated function DrawExplosionEffects(vector HitLocation, vector HitNormal)
{
	local ExplosionLight light;
	local int i;
	local Rotator rot;
	local SphereVortex sphere;
	local ExplosionSmall expeffect;
//	local mosquito mos;

	// draw a pretty explosion
	light = Spawn(class'ExplosionLight',,, HitLocation);
	if (light != None)
	{
      if (!bDamaged)
         light.RemoteRole = ROLE_None;
		light.size = 8;
		light.LightHue = 128;
		light.LightSaturation = 96;
		light.LightEffect = LE_Shell;
	}

	expeffect = Spawn(class'ExplosionSmall',,, HitLocation);
   if ((expeffect != None) && (!bDamaged))
      expeffect.RemoteRole = ROLE_None;

	// draw a cool light sphere
	if(!bDamaged)
		sphere = Spawn(class'SphereVortex',,, HitLocation);
	if (sphere != None)
	{
		sphere.RemoteRole = ROLE_None;
		sphere.size = blastRadius / 32.0;
		sphere.radius = blastRadius*2/3;
		sphere.reach = blastRadius*2;
		sphere.PhaseTime = 0.8*3;
		sphere.ShockTime = 3.6*2;
	}
/*	for (i = 0; i < 30; i++)
	{
		mos = spawn(class'mosquito',Owner,, HitLocation + VRand() * 100 + HitNormal * 100);
		mos.SetAlliance(ScriptedPawn(Owner).Alliance);
		mos.InitializePawn();
		Log(mos.Inventory);
	}*/
}

defaultproperties
{
     elasticity=0.350000
     fuseLength=3.000000
     proxRadius=128.000000
     bHighlight=False
     AISoundLevel=0.100000
     bBlood=False
     bDebris=False
     blastRadius=256.000000
     spawnWeaponClass=Class'tnmitems.WeaponPlasmanade'
     ItemName="Plasma Grenade"
     speed=1000.000000
     MaxSpeed=1000.000000
     MomentumTransfer=50000
     ImpactSound=Sound'tnmitems.Weapons.VortexIntro'
     ExplosionDecal=Class'DeusEx.ScorchMark'
     LifeSpan=0.000000
     Texture=Texture'tnmitems.Skins.JPlasmanade1'
     Mesh=LodMesh'tnmitems.plasmanadeProj'
     DrawScale=0.330000
     CollisionRadius=2.500000
     CollisionHeight=3.800000
     Mass=5.000000
     Buoyancy=2.000000
}
