//=============================================================================
// PlasticCoffee.
//=============================================================================
class PlasticCoffee extends TNMItems;

state Activated
{
	function Activate()
	{
		// can't turn it off
	}

	function BeginState()
	{
		local DeusExPlayer player;

		Super.BeginState();

		player = DeusExPlayer(Owner);
		if (player != None)
		{
			player.HealPlayer(2, False);
			player.ChargePlayer(2);
		}

		PlaySound(sound'MaleBurp');
		UseOnce();
	}
Begin:
}

// Belt and inventory icons
#exec texture IMPORT NAME=BeltIconPlasticCup FILE=Textures\BeltIconPlasticCup.pcx GROUP=Skins MIPS=off
#exec texture IMPORT NAME=LargeIconPlasticCup FILE=Textures\LargeIconPlasticCup.pcx GROUP=Skins MIPS=off

#exec MESH IMPORT MESH=PlasticCoffee ANIVFILE=MODELS\PlasticCoffee_a.3d DATAFILE=MODELS\PlasticCoffee_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=PlasticCoffee X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=PlasticCoffee SEQ=All       STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=PlasticCoffee SEQ=CoffeeCup STARTFRAME=0 NUMFRAMES=1

#exec TEXTURE IMPORT NAME=JPlasticCoffee1 FILE=Textures\PCoffeeTex1.PCX GROUP=Skins // Material #2
#exec TEXTURE IMPORT NAME=JPlasticCoffee2 FILE=Textures\PCoffeeTex2.PCX GROUP=Skins // Material #3

#exec MESHMAP NEW   MESHMAP=PlasticCoffee MESH=PlasticCoffee
#exec MESHMAP SCALE MESHMAP=PlasticCoffee X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=PlasticCoffee NUM=1 TEXTURE=JPlasticCoffee1
#exec MESHMAP SETTEXTURE MESHMAP=PlasticCoffee NUM=2 TEXTURE=JPlasticCoffee2

defaultproperties
{
     maxCopies=10
     bCanHaveMultipleCopies=True
     bActivatable=True
     ItemName="Coffee"
     ItemArticle="some"
     PlayerViewOffset=(X=30.000000,Z=-12.000000)
     PlayerViewMesh=LodMesh'tnmitems.PlasticCoffee'
     PickupViewMesh=LodMesh'tnmitems.PlasticCoffee'
     PickupViewScale=0.600000
     ThirdPersonMesh=LodMesh'tnmitems.PlasticCoffee'
     ThirdPersonScale=0.400000
     LandSound=Sound'DeusExSounds.Generic.MetalHit1'
     Icon=Texture'tnmitems.Skins.BeltIconPlasticCup'
     largeIcon=Texture'tnmitems.Skins.LargeIconPlasticCup'
     largeIconWidth=24
     largeIconHeight=45
     Description="Coffee belongs to the botanical family Rubiaceae, which has some 500 genera and over 6,000 species. Most are tropical trees and shrubs which grow in the lower storey of forests. Other members of the family include the gardenias and plants which yield quinine and other useful substances, but Coffea is by far the most important member of the family economically.|n|nThis particular coffee came in a cheap plastic cup. When consumed, it will replenish a bit of both your health and your bio energy... let's hear it for caffeine."
     beltDescription="COFFEE"
     Mesh=LodMesh'tnmitems.PlasticCoffee'
     DrawScale=0.600000
     CollisionRadius=3.000000
     CollisionHeight=3.500000
     Mass=5.000000
     Buoyancy=3.000000
}
