//=============================================================================
// Radish.
//=============================================================================
class Radish extends tnmDecoration;

#exec MESH IMPORT MESH=Radish ANIVFILE=MODELS\Radish_a.3d DATAFILE=MODELS\Radish_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=Radish X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=Radish SEQ=All    STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=Radish SEQ=Radish STARTFRAME=0 NUMFRAMES=1

#exec TEXTURE IMPORT NAME=RadishTex FILE=Textures\RadishTex.PCX GROUP=Skins // Radish
#exec TEXTURE IMPORT NAME=RadishLeaves FILE=Textures\RadishLeaves.PCX GROUP=Skins FLAGS=2 // Leaves.td

#exec MESHMAP NEW   MESHMAP=Radish MESH=Radish
#exec MESHMAP SCALE MESHMAP=Radish X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=Radish NUM=1 TEXTURE=RadishTex
#exec MESHMAP SETTEXTURE MESHMAP=Radish NUM=2 TEXTURE=RadishLeaves

var() string pickup_messages[10];

var vector start;
var bool bdown;

function PostPostBeginPlay()
{
	start=location;
	acceleration.z=-15;
}

function Tick(float dt)
{
	if(start==vect(0,0,0))
	{
		start=location;
		return;
	}
	setlocation(location+velocity*dt);
	if(vsize(start-location)>1.75)
	{
		if(!bdown)
		{
			acceleration.z*=-1;
			velocity.z/=2;
		}
		bdown=true;
	}
	else
		bdown=false;
	velocity.z+=acceleration.z*dt;
}

function Frob(Actor Frobber, Inventory frobWith)
{
	//do nothing
}

event Touch(actor other)
{
	local trestkon player;
	local string msg;

	player=trestkon(other);
	if(player==none)
		return;
	player.PickedUpRadish();
	player.PlayOwnedSound(sound'GrayAttack');
	do
	{
		msg=pickup_messages[rand(arraycount(pickup_messages))];
	} until(msg!="");
	player.clientmessage(msg);
	Destroy();
}

defaultproperties
{
    DrawType=DT_Mesh
    Mesh=Radish
    DrawScale=2.000000
    CollisionRadius=22.000000
    CollisionHeight=44.000000
    Physics=PHYS_None
    bFixedRotationDir=False
    pickup_messages(0)="You got a delicious radish!"
    pickup_messages(1)="How can life NOT be great when you have a radish?"
    pickup_messages(2)="Another defenseless radish falls to your might!"
    pickup_messages(3)="Radilicious!!"
    pickup_messages(4)="Radish power!"
    pickup_messages(5)="Got radish?"
    pickup_messages(6)="The Radish Farmer strikes again!"
    pickup_messages(7)="It's like spinach, only moderately less disgusting!"
    pickup_messages(8)="Ph34r the might of the radish!"
    pickup_messages(9)="Time to bake a radish cake!"
    bHighlight=False
    bBlockActors=False
    bBlockPlayers=False
    Mass=500.000000
    Buoyancy=100.000000
    bUnlit=True
}
