//=============================================================================
// RedBiocell.
// This is for the subquest with Grub.
//=============================================================================
class RedBiocell extends TNMItems;

var int rechargeAmount;
var int mpRechargeAmount;

var localized String msgRecharged;
var localized String RechargesLabel;

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	// If this is a netgame, then override defaults
	if ( Level.NetMode != NM_StandAlone )
		MaxCopies = 5;
}

function PostBeginPlay()
{
   Super.PostBeginPlay();
   if (Level.NetMode != NM_Standalone)
      rechargeAmount = mpRechargeAmount;
}

state Activated
{
	function Activate()
	{
		// can't turn it off
	}

	function BeginState()
	{
		local DeusExPlayer player;

		Super.BeginState();

		player = DeusExPlayer(Owner);
		if (player != None)
		{
			player.ClientMessage(Sprintf(msgRecharged, rechargeAmount));
	
			player.PlaySound(sound'BioElectricHiss', SLOT_None,,, 256);

			player.Energy += rechargeAmount;
			player.takedamage(25,player,player.location,vect(0,0,0),'redbiocell'); // Deal 25 damage to the player
			if (player.Energy > player.EnergyMax)
				player.Energy = player.EnergyMax;
		}

		UseOnce();
	}
Begin:
}

// ----------------------------------------------------------------------
// UpdateInfo()
// ----------------------------------------------------------------------

function bool UpdateInfo(Object winObject)
{
	local PersonaInfoWindow winInfo;
	local string str;

	winInfo = PersonaInfoWindow(winObject);
	if (winInfo == None)
		return False;

	winInfo.SetTitle(itemName);
	winInfo.SetText(Description $ winInfo.CR() $ winInfo.CR());
	winInfo.AppendText(Sprintf(RechargesLabel, RechargeAmount));

	// Print the number of copies
	str = CountLabel @ String(NumCopies);
	winInfo.AppendText(winInfo.CR() $ winInfo.CR() $ str);

	return True;
}

// ----------------------------------------------------------------------
// TestMPBeltSpot()
// Returns true if the suggested belt location is ok for the object in mp.
// ----------------------------------------------------------------------

simulated function bool TestMPBeltSpot(int BeltSpot)
{
   return (BeltSpot == 0);
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

#exec TEXTURE IMPORT NAME=RedcellTex1 FILE=Textures\RedcellTex1.pcx GROUP=Skins
#exec TEXTURE IMPORT NAME=BeltIconRedCell FILE=Textures\BeltIconRedCell.pcx GROUP=Skins MIPS=off
#exec TEXTURE IMPORT NAME=LargeIconRedCell FILE=Textures\LargeIconRedCell.pcx GROUP=Skins MIPS=off

defaultproperties
{
     rechargeAmount=100
     mpRechargeAmount=100
     msgRecharged="Recharged %d points"
     RechargesLabel="Recharges %d Energy Units"
     maxCopies=30
     bCanHaveMultipleCopies=True
     bActivatable=True
     ItemName="Red Biocell"
     PlayerViewOffset=(X=30.000000,Z=-12.000000)
     PlayerViewMesh=LodMesh'DeusExItems.BioCell'
     PickupViewMesh=LodMesh'DeusExItems.BioCell'
     ThirdPersonMesh=LodMesh'DeusExItems.BioCell'
     LandSound=Sound'DeusExSounds.Generic.PlasticHit2'
     Icon=Texture'tnmitems.Skins.BeltIconRedCell'
     largeIcon=Texture'tnmitems.Skins.LargeIconRedCell'
     largeIconWidth=44
     largeIconHeight=43
     Description="A bioelectric cell provides efficient storage of energy in a form that can be utilized by a number of different devices. This cell is of a non-standard fabrication which utilizes a different transformation system. As a result, it will cause a severe and potentially lethal electrical surge when applied to a standard neuroware processor. It will also, however, completely replenish the bioenergy of the recipient."
     beltDescription="REDCELL"
     Mesh=LodMesh'DeusExItems.BioCell'
     MultiSkins(0)=Texture'tnmitems.Skins.RedcellTex1'
     MultiSkins(1)=FireTexture'Effects.Laser.LaserSpot1'
     CollisionRadius=4.700000
     CollisionHeight=0.930000
     Mass=5.000000
     Buoyancy=4.000000
}
