//=============================================================================
// ExplosionSmall.
//=============================================================================
class RiceExplosionSmall extends AnimatedSprite;

Simulated function PostBeginPlay()
{
	Super.PostBeginPlay();

}

simulated function Tick(float deltaTime)
{
	time += deltaTime;
	totalTime += deltaTime;

	DrawScale = 0.3 + (1.0 * totalTime / duration);
	ScaleGlow = (duration - totalTime) / duration;

	if (time >= animSpeed)
	{
		Texture = frames[nextFrame++];
		if (nextFrame >= numFrames)
			Destroy();

		time -= animSpeed;
	}
}
#exec texture IMPORT NAME=RiceExFrame00 FILE=Textures\Rice00.pcx GROUP=Skins
#exec texture IMPORT NAME=RiceExFrame01 FILE=Textures\Rice01.pcx GROUP=Skins
#exec texture IMPORT NAME=RiceExFrame02 FILE=Textures\Rice02.pcx GROUP=Skins
#exec texture IMPORT NAME=RiceExFrame03 FILE=Textures\Rice03.pcx GROUP=Skins
#exec texture IMPORT NAME=RiceExFrame04 FILE=Textures\Rice04.pcx GROUP=Skins
#exec texture IMPORT NAME=RiceExFrame05 FILE=Textures\Rice05.pcx GROUP=Skins
#exec texture IMPORT NAME=RiceExFrame06 FILE=Textures\Rice06.pcx GROUP=Skins

defaultproperties
{
     numFrames=7
     frames(0)=Texture'tnmitems.Skins.RiceExFrame00'
     frames(1)=Texture'tnmitems.Skins.RiceExFrame01'
     frames(2)=Texture'tnmitems.Skins.RiceExFrame02'
     frames(3)=Texture'tnmitems.Skins.RiceExFrame03'
     frames(4)=Texture'tnmitems.Skins.RiceExFrame04'
     frames(5)=Texture'tnmitems.Skins.RiceExFrame05'
     frames(6)=Texture'tnmitems.Skins.RiceExFrame06'
     Texture=Texture'tnmitems.Skins.RiceExFrame00'
}
