//=============================================================================
// RicebagProj.
//=============================================================================
class RicebagProj extends tnmProjectile;

simulated function DrawExplosionEffects(vector HitLocation, vector HitNormal)
{
	local AnimatedSprite expeffect;
	expeffect = Spawn(class'RiceExplosionSmall',,, HitLocation);
	if (expeffect != None)
	  expeffect.RemoteRole = ROLE_None;
}

auto simulated state Flying
{
	simulated function ProcessTouch (Actor Other, Vector HitLocation)
	{
		if ((Other != instigator) && (DeusExProjectile(Other) == None) &&
			(Other != Owner))
		{
			damagee = Other;
			Explode(HitLocation, Normal(HitLocation-damagee.Location));
		}
	}
	simulated function HitWall(vector HitNormal, actor Wall)
	{
		if (Wall.IsA('BreakableGlass'))
			bDebris = False;

		SpawnEffects(Location, HitNormal, Wall);
		DrawExplosionEffects(Location,HitNormal);

		Super.HitWall(HitNormal, Wall);
	}

	simulated function Explode(vector HitLocation, vector HitNormal)
	{
		local bool bDestroy;
		local float rad;

		bDestroy = false;

		if (bExplodes)
		{
			DrawExplosionEffects(HitLocation, HitNormal);
			GotoState('Exploding');
		}
		else
		{
		        DrawExplosionEffects(HitLocation, HitNormal);
			// Server side only
			if ( Role == ROLE_Authority )
			{
				if (damagee != None)
				{
					if ( Level.NetMode != NM_Standalone )
					{
						if ( damagee.IsA('DeusExPlayer') )
							DeusExPlayer(damagee).myProjKiller = Self;
					}
					damagee.TakeDamage(Damage, Pawn(Owner), HitLocation, MomentumTransfer*Normal(Velocity), damageType);
				}
			}
			if (!bStuck)
				bDestroy = true;
		}

		rad = Max(blastRadius*24, 1024);

		// This needs to be outside the simulated call chain
		PlayImpactSound();

      //DEUS_EX AMSD Only do these server side
      if (Role == ROLE_Authority)
      {
         if (ImpactSound != None)
         {
            AISendEvent('LoudNoise', EAITYPE_Audio, 2.0, blastRadius*24);
            if (bExplodes)
               AISendEvent('WeaponFire', EAITYPE_Audio, 2.0, blastRadius*5);
         }
      }
		if (bDestroy)
			Destroy();
	}
	simulated function BeginState()
	{
		local DeusExWeapon W;

		initLoc = Location;
		initDir = vector(Rotation);	
		Velocity = speed*initDir;
		PlaySound(SpawnSound, SLOT_None);
	}
}

#exec MESH IMPORT MESH=RicebagProj ANIVFILE=MODELS\RicebagProj_a.3d DATAFILE=MODELS\RicebagProj_d.3d X=0 Y=0 Z=0
#exec mesh ORIGIN MESH=RicebagProj X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=RicebagProj SEQ=All     STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=RicebagProj SEQ=RiceBag STARTFRAME=0 NUMFRAMES=1

#exec texture IMPORT NAME=JRicebagProj1 FILE=Textures\AmmoRicebagtex2.pcx GROUP=Skins // MATERIAL #13

#exec MESHMAP new   MESHMAP=RicebagProj MESH=RicebagProj
#exec MESHMAP SCALE MESHMAP=RicebagProj X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=RicebagProj NUM=2 TEXTURE=JRicebagProj1

defaultproperties
{
     bDebris=True
     blastRadius=1.000000
     DamageType=headstun
     AccurateRange=400
     maxRange=800
     spawnAmmoClass=Class'tnmitems.AmmoRicebag'
     bIgnoresNanoDefense=True
     ItemName="RiceBag"
     ItemArticle="a"
     speed=1000.000000
     MaxSpeed=1000.000000
     Damage=1.000000
     MomentumTransfer=40000
     ImpactSound=Sound'TNM.Weapons.HitFlesh'
     Mesh=LodMesh'tnmitems.RicebagProj'
     CollisionRadius=2.000000
     CollisionHeight=2.500000
}
