//=============================================================================
// SporkProj.
//=============================================================================
class SporkProj extends tnmprojectile;

var float	mpDamage;
var int		mpAccurateRange;
var int		mpMaxRange;

// set it's rotation correctly
simulated function Tick(float deltaTime)
{
	local Rotator rot;

	if (bStuck)
		return;

	Super.Tick(deltaTime);

	if (Level.Netmode != NM_DedicatedServer)
	{
		rot = Rotation;
//		rot.Roll += 16384;
		rot.Pitch -= 16384;
		SetRotation(rot);
	}
}

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	// If this is a netgame, then override defaults
	if ( Level.NetMode != NM_StandAlone )
	{
		Damage = mpDamage;
		AccurateRange = mpAccurateRange;
		MaxRange = mpMaxRange;
	}
}


#exec MESH IMPORT MESH=SporkProj ANIVFILE=MODELS\SporkProj_a.3d DATAFILE=MODELS\SporkProj_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=SporkProj X=0 Y=0 Z=0 YAW=0 Pitch=0 Roll=0

#exec MESH SEQUENCE MESH=SporkProj SEQ=All       STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=SporkProj SEQ=SporkProj STARTFRAME=0 NUMFRAMES=1

#exec TEXTURE IMPORT NAME=JSporkProj1 FILE=Textures\ThrowSpork1.PCX GROUP=Skins // Spork
#exec TEXTURE IMPORT NAME=JSporkProj2 FILE=Textures\ThrowSpork1.PCX GROUP=Skins // Material #1

#exec MESHMAP NEW   MESHMAP=SporkProj MESH=SporkProj
#exec MESHMAP SCALE MESHMAP=SporkProj X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=SporkProj NUM=1 TEXTURE=JSporkProj1
//#exec MESHMAP SETTEXTURE MESHMAP=SporkProj NUM=2 TEXTURE=JSporkProj2

defaultproperties
{
     mpDamage=17.000000
     mpAccurateRange=640
     mpMaxRange=640
     bBlood=True
     bStickToWall=True
     DamageType=shot
     AccurateRange=640
     maxRange=1280
     spawnWeaponClass=Class'tnmitems.WeaponThrowSpork'
     bIgnoresNanoDefense=True
     ItemName="Throwing Spork"
     ItemArticle="a"
     speed=750.000000
     MaxSpeed=750.000000
     Damage=5.000000
     MomentumTransfer=1000
     ImpactSound=Sound'DeusExSounds.Generic.BulletHitFlesh'
     Mesh=LodMesh'tnmitems.SporkProj'
     CollisionRadius=5.000000
     CollisionHeight=0.300000
}
