class TNMEMPGrenade extends EMPGrenade;

auto simulated state Flying
{
	simulated function Explode(vector HitLocation, vector HitNormal)
	{
		local ShockRing ring;
		local DeusExPlayer player;
		local float dist;

		// flash the screen white based on how far away the explosion is
		//		player = DeusExPlayer(GetPlayerPawn());
		//		MBCODE: Reference projectile owner to get player
		//		because sever fails to get it the old way
		player = DeusExPlayer(Owner);

		if(player == none && level.netmode == NM_Standalone)
			player = DeusexPlayer(GetPlayerPawn());

		dist = Abs(VSize(player.Location - Location));

		// if you are at the same location, blind the player
		if (dist ~= 0)
			dist = 10.0;
		else
			dist = 2.0 * FClamp(blastRadius/dist, 0.0, 4.0);

		if (damageType == 'EMP')
			player.ClientFlash(dist, vect(0,200,1000));
		else if (damageType == 'TearGas')
			player.ClientFlash(dist, vect(0,1000,100));
		else
			player.ClientFlash(dist, vect(1000,1000,900));

		//DEUS_EX AMSD Only do visual effects if client or if destroyed via damage (since the client can't detect that)
		if ((Level.NetMode != NM_DedicatedServer) || (Role < ROLE_Authority) || bDamaged)
		{
			SpawnEffects(HitLocation, HitNormal, None);
			DrawExplosionEffects(HitLocation, HitNormal);
		}

		if ((damageType=='TearGas') && (Role==ROLE_Authority))
			SpawnTearGas();

		PlayImpactSound();

		if ( AISoundLevel > 0.0 )
			AISendEvent('LoudNoise', EAITYPE_Audio, 2.0, AISoundLevel*blastRadius*16);

		GotoState('Exploding');
	}
}

defaultproperties
{
     mpBlastRadius=768.000000
     mpProxRadius=128.000000
     mpEMPDamage=200.000000
     mpFuselength=1.500000
     fuseLength=3.000000
     proxRadius=128.000000
     AISoundLevel=0.100000
     bBlood=False
     bDebris=False
     DamageType=EMP
     spawnWeaponClass=Class'WeaponTNMEMPGrenade'
     ItemName="Electromagnetic Pulse (EMP) Grenade"
     speed=1000.000000
     MaxSpeed=1000.000000
     Damage=100.000000
     MomentumTransfer=50000
     ImpactSound=Sound'DeusExSounds.Weapons.EMPGrenadeExplode'
     LifeSpan=0.000000
     Mesh=LodMesh'DeusExItems.EMPGrenadePickup'
     CollisionRadius=3.000000
     CollisionHeight=1.900000
     Mass=5.000000
     Buoyancy=2.000000
}