//=============================================================================
// TNMPlasmaBolt.
//
// Smoke39 - PlasmaBolt plus penetration!
//=============================================================================
class TNMPlasmaBolt extends TNMProjectile;

#exec OBJ LOAD FILE=Effects


// Smoke39 - penetration vars
var() float penetration;		// max wall thickness we can penetrate
var Actor Penetrated;			// actor that our parent proj hit and penetrated


var ParticleGenerator pGen1;
var ParticleGenerator pGen2;

var float mpDamage;
var float mpBlastRadius;


simulated function DrawExplosionEffects(vector HitLocation, vector HitNormal)
{
	local ParticleGenerator gen;

	// create a particle generator shooting out plasma spheres
	gen = Spawn(class'ParticleGenerator',,, HitLocation, Rotator(HitNormal));
	if (gen != None)
	{
		gen.RemoteRole = ROLE_None;
		gen.particleDrawScale = 1.0;
		gen.checkTime = 0.10;
		gen.frequency = 1.0;
		gen.ejectSpeed = 200.0;
		gen.bGravity = True;
		gen.bRandomEject = True;
		gen.particleLifeSpan = 0.75;
		gen.particleTexture = Texture'Effects.Fire.Proj_PRifle';
		gen.LifeSpan = 1.3;
	}
}

function PostBeginPlay()
{
	Super.PostBeginPlay();

	if ((Level.NetMode == NM_Standalone) || (Level.NetMode == NM_ListenServer))
		SpawnPlasmaEffects();
}

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	Damage = mpDamage;
	blastRadius = mpBlastRadius;
}

simulated function PostNetBeginPlay()
{
	if (Role < ROLE_Authority)
		SpawnPlasmaEffects();
}

// DEUS_EX AMSD Should not be called as server propagating to clients.
simulated function SpawnPlasmaEffects()
{
	local Rotator rot;
	rot = Rotation;
	rot.Yaw -= 32768;

	pGen2 = Spawn(class'ParticleGenerator', Self,, Location, rot);
	if (pGen2 != None)
	{
		pGen2.RemoteRole = ROLE_None;
		pGen2.particleTexture = Texture'Effects.Fire.Proj_PRifle';
		pGen2.particleDrawScale = 0.1;
		pGen2.checkTime = 0.04;
		pGen2.riseRate = 0.0;
		pGen2.ejectSpeed = 100.0;
		pGen2.particleLifeSpan = 0.5;
		pGen2.bRandomEject = True;
		pGen2.SetBase(Self);
	}
   
}

simulated function Destroyed()
{
	if (pGen1 != None)
		pGen1.DelayedDestroy();
	if (pGen2 != None)
		pGen2.DelayedDestroy();

	Super.Destroyed();
}

// Smoke39 - the good stuff's in here
// sticking to walls is removed in these functions, 'cause it should be irrelevant...
auto simulated state Flying
{
	simulated function ProcessTouch (Actor Other, Vector HitLocation)
	{
		local float thickness;
		local TNMPlasmaBolt penetrator;

		// Smoke39 - pass through what we penetrated
		if ( Other == Penetrated )
			return;

		if ((Other != instigator) && (DeusExProjectile(Other) == None) &&
			(Other != Owner))
		{
			// Smoke39 - be nice and go only by the smaller
			thickness = FMin( Other.CollisionRadius, Other.CollisionHeight ) * 2;
			if ( penetration >= thickness )
			{
				// copy ourselves
				penetrator = Spawn( class'TNMPlasmaBolt', owner,, HitLocation );
				if ( penetrator != None )
				{
					penetrator.penetration = penetration - thickness;
					// fall on the other side
					penetrator.AccurateRange = 0;
					// don't collide with what we just flew through
					penetrator.Penetrated = Other;
				}
			}


			// Smoke39 - old stuff follows

			damagee = Other;
			Explode(HitLocation, Normal(HitLocation-damagee.Location));

			// DEUS_EX AMSD Spawn blood server side only
			if (Role == ROLE_Authority)
			{
				if (damagee.IsA('Pawn') && !damagee.IsA('Robot') && bBlood)
					SpawnBlood(HitLocation, Normal(HitLocation-damagee.Location));
			}
		}
	}

	simulated function HitWall(vector HitNormal, actor Wall)
	{
		local int i;
		local Actor other;
		local vector TraceStart, HitLocation, HN;
		local bool bGood;
		local TNMPlasmaBolt penetrator;


		// Smoke39 - shoot through walls

		// retduce all the "20"s in this section for greater accuracy
		// but potentially more traces fired for each wall impact

		if ( penetration >= 20 )
		{
			// shoot a trace up to penetration ahead 20 units at a time until we're not shooting from inside the wall
			for ( i=1; i*20<=penetration; i++ )
			{
				TraceStart = Location + i*20*Normal(velocity);
				other = Trace( HitLocation, HN, Location, TraceStart, false );
				if ( HitLocation != TraceStart )
				{
					bGood = true;
					break;
				}
			}

			// shoot through if penetration reached the other side of the wall
			if ( bGood )
			{
				// exit decal
				SpawnEffects(HitLocation,HN,other);
				// reset explosion decal so we can stick it at impact point
				ExplosionDecal = Default.ExplosionDecal;

				// copy ourselves on the other side
				penetrator = Spawn( class'TNMPlasmaBolt', owner,, HitLocation+Normal(velocity) );
				if ( penetrator != None )
				{
					penetrator.penetration = penetration - VSize(HitLocation-Location);
					// fall on the other side
					penetrator.AccurateRange = 0;
				}
			}
		}

		// Smoke39 - old stuff follows

		if (Wall.IsA('BreakableGlass'))
			bDebris = False;

		SpawnEffects(Location, HitNormal, Wall);

		// Smoke39 - TNM wall impact sound code is not applicable to this projectile
		Super(DeusExProjectile).HitWall(HitNormal, Wall);
	}
}

defaultproperties
{
     penetration=256.000000
     mpDamage=8.000000
     mpBlastRadius=300.000000
     bExplodes=True
     blastRadius=128.000000
     DamageType=Burned
     AccurateRange=14400
     maxRange=24000
     bIgnoresNanoDefense=True
     ItemName="Plasma Bolt"
     ItemArticle="a"
     speed=1500.000000
     MaxSpeed=1500.000000
     Damage=40.000000
     MomentumTransfer=5000
     ImpactSound=Sound'DeusExSounds.Weapons.PlasmaRifleHit'
     ExplosionDecal=Class'DeusEx.ScorchMark'
     Mesh=LodMesh'DeusExItems.PlasmaBolt'
     DrawScale=3.000000
     bUnlit=True
     LightType=LT_Steady
     LightEffect=LE_NonIncidence
     LightBrightness=200
     LightHue=80
     LightSaturation=128
     LightRadius=3
     bFixedRotationDir=True
}
