//=============================================================================
// TripProj.
//=============================================================================
class TripProj extends ThrownProjectile;

var float	mpBlastRadius;
var float	mpProxRadius;
var float	mpLAMDamage;
var float	mpFuselength;
var tnmLaserEmitter emitter;
var() bool bIsOn;
var bool bConfused;				// used when hit by EMP
var bool bCanFrob;
var float confusionTimer;		// how long until trigger resumes normal operation
var float confusionDuration;	// how long does EMP hit last?
var int HitDamage;
var int HitPoints;
var int minDamageThreshold;
var float TripTimer;
var float cooltime;
var int charge;

function Tick(float deltaTime)
{
    local Actor A;
    local Pawn P;
    local bool bConfusedOff;

    if (TripTimer > 0)
    {
          TripTimer -= deltaTime;
    }


    if ( bIsOn && cooltime <= 0 )
    {
      if (emitter != none)
      {
	//Any actor it hits will get hurt
	if ((emitter.HitActor != None) && (!bDisabled))
  	{
	   if(emitter.HitActor.IsA('tnmpawn') || emitter.HitActor.IsA('playerpawn'))
	   {
   	      emitter.HitActor.TakeDamage( 5, pawn(owner), emitter.HitActor.location, vect(0,0,0), 'Poison');
	      if(--charge<0)
	      {
			emitter.TurnOff();
			bIsOn = False;
	      }   
	   }

	   if ( emitter.HitActor.IsA('DeusExPlayer') &&  deusexplayer(emitter.HitActor).drugEffectTimer<7.5)
		   deusexplayer(emitter.HitActor).drugEffectTimer += 5.0;
	   cooltime = default.cooltime;
  	}
      }
    }
    else
	cooltime -= deltatime;


    //Confusion for when an EMP hits.
    if (bDisabled && bConfused && bIsOn)
    {
          confusionTimer += deltaTime;

          // randomly turn on/off the beam
          if (FRand() > 0.90)
             emitter.TurnOn();
          else
          {
             emitter.TurnOff();
             bConfusedOff=true;
          }

          if (confusionTimer > confusionDuration)
          {
             bConfused = False;
             confusionTimer = 0;
             emitter.TurnOn();
             ReEnable();
          }

          return;
    }

      //Changes the middle laser texture on the bomb.
      if (bIsOn && !bConfusedOff)
      {
         MultiSkins[2] = Texture'LaserOnTex';
      }
      else
      {
         MultiSkins[2] = Texture'JTripBomb2';
      }

    //Turns the laser on when the timer has finished
    if ((emitter == none) && TripTimer <= 0)
    {
	    //Spawn teh blue laser of injustice
	    emitter = Spawn(class'tnmLaserEmitter');

	    if (emitter != None)
	    {
		   emitter.SetGreenBeam();
		   emitter.TurnOn();
		   bIsOn = True;
	    }

            emitter.SetLocation(Location);
            emitter.SetRotation(Rotation);
    }
}

function Disarm()
{
	emitter.TurnOff();
	bDisabled=True;
	bIsOn = False;
	bCanFrob = True;
}

// if we are frobbed, turn us off
function Frob(Actor Frobber, Inventory frobWith)
{
	// if the player frobs it and it's disabled, the player can grab it
	//the player may be able to grab it if it has been EMPed.
	if(bCanFrob)
	{
		if(Charge<Default.Charge)
		{
			Trestkon(Frobber).ClientMessage("This mine has expended too much power to be able to re-arm itself and is therefore useless.");
			return;
		}
		Super.Frob(Frobber, frobWith);
	}
	//if (bDisabled)
	//	Super.Frob(Frobber, frobWith);
	//This part is for disabling the bomb
	/*else if (bArmed)
	{
        bDisabled = True;
	    if (emitter != None)
	    {
            if (bIsOn)
		    {
			   emitter.TurnOff();
			   bIsOn = False;
			   LastHitActor = None;
			   Emitter.MultiSkins[1] = Texture'BlackMaskTex';
		    }
	     }

	     return;
	}*/
}

//This function probably isn't needed.
function Destroyed()
{
	if (emitter != None)
	{
		emitter.Destroy();
		emitter = None;
	}

	Super.Destroyed();
}

//The TakeDamage function is from ThrownProjectile, all I've added is the
//confusion parts in the EMP damage type.
function TakeDamage(int Damage, Pawn EventInstigator, vector HitLocation, vector Momentum, name DamageType)
{
	local MetalFragment frag;

	if (DamageType == 'EMP')
	{
		confusionTimer = 0;
		if (!bConfused && !bDisabled)
		{
			bConfused = True;
			bDisabled = true;
			PlaySound(sound'EMPZap', SLOT_None,,, 1280);
		}
		return;
	}

	if ((DamageType == 'TearGas') || (DamageType == 'PoisonGas') || (DamageType == 'Radiation'))
		return;

	if (DamageType == 'NanoVirus')
		return;

	HitPoints -= Damage;

	if (HitPoints <= 0)
	{
		frag = Spawn(class'MetalFragment', Owner);
		if (frag != None)
		{
			frag.Instigator = EventInstigator;
			frag.CalcVelocity(Momentum,0);
			frag.DrawScale = 0.5*FRand();
			frag.Skin = GetMeshTexture();
		}

		if(bIsOn)
		{
			Damage*=1.f*Charge/Default.Charge;
			Explode(Location, Vector(Rotation));
			return;
		}
		Destroy();
	}
}

//Multiplayer Crap
simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	if ( Level.NetMode != NM_Standalone )
	{
		blastRadius=mpBlastRadius;
		proxRadius=mpProxRadius;
		Damage=mpLAMDamage;
		fuseLength=mpFuselength;
		bIgnoresNanoDefense=True;
	}
}

simulated function BeginPlay()
{
	local DeusExPlayer aplayer;

	Super(DeusexProjectile).BeginPlay();

	SetCollision(True, True, True);
}

#exec mesh IMPORT MESH=tripbombPlace ANIVFILE=MODELS\tripbombpickup_a.3d DATAFILE=MODELS\tripbombpickup_d.3d X=0 Y=0 Z=0
#exec mesh ORIGIN MESH=tripbombPlace X=0 Y=-3000 Z=0 YAW=64

#exec mesh SEQUENCE MESH=tripbombPlace SEQ=All            STARTFRAME=0 NUMFRAMES=1
#exec mesh SEQUENCE MESH=tripbombPlace SEQ=tripbombPlace STARTFRAME=0 NUMFRAMES=1

#exec texture IMPORT NAME=LaserOnTex FILE=Textures\TripBombTex2LaserOn.PCX GROUP=Skins // MuzzleTex

#exec MESHMAP new   MESHMAP=tripbombPlace MESH=tripbombPlace
#exec MESHMAP scale MESHMAP=tripbombPlace X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=tripbombPlace NUM=1 TEXTURE=JTripBomb1
#exec MESHMAP SETTEXTURE MESHMAP=tripbombPlace NUM=2 TEXTURE=JTripBomb2

defaultproperties
{
     confusionDuration=10.000000
     TripTimer=3.000000
     cooltime=0.050000
     fuseLength=0.000000
     proxRadius=0.000000
     blastRadius=256.000000
     spawnWeaponClass=Class'tnmitems.WeaponTripBomb'
     ItemName="Trip Bomb"
     speed=1000.000000
     MaxSpeed=1000.000000
     MomentumTransfer=50000
     ImpactSound=Sound'DeusExSounds.Weapons.LAMExplode'
     ExplosionDecal=Class'DeusEx.ScorchMark'
     LifeSpan=0.000000
     Mesh=LodMesh'tnmitems.tripbombPlace'
     DrawScale=0.160000
     CollisionRadius=2.500000
     CollisionHeight=3.800000
     Mass=5.000000
     Buoyancy=2.000000
     Damage=500.000000
     Charge=15
}
