//=============================================================================
// WeaponBlackBox.
//=============================================================================
class WeaponBlackBox extends TNMWeapon;

var localized String shortName;

//Make this not look like a weapon
function bool UpdateInfo(Object winObject)
{
	local PersonaInfoWindow winInfo;
	local DeusExPlayer player;
	local String outText;

	winInfo = PersonaInfoWindow(winObject);
	if (winInfo == None)
		return False;

	player = DeusExPlayer(Owner);

	if (player != None)
	{
		winInfo.SetTitle(itemName);
		winInfo.SetText(Description $ winInfo.CR() $ winInfo.CR());

		winInfo.AppendText(winInfo.CR() $ outText);
	}

	return True;
}

function PlaceGrenade()
{
	local blackbox gren;
	local float dmgX;

	gren = spawn(class'blackbox', Owner,, placeLocation , Rotator(placeNormal));
	if (gren != None)
	{
		AmmoType.UseAmmo(1);
		if ( AmmoType.AmmoAmount <= 0 )
			bDestroyOnFinish = True;

//		gren.PlayAnim('Open');
		gren.SetPhysics(PHYS_None);
		gren.bBounce = False;
		if (placeMover != None)
			gren.SetBase(placeMover);

		// Update ammo count on object belt
		if (DeusExPlayer(Owner) != None)
			DeusExPlayer(Owner).UpdateBeltText(Self);
	}
}


function PostBeginPlay()
{
   Super.PostBeginPlay();
   bWeaponStay=False;
}

/*
simulated event RenderOverlays( canvas Canvas )
{
	local rotator NewRot;
	local bool bPlayerOwner;
	local int Hand;
	local PlayerPawn PlayerOwner;

	if ( bHideWeapon || (Owner == None) )
		return;

	PlayerOwner = PlayerPawn(Owner);

	if ( PlayerOwner != None )
	{
		if ( PlayerOwner.DesiredFOV != PlayerOwner.DefaultFOV )
			return;
		bPlayerOwner = true;
		Hand = PlayerOwner.Handedness;

		if (  (Level.NetMode == NM_Client) && (Hand == 2) )
		{
			bHideWeapon = true;
			return;
		}
	}

	if ( !bPlayerOwner || (PlayerOwner.Player == None) )
		Pawn(Owner).WalkBob = vect(0,0,0);

	if ( (bMuzzleFlash > 0) && bDrawMuzzleFlash && Level.bHighDetailMode && (MFTexture != None) )
	{
		MuzzleScale = Default.MuzzleScale * Canvas.ClipX/640.0;
		if ( !bSetFlashTime )
		{
			bSetFlashTime = true;
			FlashTime = Level.TimeSeconds + FlashLength;
		}
		else if ( FlashTime < Level.TimeSeconds )
			bMuzzleFlash = 0;
		if ( bMuzzleFlash > 0 )
		{
			if ( Hand == 0 )
				Canvas.SetPos(Canvas.ClipX/2 - 0.5 * MuzzleScale * FlashS + Canvas.ClipX * (-0.2 * Default.FireOffset.Y * FlashO), Canvas.ClipY/2 - 0.5 * MuzzleScale * FlashS + Canvas.ClipY * (FlashY + FlashC));
			else
				Canvas.SetPos(Canvas.ClipX/2 - 0.5 * MuzzleScale * FlashS + Canvas.ClipX * (Hand * Default.FireOffset.Y * FlashO), Canvas.ClipY/2 - 0.5 * MuzzleScale * FlashS + Canvas.ClipY * FlashY);

			Canvas.Style = 3;
			Canvas.DrawIcon(MFTexture, MuzzleScale);
			Canvas.Style = 1;
		}
	}
	else
		bSetFlashTime = false;

	SetLocation( Owner.Location + CalcDrawOffset() );
		if (bNearWall)
		{
			newrot = Rotator(-1 *placenormal);
		}
		else
		{
	NewRot = Pawn(Owner).ViewRotation;

	if ( Hand == 0 )
		newRot.Roll = -2 * Default.Rotation.Roll;
	else
		newRot.Roll = Default.Rotation.Roll * Hand;
		}
	setRotation(newRot);
	Canvas.DrawActor(self, false);
}
*/

simulated function bool NearWallCheck()
{
	local Vector StartTrace, EndTrace, HitLocation, HitNormal;
	local Actor HitActor;
	local float temp;

	// Scripted pawns can't place LAMs
	if (ScriptedPawn(Owner) != None)
		return False;

	// Don't let players place grenades when they have something highlighted
	if ( Level.NetMode != NM_Standalone )
	{
		if ( Owner.IsA('DeusExPlayer') && (DeusExPlayer(Owner).frobTarget != None) )
		{
			if ( DeusExPlayer(Owner).IsFrobbable( DeusExPlayer(Owner).frobTarget ) )
				return False;
		}
	}

	// trace out one foot in front of the pawn //  changed to trace from weapon. For better or worse

	StartTrace = owner.Location;
	EndTrace = StartTrace + Vector(pawn(owner).viewRotation) * 32;

	StartTrace.Z += Pawn(Owner).BaseEyeHeight;
	EndTrace.Z += Pawn(Owner).BaseEyeHeight;

	HitActor = Trace(HitLocation, HitNormal, EndTrace, StartTrace);
	if ((HitActor == Level) || ((HitActor != None) && HitActor.IsA('Mover')))
	{
		if(getwallmaterial(hitlocation,hitnormal) == 'server')
		{

	StartTrace = Location;
	EndTrace = StartTrace + Vector(Rotation) * 32;

	StartTrace.Z += Pawn(Owner).BaseEyeHeight;
	EndTrace.Z += Pawn(Owner).BaseEyeHeight;

	HitActor = Trace(HitLocation, HitNormal, EndTrace, StartTrace);

		if(getwallmaterial(hitlocation,hitnormal) == 'server')
		{
		placeLocation = HitLocation;
		placeNormal = HitNormal;
		placeMover = Mover(HitActor);
		return True;
		}
		}
	}

	return False;
}

function Fire(float Value)
{
	local vector      HitLocation,HitNormal;
	local vector EndTrace, StartTrace;
	local actor target;
	local int texFlags;
	local name texName, texGroup;

	// if facing a wall, affix the LAM to the wall
	if (Pawn(Owner) != None)
	{
		if (bNearWall)
		{
			bReadyToFire = False;
			GotoState('NormalFire');
			bPointing = True;
			PlayAnim('Place',, 0.1);
			return;
		}
	}
}


// Become a pickup
// Weapons that carry their ammo with them don't vanish when dropped
function BecomePickup()
{
	Super.BecomePickup();
   if (Level.NetMode != NM_Standalone)
      if (bTossedOut)
         Lifespan = 0.0;
}



//
// Belt and Inventory Icons
//
#exec texture IMPORT NAME=LargeIconBlackBox FILE=Textures\LargeIconBlackBox.pcx GROUP=Skins MIPS=off
#exec texture IMPORT NAME=BeltIconBlackBox FILE=Textures\BeltIconBlackBox.pcx GROUP=Skins MIPS=off

#exec MESH IMPORT MESH=WeaponBlackBox ANIVFILE=MODELS\WeaponBlackBox_a.3d DATAFILE=MODELS\WeaponBlackBox_d.3d X=0 Y=0 Z=0 UNMIRROR=1
#exec MESH ORIGIN MESH=WeaponBlackBox X=7000 Y=1000 Z=-2000 YAW=64

#exec MESH SEQUENCE MESH=WeaponBlackBox SEQ=All         	STARTFRAME=0    NUMFRAMES=61
#exec MESH SEQUENCE MESH=WeaponBlackBox SEQ=Still		STARTFRAME=0	NUMFRAMES=1
#exec MESH SEQUENCE MESH=WeaponBlackBox SEQ=Select		STARTFRAME=1	NUMFRAMES=12		RATE=10	GROUP=Select
#exec MESH SEQUENCE MESH=WeaponBlackBox SEQ=Attack		STARTFRAME=13	NUMFRAMES=9		RATE=12
#exec MESH SEQUENCE MESH=WeaponBlackBox SEQ=Attack2	  	STARTFRAME=13	NUMFRAMES=9		RATE=12
#exec MESH SEQUENCE MESH=WeaponBlackBox SEQ=Attack3		STARTFRAME=13	NUMFRAMES=9		RATE=12
#exec MESH SEQUENCE MESH=WeaponBlackBox SEQ=Down		STARTFRAME=21	NUMFRAMES=5		RATE=6
#exec MESH SEQUENCE MESH=WeaponBlackBox SEQ=PlaceBegin		STARTFRAME=26	NUMFRAMES=5		RATE=8
#exec MESH SEQUENCE MESH=WeaponBlackBox SEQ=PlaceEnd		STARTFRAME=35	NUMFRAMES=5		RATE=8
#exec MESH SEQUENCE MESH=WeaponBlackBox SEQ=Place		STARTFRAME=30	NUMFRAMES=5		RATE=12
#exec MESH SEQUENCE MESH=WeaponBlackBox SEQ=Idle1		STARTFRAME=39	NUMFRAMES=8		RATE=2
#exec MESH SEQUENCE MESH=WeaponBlackBox SEQ=Idle2		STARTFRAME=46	NUMFRAMES=8		RATE=2
#exec MESH SEQUENCE MESH=WeaponBlackBox SEQ=Idle3		STARTFRAME=53	NUMFRAMES=8		RATE=2

#exec MESH NOTIFY MESH=WeaponBlackBox SEQ=Attack		TIME=0.7	FUNCTION=HandToHandAttack
#exec MESH NOTIFY MESH=WeaponBlackBox SEQ=Attack2		TIME=0.7	FUNCTION=HandToHandAttack
#exec MESH NOTIFY MESH=WeaponBlackBox SEQ=Attack3		TIME=0.7	FUNCTION=HandToHandAttack
#exec MESH NOTIFY MESH=WeaponBlackBox SEQ=Place		    	TIME=0.4	FUNCTION=PlaceGrenade

#exec TEXTURE IMPORT NAME=BlackBox FILE=Textures\BlackBoxTex1.pcx GROUP=Skins // Material #0
#exec TEXTURE IMPORT NAME=Hands FILE=Textures\WeaponHandsTex.pcx GROUP=Skins // TWOSIDED
#exec TEXTURE IMPORT NAME=LEDRed FILE=Textures\BlackBoxLEDR.pcx GROUP=Skins // Material #3
#exec TEXTURE IMPORT NAME=LEDGreen FILE=Textures\BlackBoxLEDG.pcx GROUP=Skins // Material #3

#exec MESHMAP NEW   MESHMAP=WeaponBlackBox MESH=WeaponBlackBox
#exec MESHMAP SCALE MESHMAP=WeaponBlackBox X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=WeaponBlackBox NUM=1 TEXTURE=BlackBox
#exec MESHMAP SETTEXTURE MESHMAP=WeaponBlackBox NUM=2 TEXTURE=Hands
#exec MESHMAP SETTEXTURE MESHMAP=WeaponBlackBox NUM=3 TEXTURE=LEDRed

//
// 3RD Person View
//
#exec MESH IMPORT MESH=BlackBox3rd ANIVFILE=MODELS\BlackBox_a.3d DATAFILE=MODELS\BlackBox_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=BlackBox3rd X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=BlackBox3rd SEQ=All      STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=BlackBox3rd SEQ=BlackBox3rd STARTFRAME=0 NUMFRAMES=1

#exec TEXTURE IMPORT NAME=JBlackBox3rd1 FILE=Textures\BlackBoxTex1.pcx GROUP=Skins // Material #2
#exec TEXTURE IMPORT NAME=JBlackBox3rd2 FILE=Textures\BlackBoxLEDR.pcx GROUP=Skins // Material #3

#exec MESHMAP NEW   MESHMAP=BlackBox3rd MESH=BlackBox
#exec MESHMAP SCALE MESHMAP=BlackBox3rd X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=BlackBox3rd NUM=1 TEXTURE=JBlackBox3rd1
#exec MESHMAP SETTEXTURE MESHMAP=BlackBox3rd NUM=2 TEXTURE=JBlackBox3rd2

//
// Pickup View
//
#exec MESH IMPORT MESH=BlackBox ANIVFILE=MODELS\BlackBox_a.3d DATAFILE=MODELS\BlackBox_d.3d X=0 Y=0 Z=0 UNMIRROR=1
#exec MESH ORIGIN MESH=BlackBox X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=BlackBox SEQ=All      STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=BlackBox SEQ=BlackBox STARTFRAME=0 NUMFRAMES=1

#exec TEXTURE IMPORT NAME=JBlackBox1 FILE=Textures\BlackBoxTex1.pcx GROUP=Skins // Material #2
#exec TEXTURE IMPORT NAME=JBlackBox2 FILE=Textures\BlackBoxLEDR.pcx GROUP=Skins // Material #3

#exec MESHMAP NEW   MESHMAP=BlackBox MESH=BlackBox
#exec MESHMAP SCALE MESHMAP=BlackBox X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=BlackBox NUM=1 TEXTURE=JBlackBox1
#exec MESHMAP SETTEXTURE MESHMAP=BlackBox NUM=2 TEXTURE=JBlackBox2

defaultproperties
{
     ShortName="Spyware"
     bNoMetal=True
     LowAmmoWaterMark=2
     GoverningSkill=Class'DeusEx.SkillDemolition'
     EnviroEffective=ENVEFF_All
     Concealability=CONC_All
     bEmitWeaponDrawn=False
     ShotTime=0.300000
     reloadTime=0.100000
     HitDamage=50
     maxRange=4800
     AccurateRange=2400
     BaseAccuracy=1.000000
     bHasMuzzleFlash=False
     bHandToHand=True
     bUseAsDrawnWeapon=False
     AITimeLimit=3.500000
     AIFireDelay=5.000000
     bNeedToSetMPPickupAmmo=False
     mpReloadTime=0.100000
     mpHitDamage=50
     mpBaseAccuracy=1.000000
     mpAccurateRange=2400
     mpMaxRange=2400
     AmmoName=Class'tnmitems.AmmoBlackBox'
     ReloadCount=1
     PickupAmmoCount=1
     FireOffset=(Y=10.000000,Z=20.000000)
     ProjectileClass=Class'DeusEx.LAM'
     shakemag=50.000000
     SelectSound=Sound'DeusExSounds.Weapons.LAMSelect'
     InventoryGroup=26
     ItemName="GATOR(TM) 1400rm"
     PlayerViewOffset=(X=24.000000,Y=-15.000000,Z=-17.000000)
     PlayerViewMesh=LodMesh'tnmitems.WeaponBlackBox'
     PlayerViewScale=0.700000
     PickupViewMesh=LodMesh'tnmitems.blackbox'
     ThirdPersonMesh=LodMesh'tnmitems.BlackBox3rd'
     ThirdPersonScale=0.700000
     Icon=Texture'tnmitems.Skins.BeltIconBlackBox'
     largeIcon=Texture'tnmitems.Skins.LargeIconBlackBox'
     largeIconWidth=101
     largeIconHeight=45
     invSlotsX=2
     Description="This discreet little black box is about the size of a closed book, and only decorated with a few blinking LED's and a little panel. It is in fact one of the most state-of-the-art spy-ware devices developed by The Gator Corporation for digital industrial espionage. The most impressive feature of this device is that it is incredibly easy to mount: Place it on the outside of a server (it will automatically attach itself by electro-magnetism) and connect a few wires with a multi-tool. Then it will start picking up the internal transmissions of the server and sending the data to wherever you choose."
     beltDescription="SPYWARE"
     Mesh=LodMesh'tnmitems.blackbox'
     CollisionRadius=8.000000
     CollisionHeight=5.000000
     Mass=5.000000
     Buoyancy=2.000000
}
