//=============================================================================
// WeaponBlowPipe.
//=============================================================================
class WeaponBlowPipe extends TNMWeapon;

var float firedelay;
var class<projectile> tempprojclass;
var float tempprojspeed;
var bool tempbwarn;

// Belt and Inventory Icons
#exec TEXTURE IMPORT NAME=BeltIconBlowPipe FILE=Textures\BeltIconBlowPipe.pcx GROUP=Icons MIPS=off // Belt Icon
#exec texture IMPORT NAME=LargeIconBlowPipe FILE=Textures\LargeIconBlowPipe.pcx GROUP=Icons MIPS=off // Iventory Icon

//
// Player View
//
#exec MESH IMPORT MESH=PoisonDart ANIVFILE=MODELS\PoisonDart_a.3d DATAFILE=MODELS\PoisonDart_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=PoisonDart X=0 Y=0 Z=3000

#exec MESH SEQUENCE MESH=PoisonDart SEQ=All             STARTFRAME=0 NUMFRAMES=53
#exec MESH SEQUENCE MESH=PoisonDart SEQ=Still			STARTFRAME=0	NUMFRAMES=1
#exec MESH SEQUENCE MESH=PoisonDart SEQ=Select		    STARTFRAME=1	NUMFRAMES=8	RATE=10	GROUP=Select
#exec MESH SEQUENCE MESH=PoisonDart SEQ=Shoot			STARTFRAME=8	NUMFRAMES=8	RATE=16
#exec MESH SEQUENCE MESH=PoisonDart SEQ=ReloadBegin		STARTFRAME=15	NUMFRAMES=4	RATE=10
#exec MESH SEQUENCE MESH=PoisonDart SEQ=Reload		    STARTFRAME=18	NUMFRAMES=5	RATE=8
#exec MESH SEQUENCE MESH=PoisonDart SEQ=ReloadEnd		STARTFRAME=22	NUMFRAMES=4	RATE=10
#exec MESH SEQUENCE MESH=PoisonDart SEQ=Down			STARTFRAME=25	NUMFRAMES=6	RATE=15
#exec MESH SEQUENCE MESH=PoisonDart SEQ=Idle1			STARTFRAME=31	NUMFRAMES=8	RATE=2
#exec MESH SEQUENCE MESH=PoisonDart SEQ=Idle2			STARTFRAME=38	NUMFRAMES=8	RATE=2
#exec MESH SEQUENCE MESH=PoisonDart SEQ=Idle3			STARTFRAME=45	NUMFRAMES=8	RATE=2

#exec TEXTURE IMPORT NAME=JPoisonDart1 FILE=Textures\BlowDartTex.PCX GROUP=Skins // Material #0
#exec TEXTURE IMPORT NAME=JPoisonDart2 FILE=Textures\WeaponHandsTex.PCX GROUP=Skins // Material #1

#exec MESHMAP NEW   MESHMAP=PoisonDart MESH=PoisonDart
#exec MESHMAP SCALE MESHMAP=PoisonDart X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=PoisonDart NUM=1 TEXTURE=JPoisonDart1
#exec MESHMAP SETTEXTURE MESHMAP=PoisonDart NUM=2 TEXTURE=JPoisonDart2

//
// 3rd Person View
//
#exec MESH IMPORT MESH=BlowPipe3rd ANIVFILE=MODELS\BlowPipe3rd_a.3d DATAFILE=MODELS\BlowPipe3rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=BlowPipe3rd X=2000 Y=0 Z=1000 PITCH=-24

#exec MESH SEQUENCE MESH=BlowPipe3rd SEQ=All         STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=BlowPipe3rd SEQ=BlowDart3rd STARTFRAME=0 NUMFRAMES=1

#exec TEXTURE IMPORT NAME=JBlowPipe3rd1 FILE=Textures\BlowDartTex.pcx GROUP=Skins // Material #0

#exec MESHMAP NEW   MESHMAP=BlowPipe3rd MESH=BlowPipe3rd
#exec MESHMAP SCALE MESHMAP=BlowPipe3rd X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=BlowPipe3rd NUM=1 TEXTURE=JBlowPipe3rd1

//
// Pickup View
//
#exec MESH IMPORT MESH=BlowPipePick ANIVFILE=MODELS\BlowPipePick_a.3d DATAFILE=MODELS\BlowPipePick_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=BlowPipePick X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=BlowPipe3rd SEQ=All         STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=BlowPipe3rd SEQ=BlowDart3rd STARTFRAME=0 NUMFRAMES=1

#exec TEXTURE IMPORT NAME=JBlowPipePick FILE=Textures\BlowDartTex.pcx GROUP=Skins // Material #0

#exec MESHMAP NEW   MESHMAP=BlowPipePick MESH=BlowPipePick
#exec MESHMAP SCALE MESHMAP=BlowPipePick X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=BlowPipePick NUM=1 TEXTURE=JBlowPipePick

function Projectile ProjectileFire(class<projectile> ProjClass, float ProjSpeed, bool bWarn)
{
tempprojclass = projclass;
tempprojspeed = projspeed;
tempbwarn = bwarn;

	firedelay -= 0.01;
}

function tick(float deltatime)
{

if (firedelay < default.firedelay)
{
	firedelay -= deltatime;

}
if (firedelay<=0)
{
	super.ProjectileFire(tempProjClass, tempProjSpeed, tempbWarn);
	firedelay = default.firedelay;
}

}

defaultproperties
{
     firedelay=0.400000
     bNoMetal=True
     LowAmmoWaterMark=1
     GoverningSkill=Class'DeusEx.SkillWeaponPistol'
     NoiseLevel=0.050000
     EnemyEffective=ENMEFF_Organic
     EnviroEffective=ENVEFF_AirVacuum
     Concealability=CONC_All
     ShotTime=0.800000
     reloadTime=0.500000
     HitDamage=55
     maxRange=1600
     AccurateRange=800
     BaseAccuracy=0.800000
     ScopeFOV=15
     bCanHaveLaser=False
     bHasSilencer=True
     AmmoNames(0)=Class'tnmitems.AmmoBlowDart'
     ProjectileNames(0)=Class'tnmitems.DartProj'
     StunDuration=10.000000
     bHasMuzzleFlash=False
     mpReloadTime=0.500000
     mpHitDamage=30
     mpBaseAccuracy=0.100000
     mpAccurateRange=2000
     mpMaxRange=2000
     mpReloadCount=6
     mpPickupAmmoCount=6
     bCanHaveModBaseAccuracy=True
     bCanHaveModAccurateRange=True
     bCanHaveModReloadTime=True
     AmmoName=Class'tnmitems.AmmoBlowDart'
     ReloadCount=1
     PickupAmmoCount=1
     FireOffset=(X=-25.000000,Y=8.000000,Z=14.000000)
     ProjectileClass=Class'tnmitems.DartProj'
     shakemag=30.000000
     FireSound=Sound'tnmitems.Weapons.BlowGunFire'
     CockingSound=Sound'tnmitems.Weapons.BlowGunReload'
     SelectSound=Sound'tnmitems.Weapons.BlowGunSelect'
     Misc1Sound=None
     InventoryGroup=27
     ItemName="Bamboo Blow Pipe"
     PlayerViewOffset=(X=25.000000,Y=-8.000000,Z=-14.000000)
     PlayerViewMesh=LodMesh'tnmitems.PoisonDart'
     PlayerViewScale=0.700000
     PickupViewMesh=LodMesh'tnmitems.BlowPipePick'
     ThirdPersonMesh=LodMesh'tnmitems.BlowPipe3rd'
     ThirdPersonScale=0.500000
     Icon=Texture'tnmitems.Icons.BeltIconBlowPipe'
     largeIcon=Texture'tnmitems.Icons.LargeIconBlowPipe'
     largeIconWidth=101
     largeIconHeight=43
     invSlotsX=2
     Description="UNIQUE WEAPON:|nThe blow pipe - Originally used by the TutiFruti tribe to pick their enemies off silently, until they found out how to use guns. Now mostly used by the clueless n00b-tribe who doesn't know how to fire any weapon more advanced. This particular pipe has been carefully engraved with the symbol of a powerful shaman of the TutiFruti tribe."
     beltDescription="BLOWPIPE"
     Mesh=LodMesh'tnmitems.BlowPipePick'
     CollisionRadius=8.000000
     CollisionHeight=1.000000
     Mass=5.000000
}
