//=============================================================================
// WeaponDaiKatana.
//=============================================================================
class WeaponDaiKatana extends TNMWeapon;

//
// from Weapon.uc - modified so we can have the accuracy in TraceFire
//
function Fire(float Value)
{
	local float sndVolume;
	local bool bListenClient;

	bListenClient = (Owner.IsA('DeusExPlayer') && DeusExPlayer(Owner).PlayerIsListenClient());

	sndVolume = TransientSoundVolume;

	if ( Level.NetMode != NM_Standalone )  // Turn up the sounds a bit in mulitplayer
	{
		sndVolume = TransientSoundVolume * 2.0;
		if ( Owner.IsA('DeusExPlayer') && (DeusExPlayer(Owner).NintendoImmunityTimeLeft > 0.01) || (!bClientReady && (!bListenClient)) )
		{
			DeusExPlayer(Owner).bJustFired = False;
			bReadyToFire = True;
			bPointing = False;
			bFiring = False;
			return;
		}
	}
	// check for surrounding environment
	if ((EnviroEffective == ENVEFF_Air) || (EnviroEffective == ENVEFF_Vacuum) || (EnviroEffective == ENVEFF_AirVacuum))
	{
		if (Region.Zone.bWaterZone)
		{
			if (Pawn(Owner) != None)
			{
				Pawn(Owner).ClientMessage(msgNotWorking);
				if (!bHandToHand)
					PlaySimSound( Misc1Sound, SLOT_None, sndVolume, 1024 );		// play dry fire sound
			}
			GotoState('Idle');
			return;
		}
	}


	if (bHandToHand)
	{
		if (ReloadCount > 0)
			AmmoType.UseAmmo(1);

		if (( Level.NetMode != NM_Standalone ) && !bListenClient )
			bClientReady = False;
		bReadyToFire = False;
		GotoState('NormalFire');
		bPointing=True;
		if ( Owner.IsA('PlayerPawn') )
			PlayerPawn(Owner).PlayFiring();
		//added line:
		owner.takedamage(5,pawn(owner),owner.location,vect(0,0,0),'shot');
		PlaySelectiveFiring();
		PlayFiringSound();
	}
	// if we are a single-use weapon, then our ReloadCount is 0 and we don't use ammo
	else if ((ClipCount < ReloadCount) || (ReloadCount == 0))
	{
		if ((ReloadCount == 0) || AmmoType.UseAmmo(1))
		{
			if (( Level.NetMode != NM_Standalone ) && !bListenClient )
				bClientReady = False;

			ClipCount++;
			bFiring = True;
			bReadyToFire = False;
			GotoState('NormalFire');
			if (( Level.NetMode == NM_Standalone ) || ( Owner.IsA('DeusExPlayer') && DeusExPlayer(Owner).PlayerIsListenClient()) )
			{
				if ( PlayerPawn(Owner) != None )		// shake us based on accuracy
					PlayerPawn(Owner).ShakeView(ShakeTime, currentAccuracy * ShakeMag + ShakeMag, currentAccuracy * ShakeVert);
			}
			bPointing=True;
			if ( bInstantHit )
				TraceFire(currentAccuracy);
			else
				ProjectileFire(ProjectileClass, ProjectileSpeed, bWarnTarget);

			if ( Owner.IsA('PlayerPawn') )
				PlayerPawn(Owner).PlayFiring();
			// Don't play firing anim for 20mm
			if ( Ammo20mm(AmmoType) == None )
				PlaySelectiveFiring();
			PlayFiringSound();
			if ( Owner.bHidden )
				CheckVisibility();
		}
		else
			PlaySimSound( Misc1Sound, SLOT_None, sndVolume, 1024 );		// play dry fire sound
	}
	else
		PlaySimSound( Misc1Sound, SLOT_None, sndVolume, 1024 );		// play dry fire sound

	// Update ammo count on object belt
	if (DeusExPlayer(Owner) != None)
		DeusExPlayer(Owner).UpdateBeltText(Self);
}

//
// Belt and Inventory Icons
//
#exec texture IMPORT NAME=LargeIconDaiKatana FILE=Textures\LargeIconDaiKatana.pcx GROUP=Skins MIPS=off
#exec texture IMPORT NAME=BeltIconDaiKatana FILE=Textures\BeltIconDaiKatana.pcx GROUP=Skins MIPS=off

#exec mesh IMPORT MESH=WeaponDaiKatana ANIVFILE=MODELS\WeaponKatana_a.3d DATAFILE=MODELS\WeaponKatana_d.3d X=0 Y=0 Z=0
#exec mesh ORIGIN MESH=WeaponDaiKatana X=2000 Y=0 Z=3000 YAW=64  //(Z=Up/down X=Side)

#exec mesh SEQUENCE MESH=WeaponDaiKatana SEQ=All       STARTFRAME=0    NUMFRAMES=73
#exec mesh SEQUENCE MESH=WeaponDaiKatana SEQ=Still		STARTFRAME=0	NUMFRAMES=1
#exec mesh SEQUENCE MESH=WeaponDaiKatana SEQ=Select	    STARTFRAME=1	NUMFRAMES=14	RATE=8	GROUP=Select
#exec mesh SEQUENCE MESH=WeaponDaiKatana SEQ=Attack	    STARTFRAME=14	NUMFRAMES=9	    RATE=12
#exec mesh SEQUENCE MESH=WeaponDaiKatana SEQ=Attack2	STARTFRAME=22	NUMFRAMES=10	RATE=16
#exec mesh SEQUENCE MESH=WeaponDaiKatana SEQ=Attack3	STARTFRAME=31	NUMFRAMES=9	    RATE=12
#exec mesh SEQUENCE MESH=WeaponDaiKatana SEQ=Down		STARTFRAME=39	NUMFRAMES=12	RATE=8
#exec mesh SEQUENCE MESH=WeaponDaiKatana SEQ=Idle1		STARTFRAME=51	NUMFRAMES=8	    RATE=2
#exec mesh SEQUENCE MESH=WeaponDaiKatana SEQ=Idle2		STARTFRAME=58	NUMFRAMES=8	    RATE=2
#exec mesh SEQUENCE MESH=WeaponDaiKatana SEQ=Idle3		STARTFRAME=65	NUMFRAMES=8  	RATE=2

//
// Attack Information
//
#exec mesh NOTIFY MESH=WeaponDaiKatana SEQ=Attack          TIME=0.5     FUNCTION=HandToHandAttack
#exec mesh NOTIFY MESH=WeaponDaiKatana SEQ=Attack2          TIME=0.5     FUNCTION=HandToHandAttack
#exec mesh NOTIFY MESH=WeaponDaiKatana SEQ=Attack3          TIME=0.5     FUNCTION=HandToHandAttack

#exec texture IMPORT NAME=JWeaponDaiKatana1 FILE=Textures\DaikatanaTex1.pcx GROUP=Skins // Material #2
#exec texture IMPORT NAME=JWeaponDaiKatana2 FILE=Textures\WeaponHandsTex.PCX GROUP=Skins // TWOSIDED

#exec MESHMAP new   MESHMAP=WeaponDaiKatana MESH=WeaponDaiKatana
#exec MESHMAP scale MESHMAP=WeaponDaiKatana X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=WeaponDaiKatana NUM=1 TEXTURE=JWeaponDaiKatana1
#exec MESHMAP SETTEXTURE MESHMAP=WeaponDaiKatana NUM=2 TEXTURE=JWeaponDaiKatana2

//
// Pickup Version
//
#exec mesh IMPORT MESH=DaiKatanaPickup ANIVFILE=MODELS\KatanaPickup_a.3d DATAFILE=MODELS\KatanaPickup_d.3d X=0 Y=0 Z=0
#exec mesh ORIGIN MESH=DaiKatanaPickup X=0 Y=0 Z=0

#exec mesh SEQUENCE MESH=DaiKatanaPickup SEQ=All          STARTFRAME=0 NUMFRAMES=1
#exec mesh SEQUENCE MESH=DaiKatanaPickup SEQ=DaiKatanaPickup STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP new   MESHMAP=DaiKatanaPickup MESH=DaiKatanaPickup
#exec MESHMAP scale MESHMAP=DaiKatanaPickup X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=DaiKatanaPickup NUM=1 TEXTURE=JWeaponDaiKatana1

//
// 3rd person Mesh
//
#exec mesh IMPORT MESH=DaiKatana3rd ANIVFILE=MODELS\Katana3rd_a.3d DATAFILE=MODELS\Katana3rd_d.3d X=0 Y=0 Z=0
#exec mesh ORIGIN MESH=DaiKatana3rd X=2000 Y=0 Z=0 PITCH=13

#exec mesh SEQUENCE MESH=DaiKatana3rd SEQ=All       STARTFRAME=0 NUMFRAMES=1
#exec mesh SEQUENCE MESH=DaiKatana3rd SEQ=Still     STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP new   MESHMAP=DaiKatana3rd MESH=DaiKatana3rd
#exec MESHMAP scale MESHMAP=DaiKatana3rd X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=DaiKatana3rd NUM=1 TEXTURE=JWeaponDaiKatana1

defaultproperties
{
     LowAmmoWaterMark=0
     GoverningSkill=Class'DeusEx.SkillWeaponLowTech'
     NoiseLevel=0.050000
     EnemyEffective=ENMEFF_Organic
     EnviroEffective=ENVEFF_All
     Concealability=CONC_Visual
     reloadTime=0.000000
     HitDamage=15
     maxRange=80
     AccurateRange=80
     BaseAccuracy=1.000000
     bHandToHand=True
     mpHitDamage=15
     mpBaseAccuracy=0.700000
     mpAccurateRange=70
     mpMaxRange=80
     AmmoName=Class'DeusEx.AmmoNone'
     ReloadCount=0
     bInstantHit=True
     FireOffset=(X=22.000000,Y=-10.000000,Z=14.000000)
     shakemag=20.000000
     FireSound=Sound'DeusExSounds.Weapons.SwordFire'
     SelectSound=Sound'DeusExSounds.Weapons.SwordSelect'
     Misc1Sound=Sound'DeusExSounds.Weapons.SwordHitFlesh'
     Misc2Sound=Sound'DeusExSounds.Weapons.SwordHitHard'
     Misc3Sound=Sound'DeusExSounds.Weapons.SwordHitSoft'
     InventoryGroup=44
     ItemName="DaiKatana"
     ItemArticle="the"
     PlayerViewOffset=(X=28.000000,Y=-10.000000,Z=-11.500000)
     PlayerViewMesh=LodMesh'TNMItems.WeaponDaikatana'
     PlayerViewScale=1.300000
     PickupViewMesh=LodMesh'TNMItems.DaiKatanaPickup'
     PickupViewScale=0.700000
     ThirdPersonMesh=LodMesh'TNMItems.DaiKatana3rd'
     ThirdPersonScale=0.500000
     Icon=Texture'TNMItems.Skins.BeltIconDaiKatana'
     largeIcon=Texture'TNMItems.Skins.LargeIconDaiKatana'
     largeIconWidth=205
     largeIconHeight=46
     invSlotsX=4
     Description="UNIQUE WEAPON:|nThere's something unnerving about this weapon. Even as you hold it, it seems heavy and difficult to swing. The edge of the blade looks duller than your average butter knife, and the hilt is designed so it actually hurts your hand to hold it. The words 'The best weapon we've seen since the Redeemer' have been carved into the blade, and the hilt carries the name John Romero."
     beltDescription="DAIKATANA"
     Mesh=LodMesh'TNMItems.DaiKatanaPickup'
     DrawScale=0.700000
     CollisionRadius=13.000000
     CollisionHeight=2.000000
}
