//=============================================================================
// WeaponDoubleGuns.
//=============================================================================
class WeaponDoubleGuns extends TNMWeapon;

var bool bfired1;
var bool bfireboth;
var bool bcanfireboth;

var localized string firemodeAltFireText;
var localized string firemodeDoubleFireText;
var localized string belttextAltFire;
var localized string belttextDoubleFire;
var localized string firemodemessage;


simulated function Vector ComputeProjectileStart(Vector X, Vector Y, Vector Z)
{
	local float mult;
	local Vector Start;

	if (bfired1)
		mult = -1;
	else
		mult = 1;

	// if we are instant-hit, non-projectile, then don't offset our starting point by PlayerViewOffset
	if (bInstantHit)
		Start = Owner.Location + Pawn(Owner).BaseEyeHeight * vect(0,0,1);// - Vector(Pawn(Owner).ViewRotation)*(0.9*Pawn(Owner).CollisionRadius);
	else
	{
		Start = CalcDrawOffset();
		Start = X * (start dot X) + Y  * (start dot Y) * mult + Z * (start dot Z);
		Start += Owner.Location + FireOffset.X * X + FireOffset.Y * Y * mult + FireOffset.Z * Z;
	}

	return Start;
}

// DDL - yay brute force
simulated event RenderOverlays( canvas Canvas )
{
	Super.RenderOverlays( Canvas );

	if(bHasSilencer)
		Multiskins[3] = texture'DGunsClip1';
	else
		Multiskins[3] = Texture'DeusExItems.Skins.PinkMaskTex';
}


//
// The masked silencer skin is replaced by the visable skin
// This function is called by the missionscript HAZZAH!
//
simulated function MakeSilenceVis()
{
        MultiSkins[3] = Texture'DGunsClip1'; //Replaces PinkMaskTex with DGunsClip1
        bHasSilencer = true; //This enables the silencer sounds and also lets the game know it's silenced.
        bCanHaveSilencer = true;
}


simulated function PlayFiringSound()
{
	if (bHasSilencer)
	{
		if ((bfireboth) && (bcanfireboth))
			PlaySimSound( altfiresilencedsound, SLOT_None, TransientSoundVolume, 2048 );
		else
			PlaySimSound( FireSilencedSound, SLOT_None, TransientSoundVolume, 2048 );
	}		
	else
	{
		if ((bfireboth) && (bcanfireboth))
			PlaySimSound( altfiresoundreal, SLOT_None, TransientSoundVolume, 2048 );
		else
			PlaySimSound( FireSound, SLOT_None, TransientSoundVolume, 2048 );
	}

	bcanfireboth = false;
}


// ----------------------------------------------------------------------
// UpdateAmmoInfo()
// ----------------------------------------------------------------------

simulated function UpdateAmmoInfo(Object winObject, Class<DeusExAmmo> ammoClass)
{
	local PersonaInventoryInfoWindow winInfo;
	local string str;
	local int i;

	winInfo = PersonaInventoryInfoWindow(winObject);
	if (winInfo == None)
		return;

	// Ammo loaded
	if ((AmmoName != class'AmmoNone') && (!bHandToHand) && (ReloadCount != 0))
		winInfo.UpdateAmmoLoaded(AmmoType.itemName);

	// ammo info
	if ((AmmoName == class'AmmoNone') || bHandToHand || (ReloadCount == 0))
		str = msgInfoNA;
	else
		str = AmmoName.Default.ItemName;
	for (i=0; i<ArrayCount(AmmoNames); i++)
		if ((AmmoNames[i] != None) && (AmmoNames[i] != AmmoName))
			str = str $ "|n" $ AmmoNames[i].Default.ItemName;

	winInfo.UpdateAmmoTypes(str);

	// If this weapon has ammo info, display it here
	if (ammoClass != None)
		winInfo.UpdateAmmoDescription(ammoClass.Default.ItemName $ "|n" $ ammoClass.Default.description);
}

Simulated function Tick(float deltaTime)
{
	local float recoil;
	local DeusExPlayer player;

	player = DeusExPlayer(Owner);
	if (player != None)
	{
		// reduce the recoil based on skill
		recoil = recoilStrength + GetWeaponSkill() * 2.0;
		if (recoil < 0.0)
			recoil = 0.0;

		// simulate recoil while firing
		if (bFiring && IsAnimating() && (recoil > 0.0))
		{
			if (AnimSequence == 'Shoot2')
			{
				player.ViewRotation.Yaw += deltaTime * (Rand(4096) - 2048) * recoil;
				player.ViewRotation.Pitch += deltaTime * (Rand(4096) + 4096) * recoil;
				if ((player.ViewRotation.Pitch > 16384) && (player.ViewRotation.Pitch < 32768))
					player.ViewRotation.Pitch = 16384;
			}
			else if (AnimSequence == 'AltShoot')
			{
				recoil *= 2;
				player.ViewRotation.Yaw += deltaTime * (Rand(4096) - 2048) * recoil;
				player.ViewRotation.Pitch += deltaTime * (Rand(4096) + 4096) * recoil;
				if ((player.ViewRotation.Pitch > 16384) && (player.ViewRotation.Pitch < 32768))
					player.ViewRotation.Pitch = 16384;
			}			
		}
	}
	super.Tick(deltatime);
}

simulated function int NumClips() //may want to replace this to use two clips at a time
{
	if (ReloadCount == 0)  // if this weapon is not reloadable
		return 0;
	else if (AmmoType == None)
		return 0;
	else if (AmmoType.AmmoAmount == 0)	// if we are out of ammo
		return 0;
	else  // compute remaining clips
		return ((AmmoType.AmmoAmount-AmmoLeftInClip()) + (ReloadCount-1)) / ReloadCount;
}


function CycleAmmo()
{
local pawn P;

p = pawn(owner);

bfireboth = !bfireboth;

if (bfireboth)
{
    belttext=belttextDoubleFire;
    firemode=firemodeDoubleFireText;
    ShotTime=0.625;
    baseaccuracy = 0.95 - (0.95*modbaseaccuracy*0.5); //half the bonus for acc mods when doubleshooting
}
else
{
    belttext=belttextAltFire;
    firemode=firemodeAltFireText;
    ShotTime=0.3125;
    baseaccuracy = default.baseaccuracy - (default.baseaccuracy*modbaseaccuracy); //restore accmod data
}

P.ClientMessage(Sprintf(firemodemessage, ItemName, firemode));

	// Update ammo count on object belt
	if (DeusExPlayer(Owner) != None)
		DeusExPlayer(Owner).UpdateBeltText(Self);
//}
}

simulated function PlaySelectiveFiring()
{
	local Pawn aPawn;
	local float rnd;
	local Name anim;

	if ((bfireboth) && (bcanfireboth))
		anim = 'altshoot';
	else
	{
		if (bfired1)
			anim = 'shoot2';
		else
			anim = 'Shoot';		
	}

	if (( Level.NetMode == NM_Standalone ) || ( DeusExPlayer(Owner) == DeusExPlayer(GetPlayerPawn())) )
	{
		if (bAutomatic)
			LoopAnim(anim,, 0.1);
		else
			PlayAnim(anim,,0.1);
	}
	else if ( Role == ROLE_Authority )
	{
		for ( aPawn = Level.PawnList; aPawn != None; aPawn = aPawn.nextPawn )
		{
			if ( aPawn.IsA('DeusExPlayer') && ( DeusExPlayer(Owner) != DeusExPlayer(aPawn) ) )
			{
				// If they can't see the weapon, don't bother
				if ( DeusExPlayer(aPawn).FastTrace( DeusExPlayer(aPawn).Location, Location ))
					DeusExPlayer(aPawn).ClientPlayAnimation( Self, anim, 0.1, bAutomatic );
			}
		}
	}
}

function Fire(float Value)
{
	local float sndVolume;
	local bool bListenClient;

	bListenClient = (Owner.IsA('DeusExPlayer') && DeusExPlayer(Owner).PlayerIsListenClient());

	sndVolume = TransientSoundVolume;

	if ( Level.NetMode != NM_Standalone )  // Turn up the sounds a bit in mulitplayer
	{
		sndVolume = TransientSoundVolume * 2.0;
		if ( Owner.IsA('DeusExPlayer') && (DeusExPlayer(Owner).NintendoImmunityTimeLeft > 0.01) || (!bClientReady && (!bListenClient)) )
		{
			DeusExPlayer(Owner).bJustFired = False;
			bReadyToFire = True;
			bPointing = False;
			bFiring = False;
			return;
		}
	}
	// check for surrounding environment
	if ((EnviroEffective == ENVEFF_Air) || (EnviroEffective == ENVEFF_Vacuum) || (EnviroEffective == ENVEFF_AirVacuum))
	{
		if (Region.Zone.bWaterZone)
		{
			if (Pawn(Owner) != None)
			{
				Pawn(Owner).ClientMessage(msgNotWorking);
				if (!bHandToHand)
					PlaySimSound( Misc1Sound, SLOT_None, sndVolume, 1024 );		// play dry fire sound
			}
			GotoState('Idle');
			return;
		}
	}


	// if we are a single-use weapon, then our ReloadCount is 0 and we don't use ammo
	if ((ClipCount < ReloadCount) || (ReloadCount == 0))
	{
		if (AmmoType.useammo(1))
		{
			if (( Level.NetMode != NM_Standalone ) && !bListenClient )
				bClientReady = False;

			ClipCount++; //FUUUUUUUUUUCKKKKKKKKKKKKKKKKKKKK there is no font big enough to express my annoyance.
			bFiring = True;
			bReadyToFire = False;
			GotoState('NormalFire');
			if (( Level.NetMode == NM_Standalone ) || ( Owner.IsA('DeusExPlayer') && DeusExPlayer(Owner).PlayerIsListenClient()) )
			{
				if ( PlayerPawn(Owner) != None )		// shake us based on accuracy
					PlayerPawn(Owner).ShakeView(ShakeTime, currentAccuracy * ShakeMag + ShakeMag, currentAccuracy * ShakeVert);
			}
			bPointing=True;

			if(bcanfireboth)
				Log("DOUBLE GUNS ERROR: bcanfireboth not cleared.");
			if ( bInstantHit )
				TraceFire(currentAccuracy);
			else
				ProjectileFire(ProjectileClass, ProjectileSpeed, bWarnTarget);
			bfired1 = !bfired1;

			if ((bfireboth) && (AmmoLeftInClip() > 0) && (AmmoType.useammo(1))) //go go short circuit whatever its called
			{
				ClipCount++;
				if ( bInstantHit )
					TraceFire(currentAccuracy);
				else
					ProjectileFire(ProjectileClass, ProjectileSpeed, bWarnTarget);
				bfired1 = !bfired1;

				bcanfireboth = true; //needed for anims and sounds. cleared again in playFiringSound after Play Selective Firing
			}

			if ( Owner.IsA('PlayerPawn') )
				PlayerPawn(Owner).PlayFiring();
			PlaySelectiveFiring();
			PlayFiringSound();
			if ( Owner.bHidden )
				CheckVisibility();
		}
		else
			PlaySimSound( Misc1Sound, SLOT_None, sndVolume, 1024 );		// play dry fire sound
	}
	else
		PlaySimSound( Misc1Sound, SLOT_None, sndVolume, 1024 );		// play dry fire sound
}


// Muzzle Flash Stuff
// called from the MESH NOTIFY Copied from DeusexWeapons.uc and modified...
simulated function SwapMuzzleFlashTexture()
{
     if (!bHasMuzzleFlash)
         return;

     if (bHasSilencer) //Checks to see if the guns are silenced, if they are no muzzleflash is drawn
         return;

if (!bfired1)
{
     if (FRand() < 0.5)
         MultiSkins[7] = Texture'DeusExItems.Skins.FlatFXTex34';
     else
         MultiSkins[7] = Texture'DeusExItems.Skins.FlatFXTex34';
}
else
{
     if (FRand() < 0.5)
         MultiSkins[5] = Texture'DeusExItems.Skins.FlatFXTex34';
     else
         MultiSkins[5] = Texture'DeusExItems.Skins.FlatFXTex34';
}

     MuzzleFlashLight();
     SetTimer(0.1, False);
}

simulated function SwapMuzzleFlashTextureboth()
{
     if (!bHasMuzzleFlash)
         return;

     if (bHasSilencer) //Checks to see if the guns are silenced, if they are no muzzleflash is drawn
         return;

     if (FRand() < 0.5)
         MultiSkins[7] = Texture'DeusExItems.Skins.FlatFXTex34';
     else
         MultiSkins[7] = Texture'DeusExItems.Skins.FlatFXTex34';

     if (FRand() < 0.5)
         MultiSkins[5] = Texture'DeusExItems.Skins.FlatFXTex34';
     else
         MultiSkins[5] = Texture'DeusExItems.Skins.FlatFXTex34';

     MuzzleFlashLight();
     SetTimer(0.1, False);
}

simulated function EraseMuzzleFlashTexture1()
{
     MultiSkins[7] = None;
     MultiSkins[5] = None;
}

simulated function Timer()
{
     EraseMuzzleFlashTexture1();
}

simulated function MuzzleFlashLight()
{
     local Vector offset, X, Y, Z;
     local Effects flash;

     if (!bHasMuzzleFlash)
          return;

     if (bHasSilencer)  //Checks to see if the guns are silenced, if they are no muzzleflash is drawn
          return;

     if ((flash != None) && !flash.bDeleteMe)
          flash.LifeSpan = flash.Default.LifeSpan;
     else
     {
          GetAxes(Pawn(Owner).ViewRotation,X,Y,Z);
          offset = Owner.Location;
          offset += X * Owner.CollisionRadius * 2;
          flash = spawn(class'Muzzleflash',,, offset);
          if (flash != None)
               flash.SetBase(Owner);
     }
}


//
// Belt and Inventory Icons
//
#exec texture IMPORT NAME=LargeIconDGuns FILE=Textures\LargeIconDGuns.pcx GROUP=Skins MIPS=off
#exec texture IMPORT NAME=BeltIconDGuns FILE=Textures\BeltIconDGuns.pcx GROUP=Skins MIPS=off


//
// First Person Version Left
//
#exec mesh IMPORT MESH=DoubleGunsL ANIVFILE=MODELS\DoubleGuns_a.3d DATAFILE=MODELS\DoubleGuns_d.3d X=0 Y=0 Z=0 Unmirror=1
#exec mesh ORIGIN MESH=DoubleGunsL X=3500 Y=-5000 Z=-3000 YAW=64//X = Sideways Y = Back & forward Z = Up & Down

#exec mesh SEQUENCE MESH=DoubleGunsL SEQ=All         STARTFRAME=0 NUMFRAMES=105
#exec mesh SEQUENCE MESH=DoubleGunsL SEQ=Still       STARTFRAME=0 NUMFRAMES=1
#exec mesh SEQUENCE MESH=DoubleGunsL SEQ=Select      STARTFRAME=1 NUMFRAMES=14   RATE=8 GROUP=Select
#exec mesh SEQUENCE MESH=DoubleGunsL SEQ=Shoot       STARTFRAME=14 NUMFRAMES=7   RATE=24
#exec mesh SEQUENCE MESH=DoubleGunsL SEQ=Shoot2      STARTFRAME=20 NUMFRAMES=8   RATE=24
#exec mesh SEQUENCE MESH=DoubleGunsL SEQ=AltShoot    STARTFRAME=27 NUMFRAMES=5   RATE=18
#exec mesh SEQUENCE MESH=DoubleGunsL SEQ=Down        STARTFRAME=31 NUMFRAMES=6   RATE=24
#exec mesh SEQUENCE MESH=DoubleGunsL SEQ=Reload      STARTFRAME=37 NUMFRAMES=42  RATE=8
#exec mesh SEQUENCE MESH=DoubleGunsL SEQ=Idle1       STARTFRAME=78 NUMFRAMES=10  RATE=4
#exec mesh SEQUENCE MESH=DoubleGunsL SEQ=Idle2       STARTFRAME=87 NUMFRAMES=10  RATE=4
#exec mesh SEQUENCE MESH=DoubleGunsL SEQ=Idle3       STARTFRAME=96 NUMFRAMES=10  RATE=4

#exec texture IMPORT NAME=DoubleGuns1 FILE=Textures\DoubleGunsTex1.PCX GROUP=Skins
#exec texture IMPORT NAME=DoubleGuns2 FILE=Textures\DoubleGunsTex2.PCX GROUP=Skins
#exec texture IMPORT NAME=DoubleGuns3 FILE=Textures\DoubleGunsTex3.PCX GROUP=Skins
#exec texture IMPORT NAME=Hands FILE=Textures\WeaponHandsTex.pcx GROUP=Skins
#exec texture IMPORT NAME=DGunsClip1 FILE=Textures\DgunsClipTex1.PCX GROUP=Skins

#exec MESHMAP new   MESHMAP=DoubleGunsL MESH=DoubleGunsL
#exec MESHMAP scale MESHMAP=DoubleGunsL X=0.00390625 Y=0.00390625 Z=0.00390625


#exec MESHMAP SETTEXTURE MESHMAP=DoubleGunsL NUM=1 TEXTURE=DoubleGuns1
#exec MESHMAP SETTEXTURE MESHMAP=DoubleGunsL NUM=2 TEXTURE=DoubleGuns2
#exec MESHMAP SETTEXTURE MESHMAP=DoubleGunsL NUM=3 TEXTURE=DGunsClip1
#exec MESHMAP SETTEXTURE MESHMAP=DoubleGunsL NUM=4 TEXTURE=DoubleGuns3
#exec MESHMAP SETTEXTURE MESHMAP=DoubleGunsL NUM=5 TEXTURE=BlackMaskTex
#exec MESHMAP SETTEXTURE MESHMAP=DoubleGunsL NUM=6 TEXTURE=Hands
#exec MESHMAP SETTEXTURE MESHMAP=DoubleGunsL NUM=7 TEXTURE=BlackMaskTex


#exec mesh NOTIFY MESH=DoubleGunsL SEQ=Shoot	TIME=0.03	FUNCTION=SwapMuzzleFlashTexture
#exec mesh NOTIFY MESH=DoubleGunsL SEQ=Shoot2	TIME=0.03	FUNCTION=SwapMuzzleFlashTexture
#exec mesh NOTIFY MESH=DoubleGunsL SEQ=AltShoot	TIME=0.03	FUNCTION=SwapMuzzleFlashTextureboth

//
// Pickup Version
//
#exec mesh IMPORT MESH=DoubleGunsPickup ANIVFILE=MODELS\DoubleGunsPickup_a.3d DATAFILE=MODELS\DoubleGunsPickup_d.3d X=0 Y=0 Z=0
#exec mesh ORIGIN MESH=DoubleGunsPickup X=0 Y=0 Z=1000

#exec mesh SEQUENCE MESH=DoubleGunsPickup SEQ=All             STARTFRAME=0 NUMFRAMES=1
#exec mesh SEQUENCE MESH=DoubleGunsPickup SEQ=Still           STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP new   MESHMAP=DoubleGunsPickup MESH=DoubleGunsPickup
#exec MESHMAP scale MESHMAP=DoubleGunsPickup X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=DoubleGunsPickup NUM=1 TEXTURE=DoubleGuns1
#exec MESHMAP SETTEXTURE MESHMAP=DoubleGunsPickup NUM=2 TEXTURE=DoubleGuns2


//
// 3rd Person Version
//
#exec mesh IMPORT MESH=DoubleGuns3rd ANIVFILE=MODELS\DoubleGuns3rd_a.3d DATAFILE=MODELS\DoubleGuns3rd_d.3d X=0 Y=0 Z=0
#exec mesh ORIGIN MESH=DoubleGuns3rd X=300 Y=0 Z=0 YAW=64 ROLL=21 PITCH=-4 //Z=23000 X=1500

#exec mesh SEQUENCE MESH=DoubleGuns3rd SEQ=All          STARTFRAME=0 NUMFRAMES=1
#exec mesh SEQUENCE MESH=DoubleGuns3rd SEQ=Still        STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP new   MESHMAP=DoubleGuns3rd MESH=DoubleGuns3rd
#exec MESHMAP scale MESHMAP=DoubleGuns3rd X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=DoubleGuns3rd NUM=1 TEXTURE=DoubleGuns1
#exec MESHMAP SETTEXTURE MESHMAP=DoubleGuns3rd NUM=2 TEXTURE=DoubleGuns2

defaultproperties
{
     firemodemessage="Changed fire mode for %s to %s"
     firemodeAltFireText="Alternating Fire"
     firemodeDoubleFireText="Double Fire"
     belttextAltFire="ALT FIRE"
     belttextDoubleFire="DOUBLE FIRE"
     busefiremode=True
     firemode="Alternating Fire"
     belttext="ALT FIRE"
     firesilencedsound=Sound'TNMItems.Weapons.AkimboFiresilenced'
     altfiresilencedsound=Sound'TNMItems.Weapons.AkimboAltFiresilenced'
     AltFireSoundReal=Sound'TNMItems.Weapons.AkimboAltFire'
     LowAmmoWaterMark=6
     GoverningSkill=Class'DeusEx.SkillWeaponPistol'
     NoiseLevel=0.050000
     EnemyEffective=ENMEFF_Organic
     EnviroEffective=ENVEFF_Air
     Concealability=CONC_Visual
     ShotTime=0.450000
     reloadTime=2.500000
     HitDamage=15
     maxRange=4000
     AccurateRange=2600
     BaseAccuracy=0.600000
     ScopeFOV=25
     bCanHaveLaser=False
     recoilStrength=0.600000
     mpReloadTime=3.000000
     mpHitDamage=24
     mpBaseAccuracy=0.200000
     mpAccurateRange=1200
     mpMaxRange=1200
     mpReloadCount=20
     bCanHaveModBaseAccuracy=True
     bCanHaveModReloadCount=True
     bCanHaveModAccurateRange=True
     bCanHaveModReloadTime=False
     bCanHaveModRecoilStrength=True
     AmmoName=Class'TNMItems.Ammo45'
     ReloadCount=20
     PickupAmmoCount=20
     bInstantHit=True
     FireOffset=(X=64.000000,Y=-10.000000,Z=0.000000)
     shakemag=20.000000
     FireSound=Sound'TNMItems.Weapons.AkimboFire'
     CockingSound=Sound'TNMItems.Weapons.AkimboReload'
     SelectSound=Sound'TNMItems.Weapons.AkimboSelect'
     InventoryGroup=29
     PickupMessage="You have"
     ItemName="Trestkon's Pistols"
     ItemArticle="picked up"
     PlayerViewOffset=(X=28.000000,Y=-10.000000,Z=-18.500000)
     PlayerViewMesh=LodMesh'TNMItems.DoubleGunsL'
     PlayerViewScale=0.900000
     PickupViewMesh=LodMesh'TNMItems.DoubleGunsPickup'
     PickupViewScale=0.800000
     ThirdPersonMesh=LodMesh'TNMItems.DoubleGuns3rd'
     ThirdPersonScale=0.600000
     Icon=Texture'TNMItems.Skins.BeltIconDGuns'
     largeIcon=Texture'TNMItems.Skins.LargeIconDGuns'
     largeIconWidth=101
     largeIconHeight=43
     invSlotsX=2
     Description="UNIQUE WEAPON:|nWhat is there to say? They're pistols, and there are two of them. Phasmatis gave these to you, and they're without a doubt the coolest (if not best) weapons in existence. They also carry quite a bit of sentimental value to you because of all the missions you successfully carried out for PDXCIS with these guns at your side. Aside from the powerful recoil of the .45 rounds, their only drawback is that the custom design makes them incompatible with standard silencer weapon mods."
     beltDescription="PISTOLS"
     Mesh=LodMesh'TNMItems.DoubleGunsPickup'
     MultiSkins(1)=Texture'TNMItems.Skins.DoubleGuns1'
     MultiSkins(2)=Texture'TNMItems.Skins.DoubleGuns2'
     MultiSkins(3)=Texture'DeusExItems.Skins.PinkMaskTex'
     MultiSkins(4)=Texture'TNMItems.Skins.DoubleGuns3'
     MultiSkins(5)=Texture'DeusExItems.Skins.BlackMaskTex'
     MultiSkins(6)=Texture'TNMItems.Skins.Hands'
     MultiSkins(7)=Texture'DeusExItems.Skins.BlackMaskTex'
     CollisionRadius=9.000000
     CollisionHeight=7.000000
     bReloadAnimHack=True
}
