//=============================================================================
// WeaponTNMRifle.
//=============================================================================
class WeaponFatRifle extends TNMWeapon;

var bool bRiceFire; //For use in the muzzle flash functions

var texture ScopeOverlayTexture1;
var texture ScopeOverlayTexture2;
var texture ScopeOverlayTexture3;
var texture ScopeOverlayTexture4;

//Reload Function
state Reload
{
ignores Fire, AltFire;

	function float GetReloadTimeMult()
	{		
		if (ScriptedPawn(Owner) != None)
		{
			return ScriptedPawn(Owner).BaseAccuracy*2+1;
		}
		else if (DeusExPlayer(Owner) != None)
		{
			// check for skill use if we are the player
			return 1 + GetWeaponSkill();
		}
	}

	function float GetReloadTime()
	{
		return ReloadTime * GetReloadTimeMult();
	}

	function NotifyOwner(bool bStart)
	{
		local DeusExPlayer player;
		local ScriptedPawn pawn;

		player = DeusExPlayer(Owner);
		pawn   = ScriptedPawn(Owner);

		if (player != None)
		{
			if (bStart)
				player.Reloading(self, GetReloadTime());
			else
			{
				player.DoneReloading(self);
			}
		}
		else if (pawn != None)
		{
			if (bStart)
				pawn.Reloading(self, GetReloadTime());
			else
				pawn.DoneReloading(self);
		}
	}

Begin:
	FinishAnim();

	// only reload if we have ammo left
	if (AmmoType.AmmoAmount > 0)
	{
		bWasZoomed = bZoomed;
		if (bWasZoomed)
			ScopeOff();

		NotifyOwner(True);

		if (AmmoRicebag(AmmoType) != None )  //Checks to see if the ricebags are being loaded.
		{
			Owner.PlaySound(CockingSound, SLOT_None,,, 1024);
			bRiceFire = true;   //Sets this to true for the muzzle flash functions
			PlayAnim('Riceload', 1 / GetReloadTime() );
		}
		else
		{
			Owner.PlaySound(CockingSound, SLOT_None,,, 1024);
			bRiceFire = false;
			PlayAnim('Reload', 1 / GetReloadTime() );
		}
		FinishAnim();

		NotifyOwner(False);
		if (bWasZoomed)
			ScopeOn();
		ClipCount = 0;
	}
	GotoState('Idle');
}


function name WeaponDamageType()
{
	return ('fat');
}

// Muzzle Flash Stuff
// called from the MESH NOTIFY Copied from DeusexWeapons.uc and modified...
simulated function SwapMuzzleFlashTexture()
{
     if (!bHasMuzzleFlash)
     return;

     if (bRiceFire)
     return;

     if (FRand() < 0.5)
         MultiSkins[7] = Texture'DeusExItems.Skins.FlatFXTex33';
     else
         MultiSkins[7] = Texture'DeusExItems.Skins.FlatFXTex31';

     MuzzleFlashLight();
     SetTimer(0.1, False);
}

simulated function EraseMuzzleFlashTexture()
{
     MultiSkins[7] = None;
}

simulated function Timer()
{
     EraseMuzzleFlashTexture();
}

simulated function MuzzleFlashLight()
{
     local Vector offset, X, Y, Z;
     local Effects flash;

      if (!bHasMuzzleFlash)
          return;

      if (bRiceFire)
      return;

     if ((flash != None) && !flash.bDeleteMe)
          flash.LifeSpan = flash.Default.LifeSpan;
     else
     {
          GetAxes(Pawn(Owner).ViewRotation,X,Y,Z);
          offset = Owner.Location;
          offset += X * Owner.CollisionRadius * 2;
          flash = spawn(class'Muzzleflash',,, offset);
          if (flash != None)
               flash.SetBase(Owner);
     }
}



#exec texture IMPORT NAME=BeltIconFatRifle FILE="Textures\BeltIconFatRifle.pcx" MIPS=off
#exec TEXTURE IMPORT NAME=LargeIconFatRifle FILE="Textures\LargeIconFatRifle.pcx" MIPS=off

#exec mesh IMPORT MESH=FatRifle ANIVFILE=MODELS\Fatrifle_a.3d DATAFILE=MODELS\Fatrifle_d.3d X=0 Y=0 Z=0
#exec mesh ORIGIN MESH=FatRifle X=0 Y=10000 Z=4000 YAW=64

#exec mesh SEQUENCE MESH=FatRifle SEQ=All		STARTFRAME=0	NUMFRAMES=64
#exec mesh SEQUENCE MESH=FatRifle SEQ=Still		STARTFRAME=0	NUMFRAMES=1
#exec mesh SEQUENCE MESH=FatRifle SEQ=Select	  	STARTFRAME=1	NUMFRAMES=9	RATE=8	GROUP=Select
#exec mesh SEQUENCE MESH=FatRifle SEQ=Shoot		STARTFRAME=9	NUMFRAMES=5	RATE=18
#exec mesh SEQUENCE MESH=FatRifle SEQ=Reload		STARTFRAME=13	NUMFRAMES=18	RATE=8
#exec mesh SEQUENCE MESH=FatRifle SEQ=Down		STARTFRAME=30	NUMFRAMES=5	RATE=8
#exec mesh SEQUENCE MESH=FatRifle SEQ=Idle1		STARTFRAME=35	NUMFRAMES=8	RATE=2
#exec mesh SEQUENCE MESH=FatRifle SEQ=Idle2		STARTFRAME=42	NUMFRAMES=8	RATE=2
#exec mesh SEQUENCE MESH=FatRifle SEQ=Idle3		STARTFRAME=49	NUMFRAMES=8     RATE=2
#exec mesh SEQUENCE MESH=FatRifle SEQ=RiceLoad	  	STARTFRAME=56	NUMFRAMES=8     RATE=12

#exec mesh NOTIFY MESH=FatRifle SEQ=Shoot	TIME=0.01	FUNCTION=SwapMuzzleFlashTexture

#exec texture IMPORT NAME=JFatRifle1   FILE=Textures\FRifleTex1.pcx GROUP=Skins
#exec texture IMPORT NAME=JFatRifle2   FILE=Textures\FRifleTex2.pcx GROUP=Skins
#exec texture IMPORT NAME=JFatRifle3   FILE=Textures\FRifleTex3.pcx GROUP=Skins
#exec texture IMPORT NAME=JFatRifle5   FILE=Textures\FRifleTex5.pcx GROUP=Skins
#exec texture IMPORT NAME=Hands        FILE=Textures\WeaponhandsTex.PCX GROUP=Skins
#exec texture IMPORT NAME=AmmoCan      FILE=Textures\NapalmAmmoTex2.pcx

#exec MESHMAP new   MESHMAP=FatRifle MESH=FatRifle
#exec MESHMAP SCALE MESHMAP=FatRifle X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=FatRifle NUM=1 TEXTURE=JFatRifle1
#exec MESHMAP SETTEXTURE MESHMAP=FatRifle NUM=2 TEXTURE=JFatRifle2
#exec MESHMAP SETTEXTURE MESHMAP=FatRifle NUM=3 TEXTURE=JFatRifle3
#exec MESHMAP SETTEXTURE MESHMAP=FatRifle NUM=4 TEXTURE=Effects.electricity.Nano_SFX_A
#exec MESHMAP SETTEXTURE MESHMAP=FatRifle NUM=5 TEXTURE=JFatRifle5
#exec MESHMAP SETTEXTURE MESHMAP=FatRifle NUM=6 TEXTURE=Hands
#exec MESHMAP SETTEXTURE MESHMAP=FatRifle NUM=7 TEXTURE=BlackMaskTex
#exec MESHMAP SETTEXTURE MESHMAP=FatRifle NUM=8 TEXTURE=AmmoCan

//
// 3rd Person View
//
#exec mesh IMPORT MESH=FatRifle3rd ANIVFILE=MODELS\FatRifle3rd_a.3d DATAFILE=MODELS\FatRifle3rd_d.3d X=0 Y=0 Z=0 UNMIRROR=1
#exec mesh ORIGIN MESH=FatRifle3rd X=0 Y=300 Z=-500 YAW=-54 ROLL=-24

#exec MESH SEQUENCE MESH=FatRifle3rd SEQ=All      STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=FatRifle3rd SEQ=Rifle3rd STARTFRAME=0 NUMFRAMES=1

#exec TEXTURE IMPORT NAME=JFatRifle3rd FILE=Textures\FatRifleTex.PCX GROUP=Skins // Material #0

#exec MESHMAP NEW   MESHMAP=FatRifle3rd MESH=FatRifle3rd
#exec MESHMAP SCALE MESHMAP=FatRifle3rd X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=FatRifle3rd NUM=1 TEXTURE=JFatRifle1
#exec MESHMAP SETTEXTURE MESHMAP=FatRifle3rd NUM=2 TEXTURE=JFatRifle2
#exec MESHMAP SETTEXTURE MESHMAP=FatRifle3rd NUM=3 TEXTURE=JFatRifle3
#exec MESHMAP SETTEXTURE MESHMAP=FatRifle3rd NUM=4 TEXTURE=Effects.electricity.Nano_SFX_A
#exec MESHMAP SETTEXTURE MESHMAP=FatRifle3rd NUM=5 TEXTURE=JFatRifle5
#exec MESHMAP SETTEXTURE MESHMAP=FatRifle3rd NUM=6 TEXTURE=BlackMaskTex

//
// Pickup View
//
#exec mesh IMPORT MESH=FatRiflePick ANIVFILE=MODELS\FatRiflePick_a.3d DATAFILE=MODELS\FatRiflePick_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=FatRiflePick X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=FatRiflePick SEQ=All      STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=FatRiflePick SEQ=Rifle3rd STARTFRAME=0 NUMFRAMES=1

#exec TEXTURE IMPORT NAME=JFatRiflePick FILE=Textures\FatRifleTex.PCX GROUP=Skins // Material #0

#exec MESHMAP new   MESHMAP=FatRiflePick MESH=FatRiflePick
#exec MESHMAP SCALE MESHMAP=FatRiflePick X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=FatRiflePick NUM=1 TEXTURE=JFatRifle1
#exec MESHMAP SETTEXTURE MESHMAP=FatRiflePick NUM=2 TEXTURE=JFatRifle2
#exec MESHMAP SETTEXTURE MESHMAP=FatRiflePick NUM=3 TEXTURE=JFatRifle3
#exec MESHMAP SETTEXTURE MESHMAP=FatRiflePick NUM=4 TEXTURE=Effects.electricity.Nano_SFX_A
#exec MESHMAP SETTEXTURE MESHMAP=FatRiflePick NUM=5 TEXTURE=JFatRifle5
#exec MESHMAP SETTEXTURE MESHMAP=FatRiflePick NUM=6 TEXTURE=BlackMaskTex

defaultproperties
{
     ScopeType=EScopeType_HighTech
     LowAmmoWaterMark=30
     GoverningSkill=Class'DeusEx.SkillWeaponRifle'
     EnviroEffective=ENVEFF_All
     Concealability=CONC_Visual
     bAutomatic=true
     ShotTime=0.500000
     reloadTime=1.250000
     HitDamage=8
     BaseAccuracy=0.800000
     bCanHaveScope=True
     bCanHaveLaser=True
     bPenetrating=False
     AmmoNames(0)=Class'tnmitems.AmmoFatRifle'
     AmmoNames(1)=Class'tnmitems.AmmoRicebag'
     ProjectileNames(1)=Class'tnmitems.RicebagProj'
     recoilStrength=0.200000
     MinWeaponAcc=0.200000
     mpReloadTime=0.500000
     mpHitDamage=9
     mpBaseAccuracy=1.000000
     mpAccurateRange=2400
     mpMaxRange=2400
     mpReloadCount=30
     bCanHaveModBaseAccuracy=True
     bCanHaveModReloadCount=True
     bCanHaveModAccurateRange=True
     bCanHaveModReloadTime=False
     bCanHaveModRecoilStrength=True
     AmmoName=Class'tnmitems.AmmoFatRifle'
     ReloadCount=60
     PickupAmmoCount=60
     bInstantHit=True
     FireOffset=(X=-16.000000,Y=5.000000,Z=11.500000)
     ProjectileClass=Class'tnmitems.RicebagProj'
     shakemag=200.000000
     FireSound=Sound'tnmitems.Weapons.PhatRifleFire'
     CockingSound=Sound'tnmitems.Weapons.PhatRifleReload'
     SelectSound=Sound'tnmitems.Weapons.PhatRifleSelect'
     InventoryGroup=30
     ItemName="PHAT-Rifle"
     PlayerViewOffset=(X=16.000000,Y=-5.000000,Z=-11.500000)
     PlayerViewMesh=LodMesh'tnmitems.FatRifle'
     PlayerViewScale=0.700000
     PickupViewMesh=LodMesh'tnmitems.FatRiflePick'
     ThirdPersonMesh=LodMesh'tnmitems.FatRifle3rd'
     LandSound=Sound'DeusExSounds.Generic.DropMediumWeapon'
     Icon=Texture'tnmitems.BeltIconFatRifle'
     largeIcon=Texture'tnmitems.LargeIconFatRifle'
     largeIconWidth=159
     largeIconHeight=47
     invSlotsX=4
     invSlotsY=1
     Description="UNIQUE WEAPON:|nThe amazing PHAT-Rifle was originally invented as a sort of gimmick for parties. However, as soon as the patent was sold to WorldCorp Inc., it was naturally redesigned to be used as a weapon. It exposes the target to the experimental PHAT-rays (PHysically Anamorphic Transmogryphing rays), which causes the body of the target to swell to an unnatural size until his tissue gives in to the strain and he explodes. If the PHAT-ray exposure stops before this happens, however, his body will slowly return to its natural state."
     beltDescription="PHATRIFLE"
     Mesh=LodMesh'tnmitems.FatRiflePick'
     ScaleGlow=100.000000
     CollisionRadius=15.000000
     CollisionHeight=2.800000
}
