//=============================================================================
// WeaponFireBlade.
//=============================================================================
class WeaponFireBlade extends TNMWeapon;

#exec OBJ LOAD FILE=TNM_Core_Tex

//shouldn't be necessary
/*function PickupFunction(Pawn Other)
{
	trestkon(getplayerpawn()).bunlockedSword = true;
}*/

function name WeaponDamageType()
{
	return ('Flamed');
}

auto state Pickup
{
     function EndState()
     {
          Super.EndState();
          LightType = LT_None;
     }
}

state DownWeapon
{
     function BeginState()
     {
          Super.BeginState();
          LightType = LT_None;
     }
}

state Idle
{
     function BeginState()
     {
          Super.BeginState();
          LightType = LT_Steady;
     }
}

simulated function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	local float        mult;
	local name         damageType;
	local DeusExPlayer dxPlayer;

	if (Other != None)
	{
		// tnmpcaugcombat increases our damage if hand to hand
		mult = 1.0;
		if (bHandToHand)
		{
			if (DeusExPlayer(Owner) != None)
				mult = DeusExPlayer(Owner).AugmentationSystem.GetAugLevelValue(class'tnmpcaugcombat');
			else if (tnmpawn(Owner) != None)
				if (tnmpawn(owner).TNMPAM != none)
					mult = (tnmpawn(Owner).tnmpam.getcombatvalue());
			if (mult == -1.0)
				mult = 1.0;
		}

		// skill also affects our damage
		// GetWeaponSkill returns 0.0 to -0.7 (max skill/aug)
		mult += -2.0 * GetWeaponSkill();

		// Determine damage type
		damageType = WeaponDamageType();

		if (Other != None)
		{
			if (Other.bOwned)
			{
				dxPlayer = DeusExPlayer(Owner);
				if (dxPlayer != None)
					dxPlayer.AISendEvent('Futz', EAITYPE_Visual);
			}
		}

		if ((Other == Level) || (Other.IsA('Mover')))
		{
			if ( Role == ROLE_Authority )
			{
				Other.TakeDamage(1 * mult, Pawn(Owner), HitLocation, 1000.0*X, damageType);
				Other.TakeDamage(HitDamage * mult, Pawn(Owner), HitLocation, 1000.0*X, 'shot');
			}

			SelectiveSpawnEffects( HitLocation, HitNormal, Other, HitDamage * mult);
		}
		else if ((Other != self) && (Other != Owner))
		{
			if ( Role == ROLE_Authority )
			{
				Other.TakeDamage(1 * mult, Pawn(Owner), HitLocation, 1000.0*X, damageType);
				Other.TakeDamage(HitDamage * mult, Pawn(Owner), HitLocation, 1000.0*X, 'shot');
			}

			if (bHandToHand)
				SelectiveSpawnEffects( HitLocation, HitNormal, Other, HitDamage * mult);

			// Smoke39 - become bloody if appropriate
			if ( Other.IsA('scriptedPawn') && !Other.IsA('Robot') && scriptedpawn(other).bCanBleed)
			{
				if ( bPenetrating )
				{
					SpawnBlood(HitLocation, HitNormal);
					if ( bGetsBloody )
						Bloodiness = FMin( Bloodiness + 1, 8 );
				}
				else if ( bGetsBloody )
					Bloodiness = FMin( Bloodiness + 0.5, 8 );
			}
			else if ( Other.IsA('Carcass') && bGetsBloody )
			{
				if ( bPenetrating )
					Bloodiness = FMin( Bloodiness + 1, 8 );
				else
					Bloodiness = FMin( Bloodiness + 0.5, 8 );
			}
		}
	}

	if (DeusExMPGame(Level.Game) != None)
	{
		if (DeusExPlayer(Other) != None)
			DeusExMPGame(Level.Game).TrackWeapon(self,HitDamage * mult);
		else
			DeusExMPGame(Level.Game).TrackWeapon(self,0);
	}
}


//Belt and Inventory icons
#exec texture IMPORT NAME=BeltIconFireBlade FILE="Textures\BeltIconFireBlade.pcx" MIPS=off
#exec texture IMPORT NAME=LargeIconFireBlade FILE="Textures\LargeIconFireBlade.pcx" MIPS=off

//
//First Person View
//
#exec mesh IMPORT MESH=FireBlade ANIVFILE=MODELS\FireBlade_a.3d DATAFILE=MODELS\FireBlade_d.3d X=0 Y=0 Z=0 UNMIRROR=1
#exec mesh ORIGIN MESH=FireBlade X=2000 Y=0 Z=0 //(Z=Up/down X=Side)

#exec mesh SEQUENCE MESH=FireBlade SEQ=All          STARTFRAME=0 NUMFRAMES=71
#exec mesh SEQUENCE MESH=FireBlade SEQ=Select	    STARTFRAME=1	NUMFRAMES=8	    RATE=8	GROUP=Select
#exec mesh SEQUENCE MESH=FireBlade SEQ=Attack	    STARTFRAME=8	NUMFRAMES=10	RATE=16
#exec mesh SEQUENCE MESH=FireBlade SEQ=Attack2	    STARTFRAME=17	NUMFRAMES=10	RATE=16
#exec mesh SEQUENCE MESH=FireBlade SEQ=Attack3	    STARTFRAME=26	NUMFRAMES=10	RATE=16
#exec mesh SEQUENCE MESH=FireBlade SEQ=Down		    STARTFRAME=35	NUMFRAMES=8	    RATE=8
#exec mesh SEQUENCE MESH=FireBlade SEQ=Idle1		STARTFRAME=43	NUMFRAMES=10	RATE=2
#exec mesh SEQUENCE MESH=FireBlade SEQ=Idle2		STARTFRAME=52	NUMFRAMES=10	RATE=2
#exec mesh SEQUENCE MESH=FireBlade SEQ=Idle3		STARTFRAME=61	NUMFRAMES=10  	RATE=2

#exec texture IMPORT NAME=JFireBlade1 FILE=Textures\FBhandle.PCX GROUP=Skins // MATERIAL #25
#exec texture IMPORT NAME=JFireBlade2 FILE=Textures\FBBlade.PCX GROUP=Skins // MATERIAL #26
//#exec texture IMPORT NAME=JFireBlade3 FILE=Textures\FBEffect.PCX GROUP=Skins // MATERIAL #27
#exec texture IMPORT NAME=JFireBlade4 FILE=Textures\WeaponHandsTex.PCX GROUP=Skins // MATERIAL #28

//
// Attack Information
//
#exec mesh NOTIFY MESH=FireBlade SEQ=Attack           TIME=0.1     FUNCTION=HandToHandAttack
#exec mesh NOTIFY MESH=FireBlade SEQ=Attack2          TIME=0.2     FUNCTION=HandToHandAttack
#exec mesh NOTIFY MESH=FireBlade SEQ=Attack3          TIME=0.2    FUNCTION=HandToHandAttack

#exec MESHMAP NEW   MESHMAP=FireBlade MESH=FireBlade
#exec MESHMAP SCALE MESHMAP=FireBlade X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=FireBlade NUM=1 TEXTURE=JFireBlade1
#exec MESHMAP SETTEXTURE MESHMAP=FireBlade NUM=2 TEXTURE=JFireBlade2
#exec MESHMAP SETTEXTURE MESHMAP=FireBlade NUM=3 TEXTURE=TNM_Core_Tex.Effects.FireBladeEffect
#exec MESHMAP SETTEXTURE MESHMAP=FireBlade NUM=4 TEXTURE=JFireBlade4

//
//Pickup Version
//
#exec MESH IMPORT MESH=FireBladePickup ANIVFILE=MODELS\FireBladePickup_a.3d DATAFILE=MODELS\FireBladePickup_d.3d X=0 Y=0 Z=0
#exec mesh ORIGIN MESH=FireBladePickup X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=FireBladePickup SEQ=All             STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=FireBladePickup SEQ=FireBladePickup STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW   MESHMAP=FireBladePickup MESH=FireBladePickup
#exec MESHMAP scale MESHMAP=FireBladePickup X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=FireBladePickup NUM=1 TEXTURE=JFireBlade1
#exec MESHMAP SETTEXTURE MESHMAP=FireBladePickup NUM=2 TEXTURE=JFireBlade2
#exec MESHMAP SETTEXTURE MESHMAP=FireBladePickup NUM=3 TEXTURE=TNM_Core_Tex.Effects.FireBladeEffect

//
//3rd Person View
//
#exec MESH IMPORT MESH=FireBlade3rd ANIVFILE=MODELS\FireBlade3rd_a.3d DATAFILE=MODELS\FireBlade3rd_d.3d X=0 Y=0 Z=0
#exec mesh ORIGIN MESH=FireBlade3rd X=0 Y=500 Z=500 YAW=-64

#exec MESH SEQUENCE MESH=FireBlade3rd SEQ=All          STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=FireBlade3rd SEQ=FireBlade3rd STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW   MESHMAP=FireBlade3rd MESH=FireBlade3rd
#exec MESHMAP scale MESHMAP=FireBlade3rd X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=FireBlade3rd NUM=1 TEXTURE=JFireBlade1
#exec MESHMAP SETTEXTURE MESHMAP=FireBlade3rd NUM=2 TEXTURE=JFireBlade2
#exec MESHMAP SETTEXTURE MESHMAP=FireBlade3rd NUM=3 TEXTURE=TNM_Core_Tex.Effects.FireBladeEffect

defaultproperties
{
     hitfleshsound=Sound'TNMItems.Weapons.katanaHitFlesh'
     hitwoodsound=Sound'TNMItems.Weapons.katanaHitwood'
     hitmetalsound=Sound'TNMItems.Weapons.katanaHitmetal'
     hitothersound=Sound'TNMItems.Weapons.katanaHitother'
     deselectsound=Sound'TNMItems.Weapons.katanaDeSelect'
     LowAmmoWaterMark=0
     GoverningSkill=Class'DeusEx.SkillWeaponLowTech'
     NoiseLevel=0.050000
     EnemyEffective=ENMEFF_Organic
     EnviroEffective=ENVEFF_Air
     Concealability=CONC_Visual
     ShotTime=0.400000
     reloadTime=0.000000
     HitDamage=20
     maxRange=112
     AccurateRange=90
     BaseAccuracy=1.000000
     AreaOfEffect=AOE_Cone
     bHandToHand=True
     mpHitDamage=20
     mpBaseAccuracy=0.700000
     mpAccurateRange=70
     mpMaxRange=80
     AmmoName=Class'DeusEx.AmmoNone'
     ReloadCount=0
     bInstantHit=True
     FireOffset=(X=22.000000,Y=-10.000000,Z=14.000000)
     shakemag=20.000000
     FireSound=Sound'TNMItems.Weapons.katanaFire'
     SelectSound=Sound'TNMItems.Weapons.katanaSelect'
     InventoryGroup=47
     ItemArticle="Deus Diablo's"
     ItemName="Fireblade"
     PlayerViewOffset=(X=28.000000,Y=-10.000000,Z=-11.500000)
     PlayerViewMesh=LodMesh'TNMItems.FireBlade'
     PlayerViewScale=1.200000
     PickupViewMesh=LodMesh'TNMItems.FireBladePickup'
     PickupViewScale=1.500000
     ThirdPersonMesh=LodMesh'TNMItems.FireBlade3rd'
     Icon=Texture'TNMItems.BeltIconFireBlade'
     largeIcon=Texture'TNMItems.LargeIconFireBlade'
     largeIconWidth=208
     largeIconHeight=46
     invSlotsX=5
     Description="UNIQUE WEAPON:|nThe firey blade is the trademark of Deus Diablo, the third moderator of PDX Forum City. It's a very versatile blade, good for several different purposes: Smiting trolls and spammers, commanding fear and respect from the general population, and lighting the grill for a barbeque. It also does a great job being a torch if you run out of energy for your light aug."
     beltDescription="FIREBLADE"
     Mesh=LodMesh'TNMItems.FireBladePickup'
     DrawScale=1.500000
     CollisionRadius=23.000000
     CollisionHeight=2.000000
     LightType=LT_Steady
     LightEffect=LE_WateryShimmer
     LightBrightness=255
     LightSaturation=30
     LightRadius=4
     Mass=30.000000
}
