//=============================================================================
// WeaponFireExting.
//=============================================================================
class WeaponFireExting extends TNMWeapon;

function ReloadAmmo()
{
	Pawn(Owner).ClientMessage(msgCannotBeReloaded);
	return;
}

function bool HandlePickupQuery(Inventory Item)
{
	local bool bResult;

	bResult = super.HandlePickupQuery(Item);

	if(Item.Class==Class)
	{
		ReloadCount = Max(WeaponFireExting(Item).ReloadCount+ReloadCount,100);
		ClipCount = 0;
	}

	return bResult;
}

simulated function Tick(float deltaTime)
{
	//do nothing
}

#exec texture IMPORT NAME=LargeIconTNMFireExtinguisher FILE=Textures\LargeIconTNMFireExtinguisher.pcx GROUP=Skins MIPS=off
#exec texture IMPORT NAME=BeltIconTNMFireExtinguisher FILE=Textures\BeltIconTNMFireExtinguisher.pcx GROUP=Skins MIPS=off

//First Person mesh
#exec mesh IMPORT MESH=WeaponFireExting ANIVFILE=MODELS\WeaponFireExting_a.3d DATAFILE=MODELS\WeaponFireExting_d.3d X=0 Y=0 Z=0
#exec mesh ORIGIN MESH=WeaponFireExting X=-4000 Y=6000 Z=2000  //X + Towards Cam - Away Cam | Y - Right + Left | Z - Up  + Down

#exec mesh SEQUENCE MESH=WeaponFireExting SEQ=All       STARTFRAME=0    NUMFRAMES=50
#exec mesh SEQUENCE MESH=WeaponFireExting SEQ=All	STARTFRAME=0	NUMFRAMES=50
#exec mesh SEQUENCE MESH=WeaponFireExting SEQ=Still	STARTFRAME=0	NUMFRAMES=1
#exec mesh SEQUENCE MESH=WeaponFireExting SEQ=Select	STARTFRAME=1	NUMFRAMES=6	RATE=10	GROUP=Select
#exec mesh SEQUENCE MESH=WeaponFireExting SEQ=Shoot	STARTFRAME=6	NUMFRAMES=10	RATE=8
#exec mesh SEQUENCE MESH=WeaponFireExting SEQ=Throw 	STARTFRAME=16	NUMFRAMES=12	RATE=14  //Throw Sequence
#exec mesh SEQUENCE MESH=WeaponFireExting SEQ=Down	STARTFRAME=29	NUMFRAMES=5	RATE=20
#exec mesh SEQUENCE MESH=WeaponFireExting SEQ=Idle1	STARTFRAME=34	NUMFRAMES=6	RATE=2
#exec mesh SEQUENCE MESH=WeaponFireExting SEQ=Idle2	STARTFRAME=39	NUMFRAMES=6	RATE=2
#exec mesh SEQUENCE MESH=WeaponFireExting SEQ=Idle3	STARTFRAME=44	NUMFRAMES=6	RATE=2

#exec texture IMPORT NAME=JWeaponFireExting0 FILE=Textures\WeaponHandsTex.PCX GROUP=Skins // SKIN
#exec texture IMPORT NAME=JWeaponFireExting1 FILE=Textures\FireExtingusherTex1.pcx GROUP=Skins // MAIN
#exec texture IMPORT NAME=JWeaponFireExting2 FILE=Textures\FireExtingusherTex2.pcx GROUP=Skins // FIREE.E

#exec MESHMAP NEW   MESHMAP=WeaponFireExting MESH=WeaponFireExting
#exec MESHMAP scale MESHMAP=WeaponFireExting X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=WeaponFireExting NUM=0 TEXTURE=JWeaponFireExting0
#exec MESHMAP SETTEXTURE MESHMAP=WeaponFireExting NUM=1 TEXTURE=JWeaponFireExting1
#exec MESHMAP SETTEXTURE MESHMAP=WeaponFireExting NUM=2 TEXTURE=JWeaponFireExting2

//PickupView mesh
#exec MESH IMPORT MESH=WeaponFireExtPickup ANIVFILE=MODELS\WeaponFireExtPickup_a.3d DATAFILE=MODELS\WeaponFireExtPickup_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=WeaponFireExtPickup X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=WeaponFireExtPickup STRENGTH=0.25

#exec MESH SEQUENCE MESH=WeaponFireExtPickup SEQ=All          STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=WeaponFireExtPickup SEQ=FireExPickup STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP new   MESHMAP=WeaponFireExtPickup MESH=WeaponFireExtPickup
#exec MESHMAP SCALE MESHMAP=WeaponFireExtPickup X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=WeaponFireExtPickup NUM=0 TEXTURE=JWeaponFireExting1
#exec MESHMAP SETTEXTURE MESHMAP=WeaponFireExtPickup NUM=1 TEXTURE=JWeaponFireExting2

//3rd Person mesh
#exec mesh IMPORT MESH=WeaponFireExt3rd ANIVFILE=MODELS\WeaponFireExtPickup_a.3d DATAFILE=MODELS\WeaponFireExtPickup_d.3d X=0 Y=0 Z=0
#exec mesh ORIGIN MESH=WeaponFireExt3rd X=0 Y=0 Z=6000 PITCH=64

#exec mesh SEQUENCE MESH=WeaponFireExt3rd SEQ=All          STARTFRAME=0 NUMFRAMES=1
#exec mesh SEQUENCE MESH=WeaponFireExt3rd SEQ=FireEx3rd    STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP new   MESHMAP=WeaponFireExt3rd MESH=WeaponFireExt3rd
#exec MESHMAP scale MESHMAP=WeaponFireExt3rd X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=WeaponFireExt3rd NUM=0 TEXTURE=JWeaponFireExting1
#exec MESHMAP SETTEXTURE MESHMAP=WeaponFireExt3rd NUM=1 TEXTURE=JWeaponFireExting2

defaultproperties
{
     EnviroEffective=ENVEFF_AirVacuum
     GoverningSkill=Class'DeusEx.SkillWeaponPistol'
     NoiseLevel=0.010000
     Concealability=CONC_All
     bAutomatic=True
     ShotTime=0.050000
     reloadTime=0.000000
     HitDamage=25
     maxRange=24000
     AccurateRange=14400
     BaseAccuracy=0.000000
     bHasMuzzleFlash=False
     bEmitWeaponDrawn=False
     bUseAsDrawnWeapon=False
     AmmoName=Class'AmmoFireExting'
     ReloadCount=100
     PickupAmmoCount=100
     FireOffset=(X=-20.000000,Y=10.000000,Z=16.000000)
     ProjectileClass=Class'TNM.tnmHalonGas'
     shakemag=50.000000
     FireSound=Sound'DeusExSounds.Weapons.FlamethrowerFire'
     SelectSound=Sound'DeusExSounds.Weapons.HideAGunSelect'
     LandSound=Sound'DeusExSounds.Generic.GlassDrop'
     InventoryGroup=52
     ItemName="Fire Extinguisher"
     PlayerViewOffset=(X=20.000000,Y=-10.000000,Z=-16.000000)
     PlayerViewMesh=LodMesh'tnmitems.WeaponFireExting'
     PlayerViewScale=0.400000
     PickupViewMesh=LodMesh'tnmitems.WeaponFireExtPickup'
     PickupViewScale=0.500000
     ThirdPersonMesh=LodMesh'tnmitems.WeaponFireExt3rd'
     ThirdPersonScale=0.400000
     Icon=Texture'tnmitems.Skins.BeltIconTNMFireExtinguisher'
     largeIcon=Texture'tnmitems.Skins.LargeIconTNMFireExtinguisher'
     largeIconWidth=25
     largeIconHeight=49
     Description="A chemical fire extinguisher."
     beltDescription="FIRE EXT"
     Texture=Texture'tnmitems.Skins.JWeaponFireExting2'
     Mesh=LodMesh'tnmitems.WeaponFireExtPickup'
     DrawScale=0.500000
     CollisionRadius=7.250000
     CollisionHeight=16.250000
     Mass=5.000000
     Buoyancy=2.000000
}
