//=============================================================================
// WeaponGibinator.
//=============================================================================
class WeaponGibinator extends TNMWeapon;


// force Exploding damage
function name WeaponDamageType()
{
     return 'gibbed';
}

// Muzzle Flash Stuff
// called from the MESH NOTIFY Copied from DeusexWeapons.uc and modified...
simulated function SwapMuzzleFlashTexture()
{
     if (!bHasMuzzleFlash)
     return;
     if (FRand() < 0.5)
         MultiSkins[3] = Texture'DeusExItems.Skins.FlatFXTex43';
     else
         MultiSkins[3] = Texture'DeusExItems.Skins.FlatFXTex43';

     MuzzleFlashLight();
     SetTimer(0.2, False);
}

simulated function EraseMuzzleFlashTexture()
{
     MultiSkins[3] = None;
}

simulated function Timer()
{
     EraseMuzzleFlashTexture();
}

simulated function MuzzleFlashLight()
{
     local Vector offset, X, Y, Z;
     local Effects flash;

      if (!bHasMuzzleFlash)
          return;

     if ((flash != None) && !flash.bDeleteMe)
          flash.LifeSpan = flash.Default.LifeSpan;
     else
     {
          GetAxes(Pawn(Owner).ViewRotation,X,Y,Z);
          offset = Owner.Location;
          offset += X * Owner.CollisionRadius * 2;
          flash = spawn(class'Muzzleflash',,, offset);
          if (flash != None)
               flash.SetBase(Owner);
     }
}

//
// First person version
//
#exec MESH IMPORT MESH=Gibinator ANIVFILE=MODELS\Gibinator_a.3d DATAFILE=MODELS\Gibinator_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=Gibinator X=0 Y=-2000 Z=0 YAW=64

#exec MESH SEQUENCE MESH=Gibinator SEQ=All       STARTFRAME=0 NUMFRAMES=62
#exec MESH SEQUENCE MESH=Gibinator SEQ=Still     STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=Gibinator SEQ=Select    STARTFRAME=1 NUMFRAMES=8    RATE=14     GROUP=Select
#exec MESH SEQUENCE MESH=Gibinator SEQ=Reload    STARTFRAME=8 NUMFRAMES=13   RATE=8     //GROUP=Select
#exec mesh SEQUENCE MESH=Gibinator SEQ=Shoot     STARTFRAME=20 NUMFRAMES=8    RATE=14
//#exec MESH SEQUENCE MESH=Gibinator SEQ=Attack2     STARTFRAME=20 NUMFRAMES=7    RATE=9
//#exec MESH SEQUENCE MESH=Gibinator SEQ=Attack3     STARTFRAME=20 NUMFRAMES=7    RATE=9
#exec MESH SEQUENCE MESH=Gibinator SEQ=Down      STARTFRAME=27 NUMFRAMES=6   RATE=5
#exec MESH SEQUENCE MESH=Gibinator SEQ=Idle1     STARTFRAME=34 NUMFRAMES=10  RATE=2
#exec MESH SEQUENCE MESH=Gibinator SEQ=Idle2     STARTFRAME=43 NUMFRAMES=10  RATE=2
#exec MESH SEQUENCE MESH=Gibinator SEQ=Idle3     STARTFRAME=52 NUMFRAMES=10  RATE=2

#exec TEXTURE IMPORT NAME=Gibinator0 FILE=Textures\Gibinator1.PCX GROUP=Skins // SKIN
#exec texture IMPORT NAME=Hands FILE=Textures\WeaponHandsTex.PCX GROUP=Skins // SKIN
#exec texture IMPORT NAME=GibBattery FILE=Textures\GibBattery.pcx GROUP=Skins // SKIN


#exec MESH NOTIFY MESH=Gibinator SEQ=Shoot  TIME=0.04  FUNCTION=SwapMuzzleFlashTexture

#exec MESHMAP NEW   MESHMAP=Gibinator MESH=Gibinator
#exec MESHMAP SCALE MESHMAP=Gibinator X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=Gibinator NUM=1 TEXTURE=Gibinator0
#exec MESHMAP SETTEXTURE MESHMAP=Gibinator NUM=2 TEXTURE=Hands
#exec MESHMAP SETTEXTURE MESHMAP=Gibinator NUM=3 TEXTURE=BlackMaskTex
#exec MESHMAP SETTEXTURE MESHMAP=Gibinator NUM=4 TEXTURE=GibBattery
#exec MESHMAP SETTEXTURE MESHMAP=Gibinator NUM=5 TEXTURE=Effects.electricity.Nano_SFX_A


//
// Pickup person version
//
#exec mesh IMPORT MESH=GibinatorPickup ANIVFILE=MODELS\GibinatorPickup_a.3d DATAFILE=MODELS\GibinatorPickup_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=GibinatorPickup X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=GibinatorPickup SEQ=All             STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=GibinatorPickup SEQ=GibinatorPickup STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW   MESHMAP=GibinatorPickup MESH=GibinatorPickup
#exec MESHMAP SCALE MESHMAP=GibinatorPickup X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=GibinatorPickup NUM=1 TEXTURE=Gibinator0
#exec MESHMAP SETTEXTURE MESHMAP=GibinatorPickup NUM=2 TEXTURE=GibBattery
#exec MESHMAP SETTEXTURE MESHMAP=GibinatorPickup NUM=3 TEXTURE=Effects.electricity.Nano_SFX_A


//
// 3rd Person Version
//
#exec mesh IMPORT MESH=Gibinator3rd ANIVFILE=MODELS\GibinatorPickup_a.3d DATAFILE=MODELS\GibinatorPickup_d.3d X=0 Y=0 Z=0
#exec mesh ORIGIN MESH=Gibinator3rd X=0 Y=-600 Z=0 YAW=72 ROLL=30

#exec mesh SEQUENCE MESH=Gibinator3rd SEQ=All             STARTFRAME=0 NUMFRAMES=1
#exec mesh SEQUENCE MESH=Gibinator3rd SEQ=Gibinator3rd STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP new   MESHMAP=Gibinator3rd MESH=Gibinator3rd
#exec MESHMAP scale MESHMAP=Gibinator3rd X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=Gibinator3rd NUM=1 TEXTURE=Gibinator0
#exec MESHMAP SETTEXTURE MESHMAP=Gibinator3rd NUM=2 TEXTURE=GibBattery
#exec MESHMAP SETTEXTURE MESHMAP=Gibinator3rd NUM=3 TEXTURE=Effects.electricity.Nano_SFX_A

// Belt and Inventory Icons
#exec texture IMPORT FILE="Textures\BeltIconGibinator.pcx" MIPS=off
#exec texture IMPORT FILE="Textures\LargeIconGibinator.pcx" MIPS=off

defaultproperties
{
     LowAmmoWaterMark=0
     GoverningSkill=Class'DeusEx.SkillWeaponLowTech'
     NoiseLevel=0.050000
     EnemyEffective=ENMEFF_Organic
     EnviroEffective=ENVEFF_Air
     Concealability=CONC_Visual
     HitDamage=300
     maxRange=70
     AccurateRange=70
     BaseAccuracy=0.700000
     recoilStrength=0.500000
     mpReloadTime=3.000000
     mpHitDamage=90
     mpBaseAccuracy=0.200000
     mpAccurateRange=1200
     mpMaxRange=20
     bCanHaveModBaseAccuracy=True
     bCanHaveModReloadCount=True
     bCanHaveModAccurateRange=True
     bCanHaveModReloadTime=True
     bCanHaveModRecoilStrength=True
     AmmoName=Class'tnmitems.AmmoGibBattery'
     ReloadCount=1
     PickupAmmoCount=1
     bInstantHit=True
     FireOffset=(X=22.000000,Y=-10.000000,Z=14.000000)
     shakemag=20.000000
     FireSound=Sound'tnmitems.Weapons.GibinatorFire'
     CockingSound=Sound'tnmitems.Weapons.GibinatorReload'
     SelectSound=Sound'tnmitems.Weapons.GibinatorSelect'
     InventoryGroup=32
     ItemName="Gibinator"
     PlayerViewOffset=(X=28.000000,Y=-10.000000,Z=-11.500000)
     PlayerViewMesh=LodMesh'tnmitems.Gibinator'
     PlayerViewScale=1.100000
     PickupViewMesh=LodMesh'tnmitems.GibinatorPickup'
     PickupViewScale=1.500000
     ThirdPersonMesh=LodMesh'tnmitems.Gibinator3rd'
     ThirdPersonScale=1.100000
     Icon=Texture'tnmitems.BeltIconGibinator'
     largeIcon=Texture'tnmitems.LargeIconGibinator'
     largeIconWidth=77
     largeIconHeight=46
     invSlotsX=2
     Description="UNIQUE WEAPON:|nWatch out where you point this! This weapon is a splendid example of the fact that most weapon developers in this world should be locked away. Far away. This baby can gib anyone in one touch - though it does require actual physical contact. Careful with it."
     beltDescription="GIBINATOR"
     Mesh=LodMesh'tnmitems.GibinatorPickup'
     CollisionRadius=10.000000
     CollisionHeight=4.000000
     bReloadAnimHack=True
}
