//=============================================================================
// WeaponHammer.
//=============================================================================
class WeaponHammer extends TNMWeapon;

#exec texture IMPORT NAME=LargeIconTNMHammer FILE=Textures\LargeIconTNMHammer.pcx GROUP=Skins MIPS=off
#exec texture IMPORT NAME=BeltIconTNMHammer FILE=Textures\BeltIconTNMHammer.pcx GROUP=Skins MIPS=off

//First Person mesh
#exec mesh IMPORT MESH=WeaponHammer ANIVFILE=MODELS\WeaponHammer_a.3d DATAFILE=MODELS\WeaponHammer_d.3d X=0 Y=0 Z=0
#exec mesh ORIGIN MESH=WeaponHammer X=-16000 Y=2000 Z=0  //X - Toward Cam + Away Cam | Y - Right + Left | Z - Up  + Down

#exec mesh SEQUENCE MESH=WeaponHammer SEQ=All       STARTFRAME=0    NUMFRAMES=58
#exec mesh SEQUENCE MESH=WeaponHammer SEQ=Still		STARTFRAME=0	NUMFRAMES=1
#exec mesh SEQUENCE MESH=WeaponHammer SEQ=Select	STARTFRAME=1	NUMFRAMES=6		RATE=7	GROUP=Select
#exec mesh SEQUENCE MESH=WeaponHammer SEQ=Attack	STARTFRAME=6	NUMFRAMES=8		RATE=21
#exec mesh SEQUENCE MESH=WeaponHammer SEQ=Attack2	STARTFRAME=13	NUMFRAMES=8	    RATE=33
#exec mesh SEQUENCE MESH=WeaponHammer SEQ=Attack3	STARTFRAME=20	NUMFRAMES=11	RATE=24
#exec mesh SEQUENCE MESH=WeaponHammer SEQ=Down		STARTFRAME=30	NUMFRAMES=6		RATE=10
#exec mesh SEQUENCE MESH=WeaponHammer SEQ=Idle1		STARTFRAME=36	NUMFRAMES=8		RATE=4
#exec mesh SEQUENCE MESH=WeaponHammer SEQ=Idle2		STARTFRAME=43	NUMFRAMES=8		RATE=4
#exec mesh SEQUENCE MESH=WeaponHammer SEQ=Idle3		STARTFRAME=50	NUMFRAMES=8		RATE=4

#exec mesh NOTIFY MESH=WeaponHammer SEQ=Attack		TIME=0.33	FUNCTION=HandToHandAttack
#exec mesh NOTIFY MESH=WeaponHammer SEQ=Attack2		TIME=0.33	FUNCTION=HandToHandAttack
#exec mesh NOTIFY MESH=WeaponHammer SEQ=Attack3		TIME=0.33	FUNCTION=HandToHandAttack

#exec texture IMPORT NAME=JWeaponHammer1 FILE=Textures\HammerTex1.PCX GROUP=Skins // HAMMER
#exec TEXTURE IMPORT NAME=JWeaponHammer2 FILE=Textures\WeaponHandsTex.PCX GROUP=Skins // HAND

#exec MESHMAP NEW   MESHMAP=WeaponHammer MESH=WeaponHammer
#exec MESHMAP scale MESHMAP=WeaponHammer X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=WeaponHammer NUM=1 TEXTURE=JWeaponHammer1
#exec MESHMAP SETTEXTURE MESHMAP=WeaponHammer NUM=2 TEXTURE=JWeaponHammer2


//Pickup mesh
#exec mesh IMPORT MESH=HammerPickup ANIVFILE=MODELS\HammerPickup_a.3d DATAFILE=MODELS\HammerPickup_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=HammerPickup X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=HammerPickup SEQ=All          STARTFRAME=0 NUMFRAMES=1
#exec mesh SEQUENCE MESH=HammerPickup SEQ=HammerPickup STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW   MESHMAP=HammerPickup MESH=HammerPickup
#exec MESHMAP SCALE MESHMAP=HammerPickup X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=HammerPickup NUM=1 TEXTURE=JWeaponHammer1


//3rd Person mesh
#exec mesh IMPORT MESH=Hammer3rd ANIVFILE=MODELS\Hammer3rd_a.3d DATAFILE=MODELS\Hammer3rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=Hammer3rd X=3000 Y=500 Z=0

#exec MESH SEQUENCE MESH=Hammer3rd SEQ=All       STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=Hammer3rd SEQ=Hammer3rd STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW   MESHMAP=Hammer3rd MESH=Hammer3rd
#exec MESHMAP SCALE MESHMAP=Hammer3rd X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=Hammer3rd NUM=1 TEXTURE=JWeaponHammer1

defaultproperties
{
     bGetsBloody=True
     LowAmmoWaterMark=0
     GoverningSkill=Class'DeusEx.SkillWeaponLowTech'
     NoiseLevel=0.050000
     EnemyEffective=ENMEFF_Organic
     EnviroEffective=ENVEFF_All
     Concealability=CONC_All
     bEmitWeaponDrawn=False
     reloadTime=0.000000
     HitDamage=6
     maxRange=80
     AccurateRange=80
     BaseAccuracy=1.000000
     bHasMuzzleFlash=False
     bHandToHand=True
     bFallbackWeapon=True
     mpHitDamage=20
     mpBaseAccuracy=1.000000
     mpAccurateRange=96
     mpMaxRange=96
     AmmoName=Class'DeusEx.AmmoNone'
     ReloadCount=0
     bInstantHit=True
     FireOffset=(X=-5.000000,Y=8.000000,Z=14.000000)
     shakemag=20.000000
     FireSound=Sound'DeusExSounds.Weapons.CrowbarFire'
     SelectSound=Sound'DeusExSounds.Weapons.CrowbarSelect'
     hitfleshsound=Sound'DeusExSounds.Weapons.CrowbarHitFlesh'
     hitwoodsound=Sound'DeusExSounds.Weapons.CrowbarHitSoft'
     hitmetalsound=Sound'DeusExSounds.Weapons.CrowbarHitHard'
     hitothersound=Sound'DeusExSounds.Weapons.CrowbarHitSoft'
     InventoryGroup=53
     ItemName="Hammer"
     PlayerViewOffset=(X=5.000000,Y=-8.000000,Z=-14.000000)
     PlayerViewMesh=LodMesh'tnmitems.WeaponHammer'
     PlayerViewScale=0.400000
     PickupViewMesh=LodMesh'tnmitems.HammerPickup'
     PickupViewScale=0.600000
     ThirdPersonMesh=LodMesh'tnmitems.Hammer3rd'
     ThirdPersonScale=0.350000
     Icon=Texture'tnmitems.Skins.BeltIconTNMHammer'
     largeIcon=Texture'tnmitems.Skins.LargeIconTNMHammer'
     largeIconWidth=49
     largeIconHeight=45
     Description="It's Hammer Time!"
     beltDescription="HAMMER"
     Mesh=LodMesh'tnmitems.HammerPickup'
     CollisionRadius=12.650000
     CollisionHeight=1.200000
}
