//=============================================================================
// WeaponKatana.
//=============================================================================
class WeaponKatana extends TNMWeapon;

//
// Belt and Inventory Icons
//
#exec texture IMPORT NAME=LargeIconKatana FILE=Textures\LargeIconKatana.pcx GROUP=Skins MIPS=off
#exec texture IMPORT NAME=BeltIconKatana FILE=Textures\BeltIconKatana.pcx GROUP=Skins MIPS=off

#exec MESH IMPORT MESH=WeaponKatana ANIVFILE=MODELS\WeaponKatana_a.3d DATAFILE=MODELS\WeaponKatana_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=WeaponKatana X=2000 Y=0 Z=3000 YAW=64  //(Z=Up/down X=Side)

#exec MESH SEQUENCE MESH=WeaponKatana SEQ=All       STARTFRAME=0    NUMFRAMES=73
#exec MESH SEQUENCE MESH=WeaponKatana SEQ=Still		STARTFRAME=0	NUMFRAMES=1
#exec mesh SEQUENCE MESH=WeaponKatana SEQ=Select	STARTFRAME=1	NUMFRAMES=14	RATE=8	GROUP=Select
#exec mesh SEQUENCE MESH=WeaponKatana SEQ=Attack	STARTFRAME=14	NUMFRAMES=9	    RATE=12
#exec MESH SEQUENCE MESH=WeaponKatana SEQ=Attack2	STARTFRAME=22	NUMFRAMES=10	RATE=12
#exec mesh SEQUENCE MESH=WeaponKatana SEQ=Attack3	STARTFRAME=31	NUMFRAMES=9	    RATE=12
#exec MESH SEQUENCE MESH=WeaponKatana SEQ=Down		STARTFRAME=39	NUMFRAMES=12	RATE=8
#exec MESH SEQUENCE MESH=WeaponKatana SEQ=Idle1		STARTFRAME=51	NUMFRAMES=8	    RATE=2
#exec MESH SEQUENCE MESH=WeaponKatana SEQ=Idle2		STARTFRAME=58	NUMFRAMES=8	    RATE=2
#exec MESH SEQUENCE MESH=WeaponKatana SEQ=Idle3		STARTFRAME=65	NUMFRAMES=8  	RATE=2

//
// Attack Information
//
#exec MESH NOTIFY MESH=WeaponKatana SEQ=Attack           TIME=0.2     FUNCTION=HandToHandAttack
#exec MESH NOTIFY MESH=WeaponKatana SEQ=Attack2          TIME=0.3     FUNCTION=HandToHandAttack
#exec MESH NOTIFY MESH=WeaponKatana SEQ=Attack3          TIME=0.3    FUNCTION=HandToHandAttack

#exec TEXTURE IMPORT NAME=JWeaponKatana1 FILE=Textures\KatanaTex1.PCX GROUP=Skins // Material #2
#exec TEXTURE IMPORT NAME=JWeaponKatana2 FILE=Textures\WeaponHandsTex.PCX GROUP=Skins // TWOSIDED

#exec MESHMAP NEW   MESHMAP=WeaponKatana MESH=WeaponKatana
#exec MESHMAP SCALE MESHMAP=WeaponKatana X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=WeaponKatana NUM=1 TEXTURE=JWeaponKatana1
#exec MESHMAP SETTEXTURE MESHMAP=WeaponKatana NUM=2 TEXTURE=JWeaponKatana2

//
// Pickup Version
//
#exec MESH IMPORT MESH=KatanaPickup ANIVFILE=MODELS\KatanaPickup_a.3d DATAFILE=MODELS\KatanaPickup_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=KatanaPickup X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=KatanaPickup SEQ=All          STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=KatanaPickup SEQ=KatanaPickup STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW   MESHMAP=KatanaPickup MESH=KatanaPickup
#exec MESHMAP SCALE MESHMAP=KatanaPickup X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=KatanaPickup NUM=1 TEXTURE=JWeaponKatana1

//
// 3rd person Mesh
//
#exec MESH IMPORT MESH=Katana3rd ANIVFILE=MODELS\Katana3rd_a.3d DATAFILE=MODELS\Katana3rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=Katana3rd X=2000 Y=0 Z=0 PITCH=13

#exec MESH SEQUENCE MESH=Katana3rd SEQ=All       STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=Katana3rd SEQ=Katana3rd STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW   MESHMAP=Katana3rd MESH=Katana3rd
#exec MESHMAP SCALE MESHMAP=Katana3rd X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=Katana3rd NUM=1 TEXTURE=JWeaponKatana1

defaultproperties
{
     hitfleshsound=Sound'tnmitems.Weapons.katanaHitFlesh'
     hitwoodsound=Sound'tnmitems.Weapons.katanaHitwood'
     hitmetalsound=Sound'tnmitems.Weapons.katanaHitmetal'
     hitothersound=Sound'tnmitems.Weapons.katanaHitother'
     deselectsound=Sound'tnmitems.Weapons.katanaDeSelect'
     bGetsBloody=True
     LowAmmoWaterMark=0
     GoverningSkill=Class'DeusEx.SkillWeaponLowTech'
     NoiseLevel=0.050000
     EnemyEffective=ENMEFF_Organic
     EnviroEffective=ENVEFF_All
     Concealability=CONC_Visual
     ShotTime=0.400000
     reloadTime=0.000000
     HitDamage=10
     maxRange=80
     AccurateRange=70
     BaseAccuracy=1.000000
     bHandToHand=True
     mpHitDamage=20
     mpBaseAccuracy=0.700000
     mpAccurateRange=70
     mpMaxRange=80
     AmmoName=Class'DeusEx.AmmoNone'
     ReloadCount=0
     bInstantHit=True
     FireOffset=(X=22.000000,Y=-10.000000,Z=14.000000)
     shakemag=20.000000
     FireSound=Sound'tnmitems.Weapons.katanaFire'
     SelectSound=Sound'tnmitems.Weapons.katanaSelect'
     InventoryGroup=33
     ItemName="Katana"
     PlayerViewOffset=(X=28.000000,Y=-10.000000,Z=-11.500000)
     PlayerViewMesh=LodMesh'tnmitems.WeaponKatana'
     PlayerViewScale=1.300000
     PickupViewMesh=LodMesh'tnmitems.KatanaPickup'
     PickupViewScale=0.700000
     ThirdPersonMesh=LodMesh'tnmitems.Katana3rd'
     ThirdPersonScale=0.500000
     Icon=Texture'tnmitems.Skins.BeltIconKatana'
     largeIcon=Texture'tnmitems.Skins.LargeIconKatana'
     largeIconWidth=205
     largeIconHeight=46
     invSlotsX=4
     Description="This is a katana, stable of modern action films and by now a bit of a cliche. And yes, it's yet another element that makes TNM look like a total Snow Crash ripoff. This particular version doesn't actually appear anywhere in the game though, so good job cheating, cheater."
     beltDescription="KATANA"
     Mesh=LodMesh'tnmitems.KatanaPickup'
     DrawScale=0.700000
     CollisionRadius=13.000000
     CollisionHeight=2.000000
}
