//=============================================================================
// WeaponKatana.
//=============================================================================
class WeaponKatanaRonin extends WeaponKatana;

//
// Belt and Inventory Icons
//
#exec texture IMPORT NAME=LargeIconDRKatana FILE=Textures\LargeIconDRKatana.pcx GROUP=Skins MIPS=off
#exec texture IMPORT NAME=BeltIconDRKatana FILE=Textures\BeltIconDRKatana.pcx GROUP=Skins MIPS=off

#exec mesh IMPORT MESH=WeaponKatanaRonin ANIVFILE=MODELS\WeaponKatana_a.3d DATAFILE=MODELS\WeaponKatana_d.3d X=0 Y=0 Z=0
#exec mesh ORIGIN MESH=WeaponKatanaRonin X=2000 Y=0 Z=3000 YAW=64  //(Z=Up/down X=Side)

#exec mesh SEQUENCE MESH=WeaponKatanaRonin SEQ=All       STARTFRAME=0    NUMFRAMES=73
#exec mesh SEQUENCE MESH=WeaponKatanaRonin SEQ=Still		STARTFRAME=0	NUMFRAMES=1
#exec mesh SEQUENCE MESH=WeaponKatanaRonin SEQ=Select	STARTFRAME=1	NUMFRAMES=14	RATE=8	GROUP=Select
#exec mesh SEQUENCE MESH=WeaponKatanaRonin SEQ=Attack	STARTFRAME=14	NUMFRAMES=9	    RATE=12
#exec mesh SEQUENCE MESH=WeaponKatanaRonin SEQ=Attack2	STARTFRAME=22	NUMFRAMES=10	RATE=12
#exec mesh SEQUENCE MESH=WeaponKatanaRonin SEQ=Attack3	STARTFRAME=31	NUMFRAMES=9	    RATE=12
#exec mesh SEQUENCE MESH=WeaponKatanaRonin SEQ=Down		STARTFRAME=39	NUMFRAMES=12	RATE=8
#exec mesh SEQUENCE MESH=WeaponKatanaRonin SEQ=Idle1		STARTFRAME=51	NUMFRAMES=8	    RATE=2
#exec mesh SEQUENCE MESH=WeaponKatanaRonin SEQ=Idle2		STARTFRAME=58	NUMFRAMES=8	    RATE=2
#exec mesh SEQUENCE MESH=WeaponKatanaRonin SEQ=Idle3		STARTFRAME=65	NUMFRAMES=8  	RATE=2

//
// Attack Information
//
#exec mesh NOTIFY MESH=WeaponKatanaRonin SEQ=Attack          TIME=0.5     FUNCTION=HandToHandAttack
#exec mesh NOTIFY MESH=WeaponKatanaRonin SEQ=Attack2          TIME=0.5     FUNCTION=HandToHandAttack
#exec mesh NOTIFY MESH=WeaponKatanaRonin SEQ=Attack3          TIME=0.5     FUNCTION=HandToHandAttack

#exec texture IMPORT NAME=JWeaponRoninKatana1 FILE=Textures\DRKatanaTex1.pcx GROUP=Skins // Material #2
#exec texture IMPORT NAME=JWeaponRoninKatana2 FILE=Textures\WeaponHandsTex.PCX GROUP=Skins // TWOSIDED

#exec MESHMAP new   MESHMAP=WeaponKatanaRonin MESH=WeaponKatanaRonin
#exec MESHMAP scale MESHMAP=WeaponKatanaRonin X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=WeaponKatanaRonin NUM=1 TEXTURE=JWeaponRoninKatana1
#exec MESHMAP SETTEXTURE MESHMAP=WeaponKatanaRonin NUM=2 TEXTURE=JWeaponRoninKatana2

//
// Pickup Version
//
#exec mesh IMPORT MESH=RoninKatanaPickup ANIVFILE=MODELS\KatanaPickup_a.3d DATAFILE=MODELS\KatanaPickup_d.3d X=0 Y=0 Z=0
#exec mesh ORIGIN MESH=RoninKatanaPickup X=0 Y=0 Z=0

#exec mesh SEQUENCE MESH=RoninKatanaPickup SEQ=All          STARTFRAME=0 NUMFRAMES=1
#exec mesh SEQUENCE MESH=RoninKatanaPickup SEQ=KatanaPickup STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP new   MESHMAP=RoninKatanaPickup MESH=RoninKatanaPickup
#exec MESHMAP scale MESHMAP=RoninKatanaPickup X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=RoninKatanaPickup NUM=1 TEXTURE=JWeaponRoninKatana1

//
// 3rd person Mesh
//
#exec mesh IMPORT MESH=RoninKatana3rd ANIVFILE=MODELS\Katana3rd_a.3d DATAFILE=MODELS\Katana3rd_d.3d X=0 Y=0 Z=0
#exec mesh ORIGIN MESH=RoninKatana3rd X=2000 Y=0 Z=0 PITCH=13

#exec mesh SEQUENCE MESH=RoninKatana3rd SEQ=All       STARTFRAME=0 NUMFRAMES=1
#exec mesh SEQUENCE MESH=RoninKatana3rd SEQ=Katana3rd STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP new   MESHMAP=RoninKatana3rd MESH=RoninKatana3rd
#exec MESHMAP scale MESHMAP=RoninKatana3rd X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=RoninKatana3rd NUM=1 TEXTURE=JWeaponRoninKatana1

defaultproperties
{
     HitDamage=30
     AccurateRange=80
     InventoryGroup=45
     PickupMessage="You picked"
     ItemArticle="up"
     ItemName="Digital Ronin's Katana"
     beltDescription="RONIN"
     PlayerViewMesh=LodMesh'TNMItems.WeaponKatanaRonin'
     PickupViewMesh=LodMesh'TNMItems.RoninKatanaPickup'
     ThirdPersonMesh=LodMesh'TNMItems.RoninKatana3rd'
     Icon=Texture'TNMItems.Skins.BeltIconDRKatana'
     largeIcon=Texture'TNMItems.Skins.LargeIconDRKatana'
     Description="UNIQUE WEAPON:|nThis is the exquisitely crafted and perfectly balanced katana of the legendary moderator Digital Ronin. His equally legendary parting speech can be found in a book in Yardbomb's voodoo shop, where you also bought this sword. Holding the beautiful blade in your hands, you can almost feel your mind calm down and sharpen."
     Mesh=LodMesh'TNMItems.RoninKatanaPickup'
}
