//=============================================================================
// WeaponKatana.
//=============================================================================
class WeaponKatanaSlicer extends WeaponKatana;

//
// Belt and Inventory Icons
//
#exec texture IMPORT NAME=LargeIconSlicKatana FILE=Textures\LargeIconSlicKatana.pcx GROUP=Skins MIPS=off
#exec texture IMPORT NAME=BeltIconSlicKatana FILE=Textures\BeltIconSlicKatana.pcx GROUP=Skins MIPS=off

#exec mesh IMPORT MESH=WeaponKatanaSlicer ANIVFILE=MODELS\WeaponKatana_a.3d DATAFILE=MODELS\WeaponKatana_d.3d X=0 Y=0 Z=0
#exec mesh ORIGIN MESH=WeaponKatanaSlicer X=2000 Y=0 Z=3000 YAW=64  //(Z=Up/down X=Side)

#exec mesh SEQUENCE MESH=WeaponKatanaSlicer SEQ=All         STARTFRAME=0    NUMFRAMES=73
#exec mesh SEQUENCE MESH=WeaponKatanaSlicer SEQ=Still		STARTFRAME=0	NUMFRAMES=1
#exec mesh SEQUENCE MESH=WeaponKatanaSlicer SEQ=Select  	STARTFRAME=1	NUMFRAMES=14	RATE=8	GROUP=Select
#exec mesh SEQUENCE MESH=WeaponKatanaSlicer SEQ=Attack   	STARTFRAME=14	NUMFRAMES=9	    RATE=12
#exec mesh SEQUENCE MESH=WeaponKatanaSlicer SEQ=Attack2	    STARTFRAME=22	NUMFRAMES=10	RATE=16
#exec mesh SEQUENCE MESH=WeaponKatanaSlicer SEQ=Attack3	    STARTFRAME=31	NUMFRAMES=9	    RATE=12
#exec mesh SEQUENCE MESH=WeaponKatanaSlicer SEQ=Down		STARTFRAME=39	NUMFRAMES=12	RATE=8
#exec mesh SEQUENCE MESH=WeaponKatanaSlicer SEQ=Idle1		STARTFRAME=51	NUMFRAMES=8	    RATE=2
#exec mesh SEQUENCE MESH=WeaponKatanaSlicer SEQ=Idle2		STARTFRAME=58	NUMFRAMES=8	    RATE=2
#exec mesh SEQUENCE MESH=WeaponKatanaSlicer SEQ=Idle3		STARTFRAME=65	NUMFRAMES=8  	RATE=2

//
// Attack Information
//
#exec mesh NOTIFY MESH=WeaponKatanaSlicer SEQ=Attack          TIME=0.5     FUNCTION=HandToHandAttack
#exec mesh NOTIFY MESH=WeaponKatanaSlicer SEQ=Attack2          TIME=0.5     FUNCTION=HandToHandAttack
#exec mesh NOTIFY MESH=WeaponKatanaSlicer SEQ=Attack3          TIME=0.5     FUNCTION=HandToHandAttack

#exec texture IMPORT NAME=JWeaponKatanaSlicer1 FILE=Textures\SlicerKatanaTex1.PCX GROUP=Skins // Material #2
#exec texture IMPORT NAME=JWeaponKatanaSlicer2 FILE=Textures\WeaponHandsTex.PCX GROUP=Skins // TWOSIDED

#exec MESHMAP new   MESHMAP=WeaponKatanaSlicer MESH=WeaponKatanaSlicer
#exec MESHMAP scale MESHMAP=WeaponKatanaSlicer X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=WeaponKatanaSlicer NUM=1 TEXTURE=JWeaponKatanaSlicer1
#exec MESHMAP SETTEXTURE MESHMAP=WeaponKatanaSlicer NUM=2 TEXTURE=JWeaponKatanaSlicer2

//
// Pickup Version
//
#exec mesh IMPORT MESH=SlicerKatanaPickup ANIVFILE=MODELS\KatanaPickup_a.3d DATAFILE=MODELS\KatanaPickup_d.3d X=0 Y=0 Z=0
#exec mesh ORIGIN MESH=SlicerKatanaPickup X=0 Y=0 Z=0

#exec mesh SEQUENCE MESH=SlicerKatanaPickup SEQ=All          STARTFRAME=0 NUMFRAMES=1
#exec mesh SEQUENCE MESH=SlicerKatanaPickup SEQ=SlicerKatanaPickup STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP new   MESHMAP=SlicerKatanaPickup MESH=SlicerKatanaPickup
#exec MESHMAP scale MESHMAP=SlicerKatanaPickup X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=SlicerKatanaPickup NUM=1 TEXTURE=JWeaponKatanaSlicer1

//
// 3rd person Mesh
//
#exec mesh IMPORT MESH=SlicerKatana3rd ANIVFILE=MODELS\Katana3rd_a.3d DATAFILE=MODELS\Katana3rd_d.3d X=0 Y=0 Z=0
#exec mesh ORIGIN MESH=SlicerKatana3rd X=2000 Y=0 Z=0 PITCH=13

#exec mesh SEQUENCE MESH=SlicerKatana3rd SEQ=All       STARTFRAME=0 NUMFRAMES=1
#exec mesh SEQUENCE MESH=SlicerKatana3rd SEQ=SlicerKatana3rd STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP new   MESHMAP=SlicerKatana3rd MESH=SlicerKatana3rd
#exec MESHMAP scale MESHMAP=SlicerKatana3rd X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=SlicerKatana3rd NUM=1 TEXTURE=JWeaponKatanaSlicer1

defaultproperties
{
     HitDamage=25
     AccurateRange=80
     mpHitDamage=25
     InventoryGroup=43
     PickupMessage="You picked"
     ItemArticle="up"
     ItemName="Slicer's Katana"
     beltDescription="SLICER"
     PlayerViewMesh=LodMesh'TNMItems.WeaponKatanaSlicer'
     PickupViewMesh=LodMesh'TNMItems.SlicerKatanaPickup'
     ThirdPersonMesh=LodMesh'TNMItems.SlicerKatana3rd'
     Icon=Texture'TNMItems.Skins.BeltIconSlicKatana'
     largeIcon=Texture'TNMItems.Skins.LargeIconSlicKatana'
     Description="UNIQUE WEAPON:|nThis is Slicer's katana, which you picked from his body after defeating him. It's a very elegant and finely crafted weapon."
     Mesh=LodMesh'TNMItems.SlicerKatanaPickup'
}
