//=============================================================================
// WeaponLaser.
//=============================================================================
class WeaponLaser extends TNMWeapon;

#exec OBJ LOAD FILE=Effects

var LaserEmitter emitter;
var float zapTimer;
var vector lastHitLocation;
var int shockDamage;
var() int damageAmount;                    // how much damage does this do?

function DrawAdditionalScope(GC gc, int width, int height)
{
	gc.SetTileColorRGB(255, 0, 0);
	gc.SetStyle(DSTY_Normal);
	gc.DrawPattern(width/2 - 2, height/2 - 2, 2, 2, 0, 0, Texture'Solid');
}

simulated function renderoverlays(Canvas canvas)
{
   if(bHasScope)
   {
      multiskins[3] = none;
      multiskins[5] = none;
   }
   else
   {
      multiskins[3] = texture'BlackMaskTex';
      multiskins[5] = texture'pinkmasktex';
   }
   super.renderoverlays(canvas);
}

// force EMP damage
function name WeaponDamageType()
{
     return 'EMP';
}

// intercept the hit and turn on the emitter
function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
     local vector loc;
     local rotator rot;

     Super.ProcessTraceHit(Other, HitLocation, HitNormal, X, Y, Z);

     zapTimer = 0.2;
	if (emitter != None)
     emitter.destroy();

          loc = Owner.Location + CalcDrawOffset() + FireOffset.X * X + FireOffset.Y * Y + FireOffset.Z * Z;
          loc += -20.000000 * Z;
          loc += -5.000000 * Y;
          loc += 5.000000 * X;
          rot = Pawn(Owner).ViewRotation;
          rot.Yaw += Rand(5) - 2;
          rot.Pitch += Rand(5) - 2;

     emitter = Spawn(class'LaserEmitter', Self,,loc,rot);
     if (emitter != None)
     {
          damageAmount = shockDamage;
          emitter.Instigator = Pawn(Owner);



          // add a little random jitter - looks cool!

          emitter.SetLocation(Loc);
          emitter.SetRotation(rot);
          emitter.TurnOn();
          emitter.SetBase(Owner);
          lastHitLocation = HitLocation;
     }

}

function Tick(float deltaTime)
{
     Super.Tick(deltaTime);

     if (zapTimer > 0)
     {
          zapTimer -= deltaTime;

          // update the rotation of the emitter
	  if (emitter != None)
          emitter.SetRotation(Rotator(lastHitLocation - emitter.Location));

          // turn off the electricity after the timer has expired
     }

     if (zapTimer <= 0)
     {
        zapTimer = 0;
	if (emitter != none)
        	emitter.TurnOff();
     }


}

function Destroyed()
{
     if (emitter != None)
     {
          emitter.Destroy();
          emitter = None;
     }

     Super.Destroyed();
}

function PostBeginPlay()
{
     Super.PostBeginPlay();
     if(!bHasScope)
     {
         multiskins[3] = texture'BlackMaskTex';
         multiskins[5] = texture'pinkmasktex';
     }

     zapTimer = 0;
}


// Muzzle Flash Stuff
// called from the MESH NOTIFY Copied from DeusexWeapons.uc and modified...
//
// Effect used - Effects.Electricity.LaserSpot1
//
simulated function SwapMuzzleFlashTexture()
{
     if (!bHasMuzzleFlash)
     return;
       MultiSkins[6] = Texture'DeusExItems.Skins.RedLightTex';

     MuzzleFlashLight();
     SetTimer(0.1, False);
}

simulated function EraseMuzzleFlashTexture()
{
     MultiSkins[6] = None;
}

simulated function Timer()
{
     EraseMuzzleFlashTexture();
}

simulated function MuzzleFlashLight()
{
     local Vector offset, X, Y, Z;
     local Effects flash;

      if (!bHasMuzzleFlash)
          return;

     if ((flash != None) && !flash.bDeleteMe)
          flash.LifeSpan = flash.Default.LifeSpan;
     else
     {
          GetAxes(Pawn(Owner).ViewRotation,X,Y,Z);
          offset = Owner.Location;
          offset += X * Owner.CollisionRadius * 2;
          flash = spawn(class'Muzzleflash',,, offset);
          if (flash != None)
               flash.SetBase(Owner);
     }
}

//
// Multiplayer Stuff
//
simulated function PreBeginPlay()
{
     Super.PreBeginPlay();

     // If this is a netgame, then override defaults
     if ( Level.NetMode != NM_StandAlone )
     {
          HitDamage = mpHitDamage;
          BaseAccuracy = mpBaseAccuracy;
          ReloadTime = mpReloadTime;
          AccurateRange = mpAccurateRange;
          MaxRange = mpMaxRange;
          ReloadCount = mpReloadCount;
     }
}

// 1st Person Version
#exec mesh IMPORT MESH=WeaponLaser ANIVFILE=MODELS\WeaponLaser_a.3d DATAFILE=MODELS\WeaponLaser_d.3d X=0 Y=0 Z=0 unmirror=1
#exec mesh ORIGIN MESH=WeaponLaser X=2000 Y=-5000 Z=6500 YAW=128  //(Z -up +Down Y +Right -Left x -Back +Forward

#exec mesh SEQUENCE MESH=WeaponLaser SEQ=All         STARTFRAME=0 NUMFRAMES=71
#exec mesh SEQUENCE MESH=WeaponLaser SEQ=Still       STARTFRAME=0 NUMFRAMES=1
#exec mesh SEQUENCE MESH=WeaponLaser SEQ=Select      STARTFRAME=1 NUMFRAMES=8     RATE=8 GROUP=Select
#exec mesh SEQUENCE MESH=WeaponLaser SEQ=Shoot       STARTFRAME=8 NUMFRAMES=6     RATE=24
#exec mesh SEQUENCE MESH=WeaponLaser SEQ=Down        STARTFRAME=13 NUMFRAMES=4    RATE=14
#exec mesh SEQUENCE MESH=WeaponLaser SEQ=ReloadBegin STARTFRAME=17 NUMFRAMES=0    RATE=8
#exec mesh SEQUENCE MESH=WeaponLaser SEQ=Reload      STARTFRAME=17 NUMFRAMES=27   RATE=8
#exec mesh SEQUENCE MESH=WeaponLaser SEQ=ReloadEnd   STARTFRAME=27 NUMFRAMES=0    RATE=8
#exec mesh SEQUENCE MESH=WeaponLaser SEQ=Idle1       STARTFRAME=43 NUMFRAMES=10   RATE=4
#exec mesh SEQUENCE MESH=WeaponLaser SEQ=Idle2       STARTFRAME=52 NUMFRAMES=10   RATE=4
#exec mesh SEQUENCE MESH=WeaponLaser SEQ=Idle3       STARTFRAME=61 NUMFRAMES=10   RATE=4

#exec texture IMPORT NAME=LaserTex1 FILE=Textures\LaserTex1.pcx GROUP=Skins //MainTex
#exec texture IMPORT NAME=LaserGlass FILE=Textures\LaserGlass.pcx GROUP=Skins // Glass
#exec texture IMPORT NAME=LaserSight FILE=Textures\LaserSight.PCX GROUP=Skins // LaserSight
#exec texture IMPORT NAME=LaserRods FILE=Textures\LaserRods.PCX GROUP=Skins // LaserRods
#exec texture IMPORT NAME=LaserBattery FILE=Textures\LaserBattery.PCX GROUP=Skins // LaserBattery

#exec MESHMAP new   MESHMAP=WeaponLaser MESH=WeaponLaser
#exec MESHMAP scale MESHMAP=WeaponLaser X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=WeaponLaser NUM=1 texture=LaserTex1      //MainTex
#exec MESHMAP SETTEXTURE MESHMAP=WeaponLaser NUM=2 texture=LaserGlass     //Glass
#exec MESHMAP SETTEXTURE MESHMAP=WeaponLaser NUM=3 texture=LaserSight     //LaserSight
#exec MESHMAP SETTEXTURE MESHMAP=WeaponLaser NUM=4 texture=Effects.Laser.LaserBeam1  //LaserRods
#exec MESHMAP SETTEXTURE MESHMAP=WeaponLaser NUM=5 texture=LaserTex1      //Scope
#exec MESHMAP SETTEXTURE MESHMAP=WeaponLaser NUM=6 texture=BlackMaskTex   //MuzzleFlash
#exec MESHMAP SETTEXTURE MESHMAP=WeaponLaser NUM=7 texture=WeaponHandsTex //Hands
#exec MESHMAP SETTEXTURE MESHMAP=WeaponLaser NUM=8 texture=LaserBattery   //Battery

// Muzzle flash
#exec mesh NOTIFY MESH=WeaponLaser SEQ=Shoot     TIME=0.04     FUNCTION=SwapMuzzleFlashTexture

//Pick Up Version
#exec mesh IMPORT MESH=LaserPickup ANIVFILE=MODELS\LaserPickup_a.3d DATAFILE=MODELS\LaserPickup_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=LaserPickup X=0 Y=0 Z=0

#exec mesh SEQUENCE MESH=LaserPickup SEQ=All         STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=LaserPickup SEQ=LaserPickup STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP new   MESHMAP=LaserPickup MESH=LaserPickup
#exec MESHMAP SCALE MESHMAP=LaserPickup X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=LaserPickup NUM=1 texture=LaserTex1      //MainTex
#exec MESHMAP SETTEXTURE MESHMAP=LaserPickup NUM=2 texture=LaserGlass     //Glass
#exec MESHMAP SETTEXTURE MESHMAP=LaserPickup NUM=3 texture=LaserSight     //LaserSight
#exec MESHMAP SETTEXTURE MESHMAP=LaserPickup NUM=4 texture=Effects.Laser.LaserBeam1  //LaserRods
#exec MESHMAP SETTEXTURE MESHMAP=LaserPickup NUM=5 texture=LaserTex1      //Scope
#exec MESHMAP SETTEXTURE MESHMAP=LaserPickup NUM=6 texture=BlackMaskTex   //MuzzleFlash


//
//  3rd Person Version
//
#exec mesh IMPORT MESH=Laser3rd ANIVFILE=MODELS\Laser3rd_a.3d DATAFILE=MODELS\Laser3rd_d.3d X=0 Y=0 Z=0
#exec mesh ORIGIN MESH=Laser3rd X=0 Y=-500 Z=0 YAW=128 PITCH=-22

#exec MESH SEQUENCE MESH=Laser3rd SEQ=All      STARTFRAME=0 NUMFRAMES=1
#exec mesh SEQUENCE MESH=Laser3rd SEQ=Shoot    STARTFRAME=0 NUMFRAMES=1

#exec mesh NOTIFY MESH=Laser3rd SEQ=Shoot     TIME=0.04     FUNCTION=SwapMuzzleFlashTexture

#exec MESHMAP new   MESHMAP=Laser3rd MESH=Laser3rd
#exec MESHMAP SCALE MESHMAP=Laser3rd X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=Laser3rd NUM=1 texture=LaserTex1      //MainTex
#exec MESHMAP SETTEXTURE MESHMAP=Laser3rd NUM=2 texture=LaserGlass     //Glass
#exec MESHMAP SETTEXTURE MESHMAP=Laser3rd NUM=3 texture=LaserSight     //LaserSight
#exec MESHMAP SETTEXTURE MESHMAP=Laser3rd NUM=4 texture=Effects.Laser.LaserBeam1  //LaserRods
#exec MESHMAP SETTEXTURE MESHMAP=Laser3rd NUM=5 texture=LaserTex1      //Scope
#exec MESHMAP SETTEXTURE MESHMAP=Laser3rd NUM=6 texture=BlackMaskTex   //MuzzleFlash

// Laser Belt and Inventory Icons
#exec texture IMPORT name=BeltIconLaser FILE="Textures\BeltIconLaser.pcx" MIPS=off
#exec TEXTURE IMPORT name=LargeIconLaser FILE="Textures\LargeIconLaser.pcx" MIPS=off

#exec TEXTURE IMPORT FILE="Textures\tnmHUDScopeRed01.pcx"	NAME="tnmHUDScopeRed01"	GROUP="Userinterface" MIPS=Off 
#exec TEXTURE IMPORT FILE="Textures\tnmHUDScopeRed02.pcx"	NAME="tnmHUDScopeRed02"	GROUP="Userinterface" MIPS=Off 
#exec TEXTURE IMPORT FILE="Textures\tnmHUDScopeRed03.pcx"	NAME="tnmHUDScopeRed03"	GROUP="Userinterface" MIPS=Off 
#exec TEXTURE IMPORT FILE="Textures\tnmHUDScopeRed04.pcx"	NAME="tnmHUDScopeRed04"	GROUP="Userinterface" MIPS=Off 

defaultproperties
{
     ScopeType=EScopeType_Custom
     ScopeTexture01=texture'tnmHUDScopeRed01'
     ScopeTexture02=texture'tnmHUDScopeRed02'
     ScopeTexture03=texture'tnmHUDScopeRed03'
     ScopeTexture04=texture'tnmHUDScopeRed04'
     LowAmmoWaterMark=4
     GoverningSkill=Class'DeusEx.SkillWeaponPistol'
     NoiseLevel=0.050000
     EnemyEffective=ENMEFF_Organic
     EnviroEffective=ENVEFF_Air
     Concealability=CONC_Visual
     ShotTime=0.400000
     reloadTime=2.000000
     HitDamage=20
     maxRange=4800
     AccurateRange=2400
     BaseAccuracy=0.700000
     bCanHaveScope=True
     ScopeFOV=25
     bCanHaveLaser=True
     bHasLaser=False
     bPenetrating=False
     StunDuration=10.000000
     recoilStrength=0.100000
     mpReloadTime=3.000000
     mpHitDamage=20
     mpBaseAccuracy=0.200000
     mpAccurateRange=1200
     mpMaxRange=1200
     mpReloadCount=9
     bCanHaveModBaseAccuracy=True
     bCanHaveModReloadCount=True
     bCanHaveModAccurateRange=True
     bCanHaveModReloadTime=True
     bCanHaveModRecoilStrength=False
     AmmoName=Class'tnmitems.AmmoLaserBattery'
     ReloadCount=6
     PickupAmmoCount=6
     bInstantHit=True
     FireOffset=(X=24.000000,Y=-10.000000,Z=12.000000)
     shakemag=20.000000
     FireSound=Sound'tnmitems.Weapons.LaserFire'
     CockingSound=Sound'tnmitems.Weapons.LaserReload'
     SelectSound=Sound'tnmitems.Weapons.LaserSelect'
     InventoryGroup=34
     ItemName="EMP Pistol"
     ItemArticle="an"
     PlayerViewOffset=(X=18.000000,Y=-6.000000,Z=-4.500000)
     PlayerViewMesh=LodMesh'tnmitems.WeaponLaser'
     PlayerViewScale=0.400000
     PickupViewMesh=LodMesh'tnmitems.LaserPickup'
     PickupViewScale=0.500000
     ThirdPersonMesh=LodMesh'tnmitems.Laser3rd'
     ThirdPersonScale=0.500000
     Icon=Texture'tnmitems.BeltIconLaser'
     largeIcon=Texture'tnmitems.LargeIconLaser'
     largeIconWidth=34
     largeIconHeight=28
     Description="UNIQUE WEAPON:|nThe EMP pistol is a fairly futuristic state-of-the-art weapon manufactured by WorldCorp. It uses an extremely advanced (and patented) technology to generate intense electromagnetic radiation, amplified and focused into a high-power beam. Not terribly useful against regular combat troops, but highly efficient in disabling robots and security systems or stripping away the defenses of augmented enemies.|n|nUnlike most weapons, the EMP pistol accepts the neat but rarely used red dot sight included in all standard scope mod packages."
     beltDescription="EMP GUN"
     Texture=Texture'tnmitems.Skins.LaserGlass'
     Mesh=LodMesh'tnmitems.LaserPickup'
     DrawScale=0.500000
     CollisionRadius=9.000000
     CollisionHeight=1.300000
}
