//=============================================================================
// WeaponMine.
//=============================================================================
class WeaponMine extends TNMWeapon;

var localized String shortName;

//I originally thought changing the StartTrace/EndTrace.y to z in the NearWallCheck
//function would be it but no. You can still place the mine on walls aswell as the floor
//plus it isn't placed correctly, I have left the function in, case it might
//be needed.

/*simulated function bool NearWallCheck()
{
	local Vector StartTrace, EndTrace, HitLocation, HitNormal;
	local Actor HitActor;

	// Scripted pawns can't place LAMs
	if (ScriptedPawn(Owner) != None)
		return False;

	// Don't let players place grenades when they have something highlighted
	if ( Level.NetMode != NM_Standalone )
	{
		if ( Owner.IsA('DeusExPlayer') && (DeusExPlayer(Owner).frobTarget != None) )
		{
			if ( DeusExPlayer(Owner).IsFrobbable( DeusExPlayer(Owner).frobTarget ) )
				return False;
		}
	}

	// trace out one foot in front of the pawn
	StartTrace = Owner.Location;
	EndTrace = StartTrace + Vector(Pawn(Owner).ViewRotation) * 32;

	StartTrace.y += Pawn(Owner).BaseEyeHeight;
	EndTrace.y += Pawn(Owner).BaseEyeHeight;

	HitActor = Trace(HitLocation, HitNormal, EndTrace, StartTrace);
	if ((HitActor == Level) || ((HitActor != None) && HitActor.IsA('Mover')))
	{
		placeLocation = HitLocation;
		placeNormal = HitNormal;
		placeMover = Mover(HitActor);
		return True;
	}

	return False;
}*/

//Time for that guy to try
simulated function bool NearWallCheck()
{
	local Vector StartTrace, EndTrace, HitLocation, HitNormal;
	local Actor HitActor;

	// Scripted pawns can't place LAMs
	if (ScriptedPawn(Owner) != None)
		return False;

	// Don't let players place grenades when they have something highlighted
	if ( Level.NetMode != NM_Standalone )
	{
		if ( Owner.IsA('DeusExPlayer') && (DeusExPlayer(Owner).frobTarget != None) )
		{
			if ( DeusExPlayer(Owner).IsFrobbable( DeusExPlayer(Owner).frobTarget ) )
				return False;
		}
	}

	// trace out one foot in front of the pawn
	StartTrace = Owner.Location;
	EndTrace = StartTrace + Vector(Pawn(Owner).ViewRotation) * 64;

	StartTrace.Z += Pawn(Owner).BaseEyeHeight;
	EndTrace.Z += Pawn(Owner).BaseEyeHeight;

	HitActor = Trace(HitLocation, HitNormal, EndTrace, StartTrace);
	if (((HitActor == Level) || ((HitActor != None) && HitActor.IsA('Mover')))&&(HitNormal==vect(0,0,1)))
	{
		placeLocation = HitLocation;
		placeNormal = HitNormal;
		placeMover = Mover(HitActor);
		return True;
	}

	return False;
}

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	// If this is a netgame, then override defaults
	if ( Level.NetMode != NM_StandAlone )
	{
		HitDamage = mpHitDamage;
		BaseAccuracy = mpBaseAccuracy;
		ReloadTime = mpReloadTime;
		AccurateRange = mpAccurateRange;
		MaxRange = mpMaxRange;
	}
}

function PostBeginPlay()
{
   Super.PostBeginPlay();
   bWeaponStay=False;
}

function Fire(float Value)
{
	// if facing a wall, affix the LAM to the wall
	if (Pawn(Owner) != None)
	{
		if (bNearWall)
		{
			bReadyToFire = False;
			GotoState('NormalFire');
			bPointing = True;
			PlayAnim('Place',, 0.1);
			return;
		}
	}

	// otherwise, throw as usual not! Hahahaha
	return;
	Super.Fire(Value);
}

// Become a pickup
// Weapons that carry their ammo with them don't vanish when dropped
function BecomePickup()
{
	Super.BecomePickup();
   if (Level.NetMode != NM_Standalone)
      if (bTossedOut)
         Lifespan = 0.0;
}

// ----------------------------------------------------------------------
// TestMPBeltSpot()
// Returns true if the suggested belt location is ok for the object in mp.
// ----------------------------------------------------------------------

simulated function bool TestMPBeltSpot(int BeltSpot)
{
   return (BeltSpot == 6);
}

//
// Inventory Icons
//
#exec texture IMPORT NAME=LargeIconMine FILE=Textures\LargeIconMine.pcx GROUP=Skins MIPS=off
#exec texture IMPORT NAME=BeltIconMine FILE=Textures\BeltIconMine.pcx GROUP=Skins MIPS=off

//
// Player View
//
#exec mesh IMPORT MESH=Mine ANIVFILE=MODELS\Mine_a.3d DATAFILE=MODELS\Mine_d.3d X=0 Y=0 Z=0
#exec mesh ORIGIN MESH=Mine X=-2000 Y=9000 Z=0 YAW=0  //(x=+Left/-Right)

#exec mesh SEQUENCE MESH=Mine SEQ=All         STARTFRAME=0 NUMFRAMES=62
#exec mesh SEQUENCE MESH=Mine SEQ=Still	 	  STARTFRAME=0	NUMFRAMES=1
#exec mesh SEQUENCE MESH=Mine SEQ=Select	  STARTFRAME=1	NUMFRAMES=8	    RATE=10	GROUP=Select
#exec mesh SEQUENCE MESH=Mine SEQ=Attack	  STARTFRAME=8	NUMFRAMES=8		RATE=12
#exec mesh SEQUENCE MESH=Mine SEQ=Attack2	  STARTFRAME=8	NUMFRAMES=8		RATE=12
#exec mesh SEQUENCE MESH=Mine SEQ=Attack3	  STARTFRAME=8	NUMFRAMES=8		RATE=12
#exec mesh SEQUENCE MESH=Mine SEQ=Down		  STARTFRAME=15	NUMFRAMES=6		RATE=6
#exec mesh SEQUENCE MESH=Mine SEQ=PlaceBegin  STARTFRAME=21	NUMFRAMES=5		RATE=8
#exec mesh SEQUENCE MESH=Mine SEQ=Place		  STARTFRAME=25	NUMFRAMES=6	    RATE=14
#exec mesh SEQUENCE MESH=Mine SEQ=PlaceEnd	  STARTFRAME=31	NUMFRAMES=5		RATE=8
#exec mesh SEQUENCE MESH=Mine SEQ=Idle1		  STARTFRAME=35	NUMFRAMES=10	RATE=2
#exec mesh SEQUENCE MESH=Mine SEQ=Idle2		  STARTFRAME=44	NUMFRAMES=10	RATE=2
#exec mesh SEQUENCE MESH=Mine SEQ=Idle3		  STARTFRAME=53	NUMFRAMES=10	RATE=2

#exec mesh NOTIFY MESH=Mine SEQ=Place		TIME=0.4	FUNCTION=PlaceGrenade

#exec texture IMPORT NAME=JMine1 FILE=Textures\MineTex1.PCX GROUP=Skins // MATERIAL #0

#exec MESHMAP NEW   MESHMAP=Mine MESH=Mine
#exec MESHMAP SCALE MESHMAP=Mine X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=Mine NUM=1 TEXTURE=JMine1
#exec MESHMAP SETTEXTURE MESHMAP=Mine NUM=2 TEXTURE=Hands

//
//Pickup View
//
#exec mesh IMPORT MESH=MinePickup ANIVFILE=MODELS\MinePickup_a.3d DATAFILE=MODELS\MinePickup_d.3d X=0 Y=0 Z=0
#exec mesh ORIGIN MESH=MinePickup X=0 Y=0 Z=0

#exec mesh SEQUENCE MESH=MinePickup SEQ=All        STARTFRAME=0 NUMFRAMES=11
#exec mesh SEQUENCE MESH=MinePickup SEQ=Still      STARTFRAME=0 NUMFRAMES=1
#exec mesh SEQUENCE MESH=MinePickup SEQ=Enabled    STARTFRAME=0 NUMFRAMES=5
#exec mesh SEQUENCE MESH=MinePickup SEQ=Disabled   STARTFRAME=5 NUMFRAMES=5

#exec MESHMAP new   MESHMAP=MinePickup MESH=MinePickup
#exec MESHMAP SCALE MESHMAP=MinePickup X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=MinePickup NUM=1 TEXTURE=JMine1

//
// 3rd Person View
//
#exec MESH IMPORT MESH=Mine3rd ANIVFILE=MODELS\Mine3rd_a.3d DATAFILE=MODELS\Mine3rd_d.3d X=0 Y=0 Z=0
#exec mesh ORIGIN MESH=Mine3rd X=0 Y=0 Z=0

#exec mesh SEQUENCE MESH=Mine3rd SEQ=All     STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=Mine3rd SEQ=Mine3rd STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP new   MESHMAP=Mine3rd MESH=Mine3rd
#exec MESHMAP SCALE MESHMAP=Mine3rd X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=Mine3rd NUM=1 TEXTURE=JMine1

defaultproperties
{
     ShortName="Mine"
     LowAmmoWaterMark=2
     GoverningSkill=Class'DeusEx.SkillDemolition'
     EnviroEffective=ENVEFF_All
     Concealability=CONC_All
     ShotTime=0.300000
     reloadTime=0.100000
     HitDamage=50
     maxRange=4800
     AccurateRange=2400
     BaseAccuracy=1.000000
     bHasMuzzleFlash=False
     bHandToHand=True
     bUseAsDrawnWeapon=False
     AITimeLimit=3.500000
     AIFireDelay=5.000000
     bNeedToSetMPPickupAmmo=False
     mpReloadTime=0.100000
     mpHitDamage=50
     mpBaseAccuracy=1.000000
     mpAccurateRange=2400
     mpMaxRange=2400
     AmmoName=Class'tnmitems.AmmoMine'
     ReloadCount=1
     PickupAmmoCount=1
     FireOffset=(Y=10.000000,Z=20.000000)
     ProjectileClass=Class'tnmitems.MineProj'
     shakemag=50.000000
     SelectSound=Sound'DeusExSounds.Weapons.LAMSelect'
     InventoryGroup=49
     ItemName="Mine"
     PlayerViewOffset=(X=24.000000,Y=-15.000000,Z=-17.000000)
     PlayerViewMesh=LodMesh'tnmitems.Mine'
     PlayerViewScale=0.500000
     PickupViewMesh=LodMesh'tnmitems.MinePickup'
     PickupViewScale=0.550000
     ThirdPersonMesh=LodMesh'tnmitems.Mine3rd'
     ThirdPersonScale=0.300000
     Icon=Texture'tnmitems.Skins.BeltIconMine'
     largeIcon=Texture'tnmitems.Skins.LargeIconMine'
     largeIconWidth=35
     largeIconHeight=45
     Description="How nasty can it possibly get? Hopefully no more nasty than this contraption: Once placed on the ground, a cloaking device within this mine will be activated, almost entirely hiding it from the view of most people. When somebody enters its proximity, it will project deadly laser beams in an upward-facing cone which gradually widens while rotating... you know, just to be absolutely sure.|n|nAs a final touch, the mine can't be disarmed once active, and the only way to bypass it is with the use of a Radar Transparency augmentation. The Vision aug is also a great help in pinpointing the position of cloaked mines."
     beltDescription="Mine"
     Mesh=LodMesh'tnmitems.MinePickup'
     DrawScale=0.550000
     CollisionRadius=3.800000
     CollisionHeight=1.300000
     Mass=5.000000
     Buoyancy=2.000000
}
