//=============================================================================
//Napalm launcher
//=============================================================================

class WeaponNapalmLauncher expands tnmWeapon;

var int burntime, burndamage;
var int mpBurntime, mpburndamage;
var bool altAmmoLoaded;
var sound modechange;
var localized string msgNotEnough;
var localized string msgSwitchedBack;
var localized string msgSwitched;
var localized string msgSwitchedAlt;

function CycleAmmo()
{
	SwitchFireMode();
}

// Muzzle Flash Stuff
// called from the MESH NOTIFY Copied from DeusexWeapons.uc and modified...
simulated function SwapMuzzleFlashTexture()
{
     if (!bHasMuzzleFlash)
     return;
     if (FRand() < 0.5)
         MultiSkins[6] = Texture'DeusExItems.Skins.FlatFXTex34';
     else
         MultiSkins[6] = Texture'DeusExItems.Skins.FlatFXTex34';

     MuzzleFlashLight();
     SetTimer(0.1, False);
}

simulated function EraseMuzzleFlashTexture()
{
     MultiSkins[6] = None;
}

simulated function Timer()
{
     EraseMuzzleFlashTexture();
}

simulated function MuzzleFlashLight()
{
     local Vector offset, X, Y, Z;
     local Effects flash;

      if (!bHasMuzzleFlash)
          return;

     if ((flash != None) && !flash.bDeleteMe)
          flash.LifeSpan = flash.Default.LifeSpan;
     else
     {
          GetAxes(Pawn(Owner).ViewRotation,X,Y,Z);
          offset = Owner.Location;
          offset += X * Owner.CollisionRadius * 2;
          flash = spawn(class'Muzzleflash',,, offset);
          if (flash != None)
               flash.SetBase(Owner);
     }
}

function SwitchFireMode()
{
local Projectile NewProj;
local Ammo AmmoCheck;
local deusexplayer P;

p=deusexplayer(owner);
  if(p != None)
   {
	if(!altAmmoLoaded)
		{
		AmmoCheck = Ammo(P.FindInventoryType(AmmoName));
		If((AmmoCheck != None) && (AmmoCheck.AmmoAmount >=10))
			{
			Self.ProjectileClass = ProjectileNames[1];
			self.ProjectileSpeed = ProjectileClass.Default.Speed;
			self.ShotTime = 2.00;
			Self.altAmmoLoaded = true;
			P.playsound(modechange);
			P.Clientmessage(msgSwitchedAlt);
			}
		else
			P.Clientmessage(msgNotEnough);
		}
	else
		{
		Self.ProjectileClass = ProjectileNames[0];
		Self.AltAmmoLoaded = false;
		self.ShotTime = 1.00;
		P.playsound(modechange);
		P.ClientMessage(msgSwitched);
		}

   }

}

//
// bit hacky: checks if altammo is loaded, then does exactly the same, only uses more ammo
//
function Fire(float Value)
{
	local float sndVolume;
	local bool bListenClient;

	bListenClient = (Owner.IsA('DeusExPlayer') &&
DeusExPlayer(Owner).PlayerIsListenClient());

	sndVolume = TransientSoundVolume;

	if ( Level.NetMode != NM_Standalone )  // Turn up the sounds a bit in mulitplayer
	{
		sndVolume = TransientSoundVolume * 2.0;
		if ( Owner.IsA('DeusExPlayer') &&
(DeusExPlayer(Owner).NintendoImmunityTimeLeft > 0.01) || (!bClientReady && 
(!bListenClient)) )
		{
			DeusExPlayer(Owner).bJustFired = False;
			bReadyToFire = True;
			bPointing = False;
			bFiring = False;
			return;
		}
	}
	// check for surrounding environment
	if ((EnviroEffective == ENVEFF_Air) || (EnviroEffective == ENVEFF_Vacuum)
|| (EnviroEffective == ENVEFF_AirVacuum))
	{
		if (Region.Zone.bWaterZone)
		{
			if (Pawn(Owner) != None)
			{
				Pawn(Owner).ClientMessage(msgNotWorking);
				if (!bHandToHand)
					PlaySimSound( Misc1Sound, SLOT_None, sndVolume, 1024 );		// play dry fire sound
			}
			GotoState('Idle');
			return;
		}
	}


	if (bHandToHand)
	{
		if (ReloadCount > 0)
			AmmoType.UseAmmo(1);

		if (( Level.NetMode != NM_Standalone ) && !bListenClient )
			bClientReady = False;
		bReadyToFire = False;
		GotoState('NormalFire');
		bPointing=True;
		if ( Owner.IsA('PlayerPawn') )
			PlayerPawn(Owner).PlayFiring();
		PlaySelectiveFiring();
		PlayFiringSound();
	}


	// if we are a single-use weapon, then our ReloadCount is 0 and we don't use ammo
	else if ((ClipCount < ReloadCount) || (ReloadCount == 0))
	{
	//
	//here comes the dodgy hack bit
	//
	    if(!altAmmoLoaded)
	      {
		if ((ReloadCount == 0) || ((ClipCount + 1 < ReloadCount) && AmmoType.UseAmmo(2))) //we have at least 2 rounds of napalm left
		{
			if (( Level.NetMode != NM_Standalone ) && !bListenClient )
				bClientReady = False;

			ClipCount += 2;
			bFiring = True;
			bReadyToFire = False;
			GotoState('NormalFire');
			if (( Level.NetMode == NM_Standalone ) || ( Owner.IsA('DeusExPlayer') &&
DeusExPlayer(Owner).PlayerIsListenClient()) )
			{
				if ( PlayerPawn(Owner) != None )		// shake us based on accuracy
					PlayerPawn(Owner).ShakeView(ShakeTime, currentAccuracy * ShakeMag +
ShakeMag, currentAccuracy * ShakeVert);
			}
			bPointing=True;
			if ( bInstantHit )
				TraceFire(currentAccuracy);
			else
				ProjectileFire(ProjectileClass, ProjectileSpeed, bWarnTarget);

			if ( Owner.IsA('PlayerPawn') )
				PlayerPawn(Owner).PlayFiring();
			// Don't play firing anim for 20mm
			if ( Ammo20mm(AmmoType) == None )
				PlaySelectiveFiring();
			PlayFiringSound();
			if ( Owner.bHidden )
				CheckVisibility();
		}
		else
			PlaySimSound( Misc1Sound, SLOT_None, sndVolume, 1024 );		// play dry fire sound
	       }
	   else
	       {
		if ((ReloadCount == 0) ||  ((ClipCount + 9 < ReloadCount) && AmmoType.UseAmmo(10))) //we have at least 2 rounds of napalm left
		{
			if (( Level.NetMode != NM_Standalone ) && !bListenClient )
				bClientReady = False;

			ClipCount += 10;
			bFiring = True;
			bReadyToFire = False;
			GotoState('NormalFire');
			if (( Level.NetMode == NM_Standalone ) || ( Owner.IsA('DeusExPlayer') &&
DeusExPlayer(Owner).PlayerIsListenClient()) )
			{
				if ( PlayerPawn(Owner) != None )		// shake us based on accuracy
					PlayerPawn(Owner).ShakeView(ShakeTime, currentAccuracy * ShakeMag +
ShakeMag, currentAccuracy * ShakeVert);
			}
			bPointing=True;
			if ( bInstantHit )
				TraceFire(currentAccuracy);
			else
				ProjectileFire(ProjectileClass, ProjectileSpeed, bWarnTarget);

			if ( Owner.IsA('PlayerPawn') )
				PlayerPawn(Owner).PlayFiring();
			// Don't play firing anim for 20mm
			if ( Ammo20mm(AmmoType) == None )
				PlaySelectiveFiring();
			PlayFiringSound();
			if ( Owner.bHidden )
				CheckVisibility();
		}
		else //shouldn't ever get in here as tick will switch it back, but you never know
			PlaySimSound( Misc1Sound, SLOT_None, sndVolume, 1024 );		// play dry fire sound
	       }

	}
	else
		PlaySimSound( Misc1Sound, SLOT_None, sndVolume, 1024 );		// play dry fire sound

	// Update ammo count on object belt
	if (DeusExPlayer(Owner) != None)
		DeusExPlayer(Owner).UpdateBeltText(Self);
}

//
// continual ammocheck for enough ammo to keep in altfiremode
//
simulated function Tick(float deltaTime)
{
	local vector loc;
	local rotator rot;
	local float beepspeed, recoil;
	local DeusExPlayer player;
   local Actor RealTarget;
	local Pawn pawn;
        local Ammo AmmoCheck;

	player = DeusExPlayer(Owner);
	pawn = Pawn(Owner);

	if((player != none) && (altAmmoLoaded))
		{
		AmmoCheck = Ammo(Player.FindInventoryType(AmmoName));
			if((AmmoChecK != None) && (AmmoCheck.AmmoAmount < 10))
			{
			Self.ProjectileClass = ProjectileNames[0];
			Self.AltAmmoLoaded = false;
			self.Shottime = 1.00;
			Player.playsound(modechange);
			Player.Clientmessage(msgSwitchedBack);
			}
		}

	super.Tick(deltatime);

}

// Belt and Inventory Icons
#exec TEXTURE IMPORT FILE="Textures\BeltIconNapalmLauncher.pcx" MIPS=off
#exec TEXTURE IMPORT FILE="Textures\LargeIconNapalmLauncher.pcx" MIPS=off

// 1st Person View
#exec MESH IMPORT MESH=WeaponNapalm ANIVFILE=MODELS\WeaponNapalm_a.3d DATAFILE=MODELS\WeaponNapalm_d.3d X=0 Y=0 Z=0
#exec mesh ORIGIN MESH=WeaponNapalm X=0 Y=0 Z=0 YAW=-64

#exec MESH SEQUENCE MESH=WeaponNapalm SEQ=All                STARTFRAME=0 NUMFRAMES=54
#exec MESH SEQUENCE MESH=WeaponNapalm SEQ=Still              STARTFRAME=0 NUMFRAMES=1
#exec mesh SEQUENCE MESH=WeaponNapalm SEQ=Select             STARTFRAME=1 NUMFRAMES=10 RATE=8 GROUP=Select
#exec mesh SEQUENCE MESH=WeaponNapalm SEQ=Shoot              STARTFRAME=10 NUMFRAMES=7 RATE=10
#exec mesh SEQUENCE MESH=WeaponNapalm SEQ=Down               STARTFRAME=16 NUMFRAMES=8 RATE=8
#exec mesh SEQUENCE MESH=WeaponNapalm SEQ=Reload             STARTFRAME=23 NUMFRAMES=13 RATE=5
#exec MESH SEQUENCE MESH=WeaponNapalm SEQ=Idle1              STARTFRAME=35 NUMFRAMES=6 RATE=3
#exec MESH SEQUENCE MESH=WeaponNapalm SEQ=Idle2              STARTFRAME=40 NUMFRAMES=10 RATE=3
#exec MESH SEQUENCE MESH=WeaponNapalm SEQ=Idle3              STARTFRAME=49 NUMFRAMES=6 RATE=3

#exec mesh NOTIFY MESH=WeaponNapalm SEQ=Shoot	TIME=0.03	FUNCTION=SwapMuzzleFlashTexture

#exec TEXTURE IMPORT NAME=JNapalmGun0 FILE=Textures\NapalmGunTex1.PCX GROUP=Skins  // SKIN
#exec TEXTURE IMPORT NAME=NapalmScreen FILE=Textures\NapalmScreen.PCX GROUP=Skins  // SKIN
#exec TEXTURE IMPORT NAME=NapalmAmmo1 FILE=Textures\NapalmAmmoTex1.PCX GROUP=Skins // SKIN
#exec TEXTURE IMPORT NAME=NapalmAmmo2 FILE=Textures\NapalmAmmoTex2.PCX GROUP=Skins // SKIN
#exec TEXTURE IMPORT NAME=Hands FILE=Textures\WeaponHandsTex.PCX GROUP=Skins       // SKIN1

#exec MESHMAP NEW   MESHMAP=WeaponNapalm MESH=WeaponNapalm
#exec MESHMAP SCALE MESHMAP=WeaponNapalm X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=WeaponNapalm NUM=1 TEXTURE=JNapalmGun0
#exec MESHMAP SETTEXTURE MESHMAP=WeaponNapalm NUM=2 TEXTURE=NapalmScreen
#exec MESHMAP SETTEXTURE MESHMAP=WeaponNapalm NUM=3 TEXTURE=NapalmAmmo1
#exec MESHMAP SETTEXTURE MESHMAP=WeaponNapalm NUM=4 TEXTURE=NapalmAmmo2
#exec MESHMAP SETTEXTURE MESHMAP=WeaponNapalm NUM=5 TEXTURE=Hands
#exec MESHMAP SETTEXTURE MESHMAP=WeaponNapalm NUM=6 TEXTURE=BlackMaskTex

// 3rd Person version
#exec MESH IMPORT MESH=Napalm3rd ANIVFILE=MODELS\Napalm3rd_a.3d DATAFILE=MODELS\Napalm3rd_d.3d X=0 Y=0 Z=0 UNMIRROR=1
#exec MESH ORIGIN MESH=Napalm3rd X=0 Y=0 Z=-2000 YAW=-61 ROLL=-26

#exec MESH SEQUENCE MESH=Napalm3rd SEQ=All          STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=Napalm3rd SEQ=Napalm3rd    STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW   MESHMAP=Napalm3rd MESH=Napalm3rd
#exec MESHMAP SCALE MESHMAP=Napalm3rd X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=Napalm3rd NUM=1 TEXTURE=JNapalmGun0
#exec MESHMAP SETTEXTURE MESHMAP=Napalm3rd NUM=2 TEXTURE=NapalmScreen
#exec MESHMAP SETTEXTURE MESHMAP=Napalm3rd NUM=3 TEXTURE=NapalmAmmo1
#exec MESHMAP SETTEXTURE MESHMAP=Napalm3rd NUM=4 TEXTURE=NapalmAmmo2

// Pickup version
#exec MESH IMPORT MESH=NapalmPickup ANIVFILE=MODELS\NapalmPickup_a.3d DATAFILE=MODELS\NapalmPickup_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=NapalmPickup X=0 Y=0 Z=1500

#exec MESH SEQUENCE MESH=NapalmPickup SEQ=All          STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=NapalmPickup SEQ=NapalmPickup STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW   MESHMAP=NapalmPickup MESH=NapalmPickup
#exec MESHMAP SCALE MESHMAP=NapalmPickup X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=NapalmPickup NUM=1 TEXTURE=JNapalmGun0
#exec MESHMAP SETTEXTURE MESHMAP=NapalmPickup NUM=2 TEXTURE=NapalmScreen
#exec MESHMAP SETTEXTURE MESHMAP=NapalmPickup NUM=3 TEXTURE=NapalmAmmo1
#exec MESHMAP SETTEXTURE MESHMAP=NapalmPickup NUM=4 TEXTURE=NapalmAmmo2

defaultproperties
{
     burnTime=30
     BurnDamage=5
     mpBurnTime=15
     mpBurnDamage=2
     modechange=Sound'DeusExSounds.Generic.Beep1'
     msgNotEnough="Sorry, budski. Not enough napalm left for that firemode."
     msgSwitchedBack="Damn. There isn't enough napalm left to carry on heaving great big globs of it around. Shame."
     msgSwitched="Napalm Launcher is now set to standard firemode. Boring.."
     msgSwitchedAlt="Napalm Launcher is now set to heavy-duty firemode. And I mean: heavy-fucking-duty."
     GoverningSkill=Class'DeusEx.SkillWeaponHeavy'
     NoiseLevel=0.050000
     EnemyEffective=ENMEFF_Organic
     EnviroEffective=ENVEFF_Air
     Concealability=CONC_Visual
     bAutomatic=True
     ShotTime=1.000000
     reloadTime=2.600000
     HitDamage=2
     maxRange=320
     AccurateRange=320
     BaseAccuracy=0.900000
     ScopeFOV=25
     AmmoNames(0)=Class'tnmitems.AmmoNapalmL'
     ProjectileNames(0)=Class'tnmitems.NapalmGlop'
     ProjectileNames(1)=Class'tnmitems.BigNapalmGlop'
     bHasMuzzleFlash=False
     recoilStrength=1.000000
     bCanHaveModBaseAccuracy=True
     bCanHaveModAccurateRange=True
     bCanHaveModReloadTime=True
     bCanHaveModRecoilStrength=True
     AmmoName=Class'AmmoNapalmL'
     ReloadCount=50
     PickupAmmoCount=50
     bWarnTarget=True
     FireOffset=(X=26.000000,Y=-10.000000,Z=-3.000000)
     ProjectileClass=Class'tnmitems.NapalmGlop'
     shakemag=10.000000
     FireSound=Sound'tnmitems.Weapons.NapalmGunFire'
     CockingSound=Sound'tnmitems.Weapons.NapalmGunReload'
     SelectSound=Sound'tnmitems.Weapons.NapalmGunSelect'
     InventoryGroup=35
     ItemName="Napalm Launcher"
     PlayerViewOffset=(X=18.000000,Y=-6.000000,Z=-3.500000)
     PlayerViewMesh=LodMesh'tnmitems.WeaponNapalm'
     PlayerViewScale=0.900000
     PickupViewMesh=LodMesh'tnmitems.NapalmPickup'
     PickupViewScale=1.100000
     ThirdPersonMesh=LodMesh'tnmitems.Napalm3rd'
     ThirdPersonScale=0.800000
     LandSound=Sound'DeusExSounds.Generic.DropLargeWeapon'
     Icon=Texture'tnmitems.BeltIconNapalmLauncher'
     largeIcon=Texture'tnmitems.LargeIconNapalmLauncher'
     largeIconWidth=158
     largeIconHeight=47
     invSlotsX=4
     invSlotsY=1
     Description="UNIQUE WEAPON:|nThis is the kind of weapon which is so far out, it makes you wonder what was  going through the heads of those WorldCorp scientists when they thought this monstrosity up.|n|nThe portable  napalm launcher utilizes special pressurized canisters of napalm mixed with a phosphorus-based polymer to  generate a ream of discrete, highly adhesive, globular-shaped napalm loads that ignite on prolonged contact  with air. Alternatively, the stream can be modulated to generate one heaping great big bastard of a napalm  load.|n|nImpact with particularly unforgiving surfaces, especially vehicles and bots, can lead to accelerated  phosphorus exposure, and thus premature detonation. So be careful, kiddo."
     beltDescription="NAPALM"
     Mesh=LodMesh'tnmitems.NapalmPickup'
     DrawScale=1.100000
     CollisionRadius=20.000000
     CollisionHeight=12.000000
     Mass=50.000000
     bReloadAnimHack=True
}
