//=============================================================================
// WeaponPlasmanade.
//=============================================================================
class WeaponPlasmanade extends TNMWeapon;

//
// Belt and Inventory Icons
//
#exec texture IMPORT NAME=LargeIconPlasmanade FILE=Textures\LargeIconPlasmanade.pcx GROUP=Skins MIPS=off
#exec texture IMPORT NAME=BeltIconPlasmanade FILE=Textures\BeltIconPlasmanade.pcx GROUP=Skins MIPS=off

//
//Player view
//
#exec mesh IMPORT MESH=Plasmanade ANIVFILE=MODELS\Plasmanade_a.3d DATAFILE=MODELS\Plasmanade_d.3d X=0 Y=0 Z=0 UNMIRROR=1
#exec mesh ORIGIN MESH=Plasmanade X=4000 Y=-1000 Z=3000 YAW=128

#exec mesh SEQUENCE MESH=Plasmanade SEQ=All		    STARTFRAME=0	NUMFRAMES=55
#exec mesh SEQUENCE MESH=Plasmanade SEQ=Still		STARTFRAME=0	NUMFRAMES=1
#exec mesh SEQUENCE MESH=Plasmanade SEQ=Select		STARTFRAME=1	NUMFRAMES=8	    	RATE=7	GROUP=Select
#exec mesh SEQUENCE MESH=Plasmanade SEQ=Attack		STARTFRAME=8	NUMFRAMES=14		RATE=11
#exec mesh SEQUENCE MESH=Plasmanade SEQ=Attack2		STARTFRAME=8	NUMFRAMES=14		RATE=11
#exec mesh SEQUENCE MESH=Plasmanade SEQ=Attack3		STARTFRAME=8	NUMFRAMES=14		RATE=11
#exec mesh SEQUENCE MESH=Plasmanade SEQ=Down		STARTFRAME=22	NUMFRAMES=5	     	RATE=7
#exec mesh SEQUENCE MESH=Plasmanade SEQ=Idle1		STARTFRAME=27	NUMFRAMES=10		RATE=3
#exec mesh SEQUENCE MESH=Plasmanade SEQ=Idle2		STARTFRAME=36	NUMFRAMES=10		RATE=3
#exec mesh SEQUENCE MESH=Plasmanade SEQ=Idle3		STARTFRAME=45	NUMFRAMES=10		RATE=3

#exec mesh NOTIFY MESH=Plasmanade SEQ=Attack		TIME=0.6	FUNCTION=MakeLightVis
#exec mesh NOTIFY MESH=Plasmanade SEQ=Attack2		TIME=0.6	FUNCTION=MakeLightVis
#exec mesh NOTIFY MESH=Plasmanade SEQ=Attack3		TIME=0.6	FUNCTION=MakeLightVis

#exec texture IMPORT NAME=JPlasmanade1 FILE=Textures\PlasGrenTex1.PCX GROUP=Skins // GRENADE.E
#exec texture IMPORT NAME=JPlasmanade3 FILE=Textures\PlasGrenTex3.PCX GROUP=Skins // GRENMAIN

#exec MESHMAP NEW   MESHMAP=Plasmanade MESH=Plasmanade
#exec MESHMAP SCALE MESHMAP=Plasmanade X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=Plasmanade NUM=1 TEXTURE=JPlasmanade1
#exec MESHMAP SETTEXTURE MESHMAP=Plasmanade NUM=2 TEXTURE=BlackMaskTex
#exec MESHMAP SETTEXTURE MESHMAP=Plasmanade NUM=3 TEXTURE=JPlasmanade3
#exec MESHMAP SETTEXTURE MESHMAP=Plasmanade NUM=4 TEXTURE=Hands

//
// Plasma Grenade Pickup
//
#exec mesh IMPORT MESH=plasmanadepickup ANIVFILE=MODELS\plasmanadepickup_a.3d DATAFILE=MODELS\plasmanadepickup_d.3d X=0 Y=0 Z=0
#exec mesh ORIGIN MESH=plasmanadepickup X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=plasmanadepickup SEQ=All          STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=plasmanadepickup SEQ=PlasmaPickup STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP new   MESHMAP=plasmanadepickup MESH=plasmanadepickup
#exec MESHMAP scale MESHMAP=plasmanadepickup X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=plasmanadepickup NUM=1 TEXTURE=JPlasmanade1
#exec MESHMAP SETTEXTURE MESHMAP=plasmanadepickup NUM=2 TEXTURE=BlackMaskTex
#exec MESHMAP SETTEXTURE MESHMAP=plasmanadepickup NUM=3 TEXTURE=JPlasmanade3

//
// Plasma Grenade 3RD
//
#exec mesh IMPORT MESH=plasmanade3rd ANIVFILE=MODELS\plasmanadepickup_a.3d DATAFILE=MODELS\plasmanadepickup_d.3d X=0 Y=0 Z=0
#exec mesh ORIGIN MESH=plasmanade3rd X=0 Y=0 Z=4000

#exec mesh SEQUENCE MESH=plasmanade3rd SEQ=All          STARTFRAME=0 NUMFRAMES=1
#exec mesh SEQUENCE MESH=plasmanade3rd SEQ=plasmanade3rd STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP new   MESHMAP=plasmanade3rd MESH=plasmanade3rd
#exec MESHMAP scale MESHMAP=plasmanade3rd X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=plasmanade3rd NUM=1 TEXTURE=JPlasmanade1
#exec MESHMAP SETTEXTURE MESHMAP=plasmanade3rd NUM=2 TEXTURE=BlackMaskTex
#exec MESHMAP SETTEXTURE MESHMAP=plasmanade3rd NUM=3 TEXTURE=JPlasmanade3

var localized String shortName;

simulated function MakeLightVis()
{
	MultiSkins[2] = Texture'effects.fire.flame_b';
	HandToHandAttack();
}

simulated event AnimEnd()
{
	MultiSkins[2] = Texture'BlackMaskTex';
}

//jonas said we didn't want to place it on walls so I scrapped the overloaded Fire -Nick

function BecomePickup()
{
	Super.BecomePickup();
   if (Level.NetMode != NM_Standalone)
      if (bTossedOut)
         Lifespan = 0.0;
}

defaultproperties
{
     ShortName="Vortex"
     LowAmmoWaterMark=2
     GoverningSkill=Class'DeusEx.SkillDemolition'
     EnviroEffective=ENVEFF_Air
     Concealability=CONC_All
     ShotTime=0.300000
     reloadTime=0.100000
     HitDamage=50
     maxRange=4800
     AccurateRange=2400
     BaseAccuracy=1.000000
     bHasMuzzleFlash=False
     bHandToHand=True
     bUseAsDrawnWeapon=False
     AITimeLimit=3.500000
     AIFireDelay=5.000000
     bNeedToSetMPPickupAmmo=False
     mpReloadTime=0.100000
     mpHitDamage=50
     mpBaseAccuracy=1.000000
     mpAccurateRange=2400
     mpMaxRange=2400
     AmmoName=Class'tnmitems.AmmoPlasmaNade'
     ReloadCount=1
     PickupAmmoCount=1
     FireOffset=(Y=10.000000,Z=20.000000)
     ProjectileClass=Class'tnmitems.PlasmaProj'
     shakemag=50.000000
     SelectSound=Sound'DeusExSounds.Weapons.LAMSelect'
     InventoryGroup=50
     ItemName="Vortex Grenade"
     PlayerViewOffset=(X=24.000000,Y=-15.000000,Z=-17.000000)
     PlayerViewMesh=LodMesh'tnmitems.Plasmanade'
     PlayerViewScale=0.600000
     PickupViewMesh=LodMesh'tnmitems.plasmanadepickup'
     PickupViewScale=0.380000
     ThirdPersonMesh=LodMesh'tnmitems.plasmanade3rd'
     ThirdPersonScale=0.190000
     Icon=Texture'tnmitems.Skins.BeltIconPlasmanade'
     largeIcon=Texture'tnmitems.Skins.LargeIconPlasmanade'
     largeIconWidth=35
     largeIconHeight=45
     Description="As far as you can tell from the packaging, this is a highly experimental and morally ambiguous weapon that manipulates dark matter to create a swirling vortex around a tiny black hole, sucking in anything that isn't nailed to the floor and crushing it into a fine paste. Although it doesn't come with safety instructions, it's probably a safe bet that you should stand well clear of the detonation spot."
     beltDescription="VORTEX"
     Texture=Texture'tnmitems.Skins.JPlasmanade1'
     Mesh=LodMesh'tnmitems.plasmanadepickup'
     DrawScale=0.380000
     CollisionRadius=3.800000
     CollisionHeight=3.500000
     Mass=5.000000
     Buoyancy=2.000000
}
