//=============================================================================
// WeaponQdRocket.
//=============================================================================
class WeaponQdRocket extends TNMWeapon;

#exec texture IMPORT NAME=BeltIconQdRocket FILE="Textures\BeltIconQdRocket.pcx" MIPS=off
#exec texture IMPORT NAME=LargeIconQdRocket FILE="Textures\LargeIconQdRocket.pcx" MIPS=off

#exec mesh IMPORT MESH=DblRocket ANIVFILE=MODELS\DblRocket_a.3d DATAFILE=MODELS\DblRocket_d.3d X=0 Y=0 Z=0
#exec mesh ORIGIN MESH=DblRocket X=0 Y=3000 Z=2000 YAW=64

#exec mesh SEQUENCE MESH=DblRocket SEQ=All            STARTFRAME=0  NUMFRAMES=69
#exec mesh SEQUENCE MESH=DblRocket SEQ=Still		  STARTFRAME=0	NUMFRAMES=1
#exec mesh SEQUENCE MESH=DblRocket SEQ=Select	      STARTFRAME=1	NUMFRAMES=10	RATE=8	GROUP=Select
#exec mesh SEQUENCE MESH=DblRocket SEQ=Shoot		  STARTFRAME=10	NUMFRAMES=5		RATE=18
#exec mesh SEQUENCE MESH=DblRocket SEQ=Reload	      STARTFRAME=14	NUMFRAMES=23	RATE=6
#exec mesh SEQUENCE MESH=DblRocket SEQ=Down		      STARTFRAME=36	NUMFRAMES=5		RATE=8
#exec mesh SEQUENCE MESH=DblRocket SEQ=Idle1		  STARTFRAME=41	NUMFRAMES=10	RATE=2
#exec mesh SEQUENCE MESH=DblRocket SEQ=Idle2		  STARTFRAME=50	NUMFRAMES=10	RATE=2
#exec mesh SEQUENCE MESH=DblRocket SEQ=Idle3		  STARTFRAME=59	NUMFRAMES=10    RATE=2

#exec texture IMPORT NAME=JDblRocket1 FILE=Textures\DoubleRocketTex1.pcx GROUP=Skins // MATERIAL #0
#exec texture IMPORT NAME=DblRClip FILE=Textures\DblRockClipTex1.PCX GROUP=Skins // MATERIAL #1
#exec texture IMPORT NAME=Hands FILE=Textures\WeaponHandsTex.PCX GROUP=Skins // MATERIAL #2

#exec MESHMAP NEW   MESHMAP=DblRocket MESH=DblRocket
#exec MESHMAP SCALE MESHMAP=DblRocket X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=DblRocket NUM=1 TEXTURE=JDblRocket1
#exec MESHMAP SETTEXTURE MESHMAP=DblRocket NUM=2 TEXTURE=DblRClip
#exec MESHMAP SETTEXTURE MESHMAP=DblRocket NUM=3 TEXTURE=Hands

//
// Pickup Version
//
#exec mesh IMPORT MESH=DblRocketPickup ANIVFILE=MODELS\DblRocketPickup_a.3d DATAFILE=MODELS\DblRocketPickup_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=DblRocketPickup X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=DblRocketPickup SEQ=All             STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=DblRocketPickup SEQ=DblRocketPickup STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW   MESHMAP=DblRocketPickup MESH=DblRocketPickup
#exec MESHMAP SCALE MESHMAP=DblRocketPickup X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=DblRocketPickup NUM=1 TEXTURE=JDblRocket1

//
// 3RD Person View
//
#exec MESH IMPORT MESH=DblRocket3rd ANIVFILE=MODELS\DblRocket3rd_a.3d DATAFILE=MODELS\DblRocket3rd_d.3d X=0 Y=0 Z=0
#exec mesh ORIGIN MESH=DblRocket3rd X=0 Y=300 Z=-500 YAW=-54 ROLL=-24

#exec mesh SEQUENCE MESH=DblRocket3rd SEQ=All          STARTFRAME=0 NUMFRAMES=1
#exec mesh SEQUENCE MESH=DblRocket3rd SEQ=DblRocket3rd STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW   MESHMAP=DblRocket3rd MESH=DblRocket3rd
#exec MESHMAP scale MESHMAP=DblRocket3rd X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=DblRocket3rd NUM=1 TEXTURE=JDblRocket1

defaultproperties
{
     LowAmmoWaterMark=2
     GoverningSkill=Class'DeusEx.SkillWeaponHeavy'
     NoiseLevel=3.000000
     EnviroEffective=ENVEFF_Air
     Concealability=CONC_Visual
     bAutomatic=True
     ShotTime=1.000000
     reloadTime=3.000000
     HitDamage=100
     maxRange=24000
     AccurateRange=14400
     BaseAccuracy=0.800000
     bCanTrack=True
     LockTime=1.000000
     LockedSound=Sound'tnmitems.Weapons.QuadLauncherLock'
     TrackingSound=Sound'tnmitems.Weapons.QuadLauncherTracking'
     AmmoNames(0)=Class'tnmitems.AmmoQdRocket'
     AmmoNames(1)=Class'tnmitems.AmmoEMPRocket'
     ProjectileNames(0)=Class'tnmitems.QdRocket'
     ProjectileNames(1)=Class'tnmitems.EMPRocket'
     bHasMuzzleFlash=False
     recoilStrength=0.200000
     MinWeaponAcc=0.200000
     mpReloadTime=0.500000
     mpHitDamage=9
     mpBaseAccuracy=1.000000
     mpAccurateRange=2400
     mpMaxRange=2400
     mpReloadCount=30
     bCanHaveModBaseAccuracy=True
     bCanHaveModReloadCount=True
     bCanHaveModAccurateRange=True
     bCanHaveModReloadTime=True
     bCanHaveModRecoilStrength=True
     AmmoName=Class'tnmitems.AmmoQdRocket'
     ReloadCount=4
     PickupAmmoCount=4
     FireOffset=(X=-16.000000,Y=5.000000,Z=11.500000)
     ProjectileClass=Class'tnmitems.QdRocket'
     shakemag=200.000000
     FireSound=Sound'DeusExSounds.Weapons.GEPGunFire'
     CockingSound=Sound'DeusExSounds.Weapons.GEPGunReload'
     SelectSound=Sound'DeusExSounds.Weapons.GEPGunSelect'
     InventoryGroup=38
     ItemName="Quad Rocket Launcher"
     PlayerViewOffset=(X=16.000000,Y=-5.000000,Z=-11.500000)
     PlayerViewMesh=LodMesh'tnmitems.DblRocket'
     PlayerViewScale=0.800000
     PickupViewMesh=LodMesh'tnmitems.DblRocketPickup'
     ThirdPersonMesh=LodMesh'tnmitems.DblRocket3rd'
     ThirdPersonScale=0.800000
     LandSound=Sound'DeusExSounds.Generic.DropMediumWeapon'
     Icon=Texture'tnmitems.BeltIconQdRocket'
     largeIcon=Texture'tnmitems.LargeIconQdRocket'
     largeIconWidth=158
     largeIconHeight=47
     invSlotsX=4
     invSlotsY=1
     Description="UNIQUE WEAPON:|nThis anti-personnel rocket launcher is a product of modern cooling technology; the special coolant liquid inside the barrel maintains a constant temperature, allowing it to discharge up to 4 rockets one after the other. For practical purposes, however, the rockets are quite small and carry a limited charge which is all but useless against armoured targets such as tanks or robots."
     beltDescription="QUADROCKET"
     Mesh=LodMesh'tnmitems.DblRocketPickup'
     CollisionRadius=15.000000
     CollisionHeight=4.800000
     Mass=50.000000
     bReloadAnimHack=True
}
