//=============================================================================
// WeaponScrewDriver.
//=============================================================================
class WeaponScrewDriver extends TNMWeapon;

#exec texture IMPORT NAME=LargeIconTNMScrewDriver FILE=Textures\LargeIconTNMScrewDriver.pcx GROUP=Skins MIPS=off
#exec texture IMPORT NAME=BeltIconTNMScrewDriver FILE=Textures\BeltIconTNMScrewDriver.pcx GROUP=Skins MIPS=off


#exec mesh IMPORT MESH=WeaponScrewDriver ANIVFILE=MODELS\WeaponScrewDriver_a.3d DATAFILE=MODELS\WeaponScrewDriver_d.3d X=0 Y=0 Z=0
#exec mesh ORIGIN MESH=WeaponScrewDriver X=-16000 Y=4000 Z=0 //X - Toward Cam + Away Cam | Y - Right + Left | Z - Up  + Down

#exec mesh SEQUENCE MESH=WeaponScrewDriver SEQ=All          STARTFRAME=0    NUMFRAMES=59
#exec mesh SEQUENCE MESH=WeaponScrewDriver SEQ=Still		STARTFRAME=0	NUMFRAMES=1
#exec mesh SEQUENCE MESH=WeaponScrewDriver SEQ=Select		STARTFRAME=1	NUMFRAMES=6		RATE=7	GROUP=Select
#exec mesh SEQUENCE MESH=WeaponScrewDriver SEQ=Attack		STARTFRAME=6	NUMFRAMES=8		RATE=15
#exec mesh SEQUENCE MESH=WeaponScrewDriver SEQ=Attack2	    STARTFRAME=13	NUMFRAMES=10	RATE=18
#exec mesh SEQUENCE MESH=WeaponScrewDriver SEQ=Attack3	    STARTFRAME=22	NUMFRAMES=10	RATE=24
#exec mesh SEQUENCE MESH=WeaponScrewDriver SEQ=Down		    STARTFRAME=31	NUMFRAMES=6		RATE=10
#exec mesh SEQUENCE MESH=WeaponScrewDriver SEQ=Idle1		STARTFRAME=37	NUMFRAMES=8		RATE=6
#exec mesh SEQUENCE MESH=WeaponScrewDriver SEQ=Idle2		STARTFRAME=44	NUMFRAMES=8		RATE=6
#exec mesh SEQUENCE MESH=WeaponScrewDriver SEQ=Idle3		STARTFRAME=51	NUMFRAMES=8		RATE=6

#exec mesh NOTIFY MESH=WeaponScrewDriver SEQ=Attack		    TIME=0.33	FUNCTION=HandToHandAttack
#exec mesh NOTIFY MESH=WeaponScrewDriver SEQ=Attack2		TIME=0.33	FUNCTION=HandToHandAttack
#exec mesh NOTIFY MESH=WeaponScrewDriver SEQ=Attack3		TIME=0.33	FUNCTION=HandToHandAttack

#exec texture IMPORT NAME=JWeaponScrewDriver1 FILE=Textures\ScrewDriverTex1.PCX GROUP=Skins // MATERIAL #12
#exec texture IMPORT NAME=JWeaponScrewDriver2 FILE=Textures\WeaponHandsTex.PCX GROUP=Skins // MATERIAL #13

#exec MESHMAP new   MESHMAP=WeaponScrewDriver MESH=WeaponScrewDriver
#exec MESHMAP SCALE MESHMAP=WeaponScrewDriver X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=WeaponScrewDriver NUM=1 TEXTURE=JWeaponScrewDriver1
#exec MESHMAP SETTEXTURE MESHMAP=WeaponScrewDriver NUM=2 TEXTURE=JWeaponScrewDriver2

//Pickup Mesh
#exec mesh IMPORT MESH=ScrewDriverPickup ANIVFILE=MODELS\ScrewDriverPickup_a.3d DATAFILE=MODELS\ScrewDriverPickup_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=ScrewDriverPickup X=0 Y=0 Z=0

#exec mesh SEQUENCE MESH=ScrewDriverPickup SEQ=All               STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=ScrewDriverPickup SEQ=\ScrewDriverPickup.uc STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW   MESHMAP=ScrewDriverPickup MESH=ScrewDriverPickup
#exec MESHMAP SCALE MESHMAP=ScrewDriverPickup X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=ScrewDriverPickup NUM=1 TEXTURE=JWeaponScrewDriver1

// 3rd Person Mesh
#exec mesh IMPORT MESH=ScrewDriver3rd ANIVFILE=MODELS\ScrewDriver3rd_a.3d DATAFILE=MODELS\ScrewDriver3rd_d.3d X=0 Y=0 Z=0
#exec mesh ORIGIN MESH=ScrewDriver3rd X=3000 Y=500 Z=4000

#exec MESH SEQUENCE MESH=ScrewDriver3rd SEQ=All            STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=ScrewDriver3rd SEQ=ScrewDriver3rd STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW   MESHMAP=ScrewDriver3rd MESH=ScrewDriver3rd
#exec MESHMAP scale MESHMAP=ScrewDriver3rd X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=ScrewDriver3rd NUM=1 TEXTURE=JWeaponScrewDriver1

defaultproperties
{
     bGetsBloody=True
     LowAmmoWaterMark=0
     GoverningSkill=Class'DeusEx.SkillWeaponLowTech'
     NoiseLevel=0.050000
     EnemyEffective=ENMEFF_Organic
     EnviroEffective=ENVEFF_All
     Concealability=CONC_All
     bEmitWeaponDrawn=False
     reloadTime=0.000000
     HitDamage=3
     maxRange=80
     AccurateRange=80
     BaseAccuracy=1.000000
     bHasMuzzleFlash=False
     bHandToHand=True
     bFallbackWeapon=True
     mpHitDamage=20
     mpBaseAccuracy=1.000000
     mpAccurateRange=96
     mpMaxRange=96
     AmmoName=Class'DeusEx.AmmoNone'
     ReloadCount=0
     bInstantHit=True
     FireOffset=(X=-5.000000,Y=8.000000,Z=14.000000)
     shakemag=20.000000
     FireSound=Sound'DeusExSounds.Weapons.CombatKnifeFire'
     SelectSound=Sound'DeusExSounds.Weapons.CombatKnifeSelect'
     hitfleshsound=Sound'DeusExSounds.Weapons.CombatKnifeHitFlesh'
     hitwoodsound=Sound'DeusExSounds.Weapons.CombatKnifeHitSoft'
     hitmetalsound=Sound'DeusExSounds.Weapons.CombatKnifeHitHard'
     hitothersound=Sound'DeusExSounds.Weapons.CombatKnifeHitHard'
     Misc1Sound=Sound'DeusExSounds.Weapons.CombatKnifeHitFlesh'
     Misc2Sound=Sound'DeusExSounds.Weapons.CombatKnifeHitHard'
     Misc3Sound=Sound'DeusExSounds.Weapons.CombatKnifeHitSoft'
     InventoryGroup=55
     ItemName="Screwdriver"
     PlayerViewOffset=(X=5.000000,Y=-8.000000,Z=-14.000000)
     PlayerViewMesh=LodMesh'tnmitems.WeaponScrewDriver'
     PlayerViewScale=0.400000
     PickupViewMesh=LodMesh'tnmitems.ScrewDriverPickup'
     PickupViewScale=0.500000
     ThirdPersonMesh=LodMesh'tnmitems.ScrewDriver3rd'
     ThirdPersonScale=0.250000
     Icon=Texture'tnmitems.Skins.BeltIconTNMScrewDriver'
     largeIcon=Texture'tnmitems.Skins.LargeIconTNMScrewDriver'
     largeIconWidth=49
     largeIconHeight=45
     Description="It's Scre... Stabbin' Time!"
     beltDescription="SCRW DRVR"
     Mesh=LodMesh'tnmitems.ScrewDriverPickup'
     CollisionRadius=12.650000
     CollisionHeight=0.800000
}
