//=============================================================================
// WeaponShotgun.
//=============================================================================
class WeaponShotgun extends TNMWeapon;

#exec OBJ LOAD FILE=Effects

simulated function renderoverlays(Canvas canvas)
{
   if(bHasLaser)
   {
      multiskins[5] = none;
      if(bLasing)
      	multiskins[7] = texture'WeaponShotgunLaserBeam';
      else
      	multiskins[7] = texture'BlackMaskTex';

   }
   else
   {
      multiskins[5] = texture'pinkmasktex';
      multiskins[7] = texture'BlackMaskTex';
   }
   super.renderoverlays(canvas);
}

//
// PreBeginPlay
//

function PreBeginPlay()
{
	Super.PreBeginPlay();

	CheckWeaponSkins();
}

function DropFrom(vector StartLocation)
{
	checkweaponskins();

	super.dropfrom(startlocation);
}

function BringUp()
{
	CheckWeaponSkins();

	Super.BringUp();
}

Function CheckWeaponSkins()
{
   if(bHasLaser)
   {
      multiskins[5] = none;
      if(bLasing)
      	multiskins[7] = texture'WeaponShotgunLaserBeam';
      else
      	multiskins[7] = texture'BlackMaskTex';

   }
   else
   {
      multiskins[5] = texture'pinkmasktex';
      multiskins[7] = texture'BlackMaskTex';
   }
}

function LaserOn()
{
	super.LaserOn();

	if(bLasing)
		Multiskins[7] = texture'WeaponShotgunLaserBeam';
	else
		multiskins[7] = texture'BlackMaskTex';
}

function LaserOff()
{
	super.LaserOff();

	if(bLasing)
		Multiskins[7] = texture'WeaponShotgunLaserBeam';
	else
		multiskins[7] = texture'BlackMaskTex';
}


// Muzzle Flash Stuff
// called from the MESH NOTIFY Copied from DeusexWeapons.uc and modified...
//
simulated function SwapMuzzleFlashTexture()
{
     if (!bHasMuzzleFlash)
     return;
       MultiSkins[4] = Texture'DeusExItems.Skins.FlatFXTex34';

     MuzzleFlashLight();
     SetTimer(0.1, False);
}

simulated function EraseMuzzleFlashTexture()
{
     MultiSkins[4] = None;
}

simulated function Timer()
{
     EraseMuzzleFlashTexture();
}

simulated function MuzzleFlashLight()
{
     local Vector offset, X, Y, Z;
     local Effects flash;

      if (!bHasMuzzleFlash)
          return;

     if ((flash != None) && !flash.bDeleteMe)
          flash.LifeSpan = flash.Default.LifeSpan;
     else
     {
          GetAxes(Pawn(Owner).ViewRotation,X,Y,Z);
          offset = Owner.Location;
          offset += X * Owner.CollisionRadius * 2;
          flash = spawn(class'Muzzleflash',,, offset);
          if (flash != None)
               flash.SetBase(Owner);
     }
}


//
// Belt and Inventory Icons
//
#exec texture IMPORT NAME=LargeIconTNMShotgun FILE=Textures\LargeIconTNMShotgun.pcx GROUP=Skins MIPS=off
#exec texture IMPORT NAME=BeltIconTNMShotgun FILE=Textures\BeltIconTNMShotgun.pcx GROUP=Skins MIPS=off

#exec mesh IMPORT MESH=WeaponShotgun ANIVFILE=MODELS\WeaponShotgun_a.3d DATAFILE=MODELS\WeaponShotgun_d.3d X=0 Y=0 Z=0 UNMIRROR=1
#exec mesh ORIGIN MESH=WeaponShotgun X=2000 Y=-2000 Z=-2000 YAW=128 PITCH=-8

#exec mesh SEQUENCE MESH=WeaponShotgun SEQ=All     STARTFRAME=0 NUMFRAMES=68
#exec MESH SEQUENCE MESH=WeaponShotgun SEQ=Still   STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=WeaponShotgun SEQ=Select  STARTFRAME=1 NUMFRAMES=8     RATE=8 GROUP=Select
#exec mesh SEQUENCE MESH=WeaponShotgun SEQ=Shoot   STARTFRAME=8 NUMFRAMES=12    RATE=10
#exec mesh SEQUENCE MESH=WeaponShotgun SEQ=Reload  STARTFRAME=19 NUMFRAMES=18   RATE=9
#exec mesh SEQUENCE MESH=WeaponShotgun SEQ=Idle1   STARTFRAME=36 NUMFRAMES=10   RATE=4
#exec mesh SEQUENCE MESH=WeaponShotgun SEQ=Idle2   STARTFRAME=45 NUMFRAMES=10   RATE=4
#exec mesh SEQUENCE MESH=WeaponShotgun SEQ=Idle3   STARTFRAME=54 NUMFRAMES=10   RATE=4
#exec mesh SEQUENCE MESH=WeaponShotgun SEQ=Down    STARTFRAME=63 NUMFRAMES=5    RATE=14

#exec mesh NOTIFY MESH=WeaponShotgun SEQ=Shoot     TIME=0.03     FUNCTION=SwapMuzzleFlashTexture

#exec texture IMPORT NAME=WeaponShotgunTex FILE=Textures\ShotgunTex1.PCX GROUP=Skins // MainTex
#exec texture IMPORT NAME=WeaponShotgunScreen FILE=Textures\ShotgunScreen.PCX GROUP=Skins // Screen
#exec texture IMPORT NAME=WeaponShotgunClip FILE=Textures\ShotgunClip.PCX GROUP=Skins // Clip
#exec texture IMPORT NAME=WeaponShotgunLaser FILE=Textures\ShotgunLaser.PCX GROUP=Skins // Laser
#exec texture IMPORT NAME=WeaponShotgunLaserBeam FILE=Textures\ShotgunLaserBeam.PCX GROUP=Skins // Laserbeam
#exec texture IMPORT NAME=WeaponShotgunGlass FILE=Textures\ShotgunGlass.PCX GROUP=Skins // Glass

#exec MESHMAP NEW   MESHMAP=WeaponShotgun MESH=WeaponShotgun
#exec MESHMAP SCALE MESHMAP=WeaponShotgun X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=WeaponShotgun NUM=1 TEXTURE=WeaponShotgunTex   //MainTex
#exec MESHMAP SETTEXTURE MESHMAP=WeaponShotgun NUM=2 TEXTURE=WeaponShotgunScreen   //Screen
#exec MESHMAP SETTEXTURE MESHMAP=WeaponShotgun NUM=3 TEXTURE=WeaponShotgunClip           //Clip
#exec MESHMAP SETTEXTURE MESHMAP=WeaponShotgun NUM=4 TEXTURE=BlackMaskTex     //MuzzleFlash
#exec MESHMAP SETTEXTURE MESHMAP=WeaponShotgun NUM=5 TEXTURE=WeaponShotgunLaser     //Laser
#exec MESHMAP SETTEXTURE MESHMAP=WeaponShotgun NUM=6 TEXTURE=WeaponShotgunGlass     //Glass
#exec MESHMAP SETTEXTURE MESHMAP=WeaponShotgun NUM=8 TEXTURE=WeaponHandsTex   //Hands

//
// Shotgun Pickup
//
#exec mesh IMPORT MESH=TNMShotgunPickup ANIVFILE=MODELS\TNMShotgunPickup_a.3d DATAFILE=MODELS\TNMShotgunPickup_d.3d X=0 Y=0 Z=0 UNMIRROR=1
#exec mesh ORIGIN MESH=TNMShotgunPickup X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=TNMShotgunPickup SEQ=All           STARTFRAME=0 NUMFRAMES=1
#exec mesh SEQUENCE MESH=TNMShotgunPickup SEQ=Still         STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP new   MESHMAP=TNMShotgunPickup MESH=ShotgunPickup
#exec MESHMAP SCALE MESHMAP=TNMShotgunPickup X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=TNMShotgunPickup NUM=1 TEXTURE=WeaponShotgunTex
#exec MESHMAP SETTEXTURE MESHMAP=TNMShotgunPickup NUM=2 TEXTURE=WeaponShotgunScreen
#exec MESHMAP SETTEXTURE MESHMAP=TNMShotgunPickup NUM=3 TEXTURE=WeaponShotgunClip
#exec MESHMAP SETTEXTURE MESHMAP=TNMShotgunPickup NUM=4 TEXTURE=BlackMaskTex
#exec MESHMAP SETTEXTURE MESHMAP=TNMShotgunPickup NUM=5 TEXTURE=WeaponShotgunLaser
#exec MESHMAP SETTEXTURE MESHMAP=TNMShotgunPickup NUM=6 TEXTURE=WeaponShotgunGlass

//
// Shotgun 3rd
//
#exec mesh IMPORT MESH=TNMShotgun3rd ANIVFILE=MODELS\TNMShotgun3rd_a.3d DATAFILE=MODELS\TNMShotgun3rd_d.3d X=0 Y=0 Z=0
#exec mesh ORIGIN MESH=TNMShotgun3rd X=0 Y=-1000 Z=0 YAW=64 ROLL=22

#exec MESH SEQUENCE MESH=TNMShotgun3rd SEQ=All        STARTFRAME=0 NUMFRAMES=1
#exec mesh SEQUENCE MESH=TNMShotgun3rd SEQ=Still      STARTFRAME=0 NUMFRAMES=1 RATE=10
#exec mesh SEQUENCE MESH=TNMShotgun3rd SEQ=Shoot      STARTFRAME=0 NUMFRAMES=1 RATE=10

#exec mesh NOTIFY MESH=TNMShotgun3rd SEQ=Shoot     TIME=0.03     FUNCTION=SwapMuzzleFlashTexture

#exec MESHMAP new   MESHMAP=TNMShotgun3rd MESH=TNMShotgun3rd
#exec MESHMAP SCALE MESHMAP=TNMShotgun3rd X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=TNMShotgun3rd NUM=1 TEXTURE=WeaponShotgunTex
#exec MESHMAP SETTEXTURE MESHMAP=TNMShotgun3rd NUM=2 TEXTURE=WeaponShotgunScreen
#exec MESHMAP SETTEXTURE MESHMAP=TNMShotgun3rd NUM=3 TEXTURE=WeaponShotgunClip
#exec MESHMAP SETTEXTURE MESHMAP=TNMShotgun3rd NUM=4 TEXTURE=BlackMaskTex
#exec MESHMAP SETTEXTURE MESHMAP=TNMShotgun3rd NUM=5 TEXTURE=WeaponShotgunLaser
#exec MESHMAP SETTEXTURE MESHMAP=TNMShotgun3rd NUM=6 TEXTURE=WeaponShotgunGlass

defaultproperties
{
     bReloadAnimHack=True
     LowAmmoWaterMark=8
     GoverningSkill=Class'DeusEx.SkillWeaponRifle'
     EnviroEffective=ENVEFF_Air
     Concealability=CONC_Visual
     ShotTime=0.300000
     reloadTime=1.500000
     HitDamage=4
     maxRange=3000
     AccurateRange=1500
     BaseAccuracy=0.400000
     bCanHaveLaser=True
     AmmoNames(0)=Class'DeusEx.AmmoShell'
     AmmoNames(1)=Class'DeusEx.AmmoSabot'
     AreaOfEffect=AOE_Cone
     recoilStrength=0.800000
     mpReloadTime=0.500000
     mpHitDamage=9
     mpBaseAccuracy=0.200000
     mpAccurateRange=1200
     mpMaxRange=1200
     mpReloadCount=12
     mpPickupAmmoCount=12
     bCanHaveModReloadCount=True
     bCanHaveModReloadTime=True
     bCanHaveModRecoilStrength=True
     AmmoName=Class'DeusEx.AmmoShell'
     ReloadCount=8
     PickupAmmoCount=8
     bInstantHit=True
     FireOffset=(X=-11.000000,Y=4.000000,Z=13.000000)
     shakemag=50.000000
     FireSound=Sound'tnmitems.Weapons.PumpGunFire'
     CockingSound=Sound'tnmitems.Weapons.PumpGunReload'
     SelectSound=Sound'tnmitems.Weapons.PumpGunSelect'
     InventoryGroup=36
     ItemName="Pumpgun"
     PlayerViewOffset=(X=11.000000,Y=-4.000000,Z=-13.000000)
     PlayerViewMesh=LodMesh'tnmitems.WeaponShotgun'
     PlayerViewScale=0.500000
     PickupViewMesh=LodMesh'tnmitems.TNMShotgunPickup'
     PickupViewScale=1.500000
     ThirdPersonMesh=LodMesh'tnmitems.TNMShotgun3rd'
     LandSound=Sound'DeusExSounds.Generic.DropMediumWeapon'
     Icon=Texture'tnmitems.Skins.BeltIconTNMShotgun'
     largeIcon=Texture'tnmitems.Skins.LargeIconTNMShotgun'
     largeIconWidth=131
     largeIconHeight=45
     invSlotsX=3
     Description="The pump-action shotgun has a longer barrel than the standard sawed-off, resulting in a higher accuracy and a longer range to make up for the smaller spread of the pellets. Because it's clip-loaded, it will also hold 8 shells as opposed to the 4-shell capacity of the sawed-off, and it's faster to reload."
     beltDescription="PUMPGUN"
     Mesh=LodMesh'tnmitems.TNMShotgunPickup'
     DrawScale=1.500000
     CollisionRadius=12.000000
     CollisionHeight=0.900000
     Mass=30.000000
}
