//=============================================================================
// WeaponSpork.
//=============================================================================
class WeaponSpork extends TNMWeapon;

// Belt and Inventory Icons
#exec TEXTURE IMPORT NAME=BeltIconSpork FILE=Textures\BeltIconSpork.pcx GROUP=Icons MIPS=off // Belt Icon
#exec TEXTURE IMPORT NAME=LargeIconSpork FILE=Textures\LargeIconSpork.pcx GROUP=Icons MIPS=off // Iventory Icon

//
// First Person View.
//
#exec MESH IMPORT MESH=WeaponSpork ANIVFILE=MODELS\WeaponSpork_a.3d DATAFILE=MODELS\WeaponSpork_d.3d X=0 Y=0 Z=0
#exec mesh ORIGIN MESH=WeaponSpork X=4000 Y=-8000 Z=-4000 Yaw=64  // (Y=-4000)

#exec MESH SEQUENCE MESH=WeaponSpork SEQ=All		STARTFRAME=0	NUMFRAMES=58
#exec MESH SEQUENCE MESH=WeaponSpork SEQ=Still		STARTFRAME=0	NUMFRAMES=1
#exec mesh SEQUENCE MESH=WeaponSpork SEQ=Select		STARTFRAME=1	NUMFRAMES=5		RATE=4	GROUP=Select
#exec mesh SEQUENCE MESH=WeaponSpork SEQ=Attack		STARTFRAME=5	NUMFRAMES=8		RATE=12
#exec mesh SEQUENCE MESH=WeaponSpork SEQ=Attack2	STARTFRAME=12	NUMFRAMES=12	RATE=12
#exec mesh SEQUENCE MESH=WeaponSpork SEQ=Attack3	STARTFRAME=23	NUMFRAMES=8		RATE=8
#exec mesh SEQUENCE MESH=WeaponSpork SEQ=Down		STARTFRAME=30	NUMFRAMES=4		RATE=8
#exec MESH SEQUENCE MESH=WeaponSpork SEQ=Idle1		STARTFRAME=34	NUMFRAMES=8		RATE=2
#exec MESH SEQUENCE MESH=WeaponSpork SEQ=Idle2		STARTFRAME=41	NUMFRAMES=8		RATE=2
#exec mesh SEQUENCE MESH=WeaponSpork SEQ=Idle3		STARTFRAME=48	NUMFRAMES=10	RATE=12

#exec TEXTURE IMPORT NAME=JWeaponSpork1 FILE=Textures\Spork.PCX GROUP=Skins // ENVMAPPED
#exec TEXTURE IMPORT NAME=JWeaponSpork2 FILE=Textures\WeaponHandsTex.PCX GROUP=Skins // Material #1

#exec MESHMAP NEW   MESHMAP=WeaponSpork MESH=WeaponSpork
#exec MESHMAP SCALE MESHMAP=WeaponSpork X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=WeaponSpork NUM=1 TEXTURE=JWeaponSpork1
#exec MESHMAP SETTEXTURE MESHMAP=WeaponSpork NUM=2 TEXTURE=JWeaponSpork2

//
// Attack Information
//
#exec MESH NOTIFY MESH=WeaponSpork SEQ=Attack          TIME=0.5     FUNCTION=HandToHandAttack
#exec MESH NOTIFY MESH=WeaponSpork SEQ=Attack2          TIME=0.5     FUNCTION=HandToHandAttack
#exec MESH NOTIFY MESH=WeaponSpork SEQ=Attack3          TIME=0.5     FUNCTION=HandToHandAttack


//
// Third person
//
#exec MESH IMPORT MESH=3rdSpork ANIVFILE=MODELS\3rdSpork_a.3d DATAFILE=MODELS\3rdSpork_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=3rdSpork X=0 Y=10000 Z=5000 YAW=-64 ROLL=24 //PITCH=-64

#exec MESH SEQUENCE MESH=3rdSpork SEQ=All   STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=3rdSpork SEQ=Spork STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW   MESHMAP=3rdSpork MESH=3rdSpork
#exec MESHMAP SCALE MESHMAP=3rdSpork X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=3rdSpork NUM=0 TEXTURE=JWeaponSpork1


//
// pickup mesh
//
#exec MESH IMPORT MESH=PickupSpork ANIVFILE=MODELS\3rdSpork_a.3d DATAFILE=MODELS\3rdSpork_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=PickupSpork X=0 Y=-1500 Z=0

#exec MESH SEQUENCE MESH=PickupSpork SEQ=All   STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=PickupSpork SEQ=Spork STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW   MESHMAP=PickupSpork MESH=3rdSpork
#exec MESHMAP SCALE MESHMAP=PickupSpork X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=PickupSpork NUM=0 TEXTURE=JWeaponSpork1

defaultproperties
{
     hitfleshsound=Sound'DeusExSounds.Weapons.CombatKnifeHitFlesh'
     hitwoodsound=Sound'DeusExSounds.Weapons.CombatKnifeHitSoft'
     hitmetalsound=Sound'DeusExSounds.Weapons.CombatKnifeHitHard'
     hitothersound=Sound'DeusExSounds.Weapons.CombatKnifeHitHard'
     Misc1Sound=Sound'DeusExSounds.Weapons.CombatKnifeHitFlesh'
     Misc2Sound=Sound'DeusExSounds.Weapons.CombatKnifeHitHard'
     Misc3Sound=Sound'DeusExSounds.Weapons.CombatKnifeHitSoft'
     LowAmmoWaterMark=0
     GoverningSkill=Class'DeusEx.SkillWeaponLowTech'
     NoiseLevel=0.050000
     EnemyEffective=ENMEFF_Organic
     EnviroEffective=ENVEFF_All
     Concealability=CONC_Visual
     reloadTime=0.000000
     HitDamage=8
     maxRange=80
     AccurateRange=70
     BaseAccuracy=1.000000
     bHandToHand=True
     mpHitDamage=20
     mpBaseAccuracy=0.700000
     mpAccurateRange=70
     mpMaxRange=80
     AmmoName=Class'DeusEx.AmmoNone'
     ReloadCount=0
     bInstantHit=True
     FireOffset=(X=22.000000,Y=-10.000000,Z=14.000000)
     shakemag=20.000000
     FireSound=Sound'DeusExSounds.Weapons.CombatKnifeFire'
     SelectSound=Sound'DeusExSounds.Weapons.CombatKnifeSelect'
     InventoryGroup=57
     ItemName="Spork"
     PlayerViewOffset=(X=28.000000,Y=-10.000000,Z=-11.500000)
     PlayerViewMesh=LodMesh'tnmitems.WeaponSpork'
     PlayerViewScale=0.400000
     PickupViewMesh=LodMesh'tnmitems.PickupSpork'
     PickupViewScale=0.300000
     ThirdPersonMesh=LodMesh'tnmitems.3rdSpork'
     ThirdPersonScale=0.200000
     Icon=Texture'BeltIconSpork'
     largeIcon=Texture'LargeIconSpork'
     largeIconWidth=101
     largeIconHeight=43
     invSlotsX=2
     Description="The spork is a favored weapon by the Llama cult; this one was crafted from plain, reliable steel. Good for eating soup or salad, or killing people crudely."
     beltDescription="SPORK"
     Texture=Texture'tnmitems.Skins.JWeaponSpork1'
     Mesh=LodMesh'tnmitems.3rdSpork'
     DrawScale=0.300000
     CollisionRadius=14.500000
     CollisionHeight=2.000000
}
