//=============================================================================
// WeaponSporkGolden.
//=============================================================================
class WeaponSporkGolden extends TNMWeapon;

// Belt and Inventory Icons
#exec TEXTURE IMPORT NAME=BeltIconSporkG FILE=Textures\BeltIconSporkGold.pcx GROUP=Icons MIPS=off // Belt Icon
#exec TEXTURE IMPORT NAME=LargeIconSporkG FILE=Textures\LargeIconSporkGold.pcx GROUP=Icons MIPS=off // Iventory Icon

//
// First Person View.
//
#exec MESH IMPORT MESH=WeaponSpork ANIVFILE=MODELS\WeaponSpork_a.3d DATAFILE=MODELS\WeaponSpork_d.3d X=0 Y=0 Z=0
#exec mesh ORIGIN MESH=WeaponSpork X=4000 Y=-8000 Z=-4000 Yaw=64  //(Y=-4000)

#exec MESH SEQUENCE MESH=WeaponSpork SEQ=All		STARTFRAME=0	NUMFRAMES=58
#exec MESH SEQUENCE MESH=WeaponSpork SEQ=Still		STARTFRAME=0	NUMFRAMES=1
#exec mesh SEQUENCE MESH=WeaponSpork SEQ=Select		STARTFRAME=1	NUMFRAMES=5		RATE=4	GROUP=Select
#exec mesh SEQUENCE MESH=WeaponSpork SEQ=Attack		STARTFRAME=5	NUMFRAMES=8		RATE=18
#exec mesh SEQUENCE MESH=WeaponSpork SEQ=Attack2	STARTFRAME=12	NUMFRAMES=12		RATE=18
#exec mesh SEQUENCE MESH=WeaponSpork SEQ=Attack3	STARTFRAME=23	NUMFRAMES=8		RATE=12
#exec mesh SEQUENCE MESH=WeaponSpork SEQ=Down		STARTFRAME=30	NUMFRAMES=4		RATE=8
#exec MESH SEQUENCE MESH=WeaponSpork SEQ=Idle1		STARTFRAME=34	NUMFRAMES=8		RATE=2
#exec MESH SEQUENCE MESH=WeaponSpork SEQ=Idle2		STARTFRAME=41	NUMFRAMES=8		RATE=2
#exec mesh SEQUENCE MESH=WeaponSpork SEQ=Idle3		STARTFRAME=48	NUMFRAMES=10		RATE=12

#exec TEXTURE IMPORT NAME=JWeaponSporkG1 FILE=Textures\SporkGold.PCX GROUP=Skins // ENVMAPPED
#exec TEXTURE IMPORT NAME=JWeaponSporkG2 FILE=Textures\WeaponHandsTex.PCX GROUP=Skins // Material #1

#exec MESHMAP NEW   MESHMAP=WeaponSpork MESH=WeaponSpork
#exec MESHMAP SCALE MESHMAP=WeaponSpork X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=WeaponSpork NUM=1 TEXTURE=JWeaponSporkG1
#exec MESHMAP SETTEXTURE MESHMAP=WeaponSpork NUM=2 TEXTURE=JWeaponSporkG2

//
// Attack Information
//
#exec MESH NOTIFY MESH=WeaponSpork SEQ=Attack           TIME=0.33     FUNCTION=HandToHandAttack
#exec MESH NOTIFY MESH=WeaponSpork SEQ=Attack2          TIME=0.33     FUNCTION=HandToHandAttack
#exec MESH NOTIFY MESH=WeaponSpork SEQ=Attack3          TIME=0.33     FUNCTION=HandToHandAttack


//
// Third person
//
#exec MESH IMPORT MESH=3rdSpork ANIVFILE=MODELS\3rdSpork_a.3d DATAFILE=MODELS\3rdSpork_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=3rdSpork X=0 Y=10000 Z=5000 YAW=-64 ROLL=24 //PITCH=-64

#exec MESH SEQUENCE MESH=3rdSpork SEQ=All   STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=3rdSpork SEQ=Spork STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW   MESHMAP=3rdSpork MESH=3rdSpork
#exec MESHMAP SCALE MESHMAP=3rdSpork X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=3rdSpork NUM=0 TEXTURE=JWeaponSporkG1


//
// pickup mesh
//
#exec MESH IMPORT MESH=PickupSpork ANIVFILE=MODELS\3rdSpork_a.3d DATAFILE=MODELS\3rdSpork_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=PickupSpork X=0 Y=-1500 Z=0

#exec MESH SEQUENCE MESH=PickupSpork SEQ=All   STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=PickupSpork SEQ=Spork STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW   MESHMAP=PickupSpork MESH=3rdSpork
#exec MESHMAP SCALE MESHMAP=PickupSpork X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=PickupSpork NUM=0 TEXTURE=JWeaponSporkG1

defaultproperties
{
     hitfleshsound=Sound'DeusExSounds.Weapons.CombatKnifeHitFlesh'
     hitwoodsound=Sound'DeusExSounds.Weapons.CombatKnifeHitSoft'
     hitmetalsound=Sound'DeusExSounds.Weapons.CombatKnifeHitHard'
     hitothersound=Sound'DeusExSounds.Weapons.CombatKnifeHitHard'
     Misc1Sound=Sound'DeusExSounds.Weapons.CombatKnifeHitFlesh'
     Misc2Sound=Sound'DeusExSounds.Weapons.CombatKnifeHitHard'
     Misc3Sound=Sound'DeusExSounds.Weapons.CombatKnifeHitSoft'
     LowAmmoWaterMark=0
     GoverningSkill=Class'DeusEx.SkillWeaponLowTech'
     NoiseLevel=0.050000
     EnemyEffective=ENMEFF_Organic
     EnviroEffective=ENVEFF_All
     Concealability=CONC_Visual
     ShotTime=0.400000
     reloadTime=0.000000
     HitDamage=20
     maxRange=80
     AccurateRange=70
     BaseAccuracy=1.000000
     bHandToHand=True
     mpHitDamage=20
     mpBaseAccuracy=0.700000
     mpAccurateRange=70
     mpMaxRange=80
     AmmoName=Class'DeusEx.AmmoNone'
     ReloadCount=0
     bInstantHit=True
     FireOffset=(X=22.000000,Y=-10.000000,Z=14.000000)
     shakemag=20.000000
     FireSound=Sound'TNMItems.Weapons.sporkFire'
     SelectSound=Sound'TNMItems.Weapons.sporkSelect'
     InventoryGroup=37
     ItemName="Golden Spork of Righteousness(R)"
     ItemArticle="the"
     PlayerViewOffset=(X=28.000000,Y=-10.000000,Z=-11.500000)
     PlayerViewMesh=LodMesh'TNMItems.WeaponSpork'
     PlayerViewScale=0.400000
     PickupViewMesh=LodMesh'TNMItems.PickupSpork'
     PickupViewScale=0.300000
     ThirdPersonMesh=LodMesh'TNMItems.3rdSpork'
     ThirdPersonScale=0.200000
     Icon=Texture'BeltIconSporkG'
     largeIcon=Texture'LargeIconSporkG'
     largeIconWidth=101
     largeIconHeight=43
     invSlotsX=2
     Description="UNIQUE WEAPON:|nIts THE GOLDEN SPORK OF RIGHTEOUSNESS(R), most holy relic of the Llama Religion. This was once an artifact belonging to the powerful and enigmatic Order of the Golden Spork(R) which had gathered many followers in The Nameless Boards, but as the boards went down, so did the order. Nobody ever really knew what happened to the Golden Spork(R), but apparently it found its way to the worshippers of Lamar, who kept it in their subterranean halls under the Central District of Forum City up until you came along."
     beltDescription="GOLDSPORK"
     Texture=Texture'TNMItems.Skins.JWeaponSporkG1'
     Mesh=LodMesh'TNMItems.3rdSpork'
     DrawScale=0.300000
     CollisionRadius=13.000000
     CollisionHeight=4.000000
}
