class WeaponTNMRifle extends TNMWeapon;

//var float	NoScopeMult;

simulated function renderoverlays(Canvas canvas)
{
   if(bHasSilencer)
      multiskins[4] = none;
   else
      multiskins[4] = texture'pinkmasktex';
   if(bHasLaser)
      multiskins[3] = none;
   else
      multiskins[3] = texture'pinkmasktex';

   super.renderoverlays(canvas);

   if(bHasSilencer)
      multiskins[3] = none;
   else
      multiskins[3] = texture'pinkmasktex';
   if(bHasLaser)
      multiskins[4] = none;
   else
      multiskins[4] = texture'pinkmasktex';
}

function CheckWeaponSkins() //called on drop/pickup etc
{

	if(bHasSilencer)
		multiskins[3] = none;
	else
		multiskins[3] = texture'pinkmasktex';
	if(bHasLaser)
		multiskins[4] = none;
	else
		multiskins[4] = texture'pinkmasktex';

}

// Muzzle Flash Stuff
simulated function SwapMuzzleFlashTexture()
{
     if (!bHasMuzzleFlash)
     return;
       MultiSkins[7] = Texture'DeusExItems.Skins.FlatFXTex34';

     MuzzleFlashLight();
     SetTimer(0.1, False);
}

simulated function EraseMuzzleFlashTexture()
{
     MultiSkins[7] = None;
}

simulated function Timer()
{
     EraseMuzzleFlashTexture();
}

simulated function MuzzleFlashLight()
{
     local Vector offset, X, Y, Z;
     local Effects flash;

      if (!bHasMuzzleFlash)
          return;

     if ((flash != None) && !flash.bDeleteMe)
          flash.LifeSpan = flash.Default.LifeSpan;
     else
     {
          GetAxes(Pawn(Owner).ViewRotation,X,Y,Z);
          offset = Owner.Location;
          offset += X * Owner.CollisionRadius * 2;
          flash = spawn(class'Muzzleflash',,, offset);
          if (flash != None)
               flash.SetBase(Owner);
     }
}


simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	// If this is a netgame, then override defaults
	if ( Level.NetMode != NM_StandAlone )
	{
		HitDamage = mpHitDamage;
		BaseAccuracy = mpBaseAccuracy;
		ReloadTime = mpReloadTime;
		AccurateRange = mpAccurateRange;
		MaxRange = mpMaxRange;
		ReloadCount = mpReloadCount;
      bHasMuzzleFlash = True;
      ReloadCount = 1;
      ReloadTime = ShotTime;
	}
}


//
// Icons
//
#exec texture IMPORT NAME=HDTPLargeIconRifle FILE=Textures\LargeIconRifle.pcx MIPS=off  //LargeIconRifle
#exec texture IMPORT NAME=HDTPBeltIconRifle  FILE=Textures\BeltIconRifle.pcx MIPS=off   //BeltIconRifle


//
// First Person
//
#exec mesh IMPORT MESH=HDTPWeaponRifle ANIVFILE=MODELS\HDTPWeaponRifle_a.3d DATAFILE=MODELS\HDTPWeaponRifle_d.3d X=0 Y=0 Z=0
#exec mesh ORIGIN MESH=HDTPWeaponRifle X=-4000 Y=-2000 Z=-6000   //(Z -up +Down Y -Right +Left x +Back -Forward

#exec mesh SEQUENCE MESH=HDTPWeaponRifle SEQ=All		     STARTFRAME=0	NUMFRAMES=81
#exec mesh SEQUENCE MESH=HDTPWeaponRifle SEQ=Still		     STARTFRAME=0	NUMFRAMES=1
#exec mesh SEQUENCE MESH=HDTPWeaponRifle SEQ=Select		     STARTFRAME=1	NUMFRAMES=10	RATE=24 GROUP=Select
#exec mesh SEQUENCE MESH=HDTPWeaponRifle SEQ=Shoot		     STARTFRAME=10	NUMFRAMES=6	RATE=15
#exec mesh SEQUENCE MESH=HDTPWeaponRifle SEQ=Down		     STARTFRAME=15	NUMFRAMES=3	RATE=8

#exec mesh SEQUENCE MESH=HDTPWeaponRifle SEQ=Reload		     STARTFRAME=18	NUMFRAMES=33	RATE=12

/*#exec mesh SEQUENCE MESH=HDTPWeaponRifle SEQ=ReloadBegin	     STARTFRAME=18	NUMFRAMES=4	RATE=8       I've left these in here just incase
#exec mesh SEQUENCE MESH=HDTPWeaponRifle SEQ=Reload		     STARTFRAME=21	NUMFRAMES=27	RATE=16      but I think it should be fine with
#exec mesh SEQUENCE MESH=HDTPWeaponRifle SEQ=ReloadEnd	     	     STARTFRAME=47	NUMFRAMES=4	RATE=6      just the one reload sequence.*/

#exec mesh SEQUENCE MESH=HDTPWeaponRifle SEQ=Idle1		     STARTFRAME=50	NUMFRAMES=10	RATE=3
#exec mesh SEQUENCE MESH=HDTPWeaponRifle SEQ=Idle2		     STARTFRAME=59	NUMFRAMES=10	RATE=3
#exec mesh SEQUENCE MESH=HDTPWeaponRifle SEQ=Idle3		     STARTFRAME=68	NUMFRAMES=10	RATE=3
#exec mesh SEQUENCE MESH=HDTPWeaponRifle SEQ=Zoom		     STARTFRAME=77	NUMFRAMES=5     RATE=6

#exec mesh NOTIFY MESH=HDTPWeaponRifle SEQ=Shoot	TIME=0.02	FUNCTION=SwapMuzzleFlashTexture

#exec texture IMPORT NAME=HDTPWeaponRifle1 FILE=Textures\SniperRifleTex1.pcx GROUP=Skins // SNIPERTEX1
#exec texture IMPORT NAME=HDTPWeaponRifle2 FILE=Textures\SniperRifleTex2.pcx GROUP=Skins // SNIPERTEX2
#exec texture IMPORT NAME=HDTPWeaponRifleShine FILE=Textures\SniperRifleLensShine.pcx GROUP=Skins // LENSSHINE.ET

#exec MESHMAP new   MESHMAP=HDTPWeaponRifle MESH=HDTPWeaponRifle
#exec MESHMAP scale MESHMAP=HDTPWeaponRifle X=0.002734375 Y=0.002734375 Z=0.002734375

#exec MESHMAP SETTEXTURE MESHMAP=HDTPWeaponRifle NUM=1 TEXTURE=HDTPWeaponRifle1
#exec MESHMAP SETTEXTURE MESHMAP=HDTPWeaponRifle NUM=2 TEXTURE=HDTPWeaponRifle2
#exec MESHMAP SETTEXTURE MESHMAP=HDTPWeaponRifle NUM=3 TEXTURE=HDTPWeaponRifle1  //Laser
#exec MESHMAP SETTEXTURE MESHMAP=HDTPWeaponRifle NUM=4 TEXTURE=HDTPWeaponRifle1  //Silencer
#exec MESHMAP SETTEXTURE MESHMAP=HDTPWeaponRifle NUM=5 TEXTURE=HDTPWeaponRifleShine
#exec MESHMAP SETTEXTURE MESHMAP=HDTPWeaponRifle NUM=6 TEXTURE=WeaponHandsTex
#exec MESHMAP SETTEXTURE MESHMAP=HDTPWeaponRifle NUM=7 TEXTURE=BlackMaskTex      //MuzzleFlash

//
// 3rd Person
//
#exec MESH IMPORT MESH=HDTPSniper3rd ANIVFILE=MODELS\Sniper3rdModified_a.3d DATAFILE=MODELS\Sniper3rdModified_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=HDTPSniper3rd X=700 Y=0 Z=0 PITCH=26

#exec MESH SEQUENCE MESH=HDTPSniper3rd SEQ=All       STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=HDTPSniper3rd SEQ=Still STARTFRAME=0 NUMFRAMES=1

#exec TEXTURE IMPORT NAME=HDTPSniperPickup FILE=Textures\SniperRiflePickupTex1.pcx GROUP=Skins

#exec MESHMAP NEW   MESHMAP=HDTPSniper3rd MESH=HDTPSniper3rd
#exec MESHMAP SCALE MESHMAP=HDTPSniper3rd X=0.0044921875 Y=0.0044921875 Z=0.0044921875

#exec MESHMAP SETTEXTURE MESHMAP=HDTPSniper3rd NUM=1 TEXTURE=HDTPSniperPickup
#exec MESHMAP SETTEXTURE MESHMAP=HDTPSniper3rd NUM=2 TEXTURE=HDTPSniperPickup   //Useless num?
//#exec MESHMAP SETTEXTURE MESHMAP=HDTPSniper3rd NUM=2 TEXTURE=none             //Useless num
#exec MESHMAP SETTEXTURE MESHMAP=HDTPSniper3rd NUM=3 TEXTURE=HDTPSniperPickup   //Laser
#exec MESHMAP SETTEXTURE MESHMAP=HDTPSniper3rd NUM=4 TEXTURE=HDTPSniperPickup   //Silencer


//
// First Person - FOR WEAPONUNIQUEZP
// Re-importing all the 1st-person shit for ZP's rifle so we can use different textures - it's the easiest way, apparently
//
#exec mesh IMPORT MESH=HDTPWeaponRifleZP ANIVFILE=MODELS\HDTPWeaponRifle_a.3d DATAFILE=MODELS\HDTPWeaponRifle_d.3d X=0 Y=0 Z=0
#exec mesh ORIGIN MESH=HDTPWeaponRifleZP X=-4000 Y=-2000 Z=-6000   //(Z -up +Down Y -Right +Left x +Back -Forward

#exec mesh SEQUENCE MESH=HDTPWeaponRifleZP SEQ=All			STARTFRAME=0	NUMFRAMES=81
#exec mesh SEQUENCE MESH=HDTPWeaponRifleZP SEQ=Still			STARTFRAME=0	NUMFRAMES=1
#exec mesh SEQUENCE MESH=HDTPWeaponRifleZP SEQ=Select			STARTFRAME=1	NUMFRAMES=10	RATE=24 GROUP=Select
#exec mesh SEQUENCE MESH=HDTPWeaponRifleZP SEQ=Shoot			STARTFRAME=10	NUMFRAMES=6	RATE=15
#exec mesh SEQUENCE MESH=HDTPWeaponRifleZP SEQ=Down			STARTFRAME=15	NUMFRAMES=3	RATE=8

#exec mesh SEQUENCE MESH=HDTPWeaponRifleZP SEQ=Reload			STARTFRAME=18	NUMFRAMES=33	RATE=12

#exec mesh SEQUENCE MESH=HDTPWeaponRifleZP SEQ=Idle1			STARTFRAME=50	NUMFRAMES=10	RATE=3
#exec mesh SEQUENCE MESH=HDTPWeaponRifleZP SEQ=Idle2			STARTFRAME=59	NUMFRAMES=10	RATE=3
#exec mesh SEQUENCE MESH=HDTPWeaponRifleZP SEQ=Idle3			STARTFRAME=68	NUMFRAMES=10	RATE=3
#exec mesh SEQUENCE MESH=HDTPWeaponRifleZP SEQ=Zoom			STARTFRAME=77	NUMFRAMES=5     RATE=6

#exec mesh NOTIFY MESH=HDTPWeaponRifleZP SEQ=Shoot	TIME=0.02	FUNCTION=SwapMuzzleFlashTexture

#exec texture IMPORT NAME=HDTPWeaponRifleZP1 FILE=Textures\SniperRifleZPTex1.pcx GROUP=Skins // SNIPERTEX1
#exec texture IMPORT NAME=HDTPWeaponRifleZP2 FILE=Textures\SniperRifleZPTex2.pcx GROUP=Skins // SNIPERTEX2

#exec MESHMAP new   MESHMAP=HDTPWeaponRifleZP MESH=HDTPWeaponRifleZP
#exec MESHMAP scale MESHMAP=HDTPWeaponRifleZP X=0.002734375 Y=0.002734375 Z=0.002734375

#exec MESHMAP SETTEXTURE MESHMAP=HDTPWeaponRifleZP NUM=1 TEXTURE=HDTPWeaponRifleZP1
#exec MESHMAP SETTEXTURE MESHMAP=HDTPWeaponRifleZP NUM=2 TEXTURE=HDTPWeaponRifleZP2
#exec MESHMAP SETTEXTURE MESHMAP=HDTPWeaponRifleZP NUM=3 TEXTURE=HDTPWeaponRifleZP1  //Laser
#exec MESHMAP SETTEXTURE MESHMAP=HDTPWeaponRifleZP NUM=4 TEXTURE=HDTPWeaponRifleZP1  //Silencer
#exec MESHMAP SETTEXTURE MESHMAP=HDTPWeaponRifleZP NUM=5 TEXTURE=HDTPWeaponRifleShine
#exec MESHMAP SETTEXTURE MESHMAP=HDTPWeaponRifleZP NUM=6 TEXTURE=WeaponHandsTex
#exec MESHMAP SETTEXTURE MESHMAP=HDTPWeaponRifleZP NUM=7 TEXTURE=BlackMaskTex      //MuzzleFlash


//
// Pickup Mesh
//
#exec MESH IMPORT MESH=HDTPSniperPickup ANIVFILE=MODELS\Sniper3rdModified_a.3d DATAFILE=MODELS\Sniper3rdModified_d.3d X=0 Y=0 Z=0 //UNMIRROR=1
#exec MESH ORIGIN MESH=HDTPSniperPickup X=700 Y=0 Z=0 PITCH=0 Roll=-64

#exec MESH SEQUENCE MESH=HDTPSniperPickup SEQ=All       STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=HDTPSniperPickup SEQ=Still STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW   MESHMAP=HDTPSniperPickup MESH=HDTPSniperPickup
#exec MESHMAP SCALE MESHMAP=HDTPSniperPickup X=0.0044921875 Y=0.0050921875 Z=0.0044921875

#exec MESHMAP SETTEXTURE MESHMAP=HDTPSniperPickup NUM=1 TEXTURE=HDTPSniperPickup
#exec MESHMAP SETTEXTURE MESHMAP=HDTPSniperPickup NUM=2 TEXTURE=HDTPSniperPickup              //Useless num?
//#exec MESHMAP SETTEXTURE MESHMAP=HDTPSniperPickup NUM=2 TEXTURE=none               //Useless num
#exec MESHMAP SETTEXTURE MESHMAP=HDTPSniperPickup NUM=3 TEXTURE=HDTPSniperPickup   //Laser
#exec MESHMAP SETTEXTURE MESHMAP=HDTPSniperPickup NUM=4 TEXTURE=HDTPSniperPickup   //Silencer



defaultproperties
{
//     NoScopeMult=0.350000
     LowAmmoWaterMark=6
     GoverningSkill=Class'DeusEx.SkillWeaponRifle'
     NoiseLevel=2.000000
     EnviroEffective=ENVEFF_Air
     ShotTime=1.500000
     reloadTime=2.000000
     HitDamage=25
     maxRange=48000
     AccurateRange=28800
     bCanHaveScope=True
     bHasScope=True
     bCanHaveLaser=True
     bCanHaveSilencer=True
     bHasMuzzleFlash=False
     recoilStrength=0.400000
     bUseWhileCrouched=False
     mpReloadTime=2.000000
     mpHitDamage=25
     mpAccurateRange=28800
     mpMaxRange=28800
     mpReloadCount=6
     bCanHaveModBaseAccuracy=True
     bCanHaveModReloadCount=True
     bCanHaveModAccurateRange=True
     bCanHaveModReloadTime=True
     bCanHaveModRecoilStrength=True
     AmmoName=Class'DeusEx.Ammo3006'
     ReloadCount=6
     PickupAmmoCount=6
     bInstantHit=True
     FireOffset=(X=-20.000000,Y=2.000000,Z=30.000000)
     shakemag=50.000000
     FireSound=Sound'TNMitems.Weapons.SniperFireNew'
     firesilencedsound=Sound'TNMItems.Weapons.SniperFiresilenced'
     AltFireSound=Sound'DeusExSounds.Weapons.RifleReloadEnd'
     CockingSound=Sound'DeusExSounds.Weapons.RifleReload'
     SelectSound=Sound'DeusExSounds.Weapons.RifleSelect'
     InventoryGroup=5
     ItemName="Sniper Rifle"
     PlayerViewOffset=(X=20.000000,Y=-2.000000,Z=-30.000000)
     PlayerViewMesh=LodMesh'HDTPWeaponRifle'
     PickupViewMesh=LodMesh'HDTPSniperPickup'
     ThirdPersonMesh=LodMesh'HDTPSniper3rd'
     LandSound=Sound'DeusExSounds.Generic.DropMediumWeapon'
     Icon=Texture'HDTPBeltIconRifle'
     largeIcon=Texture'HDTPLargeIconRifle'
     largeIconWidth=159
     largeIconHeight=47
     invSlotsX=4
     Description="The military sniper rifle is the superior tool for the interdiction of long-range targets. When coupled with the proven 30.06 round, a marksman can achieve tight groupings at better than 1 MOA (minute of angle) depending on environmental conditions."
     beltDescription="SNIPER"
     Mesh=LodMesh'HDTPSniperPickup'
     CollisionRadius=26.000000
     CollisionHeight=2.000000
     Mass=30.000000
     Texture=Texture'HDTPWeaponRifleShine'
}
