//=============================================================================
// WeaponThrowSpork.
//=============================================================================
class WeaponThrowSpork extends TNMWeapon;

// Belt and Inventory Icons
#exec TEXTURE IMPORT NAME=BeltIconTSpork FILE=Textures\BeltIconTSpork.pcx GROUP=Icons MIPS=off // Belt Icon
#exec TEXTURE IMPORT NAME=LargeIconTSpork FILE=Textures\LargeIconTSpork.pcx GROUP=Icons MIPS=off // Iventory Icon

#exec MESH IMPORT MESH=WeaponThrowSpork ANIVFILE=MODELS\WeaponThrowSpork_a.3d DATAFILE=MODELS\WeaponThrowSpork_d.3d X=0 Y=0 Z=0
#exec mesh ORIGIN MESH=WeaponThrowSpork X=-9000 Y=-5000 Z=1000


#exec MESH SEQUENCE MESH=WeaponThrowSpork SEQ=All		STARTFRAME=0	NUMFRAMES=48
#exec MESH SEQUENCE MESH=WeaponThrowSpork SEQ=Still		STARTFRAME=0	NUMFRAMES=1
#exec MESH SEQUENCE MESH=WeaponThrowSpork SEQ=Select	STARTFRAME=1	NUMFRAMES=9		RATE=11	GROUP=Select
#exec mesh SEQUENCE MESH=WeaponThrowSpork SEQ=Attack	STARTFRAME=10	NUMFRAMES=7		RATE=18
#exec mesh SEQUENCE MESH=WeaponThrowSpork SEQ=Attack2	STARTFRAME=10	NUMFRAMES=7		RATE=18
#exec MESH SEQUENCE MESH=WeaponThrowSpork SEQ=Attack3	STARTFRAME=10	NUMFRAMES=7		RATE=18
#exec mesh SEQUENCE MESH=WeaponThrowSpork SEQ=Down		STARTFRAME=16	NUMFRAMES=7		RATE=13
#exec mesh SEQUENCE MESH=WeaponThrowSpork SEQ=Idle1		STARTFRAME=23	NUMFRAMES=8		RATE=3
#exec mesh SEQUENCE MESH=WeaponThrowSpork SEQ=Idle2		STARTFRAME=30	NUMFRAMES=8		RATE=3
#exec mesh SEQUENCE MESH=WeaponThrowSpork SEQ=Idle3		STARTFRAME=38	NUMFRAMES=10 	RATE=3

#exec texture IMPORT NAME=JWeaponThrowSpork1 FILE=Textures\ThrowSpork1.PCX GROUP=Skins // Material #0
#exec TEXTURE IMPORT NAME=JWeaponThrowSpork2 FILE=Textures\WeaponHandsTex.pcx GROUP=Skins // Material #1

#exec MESHMAP NEW   MESHMAP=WeaponThrowSpork MESH=WeaponThrowSpork
#exec MESHMAP SCALE MESHMAP=WeaponThrowSpork X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=WeaponThrowSpork NUM=1 TEXTURE=JWeaponThrowSpork1
#exec MESHMAP SETTEXTURE MESHMAP=WeaponThrowSpork NUM=2 TEXTURE=JWeaponThrowSpork2

#exec MESH NOTIFY MESH=WeaponThrowSpork SEQ=Attack		TIME=0.2	FUNCTION=HandToHandAttack
#exec MESH NOTIFY MESH=WeaponThrowSpork SEQ=Attack2		TIME=0.2	FUNCTION=HandToHandAttack
#exec MESH NOTIFY MESH=WeaponThrowSpork SEQ=Attack3		TIME=0.2	FUNCTION=HandToHandAttack

//
// pickup mesh
//
#exec MESH IMPORT MESH=ThrowSporkPick ANIVFILE=MODELS\ThrowSporkPick_a.3d DATAFILE=MODELS\ThrowSporkPick_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=ThrowSporkPick X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=ThrowSporkPick SEQ=All         STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=ThrowSporkPick SEQ=SporkPickup STARTFRAME=0 NUMFRAMES=1

#exec TEXTURE IMPORT NAME=JThrowSporkPick1 FILE=Textures\ThrowSpork1.PCX GROUP=Skins // Spork
#exec TEXTURE IMPORT NAME=JThrowSporkPick2 FILE=Textures\ThrowSpork1.PCX GROUP=Skins // Material #1

#exec MESHMAP NEW   MESHMAP=ThrowSporkPick MESH=ThrowSporkPick
#exec MESHMAP SCALE MESHMAP=ThrowSporkPick X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=ThrowSporkPick NUM=1 TEXTURE=JWeaponThrowSpork1
//#exec MESHMAP SETTEXTURE MESHMAP=ThrowSporkPick NUM=2 TEXTURE=JThrowSporkPick2

//
// Third person
//
#exec mesh IMPORT MESH=3rdThrSpork ANIVFILE=MODELS\3rdSpork_a.3d DATAFILE=MODELS\3rdSpork_d.3d X=0 Y=0 Z=0
#exec mesh ORIGIN MESH=3rdThrSpork X=0 Y=10000 Z=5000 YAW=-64 ROLL=24 //PITCH=-64

#exec mesh SEQUENCE MESH=3rdThrSpork SEQ=All   STARTFRAME=0 NUMFRAMES=1
#exec mesh SEQUENCE MESH=3rdThrSpork SEQ=Spork STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP new   MESHMAP=3rdThrSpork MESH=3rdThrSpork
#exec MESHMAP scale MESHMAP=3rdThrSpork X=0.00390625 Y=0.00390625 Z=0.00390625

#exec MESHMAP SETTEXTURE MESHMAP=3rdThrSpork NUM=1 TEXTURE=JWeaponThrowSpork1

simulated function bool NearWallCheck()
{
    return false;
}

defaultproperties
{
     LowAmmoWaterMark=5
     GoverningSkill=Class'DeusEx.SkillWeaponLowTech'
     NoiseLevel=0.050000
     EnemyEffective=ENMEFF_Organic
     EnviroEffective=ENVEFF_AirVacuum
     Concealability=CONC_Visual
     ShotTime=0.200000
     reloadTime=0.200000
     HitDamage=5
     maxRange=1280
     AccurateRange=640
     BaseAccuracy=0.900000
     bHasMuzzleFlash=False
     bHandToHand=True
     mpReloadTime=0.200000
     mpHitDamage=35
     mpBaseAccuracy=0.100000
     mpAccurateRange=640
     mpMaxRange=640
     mpPickupAmmoCount=7
     AmmoName=Class'tnmitems.AmmoThrowSpork'
     ReloadCount=1
     PickupAmmoCount=5
     FireOffset=(X=-10.000000,Y=14.000000,Z=22.000000)
     ProjectileClass=Class'tnmitems.SporkProj'
     shakemag=5.000000
     InventoryGroup=39
     ItemName="Throwing Sporks"
     ItemArticle="some"
     PlayerViewOffset=(X=24.000000,Y=-12.000000,Z=-21.000000)
     PlayerViewMesh=LodMesh'tnmitems.WeaponThrowSpork'
     PlayerViewScale=0.800000
     PickupViewMesh=LodMesh'tnmitems.ThrowSporkPick'
     ThirdPersonMesh=LodMesh'tnmitems.3rdThrSpork'
     ThirdPersonScale=0.100000
     Icon=Texture'tnmitems.Icons.BeltIconTSpork'
     largeIcon=Texture'tnmitems.Icons.LargeIconTSpork'
     largeIconWidth=36
     largeIconHeight=45
     Description="The spork is a favored weapon by the Llama cult, and these special light sporks were engineered with a perfect aerodynamic shape which allows them to be hurled through the air with great precision."
     beltDescription="THROWSPORK"
     Mesh=LodMesh'tnmitems.ThrowSporkPick'
     CollisionRadius=7.500000
     CollisionHeight=0.800000
}
